/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.i18n.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.jackrabbit.commons.json.JsonHandler;
import org.apache.jackrabbit.commons.json.JsonParser;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.i18n.impl.ResourceBundleEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrResourceBundle
extends ResourceBundle {
    private static final Logger log = LoggerFactory.getLogger(JcrResourceBundle.class);
    static final String RT_MESSAGE_ENTRY = "sling:MessageEntry";
    static final String MIXIN_MESSAGE = "sling:Message";
    static final String MIXIN_LANGUAGE = "mix:language";
    static final String PROP_KEY = "sling:key";
    static final String PROP_VALUE = "sling:message";
    static final String PROP_BASENAME = "sling:basename";
    static final String PROP_LANGUAGE = "jcr:language";
    static final String PROP_MIXINS = "jcr:mixinTypes";
    static final String QUERY_LANGUAGE_ROOTS = "//element(*,mix:language)[@jcr:language]";
    private final Map<String, Object> resources;
    private final Locale locale;
    private final String baseName;
    private final Set<String> languageRoots = new HashSet<String>();

    JcrResourceBundle(Locale locale, String baseName, ResourceResolver resourceResolver) {
        this.locale = locale;
        this.baseName = baseName;
        log.info("Finding all dictionaries for '{}' (basename: {}) ...", (Object)locale, (Object)(baseName == null ? "<none>" : baseName));
        long start = System.currentTimeMillis();
        resourceResolver.refresh();
        Set<String> roots = this.loadPotentialLanguageRoots(resourceResolver, locale, baseName);
        this.resources = this.loadFully(resourceResolver, roots, this.languageRoots);
        long end = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info("Finished loading {} entries for '{}' (basename: {}) in {}ms", new Object[]{this.resources.size(), locale, baseName == null ? "<none>" : baseName, end - start});
        }
    }

    protected Set<String> getLanguageRootPaths() {
        return this.languageRoots;
    }

    @Override
    protected void setParent(ResourceBundle parent) {
        super.setParent(parent);
    }

    public ResourceBundle getParent() {
        return this.parent;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public String getBaseName() {
        return this.baseName;
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.resources.keySet();
    }

    @Override
    public Enumeration<String> getKeys() {
        Enumeration<String> parentKeys = this.parent != null ? this.parent.getKeys() : null;
        return new ResourceBundleEnumeration(this.resources.keySet(), parentKeys);
    }

    @Override
    protected Object handleGetObject(String key) {
        if (log.isDebugEnabled()) {
            log.debug("Requesting key '{}' from resource bundle (baseName '{}', locale '{}')", new Object[]{key, this.baseName, this.locale});
        }
        return this.resources.get(key);
    }

    private Map<String, Object> loadFully(ResourceResolver resolver, Set<String> roots, Set<String> languageRoots) {
        String[] searchPath = resolver.getSearchPath();
        ArrayList dictionariesBySearchPath = new ArrayList(searchPath.length + 1);
        for (int i = 0; i < searchPath.length + 1; ++i) {
            dictionariesBySearchPath.add(new ArrayList());
        }
        for (String root : roots) {
            Resource dictionaryResource = resolver.getResource(root);
            if (dictionaryResource == null) {
                log.warn("Dictionary root found by search not accessible: {}", (Object)root);
                continue;
            }
            LinkedHashMap<String, Object> dictionary = new LinkedHashMap<String, Object>();
            List targetList = (List)dictionariesBySearchPath.get(searchPath.length);
            for (int i = 0; i < searchPath.length; ++i) {
                if (!root.startsWith(searchPath[i])) continue;
                targetList = (List)dictionariesBySearchPath.get(i);
                break;
            }
            targetList.add(dictionary);
            if (dictionaryResource.getName().endsWith(".json")) {
                this.loadJsonDictionary(dictionaryResource, dictionary);
            } else {
                this.loadSlingMessageDictionary(dictionaryResource, dictionary);
            }
            languageRoots.add(root);
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map dict : (List)dictionariesBySearchPath.get(searchPath.length)) {
            result.putAll(dict);
        }
        for (int i = searchPath.length - 1; i >= 0; --i) {
            for (Map dict : (List)dictionariesBySearchPath.get(i)) {
                result.putAll(dict);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJsonDictionary(Resource resource, final Map<String, Object> targetDictionary) {
        log.info("Loading json dictionary: {}", (Object)resource.getPath());
        JsonParser parser = new JsonParser(new JsonHandler(){
            private String key;

            @Override
            public void key(String key) throws IOException {
                this.key = key;
            }

            @Override
            public void value(String value) throws IOException {
                targetDictionary.put(this.key, value);
            }

            @Override
            public void object() throws IOException {
            }

            @Override
            public void endObject() throws IOException {
            }

            @Override
            public void array() throws IOException {
            }

            @Override
            public void endArray() throws IOException {
            }

            @Override
            public void value(boolean value) throws IOException {
            }

            @Override
            public void value(long value) throws IOException {
            }

            @Override
            public void value(double value) throws IOException {
            }
        });
        InputStream stream = (InputStream)resource.adaptTo(InputStream.class);
        if (stream != null) {
            String encoding = "utf-8";
            ResourceMetadata metadata = resource.getResourceMetadata();
            if (metadata.getCharacterEncoding() != null) {
                encoding = metadata.getCharacterEncoding();
            }
            try {
                parser.parse(stream, encoding);
            }
            catch (IOException e) {
                log.warn("Could not parse i18n json dictionary {}: {}", (Object)resource.getPath(), (Object)e.getMessage());
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException ignore) {}
            }
        } else {
            log.warn("Not a json file: {}", (Object)resource.getPath());
        }
    }

    private void scanForSlingMessages(Resource rsrc, Map<String, Object> targetDictionary) {
        String value;
        ValueMap vm = (ValueMap)rsrc.adaptTo(ValueMap.class);
        if (vm != null && (value = (String)vm.get(PROP_VALUE, String.class)) != null) {
            String key = (String)vm.get(PROP_KEY, (Object)rsrc.getName());
            targetDictionary.put(key, value);
        }
        for (Resource c : rsrc.getChildren()) {
            this.scanForSlingMessages(c, targetDictionary);
        }
    }

    private void loadSlingMessageDictionary(Resource dictionaryResource, Map<String, Object> targetDictionary) {
        log.info("Loading sling:Message dictionary: {}", (Object)dictionaryResource.getPath());
        this.scanForSlingMessages(dictionaryResource, targetDictionary);
    }

    private Set<String> loadPotentialLanguageRoots(ResourceResolver resourceResolver, Locale locale, String baseName) {
        String localeString = locale.toString();
        String localeStringLower = localeString.toLowerCase();
        String localeRFC4646String = JcrResourceBundle.toRFC4646String(locale);
        String localeRFC4646StringLower = localeRFC4646String.toLowerCase();
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        Iterator bundles = resourceResolver.findResources(QUERY_LANGUAGE_ROOTS, "xpath");
        while (bundles.hasNext()) {
            Resource bundle = (Resource)bundles.next();
            ValueMap properties = (ValueMap)bundle.adaptTo(ValueMap.class);
            String language = (String)properties.get(PROP_LANGUAGE, String.class);
            if (language == null || language.length() <= 0 || !language.equals(localeString) && !language.equals(localeStringLower) && !language.equals(localeRFC4646String) && !language.equals(localeRFC4646StringLower) || baseName != null && !baseName.equals(properties.get(PROP_BASENAME, (Object)""))) continue;
            paths.add(bundle.getPath());
        }
        return Collections.unmodifiableSet(paths);
    }

    private static String toRFC4646String(Locale locale) {
        return locale.toString().replace('_', '-');
    }

    public String toString() {
        return "JcrResourceBundle [locale=" + this.locale + ", baseName=" + this.baseName + ", languageRoots=" + this.languageRoots + ", parent=" + this.parent + "]";
    }
}

