/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.apache.commons.lang3.StringUtils;

class ResponseBodySupport {
    private ByteArrayOutputStream outputStream;
    private ServletOutputStream servletOutputStream;
    private PrintWriter printWriter;

    public ResponseBodySupport() {
        this.reset();
    }

    public void reset() {
        this.outputStream = new ByteArrayOutputStream();
        this.servletOutputStream = null;
        this.printWriter = null;
    }

    public ServletOutputStream getOutputStream() {
        if (this.servletOutputStream == null) {
            this.servletOutputStream = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    ResponseBodySupport.this.outputStream.write(b);
                }

                public boolean isReady() {
                    return true;
                }

                public void setWriteListener(WriteListener writeListener) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.servletOutputStream;
    }

    public PrintWriter getWriter(String charset) {
        if (this.printWriter == null) {
            try {
                this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.defaultCharset(charset)));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Unsupported encoding: " + this.defaultCharset(charset), ex);
            }
        }
        return this.printWriter;
    }

    public byte[] getOutput() {
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
        if (this.servletOutputStream != null) {
            try {
                this.servletOutputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.outputStream.toByteArray();
    }

    public String getOutputAsString(String charset) {
        try {
            return new String(this.getOutput(), this.defaultCharset(charset));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported encoding: " + this.defaultCharset(charset), ex);
        }
    }

    private String defaultCharset(String charset) {
        return StringUtils.defaultString((String)charset, (String)"UTF-8");
    }
}

