/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.settings.impl.SlingSettingsServiceImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class SettingsServiceConfigurator
implements ManagedService {
    private final SlingSettingsServiceImpl settings;
    private final ServiceRegistration managedServiceReg;

    public SettingsServiceConfigurator(BundleContext btx, SlingSettingsServiceImpl s) {
        this.settings = s;
        Hashtable<String, String> msProps = new Hashtable<String, String>();
        ((Dictionary)msProps).put("service.pid", s.getClass().getName());
        ((Dictionary)msProps).put("service.description", "Apache Sling Managed Service for the Settings Service");
        ((Dictionary)msProps).put("service.vendor", "The Apache Software Foundation");
        this.managedServiceReg = btx.registerService(ManagedService.class.getName(), (Object)this, msProps);
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (properties != null) {
            this.settings.update(properties);
        }
    }

    public void destroy() {
        this.managedServiceReg.unregister();
    }
}

