/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.UUID;

public class SlingIdUtil {
    private static final int SLING_ID_LENGTH = 36;

    public static String createSlingId() {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSlingId(File idFile) throws IOException {
        if (idFile.exists() && idFile.length() >= 36L) {
            FilterInputStream dis = null;
            try {
                byte[] rawBytes = new byte[36];
                dis = new DataInputStream(new FileInputStream(idFile));
                ((DataInputStream)dis).readFully(rawBytes);
                String rawString = new String(rawBytes, "ISO-8859-1");
                String string = UUID.fromString(rawString).toString();
                return string;
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSlingId(File idFile, String id) throws IOException {
        idFile.delete();
        idFile.getParentFile().mkdirs();
        FilterOutputStream dos = null;
        try {
            byte[] rawBytes = id.getBytes("ISO-8859-1");
            dos = new DataOutputStream(new FileOutputStream(idFile));
            ((DataOutputStream)dos).write(rawBytes, 0, rawBytes.length);
            ((DataOutputStream)dos).flush();
        }
        finally {
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

