/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hamcrest;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.hamcrest.MapUtil;
import org.apache.sling.hamcrest.matchers.ResourceChildrenMatcher;
import org.apache.sling.hamcrest.matchers.ResourceNameMatcher;
import org.apache.sling.hamcrest.matchers.ResourcePathMatcher;
import org.apache.sling.hamcrest.matchers.ResourcePropertiesMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class ResourceMatchers {
    public static Matcher<Resource> hasChildren(String ... children) {
        return new ResourceChildrenMatcher(Arrays.asList(children), false, false);
    }

    public static Matcher<Resource> containsChildren(String ... children) {
        return new ResourceChildrenMatcher(Arrays.asList(children), true, true);
    }

    public static Matcher<Resource> containsChildrenInAnyOrder(String ... children) {
        return new ResourceChildrenMatcher(Arrays.asList(children), true, false);
    }

    public static Matcher<Resource> path(String path) {
        return new ResourcePathMatcher(path);
    }

    public static Matcher<Resource> name(String name) {
        return new ResourceNameMatcher(name);
    }

    public static Matcher<Resource> resourceType(String resourceType) {
        return new ResourcePropertiesMatcher(Collections.singletonMap("sling:resourceType", resourceType));
    }

    public static Matcher<Resource> props(Map<String, Object> properties) {
        return new ResourcePropertiesMatcher(properties);
    }

    public static Matcher<Resource> props(Object ... properties) {
        return ResourceMatchers.props(MapUtil.toMap(properties));
    }

    public static Matcher<Resource> nameAndProps(String name, Map<String, Object> properties) {
        return Matchers.allOf((Matcher)new ResourceNameMatcher(name), (Matcher)new ResourcePropertiesMatcher(properties));
    }

    public static Matcher<Resource> nameAndProps(String name, Object ... properties) {
        return ResourceMatchers.nameAndProps(name, MapUtil.toMap(properties));
    }

    private ResourceMatchers() {
    }
}

