/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ConcurrentUpdateSolrClient
extends SolrClient {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private HttpSolrClient client;
    final BlockingQueue<Update> queue;
    final ExecutorService scheduler;
    final Queue<Runner> runners;
    volatile CountDownLatch lock = null;
    final int threadCount;
    boolean shutdownExecutor = false;
    int pollQueueTime = 250;
    private final boolean streamDeletes;
    private boolean internalHttpClient;

    @Deprecated
    public ConcurrentUpdateSolrClient(String solrServerUrl, int queueSize, int threadCount) {
        this(solrServerUrl, null, queueSize, threadCount);
        this.shutdownExecutor = true;
        this.internalHttpClient = true;
    }

    @Deprecated
    public ConcurrentUpdateSolrClient(String solrServerUrl, HttpClient client, int queueSize, int threadCount) {
        this(solrServerUrl, client, queueSize, threadCount, ExecutorUtil.newMDCAwareCachedThreadPool(new SolrjNamedThreadFactory("concurrentUpdateScheduler")));
        this.shutdownExecutor = true;
    }

    @Deprecated
    public ConcurrentUpdateSolrClient(String solrServerUrl, HttpClient client, int queueSize, int threadCount, ExecutorService es) {
        this(solrServerUrl, client, queueSize, threadCount, es, false);
    }

    @Deprecated
    public ConcurrentUpdateSolrClient(String solrServerUrl, HttpClient client, int queueSize, int threadCount, ExecutorService es, boolean streamDeletes) {
        this.internalHttpClient = client == null;
        this.client = new HttpSolrClient.Builder(solrServerUrl).withHttpClient(client).build();
        this.client.setFollowRedirects(false);
        this.queue = new LinkedBlockingQueue<Update>(queueSize);
        this.threadCount = threadCount;
        this.runners = new LinkedList<Runner>();
        this.streamDeletes = streamDeletes;
        if (es != null) {
            this.scheduler = es;
            this.shutdownExecutor = false;
        } else {
            this.scheduler = ExecutorUtil.newMDCAwareCachedThreadPool(new SolrjNamedThreadFactory("concurrentUpdateScheduler"));
            this.shutdownExecutor = true;
        }
    }

    public Set<String> getQueryParams() {
        return this.client.getQueryParams();
    }

    public void setQueryParams(Set<String> queryParams) {
        this.client.setQueryParams(queryParams);
    }

    private void addRunner() {
        MDC.put((String)"ConcurrentUpdateSolrClient.url", (String)this.client.getBaseURL());
        try {
            Runner r = new Runner();
            this.runners.add(r);
            this.scheduler.execute(r);
        }
        finally {
            MDC.remove((String)"ConcurrentUpdateSolrClient.url");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedList<Object> request(SolrRequest request, String collection) throws SolrServerException, IOException {
        ModifiableSolrParams params;
        if (!(request instanceof UpdateRequest)) {
            return this.client.request(request, collection);
        }
        UpdateRequest req = (UpdateRequest)request;
        if (this.streamDeletes) {
            if (!(req.getDocuments() != null && !req.getDocuments().isEmpty() || req.getDeleteById() != null && !req.getDeleteById().isEmpty() || req.getDeleteByIdMap() != null && !req.getDeleteByIdMap().isEmpty() || req.getDeleteQuery() != null)) {
                this.blockUntilFinished();
                return this.client.request(request, collection);
            }
        } else if (req.getDocuments() == null || req.getDocuments().isEmpty()) {
            this.blockUntilFinished();
            return this.client.request(request, collection);
        }
        if ((params = req.getParams()) != null && params.getBool("waitSearcher", false)) {
            log.info("blocking for commit/optimize");
            this.blockUntilFinished();
            return this.client.request(request, collection);
        }
        try {
            CountDownLatch tmpLock = this.lock;
            if (tmpLock != null) {
                tmpLock.await();
            }
            Update update = new Update(req, collection);
            boolean success = this.queue.offer(update);
            while (true) {
                Queue<Runner> queue = this.runners;
                synchronized (queue) {
                    if (this.runners.isEmpty() || this.queue.remainingCapacity() < this.queue.size() && this.runners.size() < this.threadCount) {
                        this.addRunner();
                    } else if (success) {
                        break;
                    }
                }
                if (success) continue;
                success = this.queue.offer(update, 100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            log.error("interrupted", (Throwable)e);
            throw new IOException(e.getLocalizedMessage());
        }
        NamedList<Object> dummy = new NamedList<Object>();
        dummy.add("NOTE", "the request is processed in a background stream");
        return dummy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void blockUntilFinished() {
        this.lock = new CountDownLatch(1);
        try {
            Queue<Runner> queue = this.runners;
            synchronized (queue) {
                while (!this.runners.isEmpty()) {
                    try {
                        this.runners.wait(250L);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    if (this.scheduler.isShutdown()) break;
                    int queueSize = this.queue.size();
                    if (queueSize <= 0 || !this.runners.isEmpty()) continue;
                    log.warn("No more runners, but queue still has " + queueSize + " adding more runners to process remaining requests on queue");
                    this.addRunner();
                }
            }
        }
        finally {
            this.lock.countDown();
            this.lock = null;
        }
    }

    public void handleError(Throwable ex) {
        log.error("error", ex);
    }

    public void onSuccess(HttpResponse resp) {
    }

    @Override
    public void close() {
        if (this.internalHttpClient) {
            IOUtils.closeQuietly(this.client);
        }
        if (this.shutdownExecutor) {
            this.scheduler.shutdown();
            try {
                if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.scheduler.shutdownNow();
                    if (!this.scheduler.awaitTermination(60L, TimeUnit.SECONDS)) {
                        log.error("ExecutorService did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public void setConnectionTimeout(int timeout) {
        HttpClientUtil.setConnectionTimeout(this.client.getHttpClient(), timeout);
    }

    public void setSoTimeout(int timeout) {
        HttpClientUtil.setSoTimeout(this.client.getHttpClient(), timeout);
    }

    public void shutdownNow() {
        if (this.internalHttpClient) {
            IOUtils.closeQuietly(this.client);
        }
        if (this.shutdownExecutor) {
            this.scheduler.shutdownNow();
            try {
                if (!this.scheduler.awaitTermination(30L, TimeUnit.SECONDS)) {
                    log.error("ExecutorService did not terminate");
                }
            }
            catch (InterruptedException ie) {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public void setParser(ResponseParser responseParser) {
        this.client.setParser(responseParser);
    }

    public void setPollQueueTime(int pollQueueTime) {
        this.pollQueueTime = pollQueueTime;
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.client.setRequestWriter(requestWriter);
    }

    public static class Builder {
        private String baseSolrUrl;
        private HttpClient httpClient;
        private int queueSize;
        private int threadCount;
        private ExecutorService executorService;
        private boolean streamDeletes;

        public Builder(String baseSolrUrl) {
            this.baseSolrUrl = baseSolrUrl;
        }

        public Builder withHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder withQueueSize(int queueSize) {
            if (queueSize <= 0) {
                throw new IllegalArgumentException("queueSize must be a positive integer.");
            }
            this.queueSize = queueSize;
            return this;
        }

        public Builder withThreadCount(int threadCount) {
            if (threadCount <= 0) {
                throw new IllegalArgumentException("threadCount must be a positive integer.");
            }
            this.threadCount = threadCount;
            return this;
        }

        public Builder withExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder alwaysStreamDeletes() {
            this.streamDeletes = true;
            return this;
        }

        public Builder neverStreamDeletes() {
            this.streamDeletes = false;
            return this;
        }

        public ConcurrentUpdateSolrClient build() {
            if (this.baseSolrUrl == null) {
                throw new IllegalArgumentException("Cannot create HttpSolrClient without a valid baseSolrUrl!");
            }
            return new ConcurrentUpdateSolrClient(this.baseSolrUrl, this.httpClient, this.queueSize, this.threadCount, this.executorService, this.streamDeletes);
        }
    }

    class Update {
        UpdateRequest request;
        String collection;

        public Update(UpdateRequest request, String collection) {
            this.request = request;
            this.collection = collection;
        }

        public UpdateRequest getRequest() {
            return this.request;
        }

        public void setRequest(UpdateRequest request) {
            this.request = request;
        }

        public String getCollection() {
            return this.collection;
        }

        public void setCollection(String collection) {
            this.collection = collection;
        }
    }

    class Runner
    implements Runnable {
        Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.debug("starting runner: {}", (Object)this);
            while (true) {
                try {
                    this.sendUpdateStream();
                    continue;
                }
                catch (Throwable e) {
                    if (e instanceof OutOfMemoryError) {
                        throw (OutOfMemoryError)e;
                    }
                    ConcurrentUpdateSolrClient.this.handleError(e);
                    continue;
                }
                finally {
                    Queue<Runner> queue = ConcurrentUpdateSolrClient.this.runners;
                    synchronized (queue) {
                        if (ConcurrentUpdateSolrClient.this.runners.size() != 1 || ConcurrentUpdateSolrClient.this.queue.isEmpty() || ConcurrentUpdateSolrClient.this.scheduler.isShutdown()) {
                            ConcurrentUpdateSolrClient.this.runners.remove(this);
                            if (ConcurrentUpdateSolrClient.this.runners.isEmpty()) {
                                ConcurrentUpdateSolrClient.this.runners.notifyAll();
                            }
                            break;
                        }
                    }
                    continue;
                }
                break;
            }
            log.debug("finished: {}", (Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendUpdateStream() throws Exception {
            while (!ConcurrentUpdateSolrClient.this.queue.isEmpty()) {
                HttpPost method = null;
                HttpResponse response = null;
                InputStream rspBody = null;
                try {
                    final Update update = ConcurrentUpdateSolrClient.this.queue.poll(ConcurrentUpdateSolrClient.this.pollQueueTime, TimeUnit.MILLISECONDS);
                    if (update == null) break;
                    String contentType = ((ConcurrentUpdateSolrClient)ConcurrentUpdateSolrClient.this).client.requestWriter.getUpdateContentType();
                    final boolean isXml = "application/xml; charset=UTF-8".equals(contentType);
                    final ModifiableSolrParams origParams = new ModifiableSolrParams(update.getRequest().getParams());
                    EntityTemplate template = new EntityTemplate(new ContentProducer(){

                        public void writeTo(OutputStream out) throws IOException {
                            try {
                                if (isXml) {
                                    out.write("<stream>".getBytes(StandardCharsets.UTF_8));
                                }
                                Update upd = update;
                                while (upd != null) {
                                    ModifiableSolrParams params;
                                    UpdateRequest req = upd.getRequest();
                                    ModifiableSolrParams currentParams = new ModifiableSolrParams(req.getParams());
                                    if (!origParams.toNamedList().equals(currentParams.toNamedList())) {
                                        ConcurrentUpdateSolrClient.this.queue.add(upd);
                                        break;
                                    }
                                    ((ConcurrentUpdateSolrClient)ConcurrentUpdateSolrClient.this).client.requestWriter.write(req, out);
                                    if (isXml && (params = req.getParams()) != null) {
                                        String fmt = null;
                                        if (params.getBool("optimize", false)) {
                                            fmt = "<optimize waitSearcher=\"%s\" />";
                                        } else if (params.getBool("commit", false)) {
                                            fmt = "<commit waitSearcher=\"%s\" />";
                                        }
                                        if (fmt != null) {
                                            byte[] content = String.format(Locale.ROOT, fmt, params.getBool("waitSearcher", false) + "").getBytes(StandardCharsets.UTF_8);
                                            out.write(content);
                                        }
                                    }
                                    out.flush();
                                    if (ConcurrentUpdateSolrClient.this.pollQueueTime > 0 && ConcurrentUpdateSolrClient.this.threadCount == 1 && req.isLastDocInBatch()) {
                                        upd = ConcurrentUpdateSolrClient.this.queue.poll(0L, TimeUnit.MILLISECONDS);
                                        continue;
                                    }
                                    upd = ConcurrentUpdateSolrClient.this.queue.poll(ConcurrentUpdateSolrClient.this.pollQueueTime, TimeUnit.MILLISECONDS);
                                }
                                if (isXml) {
                                    out.write("</stream>".getBytes(StandardCharsets.UTF_8));
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                log.warn("", (Throwable)e);
                            }
                        }
                    });
                    ModifiableSolrParams requestParams = new ModifiableSolrParams(origParams);
                    requestParams.set("wt", ((ConcurrentUpdateSolrClient)ConcurrentUpdateSolrClient.this).client.parser.getWriterType());
                    requestParams.set("version", ((ConcurrentUpdateSolrClient)ConcurrentUpdateSolrClient.this).client.parser.getVersion());
                    String basePath = ConcurrentUpdateSolrClient.this.client.getBaseURL();
                    if (update.getCollection() != null) {
                        basePath = basePath + "/" + update.getCollection();
                    }
                    method = new HttpPost(basePath + "/update" + requestParams.toQueryString());
                    method.setEntity((HttpEntity)template);
                    method.addHeader("User-Agent", HttpSolrClient.AGENT);
                    method.addHeader("Content-Type", contentType);
                    response = ConcurrentUpdateSolrClient.this.client.getHttpClient().execute((HttpUriRequest)method, (HttpContext)HttpClientUtil.createNewHttpClientRequestContext());
                    rspBody = response.getEntity().getContent();
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        HttpSolrClient.RemoteSolrException solrExc;
                        StringBuilder msg = new StringBuilder();
                        msg.append(response.getStatusLine().getReasonPhrase());
                        msg.append("\n\n\n\n");
                        msg.append("request: ").append(method.getURI());
                        NamedList metadata = null;
                        try {
                            NamedList<Object> resp;
                            NamedList error;
                            NameValuePair param;
                            String encoding = "UTF-8";
                            if (response.getEntity().getContentType().getElements().length > 0 && (param = response.getEntity().getContentType().getElements()[0].getParameterByName("charset")) != null) {
                                encoding = param.getValue();
                            }
                            if ((error = (NamedList)(resp = ((ConcurrentUpdateSolrClient)ConcurrentUpdateSolrClient.this).client.parser.processResponse(rspBody, encoding)).get("error")) != null) {
                                metadata = (NamedList)error.get("metadata");
                                String remoteMsg = (String)error.get("msg");
                                if (remoteMsg != null) {
                                    msg.append("\nRemote error message: ");
                                    msg.append(remoteMsg);
                                }
                            }
                            solrExc = new HttpSolrClient.RemoteSolrException(ConcurrentUpdateSolrClient.this.client.getBaseURL(), statusCode, msg.toString(), null);
                            if (metadata != null) {
                                solrExc.setMetadata(metadata);
                            }
                        }
                        catch (Exception exc) {
                            try {
                                log.warn("Failed to parse error response from " + ConcurrentUpdateSolrClient.this.client.getBaseURL() + " due to: " + exc);
                                solrExc = new HttpSolrClient.RemoteSolrException(ConcurrentUpdateSolrClient.this.client.getBaseURL(), statusCode, msg.toString(), null);
                                if (metadata != null) {
                                    solrExc.setMetadata(metadata);
                                }
                            }
                            catch (Throwable throwable) {
                                solrExc = new HttpSolrClient.RemoteSolrException(ConcurrentUpdateSolrClient.this.client.getBaseURL(), statusCode, msg.toString(), null);
                                if (metadata != null) {
                                    solrExc.setMetadata(metadata);
                                }
                                throw throwable;
                            }
                        }
                        ConcurrentUpdateSolrClient.this.handleError(solrExc);
                        continue;
                    }
                    ConcurrentUpdateSolrClient.this.onSuccess(response);
                }
                finally {
                    try {
                        if (response == null) continue;
                        Utils.consumeFully(response.getEntity());
                    }
                    catch (Exception e) {
                        log.error("Error consuming and closing http response stream.", (Throwable)e);
                    }
                }
            }
        }
    }
}

