/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventProcessorStage;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoScalingConfig
implements MapWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, Object> jsonMap;
    private final boolean empty;
    private Policy policy;
    private Map<String, TriggerConfig> triggers;
    private Map<String, TriggerListenerConfig> listeners;
    private Map<String, Object> properties;
    private final int zkVersion;

    public AutoScalingConfig(byte[] utf8) {
        this(utf8 != null && utf8.length > 0 ? (Map)Utils.fromJSON(utf8) : Collections.emptyMap());
    }

    public AutoScalingConfig(Map<String, Object> jsonMap) {
        this.jsonMap = jsonMap;
        int version = -1;
        if (jsonMap.containsKey("zkVersion")) {
            try {
                version = (Integer)jsonMap.get("zkVersion");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.zkVersion = version;
        jsonMap.remove("zkVersion");
        this.empty = jsonMap.isEmpty();
    }

    private AutoScalingConfig(Policy policy, Map<String, TriggerConfig> triggerConfigs, Map<String, TriggerListenerConfig> listenerConfigs, Map<String, Object> properties, int zkVersion) {
        this.policy = policy;
        this.triggers = triggerConfigs != null ? Collections.unmodifiableMap(new LinkedHashMap<String, TriggerConfig>(triggerConfigs)) : null;
        this.listeners = listenerConfigs != null ? Collections.unmodifiableMap(new LinkedHashMap<String, TriggerListenerConfig>(listenerConfigs)) : null;
        this.jsonMap = null;
        this.properties = properties != null ? Collections.unmodifiableMap(new LinkedHashMap<String, Object>(properties)) : null;
        this.zkVersion = zkVersion;
        this.empty = !(policy != null || triggerConfigs != null && !triggerConfigs.isEmpty() || listenerConfigs != null && !listenerConfigs.isEmpty());
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public Policy getPolicy() {
        if (this.policy == null) {
            this.policy = this.jsonMap != null ? new Policy(this.jsonMap, this.zkVersion) : new Policy();
        }
        return this.policy;
    }

    public Map<String, TriggerConfig> getTriggerConfigs() {
        if (this.triggers == null) {
            if (this.jsonMap != null) {
                Map trigMap = (Map)this.jsonMap.get("triggers");
                if (trigMap == null) {
                    this.triggers = Collections.emptyMap();
                } else {
                    LinkedHashMap newTriggers = new LinkedHashMap(trigMap.size());
                    for (Map.Entry entry : trigMap.entrySet()) {
                        newTriggers.put(entry.getKey(), new TriggerConfig((String)entry.getKey(), (Map)entry.getValue()));
                    }
                    this.triggers = Collections.unmodifiableMap(newTriggers);
                }
            } else {
                this.triggers = Collections.emptyMap();
            }
        }
        return this.triggers;
    }

    public boolean hasTriggerForEvents(TriggerEventType ... types) {
        if (types == null || types.length == 0) {
            return false;
        }
        for (TriggerConfig config : this.getTriggerConfigs().values()) {
            for (TriggerEventType type : types) {
                if (!config.event.equals((Object)type)) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, TriggerListenerConfig> getTriggerListenerConfigs() {
        if (this.listeners == null) {
            if (this.jsonMap != null) {
                Map map = (Map)this.jsonMap.get("listeners");
                if (map == null) {
                    this.listeners = Collections.emptyMap();
                } else {
                    LinkedHashMap newListeners = new LinkedHashMap(map.size());
                    for (Map.Entry entry : map.entrySet()) {
                        newListeners.put(entry.getKey(), new TriggerListenerConfig((String)entry.getKey(), (Map)entry.getValue()));
                    }
                    this.listeners = Collections.unmodifiableMap(newListeners);
                }
            } else {
                this.listeners = Collections.emptyMap();
            }
        }
        return this.listeners;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            Map map;
            this.properties = this.jsonMap != null ? ((map = (Map)this.jsonMap.get("properties")) == null ? Collections.emptyMap() : new LinkedHashMap<String, Object>(map)) : Collections.emptyMap();
        }
        return this.properties;
    }

    public AutoScalingConfig withProperties(Map<String, Object> properties) {
        return new AutoScalingConfig(this.policy, this.getTriggerConfigs(), this.getTriggerListenerConfigs(), properties, this.zkVersion);
    }

    public AutoScalingConfig withPolicy(Policy policy) {
        return new AutoScalingConfig(policy, this.getTriggerConfigs(), this.getTriggerListenerConfigs(), this.getProperties(), this.zkVersion);
    }

    public AutoScalingConfig withTriggerConfigs(Map<String, TriggerConfig> configs) {
        return new AutoScalingConfig(this.getPolicy(), configs, this.getTriggerListenerConfigs(), this.getProperties(), this.zkVersion);
    }

    public AutoScalingConfig withTriggerConfig(TriggerConfig config) {
        LinkedHashMap<String, TriggerConfig> configs = new LinkedHashMap<String, TriggerConfig>(this.getTriggerConfigs());
        configs.put(config.name, config);
        return this.withTriggerConfigs(configs);
    }

    public AutoScalingConfig withoutTriggerConfig(String name) {
        LinkedHashMap<String, TriggerConfig> configs = new LinkedHashMap<String, TriggerConfig>(this.getTriggerConfigs());
        configs.remove(name);
        return this.withTriggerConfigs(configs);
    }

    public AutoScalingConfig withTriggerListenerConfigs(Map<String, TriggerListenerConfig> configs) {
        return new AutoScalingConfig(this.getPolicy(), this.getTriggerConfigs(), configs, this.getProperties(), this.zkVersion);
    }

    public AutoScalingConfig withTriggerListenerConfig(TriggerListenerConfig config) {
        LinkedHashMap<String, TriggerListenerConfig> configs = new LinkedHashMap<String, TriggerListenerConfig>(this.getTriggerListenerConfigs());
        configs.put(config.name, config);
        return this.withTriggerListenerConfigs(configs);
    }

    public AutoScalingConfig withoutTriggerListenerConfig(String name) {
        LinkedHashMap<String, TriggerListenerConfig> configs = new LinkedHashMap<String, TriggerListenerConfig>(this.getTriggerListenerConfigs());
        configs.remove(name);
        return this.withTriggerListenerConfigs(configs);
    }

    public Object clone() {
        if (this.jsonMap != null) {
            return new AutoScalingConfig(this.jsonMap);
        }
        return new AutoScalingConfig(this.getPolicy(), this.getTriggerConfigs(), this.getTriggerListenerConfigs(), this.getProperties(), this.zkVersion);
    }

    public int getZkVersion() {
        return this.zkVersion;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        Policy policy = this.getPolicy();
        policy.writeMap(ew);
        ew.put((CharSequence)"triggers", this.getTriggerConfigs());
        ew.put((CharSequence)"listeners", this.getTriggerListenerConfigs());
        ew.put((CharSequence)"properties", this.getProperties());
    }

    public String toString() {
        return Utils.toJSONString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoScalingConfig that = (AutoScalingConfig)o;
        if (!this.getPolicy().equals(that.getPolicy())) {
            return false;
        }
        if (!this.getTriggerConfigs().equals(that.getTriggerConfigs())) {
            return false;
        }
        if (!this.getTriggerListenerConfigs().equals(that.getTriggerListenerConfigs())) {
            return false;
        }
        return this.getProperties().equals(that.getProperties());
    }

    private static List<Object> getList(String key, Map<String, Object> properties) {
        return AutoScalingConfig.getList(key, properties, null);
    }

    private static List<Object> getList(String key, Map<String, Object> properties, List<Object> defaultList) {
        Object o;
        if (defaultList == null) {
            defaultList = Collections.emptyList();
        }
        if ((o = properties.get(key)) == null) {
            return defaultList;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof Collection) {
            return new ArrayList<Object>((Collection)o);
        }
        return Collections.singletonList(String.valueOf(o));
    }

    public static class ActionConfig
    implements MapWriter {
        public final String name;
        public final String actionClass;
        public final Map<String, Object> properties;

        public ActionConfig(Map<String, Object> properties) {
            this.properties = properties != null ? Collections.unmodifiableMap(new LinkedHashMap<String, Object>(properties)) : Collections.emptyMap();
            this.name = (String)this.properties.get("name");
            this.actionClass = (String)this.properties.get("class");
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                ew.put((CharSequence)entry.getKey(), entry.getValue());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionConfig that = (ActionConfig)o;
            return this.properties.equals(that.properties);
        }

        public String toString() {
            return Utils.toJSONString(this);
        }
    }

    public static class TriggerConfig
    implements MapWriter {
        public final String name;
        public final TriggerEventType event;
        public final boolean enabled;
        public final List<ActionConfig> actions;
        public final Map<String, Object> properties;

        public TriggerConfig(String name, Map<String, Object> properties) {
            this.name = name;
            this.properties = properties != null ? Collections.unmodifiableMap(new LinkedHashMap<String, Object>(properties)) : Collections.emptyMap();
            String event = (String)this.properties.get("event");
            if (event != null) {
                TriggerEventType type = null;
                try {
                    type = TriggerEventType.valueOf(event.toUpperCase(Locale.ROOT));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.event = type == null ? TriggerEventType.INVALID : type;
            } else {
                this.event = TriggerEventType.INVALID;
            }
            this.enabled = Boolean.parseBoolean(String.valueOf(this.properties.getOrDefault("enabled", "true")));
            List newActions = (List)this.properties.get("actions");
            this.actions = newActions != null ? newActions.stream().map(ActionConfig::new).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList)) : Collections.emptyList();
        }

        public TriggerConfig withEnabled(boolean enabled) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(this.properties);
            props.put("enabled", String.valueOf(enabled));
            return new TriggerConfig(this.name, props);
        }

        public TriggerConfig withProperty(String key, Object value) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(this.properties);
            props.put(key, String.valueOf(value));
            return new TriggerConfig(this.name, props);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TriggerConfig that = (TriggerConfig)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.event != that.event) {
                return false;
            }
            return this.properties.equals(that.properties);
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            if (!this.properties.containsKey("event")) {
                ew.put((CharSequence)"event", this.event.toString());
            }
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                ew.put((CharSequence)entry.getKey(), entry.getValue());
            }
        }

        public String toString() {
            return Utils.toJSONString(this);
        }
    }

    public static class TriggerListenerConfig
    implements MapWriter {
        public final String name;
        public final String trigger;
        public final EnumSet<TriggerEventProcessorStage> stages = EnumSet.noneOf(TriggerEventProcessorStage.class);
        public final String listenerClass;
        public final Set<String> beforeActions;
        public final Set<String> afterActions;
        public final Map<String, Object> properties;

        public TriggerListenerConfig(String name, Map<String, Object> properties) {
            this.name = name;
            this.properties = properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(properties));
            this.trigger = (String)this.properties.get("trigger");
            List stageNames = AutoScalingConfig.getList("stage", this.properties);
            for (Object stageName : stageNames) {
                try {
                    TriggerEventProcessorStage stage = TriggerEventProcessorStage.valueOf(String.valueOf(stageName).toUpperCase(Locale.ROOT));
                    this.stages.add(stage);
                }
                catch (Exception e) {
                    log.warn("Invalid stage name '" + name + "' in listener config, skipping: " + properties);
                }
            }
            this.listenerClass = (String)this.properties.get("class");
            LinkedHashSet bActions = new LinkedHashSet();
            AutoScalingConfig.getList("beforeAction", this.properties).forEach(o -> bActions.add(String.valueOf(o)));
            this.beforeActions = Collections.unmodifiableSet(bActions);
            LinkedHashSet aActions = new LinkedHashSet();
            AutoScalingConfig.getList("afterAction", this.properties).forEach(o -> aActions.add(String.valueOf(o)));
            this.afterActions = Collections.unmodifiableSet(aActions);
        }

        @Override
        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            if (!this.properties.containsKey("class")) {
                ew.put((CharSequence)"class", this.listenerClass);
            }
            if (!this.properties.containsKey("trigger")) {
                ew.put((CharSequence)"trigger", this.trigger);
            }
            if (!this.properties.containsKey("stage")) {
                ew.put((CharSequence)"stage", this.stages);
            }
            if (!this.properties.containsKey("beforeAction")) {
                ew.put((CharSequence)"beforeAction", this.beforeActions);
            }
            if (!this.properties.containsKey("afterAction")) {
                ew.put((CharSequence)"afterAction", this.afterActions);
            }
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                ew.put((CharSequence)entry.getKey(), entry.getValue());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TriggerListenerConfig that = (TriggerListenerConfig)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            if (this.trigger != null ? !this.trigger.equals(that.trigger) : that.trigger != null) {
                return false;
            }
            if (!this.stages.equals(that.stages)) {
                return false;
            }
            if (this.listenerClass != null ? !this.listenerClass.equals(that.listenerClass) : that.listenerClass != null) {
                return false;
            }
            if (!this.beforeActions.equals(that.beforeActions)) {
                return false;
            }
            if (!this.afterActions.equals(that.afterActions)) {
                return false;
            }
            return this.properties.equals(that.properties);
        }

        public String toString() {
            return Utils.toJSONString(this);
        }
    }
}

