/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.IOException;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.solr.common.MapWriter;

public class ConditionalMapWriter
implements MapWriter {
    private final MapWriter delegate;
    private final BiPredicate<CharSequence, Object> predicate;
    public static final BiPredicate<CharSequence, Object> NON_NULL_VAL = (s, o) -> o != null;

    public ConditionalMapWriter(MapWriter delegate, BiPredicate<CharSequence, Object> predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        if (this.delegate != null) {
            this.delegate.writeMap(new EntryWriterWrapper(ew));
        }
    }

    public static BiPredicate<CharSequence, Object> dedupeKeyPredicate(Set<CharSequence> keys) {
        return (k, v) -> keys.add((CharSequence)k);
    }

    private class EntryWriterWrapper
    implements MapWriter.EntryWriter {
        private final MapWriter.EntryWriter delegate;

        EntryWriterWrapper(MapWriter.EntryWriter delegate) {
            this.delegate = delegate;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, Object v) throws IOException {
            if (ConditionalMapWriter.this.predicate.test(k, v)) {
                this.delegate.put(k, v);
            }
            return this;
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, int v) throws IOException {
            return this.put(k, (Object)v);
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, long v) throws IOException {
            return this.put(k, (Object)v);
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, float v) throws IOException {
            return this.put(k, Float.valueOf(v));
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, double v) throws IOException {
            return this.put(k, (Object)v);
        }

        @Override
        public MapWriter.EntryWriter put(CharSequence k, boolean v) throws IOException {
            return this.put(k, (Object)v);
        }
    }
}

