/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.Map;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.UpdateAliasPropertiesRequestBody;
import org.apache.solr.client.api.model.UpdateAliasPropertyRequestBody;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class AliasPropertiesApi {

    public static class UpdateAliasProperties
    extends SolrRequest<UpdateAliasPropertiesResponse> {
        private final UpdateAliasPropertiesRequestBody requestBody;
        private final String aliasName;

        public UpdateAliasProperties(String aliasName) {
            super(SolrRequest.METHOD.valueOf("PUT"), "/aliases/{aliasName}/properties".replace("{aliasName}", aliasName));
            this.aliasName = aliasName;
            this.requestBody = new UpdateAliasPropertiesRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setProperties(Map<String, Object> properties) {
            this.requestBody.properties = properties;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected UpdateAliasPropertiesResponse createResponse(SolrClient client) {
            return new UpdateAliasPropertiesResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class UpdateAliasPropertiesResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public UpdateAliasPropertiesResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class GetAllAliasProperties
    extends SolrRequest<GetAllAliasPropertiesResponse> {
        private final String aliasName;

        public GetAllAliasProperties(String aliasName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/aliases/{aliasName}/properties".replace("{aliasName}", aliasName));
            this.aliasName = aliasName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected GetAllAliasPropertiesResponse createResponse(SolrClient client) {
            return new GetAllAliasPropertiesResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetAllAliasPropertiesResponse
    extends JacksonParsingResponse<org.apache.solr.client.api.model.GetAllAliasPropertiesResponse> {
        public GetAllAliasPropertiesResponse() {
            super(org.apache.solr.client.api.model.GetAllAliasPropertiesResponse.class);
        }
    }

    public static class GetAliasProperty
    extends SolrRequest<GetAliasPropertyResponse> {
        private final String aliasName;
        private final String propName;

        public GetAliasProperty(String aliasName, String propName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/aliases/{aliasName}/properties/{propName}".replace("{aliasName}", aliasName).replace("{propName}", propName));
            this.aliasName = aliasName;
            this.propName = propName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected GetAliasPropertyResponse createResponse(SolrClient client) {
            return new GetAliasPropertyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetAliasPropertyResponse
    extends JacksonParsingResponse<org.apache.solr.client.api.model.GetAliasPropertyResponse> {
        public GetAliasPropertyResponse() {
            super(org.apache.solr.client.api.model.GetAliasPropertyResponse.class);
        }
    }

    public static class DeleteAliasProperty
    extends SolrRequest<DeleteAliasPropertyResponse> {
        private final String aliasName;
        private final String propName;

        public DeleteAliasProperty(String aliasName, String propName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/aliases/{aliasName}/properties/{propName}".replace("{aliasName}", aliasName).replace("{propName}", propName));
            this.aliasName = aliasName;
            this.propName = propName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected DeleteAliasPropertyResponse createResponse(SolrClient client) {
            return new DeleteAliasPropertyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteAliasPropertyResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public DeleteAliasPropertyResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class CreateOrUpdateAliasProperty
    extends SolrRequest<CreateOrUpdateAliasPropertyResponse> {
        private final UpdateAliasPropertyRequestBody requestBody;
        private final String aliasName;
        private final String propName;

        public CreateOrUpdateAliasProperty(String aliasName, String propName) {
            super(SolrRequest.METHOD.valueOf("PUT"), "/aliases/{aliasName}/properties/{propName}".replace("{aliasName}", aliasName).replace("{propName}", propName));
            this.aliasName = aliasName;
            this.propName = propName;
            this.requestBody = new UpdateAliasPropertyRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setValue(Object value) {
            this.requestBody.value = value;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected CreateOrUpdateAliasPropertyResponse createResponse(SolrClient client) {
            return new CreateOrUpdateAliasPropertyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class CreateOrUpdateAliasPropertyResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public CreateOrUpdateAliasPropertyResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

