/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.List;
import java.util.Map;
import org.apache.solr.client.api.model.CreateReplicaRequestBody;
import org.apache.solr.client.api.model.ScaleCollectionRequestBody;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class ReplicasApi {

    public static class DeleteReplicasByCountAllShards
    extends SolrRequest<DeleteReplicasByCountAllShardsResponse> {
        private final ScaleCollectionRequestBody requestBody;
        private final String collectionName;

        public DeleteReplicasByCountAllShards(String collectionName) {
            super(SolrRequest.METHOD.valueOf("PUT"), "/collections/{collectionName}/scale".replace("{collectionName}", collectionName));
            this.collectionName = collectionName;
            this.requestBody = new ScaleCollectionRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setNumToDelete(Integer numToDelete) {
            this.requestBody.numToDelete = numToDelete;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.requestBody.followAliases = followAliases;
        }

        public void setDeleteInstanceDir(Boolean deleteInstanceDir) {
            this.requestBody.deleteInstanceDir = deleteInstanceDir;
        }

        public void setDeleteDataDir(Boolean deleteDataDir) {
            this.requestBody.deleteDataDir = deleteDataDir;
        }

        public void setDeleteIndex(Boolean deleteIndex) {
            this.requestBody.deleteIndex = deleteIndex;
        }

        public void setOnlyIfDown(Boolean onlyIfDown) {
            this.requestBody.onlyIfDown = onlyIfDown;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected DeleteReplicasByCountAllShardsResponse createResponse(SolrClient client) {
            return new DeleteReplicasByCountAllShardsResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteReplicasByCountAllShardsResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public DeleteReplicasByCountAllShardsResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }

    public static class DeleteReplicasByCount
    extends SolrRequest<DeleteReplicasByCountResponse> {
        private final String collectionName;
        private final String shardName;
        private Integer count;
        private Boolean followAliases;
        private Boolean deleteInstanceDir;
        private Boolean deleteDataDir;
        private Boolean deleteIndex;
        private Boolean onlyIfDown;
        private String async;

        public DeleteReplicasByCount(String collectionName, String shardName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/collections/{collectionName}/shards/{shardName}/replicas".replace("{collectionName}", collectionName).replace("{shardName}", shardName));
            this.collectionName = collectionName;
            this.shardName = shardName;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.followAliases = followAliases;
        }

        public void setDeleteInstanceDir(Boolean deleteInstanceDir) {
            this.deleteInstanceDir = deleteInstanceDir;
        }

        public void setDeleteDataDir(Boolean deleteDataDir) {
            this.deleteDataDir = deleteDataDir;
        }

        public void setDeleteIndex(Boolean deleteIndex) {
            this.deleteIndex = deleteIndex;
        }

        public void setOnlyIfDown(Boolean onlyIfDown) {
            this.onlyIfDown = onlyIfDown;
        }

        public void setAsync(String async) {
            this.async = async;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.count != null) {
                params.add("count", this.count.toString());
            }
            if (this.followAliases != null) {
                params.add("followAliases", this.followAliases.toString());
            }
            if (this.deleteInstanceDir != null) {
                params.add("deleteInstanceDir", this.deleteInstanceDir.toString());
            }
            if (this.deleteDataDir != null) {
                params.add("deleteDataDir", this.deleteDataDir.toString());
            }
            if (this.deleteIndex != null) {
                params.add("deleteIndex", this.deleteIndex.toString());
            }
            if (this.onlyIfDown != null) {
                params.add("onlyIfDown", this.onlyIfDown.toString());
            }
            if (this.async != null) {
                params.add("async", this.async);
            }
            return params;
        }

        @Override
        protected DeleteReplicasByCountResponse createResponse(SolrClient client) {
            return new DeleteReplicasByCountResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteReplicasByCountResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public DeleteReplicasByCountResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }

    public static class DeleteReplicaByName
    extends SolrRequest<DeleteReplicaByNameResponse> {
        private final String collectionName;
        private final String shardName;
        private final String replicaName;
        private Boolean followAliases;
        private Boolean deleteInstanceDir;
        private Boolean deleteDataDir;
        private Boolean deleteIndex;
        private Boolean onlyIfDown;
        private String async;

        public DeleteReplicaByName(String collectionName, String shardName, String replicaName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/collections/{collectionName}/shards/{shardName}/replicas/{replicaName}".replace("{collectionName}", collectionName).replace("{shardName}", shardName).replace("{replicaName}", replicaName));
            this.collectionName = collectionName;
            this.shardName = shardName;
            this.replicaName = replicaName;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.followAliases = followAliases;
        }

        public void setDeleteInstanceDir(Boolean deleteInstanceDir) {
            this.deleteInstanceDir = deleteInstanceDir;
        }

        public void setDeleteDataDir(Boolean deleteDataDir) {
            this.deleteDataDir = deleteDataDir;
        }

        public void setDeleteIndex(Boolean deleteIndex) {
            this.deleteIndex = deleteIndex;
        }

        public void setOnlyIfDown(Boolean onlyIfDown) {
            this.onlyIfDown = onlyIfDown;
        }

        public void setAsync(String async) {
            this.async = async;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.followAliases != null) {
                params.add("followAliases", this.followAliases.toString());
            }
            if (this.deleteInstanceDir != null) {
                params.add("deleteInstanceDir", this.deleteInstanceDir.toString());
            }
            if (this.deleteDataDir != null) {
                params.add("deleteDataDir", this.deleteDataDir.toString());
            }
            if (this.deleteIndex != null) {
                params.add("deleteIndex", this.deleteIndex.toString());
            }
            if (this.onlyIfDown != null) {
                params.add("onlyIfDown", this.onlyIfDown.toString());
            }
            if (this.async != null) {
                params.add("async", this.async);
            }
            return params;
        }

        @Override
        protected DeleteReplicaByNameResponse createResponse(SolrClient client) {
            return new DeleteReplicaByNameResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteReplicaByNameResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public DeleteReplicaByNameResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }

    public static class CreateReplica
    extends SolrRequest<CreateReplicaResponse> {
        private final CreateReplicaRequestBody requestBody;
        private final String collectionName;
        private final String shardName;

        public CreateReplica(String collectionName, String shardName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collectionName}/shards/{shardName}/replicas".replace("{collectionName}", collectionName).replace("{shardName}", shardName));
            this.collectionName = collectionName;
            this.shardName = shardName;
            this.requestBody = new CreateReplicaRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setName(String name) {
            this.requestBody.name = name;
        }

        public void setType(String type) {
            this.requestBody.type = type;
        }

        public void setInstanceDir(String instanceDir) {
            this.requestBody.instanceDir = instanceDir;
        }

        public void setDataDir(String dataDir) {
            this.requestBody.dataDir = dataDir;
        }

        public void setUlogDir(String ulogDir) {
            this.requestBody.ulogDir = ulogDir;
        }

        public void setRoute(String route) {
            this.requestBody.route = route;
        }

        public void setNrtReplicas(Integer nrtReplicas) {
            this.requestBody.nrtReplicas = nrtReplicas;
        }

        public void setTlogReplicas(Integer tlogReplicas) {
            this.requestBody.tlogReplicas = tlogReplicas;
        }

        public void setPullReplicas(Integer pullReplicas) {
            this.requestBody.pullReplicas = pullReplicas;
        }

        public void setWaitForFinalState(Boolean waitForFinalState) {
            this.requestBody.waitForFinalState = waitForFinalState;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.requestBody.followAliases = followAliases;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        public void setNode(String node) {
            this.requestBody.node = node;
        }

        public void setSkipNodeAssignment(Boolean skipNodeAssignment) {
            this.requestBody.skipNodeAssignment = skipNodeAssignment;
        }

        public void setProperties(Map<String, String> properties) {
            this.requestBody.properties = properties;
        }

        public void setNodeSet(List<String> nodeSet) {
            this.requestBody.nodeSet = nodeSet;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected CreateReplicaResponse createResponse(SolrClient client) {
            return new CreateReplicaResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class CreateReplicaResponse
    extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
        public CreateReplicaResponse() {
            super(SubResponseAccumulatingJerseyResponse.class);
        }
    }
}

