/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.cluster.api.HashRange;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.PlainIdRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.noggit.JSONWriter;

public abstract class DocRouter {
    public static final String DEFAULT_NAME = "compositeId";
    public static final DocRouter DEFAULT;
    private static final Map<String, DocRouter> routerMap;

    public static DocRouter getDocRouter(String routerName) {
        DocRouter router = routerMap.get(routerName);
        if (router != null) {
            return router;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown document router '" + routerName + "'");
    }

    public String getRouteField(DocCollection coll) {
        if (coll == null) {
            return null;
        }
        Map m = (Map)coll.get("router");
        if (m == null) {
            return null;
        }
        return (String)m.get("field");
    }

    public static Map<String, Object> getRouterSpec(ZkNodeProps props) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String s : props.keySet()) {
            if (!s.startsWith("router.")) continue;
            map.put(s.substring(7), props.get(s));
        }
        if (map.get("name") == null) {
            map.put("name", DEFAULT_NAME);
        }
        return map;
    }

    public Range fromString(String range) {
        int middle = range.indexOf(45);
        String minS = range.substring(0, middle);
        String maxS = range.substring(middle + 1);
        long min = Long.parseLong(minS, 16);
        long max = Long.parseLong(maxS, 16);
        return new Range((int)min, (int)max);
    }

    public Range fullRange() {
        return new Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public List<Range> partitionRange(int partitions, Range range) {
        return this.partitionRange(partitions, range, 0.0f);
    }

    public List<Range> partitionRange(int partitions, Range range, float fuzz) {
        long start;
        int min = range.min;
        int max = range.max;
        assert (max >= min);
        if (fuzz > 0.5f) {
            throw new IllegalArgumentException("'fuzz' parameter must be <= 0.5f but was " + fuzz);
        }
        if (fuzz < 0.0f) {
            fuzz = 0.0f;
        }
        if (partitions == 0) {
            return Collections.emptyList();
        }
        long rangeSize = (long)max - (long)min;
        long rangeStep = Math.max(1L, rangeSize / (long)partitions);
        long fuzzStep = Math.round((double)rangeStep * (double)fuzz / 2.0);
        ArrayList<Range> ranges = new ArrayList<Range>(partitions);
        long end = start = (long)min;
        boolean odd = true;
        while (end < (long)max) {
            end = start + rangeStep;
            if (fuzzStep > 0L) {
                end = odd ? (end += fuzzStep) : (end -= fuzzStep);
                boolean bl = odd = !odd;
            }
            if (ranges.size() == partitions - 1) {
                end = max;
            }
            ranges.add(new Range((int)start, (int)end));
            start = end + 1L;
        }
        return ranges;
    }

    public abstract Slice getTargetSlice(String var1, SolrInputDocument var2, String var3, SolrParams var4, DocCollection var5);

    public abstract Collection<Slice> getSearchSlicesSingle(String var1, SolrParams var2, DocCollection var3);

    public Range getSearchRangeSingle(String shardKey, SolrParams params, DocCollection collection) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean isTargetSlice(String var1, SolrInputDocument var2, SolrParams var3, String var4, DocCollection var5);

    public abstract String getName();

    public Collection<Slice> getSearchSlices(String shardKeys, SolrParams params, DocCollection collection) {
        if (shardKeys == null || shardKeys.indexOf(44) < 0) {
            return this.getSearchSlicesSingle(shardKeys, params, collection);
        }
        List<String> shardKeyList = StrUtils.splitSmart(shardKeys, ",", true);
        HashSet<Slice> allSlices = new HashSet<Slice>();
        for (String shardKey : shardKeyList) {
            allSlices.addAll(this.getSearchSlicesSingle(shardKey, params, collection));
        }
        return allSlices;
    }

    static {
        routerMap = new HashMap<String, DocRouter>();
        PlainIdRouter plain = new PlainIdRouter();
        routerMap.put(null, plain);
        routerMap.put("plain", plain);
        routerMap.put(DEFAULT_NAME, new CompositeIdRouter());
        routerMap.put("implicit", new ImplicitDocRouter());
        DEFAULT = routerMap.get(DEFAULT_NAME);
    }

    public static class Range
    implements JSONWriter.Writable,
    Comparable<Range>,
    HashRange {
        public int min;
        public int max;

        public Range(int min, int max) {
            assert (min <= max);
            this.min = min;
            this.max = max;
        }

        @Override
        public int min() {
            return this.min;
        }

        @Override
        public int max() {
            return this.max;
        }

        @Override
        public boolean includes(int hash) {
            return hash >= this.min && hash <= this.max;
        }

        public boolean isSubsetOf(Range superset) {
            return superset.min <= this.min && superset.max >= this.max;
        }

        public boolean overlaps(Range other) {
            return this.includes(other.min) || this.includes(other.max) || this.isSubsetOf(other);
        }

        public String toString() {
            return Integer.toHexString(this.min) + "-" + Integer.toHexString(this.max);
        }

        public int hashCode() {
            return (this.min >> 28) + (this.min >> 25) + (this.min >> 21) + this.min;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Range)) {
                return false;
            }
            Range other = (Range)obj;
            return this.min == other.min && this.max == other.max;
        }

        @Override
        public void write(JSONWriter writer) {
            writer.write(this.toString());
        }

        @Override
        public int compareTo(Range that) {
            int mincomp = Integer.compare(this.min, that.min);
            return mincomp == 0 ? Integer.compare(this.max, that.max) : mincomp;
        }
    }
}

