/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionStatePredicate;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;

public class ClusterStateUtil {
    private static final int TIMEOUT_POLL_MS = 1000;

    public static boolean waitForAllActiveAndLiveReplicas(ZkStateReader zkStateReader, int timeoutInMs) {
        return ClusterStateUtil.waitForAllActiveAndLiveReplicas(zkStateReader, null, timeoutInMs);
    }

    public static boolean waitForAllActiveAndLiveReplicas(ZkStateReader zkStateReader, String collection, int timeoutInMs) {
        return ClusterStateUtil.waitFor(zkStateReader, collection, timeoutInMs, TimeUnit.MILLISECONDS, (liveNodes, state) -> ClusterStateUtil.replicasOfActiveSlicesStream(state).allMatch(replica -> ClusterStateUtil.liveAndActivePredicate(replica, liveNodes)));
    }

    private static boolean liveAndActivePredicate(Replica replica, Set<String> liveNodes) {
        boolean live = liveNodes.contains(replica.getNodeName());
        boolean isActive = replica.getState() == Replica.State.ACTIVE;
        return live && isActive;
    }

    public static boolean waitForAllReplicasNotLive(ZkStateReader zkStateReader, int timeoutInMs) {
        return ClusterStateUtil.waitForAllReplicasNotLive(zkStateReader, null, timeoutInMs);
    }

    public static boolean waitForAllReplicasNotLive(ZkStateReader zkStateReader, String collection, int timeoutInMs) {
        return ClusterStateUtil.waitFor(zkStateReader, collection, timeoutInMs, TimeUnit.MILLISECONDS, (liveNodes, state) -> ClusterStateUtil.replicasOfActiveSlicesStream(state).noneMatch(replica -> liveNodes.contains(replica.getNodeName())));
    }

    public static int getLiveAndActiveReplicaCount(ZkStateReader zkStateReader, String collection) {
        ClusterState clusterState = zkStateReader.getClusterState();
        Set liveNodes = clusterState.getLiveNodes();
        DocCollection state = clusterState.getCollection(collection);
        return (int)ClusterStateUtil.replicasOfActiveSlicesStream(state).filter(replica -> ClusterStateUtil.liveAndActivePredicate(replica, liveNodes)).count();
    }

    public static Stream<Replica> replicasOfActiveSlicesStream(DocCollection collectionState) {
        return collectionState.getActiveSlices().stream().map(Slice::getReplicas).flatMap(Collection::stream);
    }

    public static boolean waitForLiveAndActiveReplicaCount(ZkStateReader zkStateReader, String collection, int replicaCount, int timeoutInMs) {
        return ClusterStateUtil.waitFor(zkStateReader, collection, timeoutInMs, TimeUnit.MILLISECONDS, (liveNodes, state) -> ClusterStateUtil.replicasOfActiveSlicesStream(state).filter(replica -> ClusterStateUtil.liveAndActivePredicate(replica, liveNodes)).count() == (long)replicaCount);
    }

    public static boolean waitFor(ZkStateReader zkStateReader, String collection, long timeout, TimeUnit timeUnit, CollectionStatePredicate predicate) {
        if (collection != null) {
            try {
                zkStateReader.waitForState(collection, timeout, timeUnit, predicate);
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted");
            }
            catch (TimeoutException e) {
                return false;
            }
        }
        long timeoutAtNs = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, timeUnit);
        while (true) {
            ClusterState clusterState;
            if ((clusterState = zkStateReader.getClusterState()) != null) {
                Set liveNodes = clusterState.getLiveNodes();
                if (clusterState.collectionStream().allMatch(state -> predicate.matches(liveNodes, state))) {
                    return true;
                }
            }
            if (System.nanoTime() > timeoutAtNs) {
                return false;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted");
            }
        }
    }

    public static String toDebugAllStatesString(ClusterState clusterState) {
        LinkedHashMap stateMap = clusterState.collectionStream().collect(LinkedHashMap::new, (map, state) -> map.put(state.getName(), state.toMap(new LinkedHashMap())), Map::putAll);
        return Utils.toJSONString((Object)stateMap);
    }
}

