/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.embedded.JettyConfig;
import org.apache.solr.embedded.JettySolrRunner;
import org.apache.solr.util.SolrClientTestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrJettyTestRule
extends SolrClientTestRule {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private JettySolrRunner jetty;
    private final ConcurrentHashMap<String, SolrClient> clients = new ConcurrentHashMap();
    private boolean enableProxy;

    protected void after() {
        for (SolrClient solrClient : this.clients.values()) {
            IOUtils.closeQuietly((Closeable)solrClient);
        }
        this.clients.clear();
        if (this.jetty != null) {
            try {
                this.jetty.stop();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.jetty = null;
            this.enableProxy = false;
        }
    }

    @Deprecated
    public void reset() {
        this.after();
    }

    @Override
    public void startSolr(Path solrHome) {
        this.startSolr(solrHome, new Properties(), JettyConfig.builder().build());
    }

    public void enableProxy() {
        assert (this.jetty == null);
        this.enableProxy = true;
    }

    public void startSolr(Path solrHome, Properties nodeProperties, JettyConfig jettyConfig) {
        if (this.jetty != null) {
            throw new IllegalStateException("Jetty is already running");
        }
        this.jetty = new JettySolrRunner(solrHome.toString(), nodeProperties, jettyConfig, this.enableProxy);
        try {
            this.jetty.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int port = this.jetty.getLocalPort();
        log.info("Jetty Assigned Port#{}", (Object)port);
    }

    public JettySolrRunner getJetty() {
        if (this.jetty == null) {
            throw new IllegalStateException("Jetty has not started");
        }
        return this.jetty;
    }

    @Override
    public SolrClient getSolrClient(String collection) {
        if (collection == null) {
            collection = "";
        }
        return this.clients.computeIfAbsent(collection, this::newSolrClient);
    }

    protected SolrClient newSolrClient(String collection) {
        return ((HttpSolrClient.Builder)new HttpSolrClient.Builder(this.getBaseUrl()).withDefaultCollection(collection)).build();
    }

    public String getBaseUrl() {
        return this.getJetty().getBaseUrl().toString();
    }

    public CoreContainer getCoreContainer() {
        return this.getJetty().getCoreContainer();
    }
}

