/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.apache.solr.util.NotSecurePseudoRandomSpi;

public class SolrTestNonSecureRandomProvider
extends Provider {
    public SolrTestNonSecureRandomProvider() {
        super("SolrTestNonSecure", "1.0", "A Test only, non secure provider");
        this.put("SecureRandom.SHA1PRNG", NotSecurePseudoRandomSpi.class.getName());
        this.put("SecureRandom.NativePRNG", NotSecurePseudoRandomSpi.class.getName());
        this.put("SecureRandom.DRBG", NotSecurePseudoRandomSpi.class.getName());
        this.put("SecureRandom.SHA1PRNG ThreadSafe", "true");
        this.put("SecureRandom.NativePRNG ThreadSafe", "true");
        this.put("SecureRandom.DRBG ThreadSafe", "true");
        this.put("SecureRandom.SHA1PRNG ImplementedIn", "Software");
        this.put("SecureRandom.NativePRNG ImplementedIn", "Software");
        this.put("SecureRandom.DRBG ImplementedIn", "Software");
    }

    public static void injectProvider() {
        SecureRandom rng1;
        Provider[] secureRandomProviders = Security.getProviders("SecureRandom.SHA1PRNG");
        if (secureRandomProviders == null || secureRandomProviders.length < 1 || !SolrTestNonSecureRandomProvider.class.equals(secureRandomProviders[0].getClass())) {
            Security.insertProviderAt(new SolrTestNonSecureRandomProvider(), 1);
        }
        if (!SolrTestNonSecureRandomProvider.class.equals((rng1 = new SecureRandom()).getProvider().getClass())) {
            throw new SecurityException("new SecureRandom() backed by wrong Provider: " + rng1.getProvider().getClass());
        }
        boolean skipCheck = false;
        SecureRandom rng2 = null;
        try {
            rng2 = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            skipCheck = true;
        }
        if (!skipCheck && !SolrTestNonSecureRandomProvider.class.equals(rng2.getProvider().getClass())) {
            throw new SecurityException("SecureRandom.getInstance(\"SHA1PRNG\") backed by wrong Provider: " + rng2.getProvider().getClass());
        }
    }
}

