/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(date/timestamp/string, fmt) - Converts a date/timestamp/string to a value of string in the format specified by the date format fmt.", extended="> SELECT _FUNC_('2016-04-08', 'y')\n '2016'")
@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001>\u0011q\u0002R1uK\u001a{'/\\1u\u00072\f7o\u001d\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u000b\u0018;A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001DH\u0005\u0003?e\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\t\u0001\u0003\u0016\u0004%\tAI\u0001\u0005Y\u00164G/F\u0001$!\t\tB%\u0003\u0002&\u0005\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u001d\u0002!\u0011#Q\u0001\n\r\nQ\u0001\\3gi\u0002B\u0001\"\u000b\u0001\u0003\u0016\u0004%\tAI\u0001\u0006e&<\u0007\u000e\u001e\u0005\tW\u0001\u0011\t\u0012)A\u0005G\u00051!/[4ii\u0002BQ!\f\u0001\u0005\u00029\na\u0001P5oSRtDcA\u00181cA\u0011\u0011\u0003\u0001\u0005\u0006C1\u0002\ra\t\u0005\u0006S1\u0002\ra\t\u0005\u0006g\u0001!\t\u0005N\u0001\tI\u0006$\u0018\rV=qKV\tQ\u0007\u0005\u00027s5\tqG\u0003\u00029\r\u0005)A/\u001f9fg&\u0011!h\u000e\u0002\t\t\u0006$\u0018\rV=qK\")A\b\u0001C!{\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0003y\u00022aP$K\u001d\t\u0001UI\u0004\u0002B\t6\t!I\u0003\u0002D\u001d\u00051AH]8pizJ\u0011AG\u0005\u0003\rf\tq\u0001]1dW\u0006<W-\u0003\u0002I\u0013\n\u00191+Z9\u000b\u0005\u0019K\u0002C\u0001\u001cL\u0013\tauG\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\")a\n\u0001C)\u001f\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019\u0001kU+\u0011\u0005a\t\u0016B\u0001*\u001a\u0005\r\te.\u001f\u0005\u0006)6\u0003\r\u0001U\u0001\ni&lWm\u001d;b[BDQAV'A\u0002A\u000baAZ8s[\u0006$\b\"\u0002-\u0001\t\u0003J\u0016!\u00033p\u000f\u0016t7i\u001c3f)\rQ\u0006-\u001a\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\n\tqaY8eK\u001e,g.\u0003\u0002`9\nAQ\t\u001f9s\u0007>$W\rC\u0003b/\u0002\u0007!-A\u0002dib\u0004\"aW2\n\u0005\u0011d&AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006M^\u0003\rAW\u0001\u0003KZDQ\u0001\u001b\u0001\u0005B%\f!\u0002\u001d:fiRLh*Y7f+\u0005Q\u0007CA6o\u001d\tAB.\u0003\u0002n3\u00051\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\ti\u0017\u0004C\u0004s\u0001\u0005\u0005I\u0011A:\u0002\t\r|\u0007/\u001f\u000b\u0004_Q,\bbB\u0011r!\u0003\u0005\ra\t\u0005\bSE\u0004\n\u00111\u0001$\u0011\u001d9\b!%A\u0005\u0002a\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001zU\t\u0019#pK\u0001|!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0001\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u000bi(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"A\u0011\u0011\u0002\u0001\u0012\u0002\u0013\u0005\u00010\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u00055\u0001!!A\u0005B\u0005=\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011\u0001\u00027b]\u001eT!!a\u0007\u0002\t)\fg/Y\u0005\u0004_\u0006U\u0001\"CA\u0011\u0001\u0005\u0005I\u0011AA\u0012\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0003E\u0002\u0019\u0003OI1!!\u000b\u001a\u0005\rIe\u000e\u001e\u0005\n\u0003[\u0001\u0011\u0011!C\u0001\u0003_\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002Q\u0003cA!\"a\r\u0002,\u0005\u0005\t\u0019AA\u0013\u0003\rAH%\r\u0005\n\u0003o\u0001\u0011\u0011!C!\u0003s\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003w\u0001R!!\u0010\u0002DAk!!a\u0010\u000b\u0007\u0005\u0005\u0013$\u0001\u0006d_2dWm\u0019;j_:LA!!\u0012\u0002@\tA\u0011\n^3sCR|'\u000fC\u0005\u0002J\u0001\t\t\u0011\"\u0001\u0002L\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002N\u0005M\u0003c\u0001\r\u0002P%\u0019\u0011\u0011K\r\u0003\u000f\t{w\u000e\\3b]\"I\u00111GA$\u0003\u0003\u0005\r\u0001\u0015\u0005\n\u0003/\u0002\u0011\u0011!C!\u00033\na!Z9vC2\u001cH\u0003BA'\u00037B\u0011\"a\r\u0002V\u0005\u0005\t\u0019\u0001))\u0017\u0001\ty&!\u001a\u0002h\u0005-\u0014Q\u000e\t\u0004#\u0005\u0005\u0014bAA2\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA5\u0003\u0005UqLR+O\u0007~CC-\u0019;f_QLW.Z:uC6\u0004xf\u001d;sS:<G\u0006\t4ni&\u0002S\u0006I\"p]Z,'\u000f^:!C\u0002\"\u0017\r^30i&lWm\u001d;b[B|3\u000f\u001e:j]\u001e\u0004Co\u001c\u0011bAY\fG.^3!_\u001a\u00043\u000f\u001e:j]\u001e\u0004\u0013N\u001c\u0011uQ\u0016\u0004cm\u001c:nCR\u00043\u000f]3dS\u001aLW\r\u001a\u0011cs\u0002\"\b.\u001a\u0011eCR,\u0007EZ8s[\u0006$\bEZ7u]\u0005AQ\r\u001f;f]\u0012,G-\t\u0002\u0002p\u0005Qc\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T\u0006\r\u001b.aa:C\u0006I\u0014zO%R\u0001e\n\u001a1cY:s!CA:\u0005\u0005\u0005\t\u0012AA;\u0003=!\u0015\r^3G_Jl\u0017\r^\"mCN\u001c\bcA\t\u0002x\u0019A\u0011AAA\u0001\u0012\u0003\tIhE\u0003\u0002x\u0005mT\u0004E\u0004\u0002~\u0005\r5eI\u0018\u000e\u0005\u0005}$bAAA3\u00059!/\u001e8uS6,\u0017\u0002BAC\u0003\u007f\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001di\u0013q\u000fC\u0001\u0003\u0013#\"!!\u001e\t\u0015\u00055\u0015qOA\u0001\n\u000b\ny)\u0001\u0005u_N#(/\u001b8h)\t\t\t\u0002\u0003\u0006\u0002\u0014\u0006]\u0014\u0011!CA\u0003+\u000bQ!\u00199qYf$RaLAL\u00033Ca!IAI\u0001\u0004\u0019\u0003BB\u0015\u0002\u0012\u0002\u00071\u0005\u0003\u0006\u0002\u001e\u0006]\u0014\u0011!CA\u0003?\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\"\u00065\u0006#\u0002\r\u0002$\u0006\u001d\u0016bAAS3\t1q\n\u001d;j_:\u0004R\u0001GAUG\rJ1!a+\u001a\u0005\u0019!V\u000f\u001d7fe!I\u0011qVAN\u0003\u0003\u0005\raL\u0001\u0004q\u0012\u0002\u0004BCAZ\u0003o\n\t\u0011\"\u0003\u00026\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\f\u0005\u0003\u0002\u0014\u0005e\u0016\u0002BA^\u0003+\u0011aa\u00142kK\u000e$\b")
public class DateFormatClass
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(DateFormatClass dateFormatClass) {
        return DateFormatClass$.MODULE$.unapply(dateFormatClass);
    }

    public static Function1<Tuple2<Expression, Expression>, DateFormatClass> tupled() {
        return DateFormatClass$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, DateFormatClass>> curried() {
        return DateFormatClass$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object timestamp, Object format2) {
        SimpleDateFormat sdf = new SimpleDateFormat(format2.toString());
        return UTF8String.fromString((String)sdf.format(new Date(BoxesRunTime.unboxToLong((Object)timestamp) / 1000L)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String sdf = SimpleDateFormat.class.getName();
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, sdf){
            public static final long serialVersionUID = 0L;
            private final String sdf$1;

            public final String apply(String timestamp, String format2) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UTF8String.fromString((new ", "(", ".toString()))\n          .format(new java.util.Date(", " / 1000)))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sdf$1, format2, timestamp}));
            }
            {
                this.sdf$1 = sdf$1;
            }
        });
    }

    @Override
    public String prettyName() {
        return "date_format";
    }

    public DateFormatClass copy(Expression left, Expression right) {
        return new DateFormatClass(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "DateFormatClass";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateFormatClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateFormatClass)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateFormatClass dateFormatClass = (DateFormatClass)x$1;
        Expression expression = this.left();
        Expression expression2 = dateFormatClass.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = dateFormatClass.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!dateFormatClass.canEqual(this)) return false;
        return true;
    }

    public DateFormatClass(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
    }
}

