/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\tEc\u0001B\u0001\u0003\u0001=\u0011\u0011#U;b]RLG.Z*v[6\f'/[3t\u0015\t\u0019A!\u0001\u0003vi&d'BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"!E\f\n\u0005a\u0011\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011A\u000e\u0002#\r|W\u000e\u001d:fgN$\u0006N]3tQ>dG-F\u0001\u001d!\t\tR$\u0003\u0002\u001f%\t\u0019\u0011J\u001c;\t\u0011\u0001\u0002!\u0011!Q\u0001\nq\t!cY8naJ,7o\u001d+ie\u0016\u001c\bn\u001c7eA!A!\u0005\u0001BC\u0002\u0013\u00051%A\u0007sK2\fG/\u001b<f\u000bJ\u0014xN]\u000b\u0002IA\u0011\u0011#J\u0005\u0003MI\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u001dI,G.\u0019;jm\u0016,%O]8sA!A!\u0006\u0001BC\u0002\u0013\u00051&A\u0004tC6\u0004H.\u001a3\u0016\u00031\u00022!E\u00170\u0013\tq#CA\u0003BeJ\f\u0017\u0010\u0005\u00021+:\u0011\u0011\u0007\u0011\b\u0003e}r!a\r \u000f\u0005QjdBA\u001b=\u001d\t14H\u0004\u00028u5\t\u0001H\u0003\u0002:\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019AaB\u0003B\u0005!\u0005!)A\tRk\u0006tG/\u001b7f'VlW.\u0019:jKN\u0004\"a\u0011#\u000e\u0003\t1Q!\u0001\u0002\t\u0002\u0015\u001b2\u0001\u0012\t\u0017\u0011\u00159E\t\"\u0001I\u0003\u0019a\u0014N\\5u}Q\t!\tC\u0004K\t\n\u0007I\u0011A\u000e\u00021\u0011,g-Y;mi\u000e{W\u000e\u001d:fgN$\u0006N]3tQ>dG\r\u0003\u0004M\t\u0002\u0006I\u0001H\u0001\u001aI\u00164\u0017-\u001e7u\u0007>l\u0007O]3tgRC'/Z:i_2$\u0007\u0005C\u0004O\t\n\u0007I\u0011A\u000e\u0002\u001f\u0011,g-Y;mi\"+\u0017\rZ*ju\u0016Da\u0001\u0015#!\u0002\u0013a\u0012\u0001\u00053fM\u0006,H\u000e\u001e%fC\u0012\u001c\u0016N_3!\u0011\u001d\u0011FI1A\u0005\u0002\r\nA\u0003Z3gCVdGOU3mCRLg/Z#se>\u0014\bB\u0002+EA\u0003%A%A\u000beK\u001a\fW\u000f\u001c;SK2\fG/\u001b<f\u000bJ\u0014xN\u001d\u0011\u0007\tY#\u0005i\u0016\u0002\u0006'R\fGo]\n\u0005+BAf\u0003\u0005\u0002\u00123&\u0011!L\u0005\u0002\b!J|G-^2u\u0011!aVK!f\u0001\n\u0003\u0019\u0013!\u0002<bYV,\u0007\u0002\u00030V\u0005#\u0005\u000b\u0011\u0002\u0013\u0002\rY\fG.^3!\u0011!\u0001WK!f\u0001\n\u0003Y\u0012!A4\t\u0011\t,&\u0011#Q\u0001\nq\t!a\u001a\u0011\t\u0011\u0011,&Q3A\u0005\u0002m\tQ\u0001Z3mi\u0006D\u0001BZ+\u0003\u0012\u0003\u0006I\u0001H\u0001\u0007I\u0016dG/\u0019\u0011\t\u000b\u001d+F\u0011\u00015\u0015\t%\\G.\u001c\t\u0003UVk\u0011\u0001\u0012\u0005\u00069\u001e\u0004\r\u0001\n\u0005\u0006A\u001e\u0004\r\u0001\b\u0005\u0006I\u001e\u0004\r\u0001\b\u0005\b_V\u000b\t\u0011\"\u0001q\u0003\u0011\u0019w\u000e]=\u0015\t%\f(o\u001d\u0005\b9:\u0004\n\u00111\u0001%\u0011\u001d\u0001g\u000e%AA\u0002qAq\u0001\u001a8\u0011\u0002\u0003\u0007A\u0004C\u0004v+F\u0005I\u0011\u0001<\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tqO\u000b\u0002%q.\n\u0011\u0010\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003}J\t!\"\u00198o_R\fG/[8o\u0013\r\t\ta\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u0003+F\u0005I\u0011AA\u0004\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u0003+\u0005qA\b\"CA\u0007+F\u0005I\u0011AA\u0004\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB\u0011\"!\u0005V\u0003\u0003%\t%a\u0005\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\t1\fgn\u001a\u0006\u0003\u0003?\tAA[1wC&!\u00111EA\r\u0005\u0019\u0019FO]5oO\"A\u0011qE+\u0002\u0002\u0013\u00051$\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0002,U\u000b\t\u0011\"\u0001\u0002.\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0018\u0003k\u00012!EA\u0019\u0013\r\t\u0019D\u0005\u0002\u0004\u0003:L\b\"CA\u001c\u0003S\t\t\u00111\u0001\u001d\u0003\rAH%\r\u0005\n\u0003w)\u0016\u0011!C!\u0003{\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u007f\u0001b!!\u0011\u0002H\u0005=RBAA\"\u0015\r\t)EE\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA%\u0003\u0007\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u001b*\u0016\u0011!C\u0001\u0003\u001f\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003#\n9\u0006E\u0002\u0012\u0003'J1!!\u0016\u0013\u0005\u001d\u0011un\u001c7fC:D!\"a\u000e\u0002L\u0005\u0005\t\u0019AA\u0018\u0011%\tY&VA\u0001\n\u0003\ni&\u0001\u0005iCND7i\u001c3f)\u0005a\u0002\"CA1+\u0006\u0005I\u0011IA2\u0003!!xn\u0015;sS:<GCAA\u000b\u0011%\t9'VA\u0001\n\u0003\nI'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003#\nY\u0007\u0003\u0006\u00028\u0005\u0015\u0014\u0011!a\u0001\u0003_9\u0011\"a\u001cE\u0003\u0003E\t!!\u001d\u0002\u000bM#\u0018\r^:\u0011\u0007)\f\u0019H\u0002\u0005W\t\u0006\u0005\t\u0012AA;'\u0015\t\u0019(a\u001e\u0017!!\tI(a %9qIWBAA>\u0015\r\tiHE\u0001\beVtG/[7f\u0013\u0011\t\t)a\u001f\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004H\u0003g\"\t!!\"\u0015\u0005\u0005E\u0004BCA1\u0003g\n\t\u0011\"\u0012\u0002d!Q\u00111RA:\u0003\u0003%\t)!$\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f%\fy)!%\u0002\u0014\"1A,!#A\u0002\u0011Ba\u0001YAE\u0001\u0004a\u0002B\u00023\u0002\n\u0002\u0007A\u0004\u0003\u0006\u0002\u0018\u0006M\u0014\u0011!CA\u00033\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u001c\u0006\u001d\u0006#B\t\u0002\u001e\u0006\u0005\u0016bAAP%\t1q\n\u001d;j_:\u0004b!EARIqa\u0012bAAS%\t1A+\u001e9mKNB\u0011\"!+\u0002\u0016\u0006\u0005\t\u0019A5\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002.\u0006M\u0014\u0011!C\u0005\u0003_\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0017\t\u0005\u0003/\t\u0019,\u0003\u0003\u00026\u0006e!AB(cU\u0016\u001cG\u000fC\u0004\u0002:\u0012#I!a/\u0002\u001b\r|W\u000e\u001d:fgNLU.\\;u)\u0019\ti,a0\u0002VB\u0019\u0011#L5\t\u0011\u0005\u0005\u0017q\u0017a\u0001\u0003\u0007\fabY;se\u0016tGoU1na2,7\u000fE\u0003\u0002F\u0006=\u0017N\u0004\u0003\u0002H\u0006-gbA\u001c\u0002J&\t1#C\u0002\u0002NJ\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002R\u0006M'AC%oI\u0016DX\rZ*fc*\u0019\u0011Q\u001a\n\t\u000f\u0005]\u0017q\u0017a\u0001I\u0005qQ.\u001a:hKRC'/Z:i_2$\u0007\"CAn\tF\u0005I\u0011AAo\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u001c\u0016\u0004\u0003{C\b\"CAr\tF\u0005I\u0011AAs\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u001d\u0016\u0004\u0003SD\bcA\t\u0002l&\u0019\u0011Q\u001e\n\u0003\t1{gn\u001a\u0005\n\u0003[#\u0015\u0011!C\u0005\u0003_C\u0011\"a=\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\u0002\u0011M\fW\u000e\u001d7fI\u0002B!\"a>\u0001\u0005\u000b\u0007I\u0011AA}\u0003\u0015\u0019w.\u001e8u+\t\tI\u000f\u0003\u0006\u0002~\u0002\u0011\t\u0011)A\u0005\u0003S\faaY8v]R\u0004\u0003BB$\u0001\t\u0003\u0011\t\u0001\u0006\u0006\u0003\u0004\t\u0015!q\u0001B\u0005\u0005\u0017\u0001\"a\u0011\u0001\t\ri\ty\u00101\u0001\u001d\u0011\u0019\u0011\u0013q a\u0001I!A!&a@\u0011\u0002\u0003\u0007A\u0006\u0003\u0006\u0002x\u0006}\b\u0013!a\u0001\u0003SD\u0011Ba\u0004\u0001\u0005\u0004%IA!\u0005\u0002\u0017!,\u0017\rZ*b[BdW\rZ\u000b\u0003\u0005'\u0001RA!\u0006\u0003\u001c\u0011j!Aa\u0006\u000b\t\te\u00111I\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011iBa\u0006\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\t\u0005C\u0001\u0001\u0015!\u0003\u0003\u0014\u0005a\u0001.Z1e'\u0006l\u0007\u000f\\3eA!9!Q\u0005\u0001\u0005\u0002\t\u001d\u0012AB5og\u0016\u0014H\u000f\u0006\u0003\u0003\u0004\t%\u0002b\u0002B\u0016\u0005G\u0001\r\u0001J\u0001\u0002q\"9!q\u0006\u0001\u0005\n\tE\u0012AF<ji\"DU-\u00193Ck\u001a4WM]%og\u0016\u0014H/\u001a3\u0016\u0005\t\r\u0001b\u0002B\u001b\u0001\u0011\u0005!qG\u0001\tG>l\u0007O]3tgR\u0011!1\u0001\u0005\b\u0005w\u0001A\u0011\u0002B\u0019\u0003-\u0019\b.\u00197m_^\u001cu\u000e]=\t\u000f\t}\u0002\u0001\"\u0001\u0003B\u0005)Q.\u001a:hKR!!1\u0001B\"\u0011!\u0011)E!\u0010A\u0002\t\r\u0011!B8uQ\u0016\u0014\bb\u0002B%\u0001\u0011\u0005!1J\u0001\u0006cV,'/\u001f\u000b\u0004I\t5\u0003b\u0002B(\u0005\u000f\u0002\r\u0001J\u0001\tcV\fg\u000e^5mK\u0002")
public class QuantileSummaries
implements Serializable {
    private final int compressThreshold;
    private final double relativeError;
    private final Stats[] sampled;
    private final long count;
    private final ArrayBuffer<Object> headSampled;

    public static long $lessinit$greater$default$4() {
        return QuantileSummaries$.MODULE$.$lessinit$greater$default$4();
    }

    public static Stats[] $lessinit$greater$default$3() {
        return QuantileSummaries$.MODULE$.$lessinit$greater$default$3();
    }

    public static double defaultRelativeError() {
        return QuantileSummaries$.MODULE$.defaultRelativeError();
    }

    public static int defaultHeadSize() {
        return QuantileSummaries$.MODULE$.defaultHeadSize();
    }

    public static int defaultCompressThreshold() {
        return QuantileSummaries$.MODULE$.defaultCompressThreshold();
    }

    public int compressThreshold() {
        return this.compressThreshold;
    }

    public double relativeError() {
        return this.relativeError;
    }

    public Stats[] sampled() {
        return this.sampled;
    }

    public long count() {
        return this.count;
    }

    private ArrayBuffer<Object> headSampled() {
        return this.headSampled;
    }

    public QuantileSummaries insert(double x) {
        QuantileSummaries result;
        this.headSampled().$plus$eq((Object)BoxesRunTime.boxToDouble((double)x));
        return this.headSampled().size() >= QuantileSummaries$.MODULE$.defaultHeadSize() ? ((result = this.withHeadBufferInserted()).sampled().length >= this.compressThreshold() ? result.compress() : result) : this;
    }

    private QuantileSummaries withHeadBufferInserted() {
        if (this.headSampled().isEmpty()) {
            return this;
        }
        long currentCount = this.count();
        double[] sorted = (double[])Predef$.MODULE$.doubleArrayOps((double[])this.headSampled().toArray(ClassTag$.MODULE$.Double())).sorted((Ordering)Ordering.Double$.MODULE$);
        ArrayBuffer newSamples = new ArrayBuffer();
        int sampleIdx = 0;
        for (int opsIdx = 0; opsIdx < sorted.length; ++opsIdx) {
            double currentSample = sorted[opsIdx];
            while (sampleIdx < this.sampled().length && this.sampled()[sampleIdx].value() <= currentSample) {
                newSamples.$plus$eq((Object)this.sampled()[sampleIdx]);
                ++sampleIdx;
            }
            int delta = newSamples.isEmpty() || sampleIdx == this.sampled().length && opsIdx == sorted.length - 1 ? 0 : (int)package$.MODULE$.floor((double)2 * this.relativeError() * (double)(++currentCount));
            Stats tuple2 = new Stats(currentSample, 1, delta);
            newSamples.$plus$eq((Object)tuple2);
        }
        while (sampleIdx < this.sampled().length) {
            newSamples.$plus$eq((Object)this.sampled()[sampleIdx]);
            ++sampleIdx;
        }
        return new QuantileSummaries(this.compressThreshold(), this.relativeError(), (Stats[])newSamples.toArray(ClassTag$.MODULE$.apply(Stats.class)), currentCount);
    }

    public QuantileSummaries compress() {
        QuantileSummaries inserted = this.withHeadBufferInserted();
        Predef$.MODULE$.assert(inserted.headSampled().isEmpty());
        Predef$.MODULE$.assert(inserted.count() == this.count() + (long)this.headSampled().size());
        Stats[] compressed = QuantileSummaries$.MODULE$.org$apache$spark$sql$catalyst$util$QuantileSummaries$$compressImmut((IndexedSeq<Stats>)Predef$.MODULE$.wrapRefArray((Object[])inserted.sampled()), (double)2 * this.relativeError() * (double)inserted.count());
        return new QuantileSummaries(this.compressThreshold(), this.relativeError(), compressed, inserted.count());
    }

    private QuantileSummaries shallowCopy() {
        return new QuantileSummaries(this.compressThreshold(), this.relativeError(), this.sampled(), this.count());
    }

    public QuantileSummaries merge(QuantileSummaries other) {
        QuantileSummaries quantileSummaries;
        Predef$.MODULE$.require(this.headSampled().isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Current buffer needs to be compressed before merge";
            }
        });
        Predef$.MODULE$.require(other.headSampled().isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Other buffer needs to be compressed before merge";
            }
        });
        if (other.count() == 0L) {
            quantileSummaries = this.shallowCopy();
        } else if (this.count() == 0L) {
            quantileSummaries = other.shallowCopy();
        } else {
            Stats[] res = (Stats[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.sampled()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])other.sampled()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Stats.class)))).sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Stats x$1) {
                    return x$1.value();
                }
            }, (Ordering)Ordering.Double$.MODULE$);
            Stats[] comp = QuantileSummaries$.MODULE$.org$apache$spark$sql$catalyst$util$QuantileSummaries$$compressImmut((IndexedSeq<Stats>)Predef$.MODULE$.wrapRefArray((Object[])res), (double)2 * this.relativeError() * (double)this.count());
            quantileSummaries = new QuantileSummaries(other.compressThreshold(), other.relativeError(), comp, other.count() + this.count());
        }
        return quantileSummaries;
    }

    public double query(double quantile) {
        Predef$.MODULE$.require(quantile >= 0.0 && quantile <= 1.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "quantile should be in the range [0.0, 1.0]";
            }
        });
        Predef$.MODULE$.require(this.headSampled().isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot operate on an uncompressed summary, call compress() first";
            }
        });
        if (quantile <= this.relativeError()) {
            return ((Stats)Predef$.MODULE$.refArrayOps((Object[])this.sampled()).head()).value();
        }
        if (quantile >= 1.0 - this.relativeError()) {
            return ((Stats)Predef$.MODULE$.refArrayOps((Object[])this.sampled()).last()).value();
        }
        int rank = (int)package$.MODULE$.ceil(quantile * (double)this.count());
        double targetError = package$.MODULE$.ceil(this.relativeError() * (double)this.count());
        int minRank = 0;
        for (int i = 1; i < this.sampled().length - 1; ++i) {
            Stats curSample = this.sampled()[i];
            int maxRank = (minRank += curSample.g()) + curSample.delta();
            if (!((double)maxRank - targetError <= (double)rank) || !((double)rank <= (double)minRank + targetError)) continue;
            return curSample.value();
        }
        return ((Stats)Predef$.MODULE$.refArrayOps((Object[])this.sampled()).last()).value();
    }

    public QuantileSummaries(int compressThreshold, double relativeError, Stats[] sampled, long count) {
        this.compressThreshold = compressThreshold;
        this.relativeError = relativeError;
        this.sampled = sampled;
        this.count = count;
        this.headSampled = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
    }

    public static class Stats
    implements Product,
    Serializable {
        private final double value;
        private final int g;
        private final int delta;

        public double value() {
            return this.value;
        }

        public int g() {
            return this.g;
        }

        public int delta() {
            return this.delta;
        }

        public Stats copy(double value2, int g, int delta) {
            return new Stats(value2, g, delta);
        }

        public double copy$default$1() {
            return this.value();
        }

        public int copy$default$2() {
            return this.g();
        }

        public int copy$default$3() {
            return this.delta();
        }

        public String productPrefix() {
            return "Stats";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Number number;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    number = BoxesRunTime.boxToInteger((int)this.delta());
                    break;
                }
                case 1: {
                    number = BoxesRunTime.boxToInteger((int)this.g());
                    break;
                }
                case 0: {
                    number = BoxesRunTime.boxToDouble((double)this.value());
                }
            }
            return number;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Stats;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.value()));
            n = Statics.mix((int)n, (int)this.g());
            n = Statics.mix((int)n, (int)this.delta());
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Stats)) return false;
            boolean bl = true;
            if (!bl) return false;
            Stats stats = (Stats)x$1;
            if (this.value() != stats.value()) return false;
            if (this.g() != stats.g()) return false;
            if (this.delta() != stats.delta()) return false;
            if (!stats.canEqual(this)) return false;
            return true;
        }

        public Stats(double value2, int g, int delta) {
            this.value = value2;
            this.g = g;
            this.delta = delta;
            Product.class.$init$((Product)this);
        }
    }
}

