/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LessThan$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is less than `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 1 _FUNC_ 2;\n       true\n      > SELECT 1.1 _FUNC_ '1';\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       true\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001>\u0011\u0001\u0002T3tgRC\u0017M\u001c\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u000b\u001cCA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:\u0004\"!\u0006\r\u000f\u0005E1\u0012BA\f\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0007\u000e\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011qC\u0001\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\b!J|G-^2u!\ta\"%\u0003\u0002$;\ta1+\u001a:jC2L'0\u00192mK\"AQ\u0005\u0001BK\u0002\u0013\u0005a%\u0001\u0003mK\u001a$X#A\u0014\u0011\u0005EA\u0013BA\u0015\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tW\u0001\u0011\t\u0012)A\u0005O\u0005)A.\u001a4uA!AQ\u0006\u0001BK\u0002\u0013\u0005a%A\u0003sS\u001eDG\u000f\u0003\u00050\u0001\tE\t\u0015!\u0003(\u0003\u0019\u0011\u0018n\u001a5uA!)\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"2a\r\u001b6!\t\t\u0002\u0001C\u0003&a\u0001\u0007q\u0005C\u0003.a\u0001\u0007q\u0005C\u00038\u0001\u0011\u0005\u0003(\u0001\u0004ts6\u0014w\u000e\\\u000b\u0002sA\u0011!(\u0010\b\u00039mJ!\u0001P\u000f\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003yuAQ!\u0011\u0001\u0005R\t\u000bAB\\;mYN\u000bg-Z#wC2$2a\u0011$I!\taB)\u0003\u0002F;\t\u0019\u0011I\\=\t\u000b\u001d\u0003\u0005\u0019A\"\u0002\r%t\u0007/\u001e;2\u0011\u0015I\u0005\t1\u0001D\u0003\u0019Ig\u000e];ue!91\nAA\u0001\n\u0003a\u0015\u0001B2paf$2aM'O\u0011\u001d)#\n%AA\u0002\u001dBq!\f&\u0011\u0002\u0003\u0007q\u0005C\u0004Q\u0001E\u0005I\u0011A)\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t!K\u000b\u0002('.\nA\u000b\u0005\u0002V56\taK\u0003\u0002X1\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u00033v\t!\"\u00198o_R\fG/[8o\u0013\tYfKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dq!\u0018\u0001\u0012\u0002\u0013\u0005\u0011+\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u000f}\u0003\u0011\u0011!C!A\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012!\u0019\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fA\u0001\\1oO*\ta-\u0001\u0003kCZ\f\u0017B\u0001 d\u0011\u001dI\u0007!!A\u0005\u0002)\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012a\u001b\t\u000391L!!\\\u000f\u0003\u0007%sG\u000fC\u0004p\u0001\u0005\u0005I\u0011\u00019\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00111)\u001d\u0005\be:\f\t\u00111\u0001l\u0003\rAH%\r\u0005\bi\u0002\t\t\u0011\"\u0011v\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014X#\u0001<\u0011\u0007]T8)D\u0001y\u0015\tIX$\u0001\u0006d_2dWm\u0019;j_:L!a\u001f=\u0003\u0011%#XM]1u_JDq! \u0001\u0002\u0002\u0013\u0005a0\u0001\u0005dC:,\u0015/^1m)\ry\u0018Q\u0001\t\u00049\u0005\u0005\u0011bAA\u0002;\t9!i\\8mK\u0006t\u0007b\u0002:}\u0003\u0003\u0005\ra\u0011\u0005\n\u0003\u0013\u0001\u0011\u0011!C!\u0003\u0017\ta!Z9vC2\u001cHcA@\u0002\u000e!A!/a\u0002\u0002\u0002\u0003\u00071\tK\b\u0001\u0003#\t9\"!\u0007\u0002\u001e\u0005}\u00111EA\u0013!\r\t\u00121C\u0005\u0004\u0003+\u0011!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u00037\t!)\u001a=qeF\u0002sLR+O\u0007~\u0003S\r\u001f9se\u0001j\u0003EU3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011aKb\u0004(/\r1!SN\u0004C.Z:tAQD\u0017M\u001c\u0011aKb\u0004(O\r1/\u0003%\t'oZ;nK:$8/\t\u0002\u0002\"\u0005\u0011\u0019J\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Kb\u0004(/\r\u0017!Kb\u0004(O\r\u0011.AQDW\r\t;x_\u0002*\u0007\u0010\u001d:fgNLwN\\:![V\u001cH\u000f\t2fAM\fW.\u001a\u0011usB,\u0007e\u001c:!G\u0006t\u0007EY3!G\u0006\u001cH/\u001a3!i>\u0004\u0013\rI2p[6|g\u000e\t;za\u0016d#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!C:$\u0007%\\;ti\u0002\u0012W\rI1!if\u0004X\r\t;iCR\u00043-\u00198!E\u0016\u0004sN\u001d3fe\u0016$g\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003%\\1qAQL\b/\u001a\u0011jg\u0002rw\u000e\u001e\u0011pe\u0012,'/\u00192mK2\u00023o\u001c\u0011ji*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I5tA9|G\u000fI:vaB|'\u000f^3e]\u00012uN\u001d\u0011d_6\u0004H.\u001a=!if\u0004Xm\u001d\u0011tk\u000eD\u0007%\u0019:sCf|3\u000f\u001e:vGRd\u0003\u0005\u001e5fA\u0011\fG/\u0019\u0011usB,7\u000fI8gA\u0019LW\r\u001c3tA5,8\u000f\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012W\rI8sI\u0016\u0014\u0018M\u00197f])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9#\u0001BR\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\n\u0004e\u0018$V\u001d\u000e{\u0006EM\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00112]E\u0002sLR+O\u0007~\u0003s%M\u0014<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0019\fGn]3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAQ|w\fZ1uK\":#\u0007\r\u0019:[A:Tf\r\u0019!aQR\u0014g\u000e\u001e6e\u001dJ\u0003e\u0018$V\u001d\u000e{\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006M\u001c.gA\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0019\fGn]3\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAQ|w\fZ1uK\":#\u0007\r\u0019:[A:Tf\r\u0019!aQR\u0014g\u000e\u001e6e\u001dJ\u0003e\u0018$V\u001d\u000e{\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006\r\u001d.aE\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!c\u0001zf)\u0016(D?\u0002rU\u000b\u0014'<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u001dI\u00111\u0006\u0002\u0002\u0002#\u0005\u0011QF\u0001\t\u0019\u0016\u001c8\u000f\u00165b]B\u0019\u0011#a\f\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003c\u0019R!a\f\u00024\u0005\u0002r!!\u000e\u0002<\u001d:3'\u0004\u0002\u00028)\u0019\u0011\u0011H\u000f\u0002\u000fI,h\u000e^5nK&!\u0011QHA\u001c\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bc\u0005=B\u0011AA!)\t\ti\u0003\u0003\u0006\u0002F\u0005=\u0012\u0011!C#\u0003\u000f\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002C\"Q\u00111JA\u0018\u0003\u0003%\t)!\u0014\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bM\ny%!\u0015\t\r\u0015\nI\u00051\u0001(\u0011\u0019i\u0013\u0011\na\u0001O!Q\u0011QKA\u0018\u0003\u0003%\t)a\u0016\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011LA3!\u0015a\u00121LA0\u0013\r\ti&\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bq\t\tgJ\u0014\n\u0007\u0005\rTD\u0001\u0004UkBdWM\r\u0005\n\u0003O\n\u0019&!AA\u0002M\n1\u0001\u001f\u00131\u0011)\tY'a\f\u0002\u0002\u0013%\u0011QN\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002pA\u0019!-!\u001d\n\u0007\u0005M4M\u0001\u0004PE*,7\r\u001e")
public class LessThan
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(LessThan lessThan) {
        return LessThan$.MODULE$.unapply(lessThan);
    }

    public static Function1<Tuple2<Expression, Expression>, LessThan> tupled() {
        return LessThan$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, LessThan>> curried() {
        return LessThan$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().lt(input1, input2));
    }

    public LessThan copy(Expression left, Expression right) {
        return new LessThan(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "LessThan";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LessThan;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LessThan)) return false;
        boolean bl = true;
        if (!bl) return false;
        LessThan lessThan = (LessThan)x$1;
        Expression expression = this.left();
        Expression expression2 = lessThan.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = lessThan.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!lessThan.canEqual(this)) return false;
        return true;
    }

    public LessThan(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

