/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringReplace$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, search[, replace]) - Replaces all occurrences of `search` with `replace`.", arguments="\n    Arguments:\n      * str - a string expression\n      * search - a string expression. If `search` is not found in `str`, `str` is returned unchanged.\n      * replace - a string expression. If `replace` is not specified or is an empty string, nothing replaces\n          the string that is removed from `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ABCabc', 'abc', 'DEF');\n       ABCDEF\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\u0001\u0003\u0001>\u0011Qb\u0015;sS:<'+\u001a9mC\u000e,'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001BcF\u000f\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!!\u0005+fe:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%A\u0004te\u000e,\u0005\u0010\u001d:\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0005te\u000e,\u0005\u0010\u001d:!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013AC:fCJ\u001c\u0007.\u0012=qe\"A1\u0006\u0001B\tB\u0003%1%A\u0006tK\u0006\u00148\r[#yaJ\u0004\u0003\u0002C\u0017\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\u0017I,\u0007\u000f\\1dK\u0016C\bO\u001d\u0005\t_\u0001\u0011\t\u0012)A\u0005G\u0005a!/\u001a9mC\u000e,W\t\u001f9sA!)\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"Ba\r\u001b6mA\u0011\u0011\u0003\u0001\u0005\u0006CA\u0002\ra\t\u0005\u0006SA\u0002\ra\t\u0005\u0006[A\u0002\ra\t\u0005\u0006c\u0001!\t\u0001\u000f\u000b\u0004geR\u0004\"B\u00118\u0001\u0004\u0019\u0003\"B\u00158\u0001\u0004\u0019\u0003\"\u0002\u001f\u0001\t\u0003j\u0014\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003\u0002 B\u0007\u0016\u0003\"\u0001G \n\u0005\u0001K\"aA!os\")!i\u000fa\u0001}\u000591O]2Fm\u0006d\u0007\"\u0002#<\u0001\u0004q\u0014AC:fCJ\u001c\u0007.\u0012<bY\")ai\u000fa\u0001}\u0005Y!/\u001a9mC\u000e,WI^1m\u0011\u0015A\u0005\u0001\"\u0011J\u0003%!wnR3o\u0007>$W\rF\u0002K!V\u0003\"a\u0013(\u000e\u00031S!!\u0014\u0002\u0002\u000f\r|G-Z4f]&\u0011q\n\u0014\u0002\t\u000bb\u0004(oQ8eK\")\u0011k\u0012a\u0001%\u0006\u00191\r\u001e=\u0011\u0005-\u001b\u0016B\u0001+M\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQAV$A\u0002)\u000b!!\u001a<\t\u000ba\u0003A\u0011I-\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;\u001a\tQ\u0001^=qKNL!a\u0018/\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ!\u0019\u0001\u0005B\t\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005\u0019\u0007c\u00013m5:\u0011QM\u001b\b\u0003M&l\u0011a\u001a\u0006\u0003Q:\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005-L\u0012a\u00029bG.\fw-Z\u0005\u0003[:\u00141aU3r\u0015\tY\u0017\u0004C\u0003q\u0001\u0011\u0005\u0013/\u0001\u0005dQ&dGM]3o+\u0005\u0011\bc\u00013mG!)A\u000f\u0001C!k\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003Y\u0004\"a\u001e>\u000f\u0005aA\u0018BA=\u001a\u0003\u0019\u0001&/\u001a3fM&\u00111\u0010 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005eL\u0002b\u0002@\u0001\u0003\u0003%\ta`\u0001\u0005G>\u0004\u0018\u0010F\u00044\u0003\u0003\t\u0019!!\u0002\t\u000f\u0005j\b\u0013!a\u0001G!9\u0011& I\u0001\u0002\u0004\u0019\u0003bB\u0017~!\u0003\u0005\ra\t\u0005\n\u0003\u0013\u0001\u0011\u0013!C\u0001\u0003\u0017\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u000e)\u001a1%a\u0004,\u0005\u0005E\u0001\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0007\u001a\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\t)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\t\u0001#\u0003%\t!a\u0003\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011q\u0005\u0001\u0012\u0002\u0013\u0005\u00111B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011%\tY\u0003AA\u0001\n\u0003\ni#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003_\u0001B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$\u0001\u0003mC:<'BAA\u001d\u0003\u0011Q\u0017M^1\n\u0007m\f\u0019\u0004C\u0005\u0002@\u0001\t\t\u0011\"\u0001\u0002B\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\t\t\u00041\u0005\u0015\u0013bAA$3\t\u0019\u0011J\u001c;\t\u0013\u0005-\u0003!!A\u0005\u0002\u00055\u0013A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004}\u0005=\u0003BCA)\u0003\u0013\n\t\u00111\u0001\u0002D\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005U\u0003!!A\u0005B\u0005]\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\u0003#BA.\u0003CrTBAA/\u0015\r\ty&G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA2\u0003;\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003O\u0002\u0011\u0011!C\u0001\u0003S\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003W\n\t\bE\u0002\u0019\u0003[J1!a\u001c\u001a\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0015\u0002f\u0005\u0005\t\u0019\u0001 \t\u0013\u0005U\u0004!!A\u0005B\u0005]\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002l\u0005e\u0004\"CA)\u0003g\n\t\u00111\u0001?Q=\u0001\u0011QPAB\u0003\u000b\u000bI)a#\u0002\u0010\u0006E\u0005cA\t\u0002\u0000%\u0019\u0011\u0011\u0011\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qQ\u0001V?\u001a+fjQ0)gR\u0014H\u0006I:fCJ\u001c\u0007n\u0017\u0017!e\u0016\u0004H.Y2f;&\u0002S\u0006\t*fa2\f7-Z:!C2d\u0007e\\2dkJ\u0014XM\\2fg\u0002zg\r\t1tK\u0006\u00148\r\u001b1!o&$\b\u000e\t1sKBd\u0017mY3a]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003\u001b\u000b!\u0011\u000f\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$(\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0016!g\u0016\f'o\u00195![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o]\u0001Je\r\t1tK\u0006\u00148\r\u001b1!SN\u0004cn\u001c;!M>,h\u000e\u001a\u0011j]\u0002\u00027\u000f\u001e:aY\u0001\u00027\u000f\u001e:aA%\u001c\bE]3ukJtW\r\u001a\u0011v]\u000eD\u0017M\\4fI:R\u0001\u0005\t\u0011!A\u0001R\u0003E]3qY\u0006\u001cW\rI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!\u0013\u001a\u0004\u0003M]3qY\u0006\u001cW\r\u0019\u0011jg\u0002rw\u000e\u001e\u0011ta\u0016\u001c\u0017NZ5fI\u0002z'\u000fI5tA\u0005t\u0007%Z7qif\u00043\u000f\u001e:j]\u001ed\u0003E\\8uQ&tw\r\t:fa2\f7-Z:\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u000f[3!gR\u0014\u0018N\\4!i\"\fG\u000fI5tAI,Wn\u001c<fI\u00022'o\\7!AN$(\u000f\u0019\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003'\u000baJ\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u0003\n\u001b\u0015MY2(Y\u0001:\u0013MY2(Y\u0001:C)\u0012$(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013IQ\"E\u000b\u001aS\u0001\u0005I\u0004\n\u0003/\u0013\u0011\u0011!E\u0001\u00033\u000bQb\u0015;sS:<'+\u001a9mC\u000e,\u0007cA\t\u0002\u001c\u001aA\u0011AAA\u0001\u0012\u0003\tijE\u0003\u0002\u001c\u0006}U\u0004\u0005\u0005\u0002\"\u0006\u001d6eI\u00124\u001b\t\t\u0019KC\u0002\u0002&f\tqA];oi&lW-\u0003\u0003\u0002*\u0006\r&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9\u0011'a'\u0005\u0002\u00055FCAAM\u0011)\t\t,a'\u0002\u0002\u0013\u0015\u00131W\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u0006\u0005\u000b\u0003o\u000bY*!A\u0005\u0002\u0006e\u0016!B1qa2LHcB\u001a\u0002<\u0006u\u0016q\u0018\u0005\u0007C\u0005U\u0006\u0019A\u0012\t\r%\n)\f1\u0001$\u0011\u0019i\u0013Q\u0017a\u0001G!Q\u00111YAN\u0003\u0003%\t)!2\u0002\u000fUt\u0017\r\u001d9msR!\u0011qYAj!\u0015A\u0012\u0011ZAg\u0013\r\tY-\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ra\tymI\u0012$\u0013\r\t\t.\u0007\u0002\u0007)V\u0004H.Z\u001a\t\u0013\u0005U\u0017\u0011YA\u0001\u0002\u0004\u0019\u0014a\u0001=%a!Q\u0011\u0011\\AN\u0003\u0003%I!a7\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003;\u0004B!!\r\u0002`&!\u0011\u0011]A\u001a\u0005\u0019y%M[3di\u0002")
public class StringReplace
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression srcExpr;
    private final Expression searchExpr;
    private final Expression replaceExpr;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringReplace stringReplace) {
        return StringReplace$.MODULE$.unapply(stringReplace);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringReplace> tupled() {
        return StringReplace$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringReplace>>> curried() {
        return StringReplace$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression srcExpr() {
        return this.srcExpr;
    }

    public Expression searchExpr() {
        return this.searchExpr;
    }

    public Expression replaceExpr() {
        return this.replaceExpr;
    }

    @Override
    public Object nullSafeEval(Object srcEval, Object searchEval, Object replaceEval) {
        return ((UTF8String)srcEval).replace((UTF8String)searchEval, (UTF8String)replaceEval);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)new Serializable(this, ev){
            public static final long serialVersionUID = 0L;
            private final ExprCode ev$1;

            public final String apply(String src, String search2, String replace) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = ", ".replace(", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ev$1.value(), src, search2, replace}));
            }
            {
                this.ev$1 = ev$1;
            }
        });
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.srcExpr();
        Expression expression2 = this.searchExpr();
        Expression expression3 = this.replaceExpr();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "replace";
    }

    public StringReplace copy(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        return new StringReplace(srcExpr, searchExpr, replaceExpr);
    }

    public Expression copy$default$1() {
        return this.srcExpr();
    }

    public Expression copy$default$2() {
        return this.searchExpr();
    }

    public Expression copy$default$3() {
        return this.replaceExpr();
    }

    @Override
    public String productPrefix() {
        return "StringReplace";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.replaceExpr();
                break;
            }
            case 1: {
                expression = this.searchExpr();
                break;
            }
            case 0: {
                expression = this.srcExpr();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringReplace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringReplace stringReplace = (StringReplace)x$1;
        Expression expression = this.srcExpr();
        Expression expression2 = stringReplace.srcExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.searchExpr();
        Expression expression4 = stringReplace.searchExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replaceExpr();
        Expression expression6 = stringReplace.replaceExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringReplace.canEqual(this)) return false;
        return true;
    }

    public StringReplace(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        this.srcExpr = srcExpr;
        this.searchExpr = searchExpr;
        this.replaceExpr = replaceExpr;
        ExpectsInputTypes$class.$init$(this);
    }

    public StringReplace(Expression srcExpr, Expression searchExpr) {
        this(srcExpr, searchExpr, Literal$.MODULE$.apply(""));
    }
}

