/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.codegen.BufferHolder;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.bitset.BitSetMethods;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class UnsafeArrayWriter {
    private BufferHolder holder;
    private int startingOffset;
    private int numElements;
    private int headerInBytes;

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.numElements) : "index (" + index + ") should < " + this.numElements;
    }

    public void initialize(BufferHolder holder, int numElements, int elementSize) {
        int i;
        this.numElements = numElements;
        this.headerInBytes = UnsafeArrayData.calculateHeaderPortionInBytes(numElements);
        this.holder = holder;
        this.startingOffset = holder.cursor;
        int fixedPartInBytes = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)(elementSize * numElements));
        holder.grow(this.headerInBytes + fixedPartInBytes);
        Platform.putLong((Object)holder.buffer, (long)this.startingOffset, (long)numElements);
        for (i = 8; i < this.headerInBytes; i += 8) {
            Platform.putLong((Object)holder.buffer, (long)(this.startingOffset + i), (long)0L);
        }
        for (i = elementSize * numElements; i < fixedPartInBytes; ++i) {
            Platform.putByte((Object)holder.buffer, (long)(this.startingOffset + this.headerInBytes + i), (byte)0);
        }
        holder.cursor += this.headerInBytes + fixedPartInBytes;
    }

    private void zeroOutPaddingBytes(int numBytes) {
        if ((numBytes & 7) > 0) {
            Platform.putLong((Object)this.holder.buffer, (long)(this.holder.cursor + (numBytes >> 3 << 3)), (long)0L);
        }
    }

    private long getElementOffset(int ordinal, int elementSize) {
        return this.startingOffset + this.headerInBytes + ordinal * elementSize;
    }

    public void setOffsetAndSize(int ordinal, long currentCursor, int size) {
        this.assertIndexIsValid(ordinal);
        long relativeOffset = currentCursor - (long)this.startingOffset;
        long offsetAndSize = relativeOffset << 32 | (long)size;
        this.write(ordinal, offsetAndSize);
    }

    private void setNullBit(int ordinal) {
        this.assertIndexIsValid(ordinal);
        BitSetMethods.set((Object)this.holder.buffer, (long)(this.startingOffset + 8), (int)ordinal);
    }

    public void setNullBoolean(int ordinal) {
        this.setNullBit(ordinal);
        Platform.putBoolean((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 1), (boolean)false);
    }

    public void setNullByte(int ordinal) {
        this.setNullBit(ordinal);
        Platform.putByte((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 1), (byte)0);
    }

    public void setNullShort(int ordinal) {
        this.setNullBit(ordinal);
        Platform.putShort((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 2), (short)0);
    }

    public void setNullInt(int ordinal) {
        this.setNullBit(ordinal);
        Platform.putInt((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 4), (int)0);
    }

    public void setNullLong(int ordinal) {
        this.setNullBit(ordinal);
        Platform.putLong((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 8), (long)0L);
    }

    public void setNullFloat(int ordinal) {
        this.setNullBit(ordinal);
        Platform.putFloat((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 4), (float)0.0f);
    }

    public void setNullDouble(int ordinal) {
        this.setNullBit(ordinal);
        Platform.putDouble((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 8), (double)0.0);
    }

    public void setNull(int ordinal) {
        this.setNullLong(ordinal);
    }

    public void write(int ordinal, boolean value2) {
        this.assertIndexIsValid(ordinal);
        Platform.putBoolean((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 1), (boolean)value2);
    }

    public void write(int ordinal, byte value2) {
        this.assertIndexIsValid(ordinal);
        Platform.putByte((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 1), (byte)value2);
    }

    public void write(int ordinal, short value2) {
        this.assertIndexIsValid(ordinal);
        Platform.putShort((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 2), (short)value2);
    }

    public void write(int ordinal, int value2) {
        this.assertIndexIsValid(ordinal);
        Platform.putInt((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 4), (int)value2);
    }

    public void write(int ordinal, long value2) {
        this.assertIndexIsValid(ordinal);
        Platform.putLong((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 8), (long)value2);
    }

    public void write(int ordinal, float value2) {
        if (Float.isNaN(value2)) {
            value2 = Float.NaN;
        }
        this.assertIndexIsValid(ordinal);
        Platform.putFloat((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 4), (float)value2);
    }

    public void write(int ordinal, double value2) {
        if (Double.isNaN(value2)) {
            value2 = Double.NaN;
        }
        this.assertIndexIsValid(ordinal);
        Platform.putDouble((Object)this.holder.buffer, (long)this.getElementOffset(ordinal, 8), (double)value2);
    }

    public void write(int ordinal, Decimal input, int precision, int scale) {
        this.assertIndexIsValid(ordinal);
        if (input.changePrecision(precision, scale)) {
            if (precision <= Decimal.MAX_LONG_DIGITS()) {
                this.write(ordinal, input.toUnscaledLong());
            } else {
                byte[] bytes = input.toJavaBigDecimal().unscaledValue().toByteArray();
                int numBytes = bytes.length;
                assert (numBytes <= 16);
                int roundedSize = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
                this.holder.grow(roundedSize);
                this.zeroOutPaddingBytes(numBytes);
                Platform.copyMemory((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (Object)this.holder.buffer, (long)this.holder.cursor, (long)numBytes);
                this.setOffsetAndSize(ordinal, this.holder.cursor, numBytes);
                this.holder.cursor += roundedSize;
            }
        } else {
            this.setNull(ordinal);
        }
    }

    public void write(int ordinal, UTF8String input) {
        int numBytes = input.numBytes();
        int roundedSize = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
        this.holder.grow(roundedSize);
        this.zeroOutPaddingBytes(numBytes);
        input.writeToMemory((Object)this.holder.buffer, (long)this.holder.cursor);
        this.setOffsetAndSize(ordinal, this.holder.cursor, numBytes);
        this.holder.cursor += roundedSize;
    }

    public void write(int ordinal, byte[] input) {
        int numBytes = input.length;
        int roundedSize = ByteArrayMethods.roundNumberOfBytesToNearestWord((int)input.length);
        this.holder.grow(roundedSize);
        this.zeroOutPaddingBytes(numBytes);
        Platform.copyMemory((Object)input, (long)Platform.BYTE_ARRAY_OFFSET, (Object)this.holder.buffer, (long)this.holder.cursor, (long)numBytes);
        this.setOffsetAndSize(ordinal, this.holder.cursor, numBytes);
        this.holder.cursor += roundedSize;
    }

    public void write(int ordinal, CalendarInterval input) {
        this.holder.grow(16);
        Platform.putLong((Object)this.holder.buffer, (long)this.holder.cursor, (long)input.months);
        Platform.putLong((Object)this.holder.buffer, (long)(this.holder.cursor + 8), (long)input.microseconds);
        this.setOffsetAndSize(ordinal, this.holder.cursor, 16);
        this.holder.cursor += 16;
    }
}

