/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regexp, rep) - Replaces all substrings of `str` that match `regexp` with `rep`.", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\d+)', 'num');\n       num-num\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t%d\u0001B\u0001\u0003\u0001>\u0011QBU3h\u000bb\u0004(+\u001a9mC\u000e,'BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001BcF\u000f\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!!\u0005+fe:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%A\u0004tk\nTWm\u0019;\u0016\u0003\r\u0002\"!\u0005\u0013\n\u0005\u0015\u0012!AC#yaJ,7o]5p]\"Aq\u0005\u0001B\tB\u0003%1%\u0001\u0005tk\nTWm\u0019;!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013A\u0002:fO\u0016D\b\u000f\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003\u001d\u0011XmZ3ya\u0002B\u0001\"\f\u0001\u0003\u0016\u0004%\tAI\u0001\u0004e\u0016\u0004\b\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\tI,\u0007\u000f\t\u0005\u0006c\u0001!\tAM\u0001\u0007y%t\u0017\u000e\u001e \u0015\tM\"TG\u000e\t\u0003#\u0001AQ!\t\u0019A\u0002\rBQ!\u000b\u0019A\u0002\rBQ!\f\u0019A\u0002\rB\u0011\u0002\u000f\u0001A\u0002\u0003\u0007I\u0011B\u001d\u0002\u00131\f7\u000f\u001e*fO\u0016DX#\u0001\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014!\u0002;za\u0016\u001c(BA \t\u0003\u0019)hn]1gK&\u0011\u0011\t\u0010\u0002\u000b+R3\u0005h\u0015;sS:<\u0007\"C\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003E\u00035a\u0017m\u001d;SK\u001e,\u0007p\u0018\u0013fcR\u0011Q\t\u0013\t\u00031\u0019K!aR\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u0013\n\u000b\t\u00111\u0001;\u0003\rAH%\r\u0005\u0007\u0017\u0002\u0001\u000b\u0015\u0002\u001e\u0002\u00151\f7\u000f\u001e*fO\u0016D\b\u0005\u000b\u0002K\u001bB\u0011\u0001DT\u0005\u0003\u001ff\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0013E\u0003\u0001\u0019!a\u0001\n\u0013\u0011\u0016a\u00029biR,'O\\\u000b\u0002'B\u0011AkW\u0007\u0002+*\u0011akV\u0001\u0006e\u0016<W\r\u001f\u0006\u00031f\u000bA!\u001e;jY*\t!,\u0001\u0003kCZ\f\u0017B\u0001/V\u0005\u001d\u0001\u0016\r\u001e;fe:D\u0011B\u0018\u0001A\u0002\u0003\u0007I\u0011B0\u0002\u0017A\fG\u000f^3s]~#S-\u001d\u000b\u0003\u000b\u0002Dq!S/\u0002\u0002\u0003\u00071\u000b\u0003\u0004c\u0001\u0001\u0006KaU\u0001\ta\u0006$H/\u001a:oA!\u0012\u0011-\u0014\u0005\nK\u0002\u0001\r\u00111A\u0005\n\u0019\fq\u0002\\1tiJ+\u0007\u000f\\1dK6,g\u000e^\u000b\u0002OB\u0011\u0001n\u001b\b\u00031%L!A[\r\u0002\rA\u0013X\rZ3g\u0013\taWN\u0001\u0004TiJLgn\u001a\u0006\u0003UfA\u0011b\u001c\u0001A\u0002\u0003\u0007I\u0011\u00029\u0002'1\f7\u000f\u001e*fa2\f7-Z7f]R|F%Z9\u0015\u0005\u0015\u000b\bbB%o\u0003\u0003\u0005\ra\u001a\u0005\u0007g\u0002\u0001\u000b\u0015B4\u0002!1\f7\u000f\u001e*fa2\f7-Z7f]R\u0004\u0003F\u0001:N\u0011%1\b\u00011AA\u0002\u0013%\u0011(A\u000bmCN$(+\u001a9mC\u000e,W.\u001a8u\u0013:,FK\u0012\u001d\t\u0013a\u0004\u0001\u0019!a\u0001\n\u0013I\u0018!\u00077bgR\u0014V\r\u001d7bG\u0016lWM\u001c;J]V#f\tO0%KF$\"!\u0012>\t\u000f%;\u0018\u0011!a\u0001u!1A\u0010\u0001Q!\ni\na\u0003\\1tiJ+\u0007\u000f\\1dK6,g\u000e^%o+R3\u0005\b\t\u0015\u0003w6C\u0011b \u0001\t\u0006\u0004%I!!\u0001\u0002\rI,7/\u001e7u+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI!W\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u000e\u0005\u001d!\u0001D*ue&twMQ;gM\u0016\u0014\bBCA\t\u0001!\u0005\t\u0015)\u0003\u0002\u0004\u00059!/Z:vYR\u0004\u0003fAA\b\u001b\"9\u0011q\u0003\u0001\u0005B\u0005e\u0011\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003CA\u000e\u0003C\t)#!\u000b\u0011\u0007a\ti\"C\u0002\u0002 e\u00111!\u00118z\u0011!\t\u0019#!\u0006A\u0002\u0005m\u0011!A:\t\u0011\u0005\u001d\u0012Q\u0003a\u0001\u00037\t\u0011\u0001\u001d\u0005\t\u0003W\t)\u00021\u0001\u0002\u001c\u0005\t!\u000fC\u0004\u00020\u0001!\t%!\r\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\r\u0011\t\u0005U\u0012\u0011H\u0007\u0003\u0003oQ!!\u0010\u0004\n\t\u0005m\u0012q\u0007\u0002\t\t\u0006$\u0018\rV=qK\"9\u0011q\b\u0001\u0005B\u0005\u0005\u0013AC5oaV$H+\u001f9fgV\u0011\u00111\t\t\u0007\u0003\u000b\n)&a\u0017\u000f\t\u0005\u001d\u0013\u0011\u000b\b\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011Q\n\b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012bAA*3\u00059\u0001/Y2lC\u001e,\u0017\u0002BA,\u00033\u00121aU3r\u0015\r\t\u0019&\u0007\t\u0005\u0003k\ti&\u0003\u0003\u0002`\u0005]\"\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u001d\t\u0019\u0007\u0001C!\u0003K\n\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0003\u0003O\u0002R!!\u0012\u0002V\rBa!a\u001b\u0001\t\u00032\u0017A\u00039sKR$\u0018PT1nK\"9\u0011q\u000e\u0001\u0005R\u0005E\u0014!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t\u0019(a \u0002\nB!\u0011QOA>\u001b\t\t9HC\u0002\u0002z\t\tqaY8eK\u001e,g.\u0003\u0003\u0002~\u0005]$\u0001C#yaJ\u001cu\u000eZ3\t\u0011\u0005\u0005\u0015Q\u000ea\u0001\u0003\u0007\u000b1a\u0019;y!\u0011\t)(!\"\n\t\u0005\u001d\u0015q\u000f\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011!\tY)!\u001cA\u0002\u0005M\u0014AA3w\u0011%\ty\tAA\u0001\n\u0003\t\t*\u0001\u0003d_BLHcB\u001a\u0002\u0014\u0006U\u0015q\u0013\u0005\tC\u00055\u0005\u0013!a\u0001G!A\u0011&!$\u0011\u0002\u0003\u00071\u0005\u0003\u0005.\u0003\u001b\u0003\n\u00111\u0001$\u0011%\tY\nAI\u0001\n\u0003\ti*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}%fA\u0012\u0002\".\u0012\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003%)hn\u00195fG.,GMC\u0002\u0002.f\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t,a*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u00026\u0002\t\n\u0011\"\u0001\u0002\u001e\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CA]\u0001E\u0005I\u0011AAO\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIMB\u0011\"!0\u0001\u0003\u0003%\t%a0\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\r\u0005\u0003\u0002\u0006\u0005\r\u0017b\u00017\u0002\b!I\u0011q\u0019\u0001\u0002\u0002\u0013\u0005\u0011\u0011Z\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0017\u00042\u0001GAg\u0013\r\ty-\u0007\u0002\u0004\u0013:$\b\"CAj\u0001\u0005\u0005I\u0011AAk\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0007\u0002X\"I\u0011*!5\u0002\u0002\u0003\u0007\u00111\u001a\u0005\n\u00037\u0004\u0011\u0011!C!\u0003;\fq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003?\u0004b!!9\u0002h\u0006mQBAAr\u0015\r\t)/G\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAu\u0003G\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003[\u0004\u0011\u0011!C\u0001\u0003_\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003c\f9\u0010E\u0002\u0019\u0003gL1!!>\u001a\u0005\u001d\u0011un\u001c7fC:D\u0011\"SAv\u0003\u0003\u0005\r!a\u0007\t\u0013\u0005m\b!!A\u0005B\u0005u\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002r\u0006}\b\"C%\u0002z\u0006\u0005\t\u0019AA\u000eQ=\u0001!1\u0001B\u0005\u0005\u0017\u0011yA!\u0005\u0003\u0016\t]\u0001cA\t\u0003\u0006%\u0019!q\u0001\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!QB\u0001\\?\u001a+fjQ0)gR\u0014H\u0006\t:fO\u0016D\b\u000f\f\u0011sKBL\u0003%\f\u0011SKBd\u0017mY3tA\u0005dG\u000eI:vEN$(/\u001b8hg\u0002zg\r\t1tiJ\u0004\u0007\u0005\u001e5bi\u0002j\u0017\r^2iA\u0001\u0014XmZ3ya\u0002\u0004s/\u001b;iA\u0001\u0014X\r\u001d1/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B\n\u0003IS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ\u00191a5\u0012\u0004\u0007M\u0014-A\u001dBC\fZ\u0016*O1\u0002sE\\;nO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\\;n[9,XN\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011I\"A\u00032]Ur\u0003gB\u0005\u0003\u001e\t\t\t\u0011#\u0001\u0003 \u0005i!+Z4FqB\u0014V\r\u001d7bG\u0016\u00042!\u0005B\u0011\r!\t!!!A\t\u0002\t\r2#\u0002B\u0011\u0005Ki\u0002\u0003\u0003B\u0014\u0005[\u00193eI\u001a\u000e\u0005\t%\"b\u0001B\u00163\u00059!/\u001e8uS6,\u0017\u0002\u0002B\u0018\u0005S\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84\u0011\u001d\t$\u0011\u0005C\u0001\u0005g!\"Aa\b\t\u0015\t]\"\u0011EA\u0001\n\u000b\u0012I$\u0001\u0005u_N#(/\u001b8h)\t\t\t\r\u0003\u0006\u0003>\t\u0005\u0012\u0011!CA\u0005\u007f\tQ!\u00199qYf$ra\rB!\u0005\u0007\u0012)\u0005\u0003\u0004\"\u0005w\u0001\ra\t\u0005\u0007S\tm\u0002\u0019A\u0012\t\r5\u0012Y\u00041\u0001$\u0011)\u0011IE!\t\u0002\u0002\u0013\u0005%1J\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iE!\u0017\u0011\u000ba\u0011yEa\u0015\n\u0007\tE\u0013D\u0001\u0004PaRLwN\u001c\t\u00071\tU3eI\u0012\n\u0007\t]\u0013D\u0001\u0004UkBdWm\r\u0005\n\u00057\u00129%!AA\u0002M\n1\u0001\u001f\u00131\u0011)\u0011yF!\t\u0002\u0002\u0013%!\u0011M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003dA!\u0011Q\u0001B3\u0013\u0011\u00119'a\u0002\u0003\r=\u0013'.Z2u\u0001")
public class RegExpReplace
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression rep;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;
    private transient String lastReplacement;
    private transient UTF8String lastReplacementInUTF8;
    private transient StringBuffer result;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpReplace regExpReplace) {
        return RegExpReplace$.MODULE$.unapply(regExpReplace);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpReplace> tupled() {
        return RegExpReplace$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpReplace>>> curried() {
        return RegExpReplace$.MODULE$.curried();
    }

    private StringBuffer result$lzycompute() {
        RegExpReplace regExpReplace = this;
        synchronized (regExpReplace) {
            if (!this.bitmap$trans$0) {
                this.result = new StringBuffer();
                this.bitmap$trans$0 = true;
            }
            return this.result;
        }
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression rep() {
        return this.rep;
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    private String lastReplacement() {
        return this.lastReplacement;
    }

    private void lastReplacement_$eq(String x$1) {
        this.lastReplacement = x$1;
    }

    private UTF8String lastReplacementInUTF8() {
        return this.lastReplacementInUTF8;
    }

    private void lastReplacementInUTF8_$eq(UTF8String x$1) {
        this.lastReplacementInUTF8 = x$1;
    }

    private StringBuffer result() {
        return this.bitmap$trans$0 ? this.result : this.result$lzycompute();
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        if (!p.equals(this.lastRegex())) {
            this.lastRegex_$eq(((UTF8String)p).clone());
            this.pattern_$eq(Pattern.compile(this.lastRegex().toString()));
        }
        if (!r.equals(this.lastReplacementInUTF8())) {
            this.lastReplacementInUTF8_$eq(((UTF8String)r).clone());
            this.lastReplacement_$eq(this.lastReplacementInUTF8().toString());
        }
        Matcher m = this.pattern().matcher(s.toString());
        this.result().delete(0, this.result().length());
        while (m.find()) {
            m.appendReplacement(this.result(), this.lastReplacement());
        }
        m.appendTail(this.result());
        return UTF8String.fromString((String)this.result().toString());
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.subject();
        Expression expression2 = this.regexp();
        Expression expression3 = this.rep();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public String prettyName() {
        return "regexp_replace";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String termResult = ctx.freshName("termResult");
        String classNamePattern = Pattern.class.getCanonicalName();
        String classNameStringBuffer = StringBuffer.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacement = ctx.addMutableState("String", "lastReplacement", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacementInUTF8 = ctx.addMutableState("UTF8String", "lastReplacementInUTF8", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = false;"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull()})) : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)new Serializable(this, ev, termResult, classNamePattern, classNameStringBuffer, matcher, termLastRegex, termPattern, termLastReplacement, termLastReplacementInUTF8, setEvNotNull){
            public static final long serialVersionUID = 0L;
            private final ExprCode ev$4;
            private final String termResult$1;
            private final String classNamePattern$1;
            private final String classNameStringBuffer$1;
            private final String matcher$1;
            private final String termLastRegex$1;
            private final String termPattern$1;
            private final String termLastReplacement$1;
            private final String termLastReplacementInUTF8$1;
            private final String setEvNotNull$1;

            public final String apply(String subject, String regexp, String rep) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      if (!", ".equals(", ")) {\n        // regex value changed\n        ", " = ", ".clone();\n        ", " = ", ".compile(", ".toString());\n      }\n      if (!", ".equals(", ")) {\n        // replacement string changed\n        ", " = ", ".clone();\n        ", " = ", ".toString();\n      }\n      ", " ", " = new ", "();\n      java.util.regex.Matcher ", " = ", ".matcher(", ".toString());\n\n      while (", ".find()) {\n        ", ".appendReplacement(", ", ", ");\n      }\n      ", ".appendTail(", ");\n      ", " = UTF8String.fromString(", ".toString());\n      ", " = null;\n      ", "\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{regexp, this.termLastRegex$1, this.termLastRegex$1, regexp, this.termPattern$1, this.classNamePattern$1, this.termLastRegex$1, rep, this.termLastReplacementInUTF8$1, this.termLastReplacementInUTF8$1, rep, this.termLastReplacement$1, this.termLastReplacementInUTF8$1, this.classNameStringBuffer$1, this.termResult$1, this.classNameStringBuffer$1, this.matcher$1, this.termPattern$1, subject, this.matcher$1, this.matcher$1, this.termResult$1, this.termLastReplacement$1, this.matcher$1, this.termResult$1, this.ev$4.value(), this.termResult$1, this.termResult$1, this.setEvNotNull$1}));
            }
            {
                this.ev$4 = ev$4;
                this.termResult$1 = termResult$1;
                this.classNamePattern$1 = classNamePattern$1;
                this.classNameStringBuffer$1 = classNameStringBuffer$1;
                this.matcher$1 = matcher$1;
                this.termLastRegex$1 = termLastRegex$1;
                this.termPattern$1 = termPattern$1;
                this.termLastReplacement$1 = termLastReplacement$1;
                this.termLastReplacementInUTF8$1 = termLastReplacementInUTF8$1;
                this.setEvNotNull$1 = setEvNotNull$1;
            }
        });
    }

    public RegExpReplace copy(Expression subject, Expression regexp, Expression rep) {
        return new RegExpReplace(subject, regexp, rep);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.rep();
    }

    @Override
    public String productPrefix() {
        return "RegExpReplace";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                expression = this.rep();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 0: {
                expression = this.subject();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpReplace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpReplace regExpReplace = (RegExpReplace)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpReplace.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpReplace.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.rep();
        Expression expression6 = regExpReplace.rep();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpReplace.canEqual(this)) return false;
        return true;
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep) {
        this.subject = subject;
        this.regexp = regexp;
        this.rep = rep;
        ExpectsInputTypes$class.$init$(this);
    }
}

