/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.util.Random;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001#\tA\u0002*\u001f9fe2{w\rT8h!2,8\u000f\u00157vgN+\u0018\u000e^3\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0004\t\u0003!\u0019\u0017\r^1msN$(BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u000b\u0013\t)\"BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAQ\u0001\b\u0001\u0005\u0002u\tqb\u0019:fCR,Wi\u001d;j[\u0006$xN\u001d\u000b\u0004=-\u0002\u0004#B\u0010#I\u001d:S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\rQ+\b\u000f\\34!\tQR%\u0003\u0002'\u0005\t\u0019\u0002*\u001f9fe2{w\rT8h!2,8\u000f\u00157vgB\u0011\u0001&K\u0007\u0002\r%\u0011!F\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003-7\u0001\u0007Q&A\u0002sg\u0012\u0004\"a\b\u0018\n\u0005=\u0002#A\u0002#pk\ndW\rC\u000427A\u0005\t\u0019\u0001\u001a\u0002\u0005\u0011$\bCA\u001a7\u001b\u0005!$BA\u001b\t\u0003\u0015!\u0018\u0010]3t\u0013\t9DG\u0001\u0005ECR\fG+\u001f9f\u0011\u0015I\u0004\u0001\"\u0001;\u00031\u0019'/Z1uK\n+hMZ3s)\t93\bC\u0003=q\u0001\u0007A%A\u0002iY2DQA\u0010\u0001\u0005\u0002}\n\u0001#\u001a<bYV\fG/Z#ti&l\u0017\r^3\u0015\t\u0001\u001bEI\u0012\t\u0003?\u0005K!A\u0011\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006yu\u0002\r\u0001\n\u0005\u0006\u000bv\u0002\raJ\u0001\u0007EV4g-\u001a:\t\u000b\u001dk\u0004\u0019\u0001%\u0002\u0017\r\f'\u000fZ5oC2LG/\u001f\t\u0003?%K!A\u0013\u0011\u0003\u0007%sG\u000fC\u0003M\u0001\u0011\u0005Q*\u0001\ruKN$8)\u0019:eS:\fG.\u001b;z\u000bN$\u0018.\\1uKN$R\u0001\u0011(]?\u0012DQaT&A\u0002A\u000bAA]:egB\u0019\u0011+W\u0017\u000f\u0005I;fBA*W\u001b\u0005!&BA+\u0011\u0003\u0019a$o\\8u}%\t\u0011%\u0003\u0002YA\u00059\u0001/Y2lC\u001e,\u0017B\u0001.\\\u0005\r\u0019V-\u001d\u0006\u00031\u0002BQ!X&A\u0002y\u000b!A\\:\u0011\u0007EK\u0006\nC\u0003a\u0017\u0002\u0007\u0011-A\u0001g!\u0011y\"\r\u0013%\n\u0005\r\u0004#!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0015)7\n1\u0001b\u0003\u0005\u0019\u0007bB4\u0001#\u0003%\t\u0001[\u0001\u001aGJ,\u0017\r^3FgRLW.\u0019;pe\u0012\"WMZ1vYR$#'F\u0001jU\t\u0011$nK\u0001l!\ta\u0017/D\u0001n\u0015\tqw.A\u0005v]\u000eDWmY6fI*\u0011\u0001\u000fI\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001:n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class HyperLogLogPlusPlusSuite
extends SparkFunSuite {
    public Tuple3<HyperLogLogPlusPlus, InternalRow, InternalRow> createEstimator(double rsd, DataType dt) {
        SpecificInternalRow input = new SpecificInternalRow((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{dt})));
        HyperLogLogPlusPlus hll = new HyperLogLogPlusPlus((Expression)new BoundReference(0, dt, true), rsd, HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$3(), HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$4());
        InternalRow buffer = this.createBuffer(hll);
        return new Tuple3((Object)hll, (Object)input, (Object)buffer);
    }

    public DataType createEstimator$default$2() {
        return IntegerType$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public InternalRow createBuffer(HyperLogLogPlusPlus hll) {
        void var2_2;
        SpecificInternalRow buffer = new SpecificInternalRow((Seq)hll.aggBufferAttributes().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DataType apply(AttributeReference x$1) {
                return x$1.dataType();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        hll.initialize((InternalRow)buffer);
        return var2_2;
    }

    public void evaluateEstimate(HyperLogLogPlusPlus hll, InternalRow buffer, int cardinality) {
        double error;
        double estimate = BoxesRunTime.unboxToLong((Object)hll.eval(buffer));
        double $org_scalatest_assert_macro_left = error = package$.MODULE$.abs(estimate / (double)cardinality - 1.0);
        double $org_scalatest_assert_macro_right = hll.hllppHelper().trueRsd() * 3.0;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Error should be within 3 std. errors.", Prettifier$.MODULE$.default(), new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
    }

    public void testCardinalityEstimates(Seq<Object> rsds, Seq<Object> ns, Function1<Object, Object> f2, Function1<Object, Object> c) {
        ((IterableLike)rsds.flatMap((Function1)new Serializable(this, ns){
            public static final long serialVersionUID = 0L;
            private final Seq ns$1;

            public final Seq<Tuple2<Object, Object>> apply(double rsd) {
                return (Seq)this.ns$1.map((Function1)new Serializable(this, rsd){
                    public static final long serialVersionUID = 0L;
                    private final double rsd$1;

                    public final Tuple2<Object, Object> apply(int n) {
                        return new Tuple2.mcDI.sp(this.rsd$1, n);
                    }
                    {
                        this.rsd$1 = rsd$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.ns$1 = ns$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, f2, c){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperLogLogPlusPlusSuite $outer;
            private final Function1 f$1;
            private final Function1 c$1;

            public final Assertion apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double rsd = tuple2._1$mcD$sp();
                    int n = tuple2._2$mcI$sp();
                    Tuple3<HyperLogLogPlusPlus, InternalRow, InternalRow> tuple3 = this.$outer.createEstimator(rsd, this.$outer.createEstimator$default$2());
                    if (tuple3 != null) {
                        double error;
                        Tuple3 tuple32;
                        HyperLogLogPlusPlus hll = (HyperLogLogPlusPlus)tuple3._1();
                        InternalRow input = (InternalRow)tuple3._2();
                        InternalRow buffer = (InternalRow)tuple3._3();
                        Tuple3 tuple33 = tuple32 = new Tuple3((Object)hll, (Object)input, (Object)buffer);
                        HyperLogLogPlusPlus hll2 = (HyperLogLogPlusPlus)tuple33._1();
                        InternalRow input2 = (InternalRow)tuple33._2();
                        InternalRow buffer2 = (InternalRow)tuple33._3();
                        for (int i = 0; i < n; ++i) {
                            input2.setInt(0, this.f$1.apply$mcII$sp(i));
                            hll2.update(buffer2, input2);
                        }
                        double estimate = BoxesRunTime.unboxToLong((Object)hll2.eval(buffer2));
                        int cardinality = this.c$1.apply$mcII$sp(n);
                        double $org_scalatest_assert_macro_left = error = package$.MODULE$.abs(estimate / (double)cardinality - 1.0);
                        double $org_scalatest_assert_macro_right = hll2.hllppHelper().trueRsd() * 3.0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        Assertion assertion = this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Error should be within 3 std. errors.", Prettifier$.MODULE$.default(), new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
                        return assertion;
                    }
                    throw new MatchError(tuple3);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$1 = f$1;
                this.c$1 = c$1;
            }
        });
    }

    public HyperLogLogPlusPlusSuite() {
        this.test("test invalid parameter relativeSD", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperLogLogPlusPlusSuite $outer;

            public final IllegalArgumentException apply() {
                return (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final HyperLogLogPlusPlus apply() {
                        return new HyperLogLogPlusPlus((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), 0.4, HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$3(), HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$4());
                    }
                }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("add nulls", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperLogLogPlusPlusSuite $outer;

            public final Assertion apply() {
                Tuple3<HyperLogLogPlusPlus, InternalRow, InternalRow> tuple3 = this.$outer.createEstimator(0.05, this.$outer.createEstimator$default$2());
                if (tuple3 != null) {
                    long estimate;
                    Tuple3 tuple32;
                    HyperLogLogPlusPlus hll = (HyperLogLogPlusPlus)tuple3._1();
                    InternalRow input = (InternalRow)tuple3._2();
                    InternalRow buffer = (InternalRow)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)hll, (Object)input, (Object)buffer);
                    HyperLogLogPlusPlus hll2 = (HyperLogLogPlusPlus)tuple33._1();
                    InternalRow input2 = (InternalRow)tuple33._2();
                    InternalRow buffer2 = (InternalRow)tuple33._3();
                    input2.setNullAt(0);
                    hll2.update(buffer2, input2);
                    hll2.update(buffer2, input2);
                    long $org_scalatest_assert_macro_left = estimate = BoxesRunTime.unboxToLong((Object)hll2.eval(buffer2));
                    long $org_scalatest_assert_macro_right = 0L;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Nothing meaningful added; estimate should be 0.", Prettifier$.MODULE$.default(), new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("deterministic cardinality estimation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperLogLogPlusPlusSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int repeats = 10;
                this.$outer.testCardinalityEstimates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1, 0.05, 0.025, 0.01, 0.001}))), (Seq<Object>)((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 500, 1000, 5000, 10000, 50000, 100000, 500000, 1000000}))).map((Function1)new Serializable(this, repeats){
                    public static final long serialVersionUID = 0L;
                    private final int repeats$1;

                    public final int apply(int x$4) {
                        return this.apply$mcII$sp(x$4);
                    }

                    public int apply$mcII$sp(int x$4) {
                        return x$4 * this.repeats$1;
                    }
                    {
                        this.repeats$1 = repeats$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())), (Function1<Object, Object>)new Serializable(this, repeats){
                    public static final long serialVersionUID = 0L;
                    private final int repeats$1;

                    public final int apply(int i) {
                        return this.apply$mcII$sp(i);
                    }

                    public int apply$mcII$sp(int i) {
                        return i / this.repeats$1;
                    }
                    {
                        this.repeats$1 = repeats$1;
                    }
                }, (Function1<Object, Object>)new Serializable(this, repeats){
                    public static final long serialVersionUID = 0L;
                    private final int repeats$1;

                    public final int apply(int i) {
                        return this.apply$mcII$sp(i);
                    }

                    public int apply$mcII$sp(int i) {
                        return i / this.repeats$1;
                    }
                    {
                        this.repeats$1 = repeats$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("random cardinality estimation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperLogLogPlusPlusSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random srng = new Random(323981238L);
                HashSet seen = HashSet$.MODULE$.empty();
                Serializable update = new Serializable(this, srng, seen){
                    public static final long serialVersionUID = 0L;
                    private final Random srng$1;
                    private final HashSet seen$1;

                    public final int apply(int i) {
                        return this.apply$mcII$sp(i);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public int apply$mcII$sp(int i) {
                        void var2_2;
                        int value = this.srng$1.nextInt();
                        this.seen$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)value));
                        return (int)var2_2;
                    }
                    {
                        this.srng$1 = srng$1;
                        this.seen$1 = seen$1;
                    }
                };
                Serializable eval = new Serializable(this, seen){
                    public static final long serialVersionUID = 0L;
                    private final HashSet seen$1;

                    public final int apply(int n) {
                        return this.apply$mcII$sp(n);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public int apply$mcII$sp(int n) {
                        void var2_2;
                        int cardinality = this.seen$1.size();
                        this.seen$1.clear();
                        return (int)var2_2;
                    }
                    {
                        this.seen$1 = seen$1;
                    }
                };
                this.$outer.testCardinalityEstimates((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.05, 0.01}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 10000, 500000}))), (Function1<Object, Object>)update, (Function1<Object, Object>)eval);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("merging HLL instances", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HyperLogLogPlusPlusSuite $outer;

            public final Assertion apply() {
                Tuple3<HyperLogLogPlusPlus, InternalRow, InternalRow> tuple3 = this.$outer.createEstimator(0.05, this.$outer.createEstimator$default$2());
                if (tuple3 != null) {
                    int i;
                    Tuple3 tuple32;
                    HyperLogLogPlusPlus hll = (HyperLogLogPlusPlus)tuple3._1();
                    InternalRow input = (InternalRow)tuple3._2();
                    InternalRow buffer1a = (InternalRow)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)hll, (Object)input, (Object)buffer1a);
                    HyperLogLogPlusPlus hll2 = (HyperLogLogPlusPlus)tuple33._1();
                    InternalRow input2 = (InternalRow)tuple33._2();
                    InternalRow buffer1a2 = (InternalRow)tuple33._3();
                    InternalRow buffer1b = this.$outer.createBuffer(hll2);
                    InternalRow buffer2 = this.$outer.createBuffer(hll2);
                    for (i = 0; i < 500000; ++i) {
                        input2.setInt(0, i);
                        hll2.update(buffer1a2, input2);
                    }
                    for (i = 500000; i < 1000000; ++i) {
                        input2.setInt(0, i);
                        hll2.update(buffer1b, input2);
                    }
                    hll2.merge(buffer1a2, buffer1b);
                    for (i = 999999; i >= 0; --i) {
                        input2.setInt(0, i);
                        hll2.update(buffer2, input2);
                    }
                    InternalRow $org_scalatest_assert_macro_left = buffer2;
                    InternalRow $org_scalatest_assert_macro_right = buffer1a2;
                    InternalRow internalRow = $org_scalatest_assert_macro_left;
                    InternalRow internalRow2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(internalRow != null ? !internalRow.equals(internalRow2) : internalRow2 != null), Prettifier$.MODULE$.default());
                    return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Buffers should be equal", Prettifier$.MODULE$.default(), new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
                }
                throw new MatchError(tuple3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("HyperLogLogPlusPlusSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
    }
}

