/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0001\u0002\u0001\u001f\t\u0019B)\u0019;b)f\u0004X\rU1sg\u0016\u00148+^5uK*\u00111\u0001B\u0001\u0007a\u0006\u00148/\u001a:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005A\u0011BA\n\t\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\u00065\u0001!\taG\u0001\u0006a\u0006\u00148/\u001a\u000b\u00039\t\u0002\"!\b\u0011\u000e\u0003yQ!a\b\u0004\u0002\u000bQL\b/Z:\n\u0005\u0005r\"\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000b\u001dI\u0002\u0019A\u0012\u0011\u0005\u0011RcBA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2\u0013A\u0002)sK\u0012,g-\u0003\u0002,Y\t11\u000b\u001e:j]\u001eT!!\u000b\u0014\t\u000b9\u0002A\u0011A\u0018\u0002\u001b\rDWmY6ECR\fG+\u001f9f)\r\u00014'\u000e\t\u0003KEJ!A\r\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006i5\u0002\raI\u0001\u000fI\u0006$\u0018\rV=qKN#(/\u001b8h\u0011\u00151T\u00061\u0001\u001d\u0003A)\u0007\u0010]3di\u0016$G)\u0019;b)f\u0004X\rC\u00039\u0001\u0011\u0005\u0011(A\u0005j]R,'oY3qiR\u0011!(\u0010\t\u00031mJ!\u0001\u0010\u0002\u0003\u001dA\u000b'o]3Fq\u000e,\u0007\u000f^5p]\")qa\u000ea\u0001G!)q\b\u0001C\u0001\u0001\u0006YQO\\:vaB|'\u000f^3e)\t\u0001\u0014\tC\u00035}\u0001\u00071\u0005")
public class DataTypeParserSuite
extends SparkFunSuite {
    public DataType parse(String sql) {
        return CatalystSqlParser$.MODULE$.parseDataType(sql);
    }

    public void checkDataType(String dataTypeString, DataType expectedDataType) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parse ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataTypeString.replace("\n", "")})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, dataTypeString, expectedDataType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeParserSuite $outer;
            private final String dataTypeString$1;
            private final DataType expectedDataType$1;

            public final Assertion apply() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.parse(this.dataTypeString$1));
                DataType $org_scalatest_assert_macro_right = this.expectedDataType$1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataTypeString$1 = dataTypeString$1;
                this.expectedDataType$1 = expectedDataType$1;
            }
        }, new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
    }

    public ParseException intercept(String sql) {
        return (ParseException)this.intercept((Function0)new Serializable(this, sql){
            public static final long serialVersionUID = 0L;
            private final String sql$1;

            public final DataType apply() {
                return CatalystSqlParser$.MODULE$.parseDataType(this.sql$1);
            }
            {
                this.sql$1 = sql$1;
            }
        }, ClassTag$.MODULE$.apply(ParseException.class), new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
    }

    public void unsupported(String dataTypeString) {
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataTypeString})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, dataTypeString){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeParserSuite $outer;
            private final String dataTypeString$2;

            public final ParseException apply() {
                return this.$outer.intercept(this.dataTypeString$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataTypeString$2 = dataTypeString$2;
            }
        }, new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
    }

    public DataTypeParserSuite() {
        this.checkDataType("int", (DataType)IntegerType$.MODULE$);
        this.checkDataType("integer", (DataType)IntegerType$.MODULE$);
        this.checkDataType("BooLean", (DataType)BooleanType$.MODULE$);
        this.checkDataType("tinYint", (DataType)ByteType$.MODULE$);
        this.checkDataType("smallINT", (DataType)ShortType$.MODULE$);
        this.checkDataType("INT", (DataType)IntegerType$.MODULE$);
        this.checkDataType("INTEGER", (DataType)IntegerType$.MODULE$);
        this.checkDataType("bigint", (DataType)LongType$.MODULE$);
        this.checkDataType("float", (DataType)FloatType$.MODULE$);
        this.checkDataType("dOUBle", (DataType)DoubleType$.MODULE$);
        this.checkDataType("decimal(10, 5)", (DataType)new DecimalType(10, 5));
        this.checkDataType("decimal", (DataType)DecimalType$.MODULE$.USER_DEFAULT());
        this.checkDataType("DATE", (DataType)DateType$.MODULE$);
        this.checkDataType("timestamp", (DataType)TimestampType$.MODULE$);
        this.checkDataType("string", (DataType)StringType$.MODULE$);
        this.checkDataType("ChaR(5)", (DataType)StringType$.MODULE$);
        this.checkDataType("varchAr(20)", (DataType)StringType$.MODULE$);
        this.checkDataType("cHaR(27)", (DataType)StringType$.MODULE$);
        this.checkDataType("BINARY", (DataType)BinaryType$.MODULE$);
        this.checkDataType("array<doublE>", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true));
        this.checkDataType("Array<map<int, tinYint>>", (DataType)new ArrayType((DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ByteType$.MODULE$, true), true));
        StructField structField = new StructField("tinYint", (DataType)ByteType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("array<struct<tinYint:tinyint>>", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)), true));
        this.checkDataType("MAP<int, STRING>", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$, true));
        this.checkDataType("MAp<int, ARRAY<double>>", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), true));
        StructField structField2 = new StructField("varchar", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("MAP<int, struct<varchar:string>>", (DataType)new MapType((DataType)IntegerType$.MODULE$, (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2)), true));
        StructField structField3 = new StructField("intType", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("ts", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("struct<intType: int, ts:timestamp>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4).$colon$colon((Object)structField3)));
        StructField structField5 = new StructField("int", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("timestamp", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("Struct<int: int, timestamp:timestamp>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5)));
        StructField structField7 = new StructField("deciMal", (DataType)DecimalType$.MODULE$.USER_DEFAULT(), true, StructField$.MODULE$.apply$default$4());
        StructField structField8 = new StructField("anotherDecimal", (DataType)new DecimalType(5, 2), true, StructField$.MODULE$.apply$default$4());
        StructField structField9 = new StructField("struct", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField8).$colon$colon((Object)structField7)), true, StructField$.MODULE$.apply$default$4());
        StructField structField10 = new StructField("MAP", (DataType)MapType$.MODULE$.apply((DataType)TimestampType$.MODULE$, (DataType)StringType$.MODULE$), true, StructField$.MODULE$.apply$default$4());
        StructField structField11 = new StructField("arrAy", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4());
        StructField structField12 = new StructField("anotherArray", (DataType)new ArrayType((DataType)StringType$.MODULE$, true), true, StructField$.MODULE$.apply$default$4());
        this.checkDataType(new StringOps(Predef$.MODULE$.augmentString("\n      |struct<\n      |  struct:struct<deciMal:DECimal, anotherDecimal:decimAL(5,2)>,\n      |  MAP:Map<timestamp, varchar(10)>,\n      |  arrAy:Array<double>,\n      |  anotherArray:Array<char(9)>>\n    ")).stripMargin(), (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField12).$colon$colon((Object)structField11).$colon$colon((Object)structField10).$colon$colon((Object)structField9)));
        StructField structField13 = new StructField("x+y", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField14 = new StructField("!@#$%^&*()", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField15 = new StructField("1_2.345<>:\"", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("struct<`x+y`:int, `!@#$%^&*()`:string, `1_2.345<>:\"`:varchar(20)>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField15).$colon$colon((Object)structField14).$colon$colon((Object)structField13)));
        this.checkDataType("strUCt<>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
        this.unsupported("it is not a data type");
        this.unsupported("struct<x+y: int, 1.1:timestamp>");
        this.unsupported("struct<x: int");
        this.unsupported("struct<x int, y string>");
        this.test("Do not print empty parentheses for no params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataTypeParserSuite $outer;

            public final Assertion apply() {
                String $org_scalatest_assert_macro_left = this.$outer.intercept("unkwon").getMessage();
                String $org_scalatest_assert_macro_right = "unkwon is not supported";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
                String $org_scalatest_assert_macro_left2 = this.$outer.intercept("unkwon(1,2,3)").getMessage();
                String $org_scalatest_assert_macro_right2 = "unkwon(1,2,3) is not supported";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DataTypeParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        StructField structField16 = new StructField("TABLE", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField17 = new StructField("DATE", (DataType)BooleanType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        this.checkDataType("Struct<TABLE: string, DATE:boolean>", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField17).$colon$colon((Object)structField16)));
        this.checkDataType("struct<end: long, select: int, from: string>", (DataType)new StructType().add("end", (DataType)LongType$.MODULE$).add("select", (DataType)IntegerType$.MODULE$).add("from", (DataType)StringType$.MODULE$));
        this.checkDataType("Struct<x: INT, y: STRING COMMENT 'test'>", (DataType)new StructType().add("x", (DataType)IntegerType$.MODULE$).add("y", (DataType)StringType$.MODULE$, true, "test"));
    }
}

