/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtilsSuite$;
import org.apache.spark.sql.catalyst.util.DateTimeUtilsSuite$$anonfun$10$;
import org.apache.spark.sql.catalyst.util.DateTimeUtilsSuite$$anonfun$7$;
import org.apache.spark.sql.catalyst.util.DateTimeUtilsSuite$$anonfun$8$;
import org.apache.spark.sql.catalyst.util.DateTimeUtilsSuite$$anonfun$9$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0001\u001f\t\u0011B)\u0019;f)&lW-\u0016;jYN\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0003vi&d'BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAqA\u0007\u0001C\u0002\u0013\u00051$A\u0006US6,'l\u001c8f!N#V#\u0001\u000f\u0011\u0005u\tS\"\u0001\u0010\u000b\u0005\ry\"\"\u0001\u0011\u0002\t)\fg/Y\u0005\u0003Ey\u0011\u0001\u0002V5nKj{g.\u001a\u0005\u0007I\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u0019QKW.\u001a.p]\u0016\u00046\u000b\u0016\u0011\t\r\u0019\u0002\u0001\u0015\"\u0003(\u000319W\r^%o+R\u001bE)Y=t)\tAc\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#FA\u0002J]RDQaL\u0013A\u0002A\n\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0005%\n\u0014B\u0001\u001a+\u0005\u0011auN\\4")
public class DateTimeUtilsSuite
extends SparkFunSuite {
    private final TimeZone TimeZonePST = TimeZone.getTimeZone("PST");

    public TimeZone TimeZonePST() {
        return this.TimeZonePST;
    }

    public int org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(long timestamp) {
        TimeZone tz = TimeZone.getDefault();
        return (int)((timestamp + (long)tz.getOffset(timestamp)) / 86400000L);
    }

    public DateTimeUtilsSuite() {
        this.test("nanoseconds truncation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.checkStringToTimestamp$1("2015-01-02 00:00:00.123456789", "2015-01-02 00:00:00.123456");
                this.checkStringToTimestamp$1("2015-01-02 00:00:00.100000009", "2015-01-02 00:00:00.1");
                this.checkStringToTimestamp$1("2015-01-02 00:00:00.000050000", "2015-01-02 00:00:00.00005");
                this.checkStringToTimestamp$1("2015-01-02 00:00:00.12005", "2015-01-02 00:00:00.12005");
                this.checkStringToTimestamp$1("2015-01-02 00:00:00.100", "2015-01-02 00:00:00.1");
                this.checkStringToTimestamp$1("2015-01-02 00:00:00.000456789", "2015-01-02 00:00:00.000456");
                this.checkStringToTimestamp$1("1950-01-02 00:00:00.000456789", "1950-01-02 00:00:00.000456");
            }

            private final void checkStringToTimestamp$1(String originalTime, String expectedParsedTime) {
                Option parsedTimestampOp = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)originalTime));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(parsedTimestampOp.isDefined(), "parsedTimestampOp.isDefined", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"timestamp with nanoseconds was not parsed correctly", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.timestampToString(BoxesRunTime.unboxToLong((Object)parsedTimestampOp.get())));
                String $org_scalatest_assert_macro_right = expectedParsedTime;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("timestamp and us", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Timestamp now = new Timestamp(System.currentTimeMillis());
                now.setNanos(1000);
                long ns = DateTimeUtils$.MODULE$.fromJavaTimestamp(now);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)(ns % 1000000L)));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(ns));
                Timestamp $org_scalatest_assert_macro_right2 = now;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{-111111111111L, -1L, 0L, 1L, 111111111111L})).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final Assertion apply(long t) {
                        Timestamp ts = DateTimeUtils$.MODULE$.toJavaTimestamp(t);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(ts)));
                        long $org_scalatest_assert_macro_right = t;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.fromJavaTimestamp(ts)));
                        Timestamp $org_scalatest_assert_macro_right2 = ts;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DateTimeUtilsSuite org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("us and julian day", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(0L);
                if (tuple2 != null) {
                    Tuple2.mcIJ.sp sp2;
                    int d = tuple2._1$mcI$sp();
                    long ns = tuple2._2$mcJ$sp();
                    Tuple2.mcIJ.sp sp3 = sp2 = new Tuple2.mcIJ.sp(d, ns);
                    int d2 = sp3._1$mcI$sp();
                    long ns2 = sp3._2$mcJ$sp();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)d2));
                    int $org_scalatest_assert_macro_right = 2440588;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)ns2));
                    int $org_scalatest_assert_macro_right2 = 0;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
                    long $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.fromJulianDay(d2, ns2);
                    long $org_scalatest_assert_macro_right3 = 0L;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
                    ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Timestamp[]{Timestamp.valueOf("2015-06-11 10:10:10.100"), Timestamp.valueOf("2015-06-11 20:10:10.100"), Timestamp.valueOf("1900-06-11 20:10:10.100")}))).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$3 $outer;

                        public final Assertion apply(Timestamp t) {
                            Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(DateTimeUtils$.MODULE$.fromJavaTimestamp(t));
                            if (tuple2 != null) {
                                long ns;
                                Tuple2.mcIJ.sp sp2;
                                int d = tuple2._1$mcI$sp();
                                long ns2 = tuple2._2$mcJ$sp();
                                Tuple2.mcIJ.sp sp3 = sp2 = new Tuple2.mcIJ.sp(d, ns2);
                                int d2 = sp3._1$mcI$sp();
                                long $org_scalatest_assert_macro_left = ns = sp3._2$mcJ$sp();
                                int $org_scalatest_assert_macro_right = 0;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
                                Timestamp t1 = DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.fromJulianDay(d2, ns));
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(t.equals(t1), "t.equals(t1)", Prettifier$.MODULE$.default());
                                return this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    return;
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ DateTimeUtilsSuite org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("SPARK-6785: java date conversion before and after epoch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
                SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.US);
                this.checkFromToJavaDate$1(new Date(100L));
                this.checkFromToJavaDate$1(Date.valueOf("1970-01-01"));
                this.checkFromToJavaDate$1(new Date(df1.parse("1970-01-01 00:00:00").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1970-01-01 00:00:00 UTC").getTime()));
                this.checkFromToJavaDate$1(new Date(df1.parse("1970-01-01 00:00:01").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1970-01-01 00:00:01 UTC").getTime()));
                this.checkFromToJavaDate$1(new Date(df1.parse("1969-12-31 23:59:59").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1969-12-31 23:59:59 UTC").getTime()));
                this.checkFromToJavaDate$1(Date.valueOf("1969-01-01"));
                this.checkFromToJavaDate$1(new Date(df1.parse("1969-01-01 00:00:00").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1969-01-01 00:00:00 UTC").getTime()));
                this.checkFromToJavaDate$1(new Date(df1.parse("1969-01-01 00:00:01").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1969-01-01 00:00:01 UTC").getTime()));
                this.checkFromToJavaDate$1(new Date(df1.parse("1989-11-09 11:59:59").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1989-11-09 19:59:59 UTC").getTime()));
                this.checkFromToJavaDate$1(new Date(df1.parse("1776-07-04 10:30:00").getTime()));
                this.checkFromToJavaDate$1(new Date(df2.parse("1776-07-04 18:30:00 UTC").getTime()));
            }

            private final void checkFromToJavaDate$1(Date d1) {
                Date d2 = DateTimeUtils$.MODULE$.toJavaDate(DateTimeUtils$.MODULE$.fromJavaDate(d1));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(d2.toString());
                String $org_scalatest_assert_macro_right = d1.toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("string to date", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 0, 28, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-01-28")).get());
                int $org_scalatest_assert_macro_right = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
                c.set(2015, 0, 1, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015")).get());
                int $org_scalatest_assert_macro_right2 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
                c.set(1, 0, 1, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"0001")).get());
                int $org_scalatest_assert_macro_right3 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                c = Calendar.getInstance();
                c.set(2015, 2, 1, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03")).get());
                int $org_scalatest_assert_macro_right4 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
                c = Calendar.getInstance();
                c.set(2015, 2, 18, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03-18")).get());
                int $org_scalatest_assert_macro_right5 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03-18 ")).get());
                int $org_scalatest_assert_macro_right6 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03-18 123142")).get());
                int $org_scalatest_assert_macro_right7 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03-18T123123")).get());
                int $org_scalatest_assert_macro_right8 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03-18T")).get());
                int $org_scalatest_assert_macro_right9 = DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
                Option $org_scalatest_assert_macro_left10 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-03-18X"));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left10, "isEmpty", $org_scalatest_assert_macro_left10.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
                Option $org_scalatest_assert_macro_left11 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015/03/18"));
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left11, "isEmpty", $org_scalatest_assert_macro_left11.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                Option $org_scalatest_assert_macro_left12 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015.03.18"));
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left12, "isEmpty", $org_scalatest_assert_macro_left12.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
                Option $org_scalatest_assert_macro_left13 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"20150318"));
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left13, "isEmpty", $org_scalatest_assert_macro_left13.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
                Option $org_scalatest_assert_macro_left14 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-031-8"));
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left14, "isEmpty", $org_scalatest_assert_macro_left14.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
                Option $org_scalatest_assert_macro_left15 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"02015-03-18"));
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left15, "isEmpty", $org_scalatest_assert_macro_left15.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
                Option $org_scalatest_assert_macro_left16 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"015-03-18"));
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left16, "isEmpty", $org_scalatest_assert_macro_left16.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
                Option $org_scalatest_assert_macro_left17 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"015"));
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left17, "isEmpty", $org_scalatest_assert_macro_left17.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
                Option $org_scalatest_assert_macro_left18 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"02015"));
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left18, "isEmpty", $org_scalatest_assert_macro_left18.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
                Option $org_scalatest_assert_macro_left19 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"1999 08 01"));
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left19, "isEmpty", $org_scalatest_assert_macro_left19.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
                Option $org_scalatest_assert_macro_left20 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"1999-08 01"));
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left20, "isEmpty", $org_scalatest_assert_macro_left20.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
                Option $org_scalatest_assert_macro_left21 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"1999 08"));
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left21, "isEmpty", $org_scalatest_assert_macro_left21.isEmpty(), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("string to time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                c.set(14, 0);
                c.set(1900, 0, 1, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTime("1900-01-01T00:00:00GMT-00:00"));
                java.util.Date $org_scalatest_assert_macro_right = c.getTime();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
                c.set(2000, 11, 30, 10, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTime("2000-12-30T10:00:00Z"));
                java.util.Date $org_scalatest_assert_macro_right2 = c.getTime();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
                c.setTimeZone(TimeZone.getTimeZone("GMT-04:00"));
                c.set(14, 0);
                c.set(1900, 0, 1, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTime("1900-01-01T00:00:00-04:00"));
                java.util.Date $org_scalatest_assert_macro_right3 = c.getTime();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
                c.set(1900, 0, 1, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTime("1900-01-01T00:00:00GMT-04:00"));
                java.util.Date $org_scalatest_assert_macro_right4 = c.getTime();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
                c.setTimeZone(TimeZone.getDefault());
                c.set(14, 0);
                c.set(2000, 11, 30, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTime("2000-12-30"));
                Date $org_scalatest_assert_macro_right5 = new Date(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
                c.set(2000, 11, 30, 10, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.stringToTime("2000-12-30 10:00:00"));
                Timestamp $org_scalatest_assert_macro_right6 = new Timestamp(c.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("string to timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply(TimeZone tz) {
                        Calendar c = Calendar.getInstance(tz);
                        c.set(1969, 11, 31, 16, 0, 0);
                        c.set(14, 0);
                        this.checkStringToTimestamp$2("1969-12-31 16:00:00", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c.set(1, 0, 1, 0, 0, 0);
                        c.set(14, 0);
                        this.checkStringToTimestamp$2("0001", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(tz);
                        c.set(2015, 2, 1, 0, 0, 0);
                        c.set(14, 0);
                        this.checkStringToTimestamp$2("2015-03", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(tz);
                        c.set(2015, 2, 18, 0, 0, 0);
                        c.set(14, 0);
                        this.checkStringToTimestamp$2("2015-03-18", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        this.checkStringToTimestamp$2("2015-03-18 ", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        this.checkStringToTimestamp$2("2015-03-18T", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(tz);
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 0);
                        this.checkStringToTimestamp$2("2015-03-18 12:03:17", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("GMT-13:53"));
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 0);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17-13:53", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 0);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17Z", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        this.checkStringToTimestamp$2("2015-03-18 12:03:17Z", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("GMT-01:00"));
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 0);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17-1:0", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17-01:00", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 0);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17+07:30", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:03"));
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 0);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17+07:03", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(tz);
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 123);
                        this.checkStringToTimestamp$2("2015-03-18 12:03:17.123", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17.123", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 456);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17.456Z", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        this.checkStringToTimestamp$2("2015-03-18 12:03:17.456Z", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("GMT-01:00"));
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 123);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17.123-1:0", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17.123-01:00", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 123);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17.123+07:30", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 123);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17.123+07:30", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 123);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17.123121+7:30", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L + 121L))), tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 123);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17.12312+7:30", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L + 120L))), tz);
                        c = Calendar.getInstance(tz);
                        c.set(11, 18);
                        c.set(12, 12);
                        c.set(13, 15);
                        c.set(14, 0);
                        this.checkStringToTimestamp$2("18:12:15", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                        c.set(11, 18);
                        c.set(12, 12);
                        c.set(13, 15);
                        c.set(14, 123);
                        this.checkStringToTimestamp$2("T18:12:15.12312+7:30", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L + 120L))), tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("GMT+07:30"));
                        c.set(11, 18);
                        c.set(12, 12);
                        c.set(13, 15);
                        c.set(14, 123);
                        this.checkStringToTimestamp$2("18:12:15.12312+7:30", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L + 120L))), tz);
                        c = Calendar.getInstance(tz);
                        c.set(2011, 4, 6, 7, 8, 9);
                        c.set(14, 100);
                        this.checkStringToTimestamp$2("2011-05-06 07:08:09.1000", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L))), tz);
                        this.checkStringToTimestamp$2("238", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("00238", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("2015-03-18 123142", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("2015-03-18T123123", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("2015-03-18X", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("2015/03/18", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("2015.03.18", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("20150318", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("2015-031-8", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("02015-01-18", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("015-01-18", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("2015-03-18T12:03.17-20:0", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("2015-03-18T12:03.17-0:70", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("2015-03-18T12:03.17-1:0:0", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("1999 08 01", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("1999-08 01", (Option)None$.MODULE$, tz);
                        this.checkStringToTimestamp$2("1999 08", (Option)None$.MODULE$, tz);
                        c = Calendar.getInstance(TimeZone.getTimeZone("GMT+00:00"));
                        c.set(2015, 2, 18, 12, 3, 17);
                        c.set(14, 0);
                        this.checkStringToTimestamp$2("2015-03-18T12:03:17.123456789+0:00", Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L + 123456L))), tz);
                    }

                    private final void checkStringToTimestamp$2(String str, Option expected, TimeZone tz$1) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)str), tz$1));
                        Option $org_scalatest_assert_macro_right = expected;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DateTimeUtilsSuite org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("SPARK-15379: special invalid date string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Option $org_scalatest_assert_macro_left = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-02-29 00:00:00"));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
                Option $org_scalatest_assert_macro_left2 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-04-31 00:00:00"));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
                Option $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-02-29"));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
                Option $org_scalatest_assert_macro_left4 = DateTimeUtils$.MODULE$.stringToDate(UTF8String.fromString((String)"2015-04-31"));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
                Option $org_scalatest_assert_macro_left5 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-02-29 00:00:00"));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
                Option $org_scalatest_assert_macro_left6 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-04-31 00:00:00"));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
                Option $org_scalatest_assert_macro_left7 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-02-29"));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
                Option $org_scalatest_assert_macro_left8 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-04-31"));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        this.test("hours", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Calendar c = Calendar.getInstance(this.$outer.TimeZonePST());
                c.set(2015, 2, 18, 13, 2, 11);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(c.getTimeInMillis() * 1000L, this.$outer.TimeZonePST())));
                int $org_scalatest_assert_macro_right = 13;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(c.getTimeInMillis() * 1000L, DateTimeUtils$.MODULE$.TimeZoneGMT())));
                int $org_scalatest_assert_macro_right2 = 20;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
                c.set(2015, 12, 8, 2, 7, 9);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(c.getTimeInMillis() * 1000L, this.$outer.TimeZonePST())));
                int $org_scalatest_assert_macro_right3 = 2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getHours(c.getTimeInMillis() * 1000L, DateTimeUtils$.MODULE$.TimeZoneGMT())));
                int $org_scalatest_assert_macro_right4 = 10;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        this.test("minutes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Calendar c = Calendar.getInstance(this.$outer.TimeZonePST());
                c.set(2015, 2, 18, 13, 2, 11);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(c.getTimeInMillis() * 1000L, this.$outer.TimeZonePST())));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(c.getTimeInMillis() * 1000L, DateTimeUtils$.MODULE$.TimeZoneGMT())));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(c.getTimeInMillis() * 1000L, TimeZone.getTimeZone("Australia/North"))));
                int $org_scalatest_assert_macro_right3 = 32;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
                c.set(2015, 2, 8, 2, 7, 9);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(c.getTimeInMillis() * 1000L, this.$outer.TimeZonePST())));
                int $org_scalatest_assert_macro_right4 = 7;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(c.getTimeInMillis() * 1000L, DateTimeUtils$.MODULE$.TimeZoneGMT())));
                int $org_scalatest_assert_macro_right5 = 7;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMinutes(c.getTimeInMillis() * 1000L, TimeZone.getTimeZone("Australia/North"))));
                int $org_scalatest_assert_macro_right6 = 37;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        this.test("seconds", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Calendar c = Calendar.getInstance(this.$outer.TimeZonePST());
                c.set(2015, 2, 18, 13, 2, 11);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(c.getTimeInMillis() * 1000L, this.$outer.TimeZonePST())));
                int $org_scalatest_assert_macro_right = 11;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(c.getTimeInMillis() * 1000L, DateTimeUtils$.MODULE$.TimeZoneGMT())));
                int $org_scalatest_assert_macro_right2 = 11;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
                c.set(2015, 2, 8, 2, 7, 9);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(c.getTimeInMillis() * 1000L, this.$outer.TimeZonePST())));
                int $org_scalatest_assert_macro_right3 = 9;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getSeconds(c.getTimeInMillis() * 1000L, DateTimeUtils$.MODULE$.TimeZoneGMT())));
                int $org_scalatest_assert_macro_right4 = 9;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        this.test("hours / minutes / seconds", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Timestamp[]{Timestamp.valueOf("2015-06-11 10:12:35.789"), Timestamp.valueOf("2015-06-11 20:13:40.789"), Timestamp.valueOf("1900-06-11 12:14:50.789"), Timestamp.valueOf("1700-02-28 12:14:50.123456")}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final Assertion apply(Timestamp t) {
                        long us = DateTimeUtils$.MODULE$.fromJavaTimestamp(t);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(us));
                        Timestamp $org_scalatest_assert_macro_right = t;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DateTimeUtilsSuite org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
        this.test("get day in year", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayInYear(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right = 77;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
                c.set(2012, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayInYear(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right2 = 78;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
        this.test("get year", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getYear(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right = 2015;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 429));
                c.set(2012, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getYear(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right2 = 2012;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
        this.test("get quarter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getQuarter(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
                c.set(2012, 11, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getQuarter(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right2 = 4;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        this.test("get month", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMonth(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
                c.set(2012, 11, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getMonth(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right2 = 12;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
        this.test("get day of month", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Calendar c = Calendar.getInstance();
                c.set(2015, 2, 18, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayOfMonth(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right = 18;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
                c.set(2012, 11, 24, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getDayOfMonth(this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$getInUTCDays(c.getTimeInMillis()))));
                int $org_scalatest_assert_macro_right2 = 24;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
        this.test("date add months", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Calendar c1 = Calendar.getInstance();
                c1.set(1997, 1, 28, 10, 30, 0);
                int days1 = DateTimeUtils$.MODULE$.millisToDays(c1.getTimeInMillis());
                Calendar c2 = Calendar.getInstance();
                c2.set(2000, 1, 29);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddMonths(days1, 36)));
                int $org_scalatest_assert_macro_right = DateTimeUtils$.MODULE$.millisToDays(c2.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
                c2.set(1996, 0, 31);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.dateAddMonths(days1, -13)));
                int $org_scalatest_assert_macro_right2 = DateTimeUtils$.MODULE$.millisToDays(c2.getTimeInMillis());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
        this.test("timestamp add months", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Calendar c1 = Calendar.getInstance();
                c1.set(1997, 1, 28, 10, 30, 0);
                c1.set(14, 0);
                long ts1 = c1.getTimeInMillis() * 1000L;
                Calendar c2 = Calendar.getInstance();
                c2.set(2000, 1, 29, 10, 30, 0);
                c2.set(14, 123);
                long ts2 = c2.getTimeInMillis() * 1000L;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts1, 36, 123000L)));
                long $org_scalatest_assert_macro_right = ts2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
                Calendar c3 = Calendar.getInstance(this.$outer.TimeZonePST());
                c3.set(1997, 1, 27, 16, 0, 0);
                c3.set(14, 0);
                long ts3 = c3.getTimeInMillis() * 1000L;
                Calendar c4 = Calendar.getInstance(this.$outer.TimeZonePST());
                c4.set(2000, 1, 27, 16, 0, 0);
                c4.set(14, 123);
                long ts4 = c4.getTimeInMillis() * 1000L;
                Calendar c5 = Calendar.getInstance(DateTimeUtils$.MODULE$.TimeZoneGMT());
                c5.set(2000, 1, 29, 0, 0, 0);
                c5.set(14, 123);
                long ts5 = c5.getTimeInMillis() * 1000L;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts3, 36, 123000L, this.$outer.TimeZonePST())));
                long $org_scalatest_assert_macro_right2 = ts4;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAddInterval(ts3, 36, 123000L, DateTimeUtils$.MODULE$.TimeZoneGMT())));
                long $org_scalatest_assert_macro_right3 = ts5;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
        this.test("monthsBetween", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Calendar c1 = Calendar.getInstance();
                c1.set(1997, 1, 28, 10, 30, 0);
                Calendar c2 = Calendar.getInstance();
                c2.set(1996, 9, 30, 0, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(c1.getTimeInMillis() * 1000L, c2.getTimeInMillis() * 1000L, true, c1.getTimeZone())));
                double $org_scalatest_assert_macro_right = 3.94959677;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(c1.getTimeInMillis() * 1000L, c2.getTimeInMillis() * 1000L, false, c1.getTimeZone())));
                double $org_scalatest_assert_macro_right2 = 3.9495967741935485;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1)new Serializable(this, c1, c2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$26 $outer;
                    private final Calendar c1$1;
                    private final Calendar c2$1;

                    public final Assertion apply(boolean roundOff) {
                        this.c2$1.set(2000, 1, 28, 0, 0, 0);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(this.c1$1.getTimeInMillis() * 1000L, this.c2$1.getTimeInMillis() * 1000L, roundOff, this.c1$1.getTimeZone())));
                        int $org_scalatest_assert_macro_right = -36;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
                        this.c2$1.set(2000, 1, 29, 0, 0, 0);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(this.c1$1.getTimeInMillis() * 1000L, this.c2$1.getTimeInMillis() * 1000L, roundOff, this.c1$1.getTimeZone())));
                        int $org_scalatest_assert_macro_right2 = -36;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
                        this.c2$1.set(1996, 2, 31, 0, 0, 0);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(this.c1$1.getTimeInMillis() * 1000L, this.c2$1.getTimeInMillis() * 1000L, roundOff, this.c1$1.getTimeZone())));
                        int $org_scalatest_assert_macro_right3 = 11;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.c1$1 = c1$1;
                        this.c2$1 = c2$1;
                    }
                });
                Calendar c3 = Calendar.getInstance(this.$outer.TimeZonePST());
                c3.set(2000, 1, 28, 16, 0, 0);
                Calendar c4 = Calendar.getInstance(this.$outer.TimeZonePST());
                c4.set(1997, 1, 28, 16, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(c3.getTimeInMillis() * 1000L, c4.getTimeInMillis() * 1000L, true, this.$outer.TimeZonePST())));
                double $org_scalatest_assert_macro_right3 = 36.0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(c3.getTimeInMillis() * 1000L, c4.getTimeInMillis() * 1000L, true, DateTimeUtils$.MODULE$.TimeZoneGMT())));
                double $org_scalatest_assert_macro_right4 = 35.90322581;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(c3.getTimeInMillis() * 1000L, c4.getTimeInMillis() * 1000L, false, DateTimeUtils$.MODULE$.TimeZoneGMT())));
                double $org_scalatest_assert_macro_right5 = 35.903225806451616;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
            }

            public /* synthetic */ DateTimeUtilsSuite org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
        this.test("from UTC timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(TimeZone tz) {
                        DateTimeTestUtils$.MODULE$.withDefaultTimeZone(tz, new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$7$$anonfun$apply$mcV$sp$7 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2011-12-25 09:00:00.123456", "UTC", "2011-12-25 09:00:00.123456");
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2011-12-25 09:00:00.123456", "JST", "2011-12-25 18:00:00.123456");
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2011-12-25 09:00:00.123456", "PST", "2011-12-25 01:00:00.123456");
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2011-12-25 09:00:00.123456", "Asia/Shanghai", "2011-12-25 17:00:00.123456");
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$7 org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                DateTimeTestUtils$.MODULE$.withDefaultTimeZone(TimeZone.getTimeZone("PST"), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2016-03-13 09:59:59.0", "PST", "2016-03-13 01:59:59.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2016-03-13 10:00:00.0", "PST", "2016-03-13 03:00:00.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2016-11-06 08:59:59.0", "PST", "2016-11-06 01:59:59.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2016-11-06 09:00:00.0", "PST", "2016-11-06 01:00:00.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1("2016-11-06 10:00:00.0", "PST", "2016-11-06 02:00:00.0");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$1(String utc, String tz, String expected) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.fromUTCTime(DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf(utc)), tz)).toString());
                String $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
        this.test("to UTC timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(TimeZone tz) {
                        DateTimeTestUtils$.MODULE$.withDefaultTimeZone(tz, new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$8$$anonfun$apply$mcV$sp$8 $outer;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2011-12-25 09:00:00.123456", "UTC", "2011-12-25 09:00:00.123456");
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2011-12-25 18:00:00.123456", "JST", "2011-12-25 09:00:00.123456");
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2011-12-25 01:00:00.123456", "PST", "2011-12-25 09:00:00.123456");
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2011-12-25 17:00:00.123456", "Asia/Shanghai", "2011-12-25 09:00:00.123456");
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$8 org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                DateTimeTestUtils$.MODULE$.withDefaultTimeZone(TimeZone.getTimeZone("PST"), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-03-13 01:59:59", "PST", "2016-03-13 09:59:59.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-03-13 02:00:00", "PST", "2016-03-13 10:00:00.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-03-13 03:00:00", "PST", "2016-03-13 10:00:00.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-11-06 00:59:59", "PST", "2016-11-06 07:59:59.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-11-06 01:00:00", "PST", "2016-11-06 09:00:00.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-11-06 01:59:59", "PST", "2016-11-06 09:59:59.0");
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2("2016-11-06 02:00:00", "PST", "2016-11-06 10:00:00.0");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$test$2(String utc, String tz, String expected) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.toUTCTime(DateTimeUtils$.MODULE$.fromJavaTimestamp(Timestamp.valueOf(utc)), tz)).toString());
                String $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
        this.test("trailing characters while converting string to timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                Option time;
                UTF8String s = UTF8String.fromString((String)"2019-10-31T10:59:23Z:::");
                Option $org_scalatest_assert_macro_left = time = DateTimeUtils$.MODULE$.stringToTimestamp(s, DateTimeUtils$.MODULE$.defaultTimeZone());
                None$ $org_scalatest_assert_macro_right = None$.MODULE$;
                Option option = $org_scalatest_assert_macro_left;
                None$ none$ = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(none$) : none$ != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
        this.test("truncTimestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option defaultInputTS = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-05T09:32:05.359"));
                Option defaultInputTS1 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-31T20:32:05.359"));
                Option defaultInputTS2 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-04-01T02:32:05.359"));
                Option defaultInputTS3 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-30T02:32:05.359"));
                Option defaultInputTS4 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-29T02:32:05.359"));
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_YEAR(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4$1());
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_MONTH(), "2015-03-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4$1());
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_DAY(), "2015-03-05T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4$1());
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_HOUR(), "2015-03-05T09:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4$1());
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_MINUTE(), "2015-03-05T09:32:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4$1());
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_SECOND(), "2015-03-05T09:32:05", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4$1());
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-02T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4$1());
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS1.get()), this.testTrunc$default$4$1());
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS2.get()), this.testTrunc$default$4$1());
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS3.get()), this.testTrunc$default$4$1());
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-23T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS4.get()), this.testTrunc$default$4$1());
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS.get()), this.testTrunc$default$4$1());
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS1.get()), this.testTrunc$default$4$1());
                this.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-04-01T00:00:00", BoxesRunTime.unboxToLong((Object)defaultInputTS2.get()), this.testTrunc$default$4$1());
                DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply(TimeZone tz) {
                        DateTimeTestUtils$.MODULE$.withDefaultTimeZone(tz, new Serializable(this, tz){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$9 $outer;
                            private final TimeZone tz$2;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                Option inputTS = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-05T09:32:05.359"));
                                Option inputTS1 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-31T20:32:05.359"));
                                Option inputTS2 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-04-01T02:32:05.359"));
                                Option inputTS3 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-30T02:32:05.359"));
                                Option inputTS4 = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)"2015-03-29T02:32:05.359"));
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_YEAR(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), this.tz$2);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_MONTH(), "2015-03-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), this.tz$2);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_DAY(), "2015-03-05T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), this.tz$2);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_HOUR(), "2015-03-05T09:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), this.tz$2);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_MINUTE(), "2015-03-05T09:32:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), this.tz$2);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_SECOND(), "2015-03-05T09:32:05", BoxesRunTime.unboxToLong((Object)inputTS.get()), this.tz$2);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-02T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), this.tz$2);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS1.get()), this.tz$2);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS2.get()), this.tz$2);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-30T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS3.get()), this.tz$2);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_WEEK(), "2015-03-23T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS4.get()), this.tz$2);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS.get()), this.tz$2);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-01-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS1.get()), this.tz$2);
                                this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(DateTimeUtils$.MODULE$.TRUNC_TO_QUARTER(), "2015-04-01T00:00:00", BoxesRunTime.unboxToLong((Object)inputTS2.get()), this.tz$2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tz$2 = tz$2;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$9 org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$testTrunc$1(int level, String expected, long inputTS, TimeZone timezone) {
                long truncated = DateTimeUtils$.MODULE$.truncTimestamp(inputTS, level, timezone);
                Option expectedTS = DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)expected));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)truncated));
                long $org_scalatest_assert_macro_right = BoxesRunTime.unboxToLong((Object)expectedTS.get());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 602));
            }

            private final TimeZone testTrunc$default$4$1() {
                return DateTimeUtils$.MODULE$.defaultTimeZone();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 592));
        this.test("daysToMillis and millisToDays", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Calendar c = Calendar.getInstance(this.$outer.TimeZonePST());
                c.set(2015, 11, 31, 16, 0, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis(), this.$outer.TimeZonePST())));
                int $org_scalatest_assert_macro_right = 16800;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 666));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.millisToDays(c.getTimeInMillis(), DateTimeUtils$.MODULE$.TimeZoneGMT())));
                int $org_scalatest_assert_macro_right2 = 16801;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
                int $org_scalatest_assert_macro_left3 = DateTimeUtils$.MODULE$.millisToDays(-86399999L, DateTimeUtils$.MODULE$.TimeZoneGMT());
                int $org_scalatest_assert_macro_right3 = -1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
                c.set(2015, 11, 31, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.daysToMillis(16800, this.$outer.TimeZonePST())));
                long $org_scalatest_assert_macro_right4 = c.getTimeInMillis();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
                c.setTimeZone(DateTimeUtils$.MODULE$.TimeZoneGMT());
                c.set(2015, 11, 31, 0, 0, 0);
                c.set(14, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.daysToMillis(16800, DateTimeUtils$.MODULE$.TimeZoneGMT())));
                long $org_scalatest_assert_macro_right5 = c.getTimeInMillis();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
                Map skipped_days = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Kwajalein"), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8632, 8633, 8634}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Apia"), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{15338}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Enderbury"), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9130, 9131}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Fakaofo"), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{15338}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Kiritimati"), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9130, 9131}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Pacific/Kwajalein"), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8632, 8633, 8634}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MIT"), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{15338})))}));
                DateTimeTestUtils$.MODULE$.ALL_TIMEZONES().foreach((Function1)new Serializable(this, skipped_days){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;
                    private final Map skipped_days$1;

                    public final void apply(TimeZone tz) {
                        Set skipped = (Set)this.skipped_days$1.getOrElse((Object)tz.getID(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Set<Object> apply() {
                                return Predef$.MODULE$.Set().empty();
                            }
                        });
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-20000), 20000).foreach((Function1)new Serializable(this, skipped, tz){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$10$$anonfun$apply$mcV$sp$10 $outer;
                            private final Set skipped$1;
                            private final TimeZone tz$3;

                            public final Object apply(int d) {
                                BoxedUnit boxedUnit;
                                if (this.skipped$1.contains((Object)BoxesRunTime.boxToInteger((int)d))) {
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.millisToDays(DateTimeUtils$.MODULE$.daysToMillis(d, this.tz$3), this.tz$3)));
                                    int $org_scalatest_assert_macro_right = d;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                    boxedUnit = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Round trip of ", " did not work in tz ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)d), this.tz$3})), Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
                                }
                                return boxedUnit;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.skipped$1 = skipped$1;
                                this.tz$3 = tz$3;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$10 org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.skipped_days$1 = skipped_days$1;
                    }
                });
            }

            public /* synthetic */ DateTimeUtilsSuite org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 662));
        this.test("parsing timestamp strings up to microsecond precision", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DateTimeTestUtils$.MODULE$.outstandingTimezones().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final Assertion apply(TimeZone timeZone) {
                        this.check$1("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSXXX", "2019-10-14T09:39:07.3220000Z", "2019-10-14T09:39:07.322Z", timeZone);
                        this.check$1("yyyy-MM-dd'T'HH:mm:ss.SSSSSS", "2019-10-14T09:39:07.322000", "2019-10-14T09:39:07.322", timeZone);
                        this.check$1("yyyy-MM-dd'T'HH:mm:ss.SSSX", "2019-10-14T09:39:07.322Z", "2019-10-14T09:39:07.322Z", timeZone);
                        this.check$1("yyyy-MM-dd'T'HH:mm:ss.SSSSSSX", "2019-10-14T09:39:07.123456Z", "2019-10-14T09:39:07.123456Z", timeZone);
                        this.check$1("yyyy-MM-dd'T'HH:mm:ss.SSSSSSX", "2019-10-14T09:39:07.000010Z", "2019-10-14T09:39:07.00001Z", timeZone);
                        this.check$1("yyyy-MM-dd'T'HH:mm:ss.S", "2019-10-14T09:39:07.1", "2019-10-14T09:39:07.1", timeZone);
                        this.check$1("yyyy-MM-dd'T'HH:mm:ss.SS", "2019-10-14T09:39:07.10", "2019-10-14T09:39:07.1", timeZone);
                        try {
                            new DateTimeUtils.TimestampParser(FastDateFormat.getInstance((String)"yyyy/MM/dd HH_mm_ss.SSSSSS", (TimeZone)timeZone, (Locale)Locale.US)).parse("2019/11/14 20#25#30.123456");
                            throw this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().fail("Expected to throw an exception for the invalid input", new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            String $org_scalatest_assert_macro_left = illegalArgumentException.getMessage();
                            String $org_scalatest_assert_macro_right = "is an invalid timestamp";
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                            return this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
                        }
                    }

                    private final void check$1(String pattern, String input, String reference, TimeZone timeZone$1) {
                        DateTimeUtils.TimestampParser parser = new DateTimeUtils.TimestampParser(FastDateFormat.getInstance((String)pattern, (TimeZone)timeZone$1, (Locale)Locale.US));
                        long expected = BoxesRunTime.unboxToLong((Object)DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)reference), timeZone$1).get());
                        long actual = parser.parse(input);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)actual));
                        long $org_scalatest_assert_macro_right = expected;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DateTimeUtilsSuite org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
        this.test("formatting timestamp strings up to microsecond precision", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DateTimeTestUtils$.MODULE$.outstandingTimezones().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$12 $outer;

                    public final void apply(TimeZone timeZone) {
                        this.check$2("yyyy-MM-dd HH:mm:ss.SSSSSSS", "2019-10-14T09:39:07.123456", "2019-10-14 09:39:07.1234560", timeZone);
                        this.check$2("yyyy-MM-dd HH:mm:ss.SSSSSS", "1960-01-01T09:39:07.123456", "1960-01-01 09:39:07.123456", timeZone);
                        this.check$2("yyyy-MM-dd HH:mm:ss.SSSSS", "0001-10-14T09:39:07.1", "0001-10-14 09:39:07.10000", timeZone);
                        this.check$2("yyyy-MM-dd HH:mm:ss.SSSS", "9999-12-31T23:59:59.999", "9999-12-31 23:59:59.9990", timeZone);
                        this.check$2("yyyy-MM-dd HH:mm:ss.SSS", "1970-01-01T00:00:00.0101", "1970-01-01 00:00:00.010", timeZone);
                        this.check$2("yyyy-MM-dd HH:mm:ss.SS", "2019-10-14T09:39:07.09", "2019-10-14 09:39:07.09", timeZone);
                        this.check$2("yyyy-MM-dd HH:mm:ss.S", "2019-10-14T09:39:07.2", "2019-10-14 09:39:07.2", timeZone);
                        this.check$2("yyyy-MM-dd HH:mm:ss.S", "2019-10-14T09:39:07", "2019-10-14 09:39:07.0", timeZone);
                        this.check$2("yyyy-MM-dd HH:mm:ss", "2019-10-14T09:39:07.123456", "2019-10-14 09:39:07", timeZone);
                    }

                    private final void check$2(String pattern, String input, String expected, TimeZone timeZone$2) {
                        DateTimeUtils.TimestampParser parser = new DateTimeUtils.TimestampParser(FastDateFormat.getInstance((String)pattern, (TimeZone)timeZone$2, (Locale)Locale.US));
                        long timestamp = BoxesRunTime.unboxToLong((Object)DateTimeUtils$.MODULE$.stringToTimestamp(UTF8String.fromString((String)input), timeZone$2).get());
                        String actual = parser.format(timestamp);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().convertToEqualizer(actual);
                        String $org_scalatest_assert_macro_right = expected;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        this.$outer.org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ DateTimeUtilsSuite org$apache$spark$sql$catalyst$util$DateTimeUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 736));
        this.test("toMillis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateTimeUtilsSuite $outer;

            public final Assertion apply() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.toMillis(-9223372036844776001L)));
                long $org_scalatest_assert_macro_right = -9223372036844777L;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.toMillis(-157700927876544L)));
                long $org_scalatest_assert_macro_right2 = -157700927877L;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("DateTimeUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 776));
    }
}

