/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonExprUtils$;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$class;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback$class;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.BadRecordException;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1, \"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":\"2015-08-26 00:00:00.0\"}\n  ", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0001\tud\u0001B\u0001\u0003\u0001>\u0011QBS:p]R{7\u000b\u001e:vGR\u001c(BA\u0002\u0005\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001\u0001BcF\u000f!MA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005aYR\"A\r\u000b\u0005i\u0011\u0011aB2pI\u0016<WM\\\u0005\u00039e\u0011qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003#yI!a\b\u0002\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0004Qe>$Wo\u0019;\u0011\u0005\u0005:\u0013B\u0001\u0015#\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!Q\u0003A!f\u0001\n\u0003Y\u0013AB:dQ\u0016l\u0017-F\u0001-!\ti\u0003'D\u0001/\u0015\tyc!A\u0003usB,7/\u0003\u00022]\tAA)\u0019;b)f\u0004X\r\u0003\u00054\u0001\tE\t\u0015!\u0003-\u0003\u001d\u00198\r[3nC\u0002B\u0001\"\u000e\u0001\u0003\u0016\u0004%\tAN\u0001\b_B$\u0018n\u001c8t+\u00059\u0004\u0003\u0002\u001d<}yr!!I\u001d\n\u0005i\u0012\u0013A\u0002)sK\u0012,g-\u0003\u0002={\t\u0019Q*\u00199\u000b\u0005i\u0012\u0003C\u0001\u001d@\u0013\t\u0001UH\u0001\u0004TiJLgn\u001a\u0005\t\u0005\u0002\u0011\t\u0012)A\u0005o\u0005Aq\u000e\u001d;j_:\u001c\b\u0005\u0003\u0005E\u0001\tU\r\u0011\"\u0001F\u0003\u0015\u0019\u0007.\u001b7e+\u00051\u0005CA\tH\u0013\tA%A\u0001\u0006FqB\u0014Xm]:j_:D\u0001B\u0013\u0001\u0003\u0012\u0003\u0006IAR\u0001\u0007G\"LG\u000e\u001a\u0011\t\u00111\u0003!Q3A\u0005\u00025\u000b!\u0002^5nKj{g.Z%e+\u0005q\u0005cA\u0011P}%\u0011\u0001K\t\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011I\u0003!\u0011#Q\u0001\n9\u000b1\u0002^5nKj{g.Z%eA!)A\u000b\u0001C\u0001+\u00061A(\u001b8jiz\"RAV,Y3j\u0003\"!\u0005\u0001\t\u000b)\u001a\u0006\u0019\u0001\u0017\t\u000bU\u001a\u0006\u0019A\u001c\t\u000b\u0011\u001b\u0006\u0019\u0001$\t\u000f1\u001b\u0006\u0013!a\u0001\u001d\"9A\f\u0001b\u0001\n\u0003i\u0016a\u00054pe\u000e,g*\u001e7mC\ndWmU2iK6\fW#\u00010\u0011\u0005\u0005z\u0016B\u00011#\u0005\u001d\u0011un\u001c7fC:DaA\u0019\u0001!\u0002\u0013q\u0016\u0001\u00064pe\u000e,g*\u001e7mC\ndWmU2iK6\f\u0007\u0005C\u0004e\u0001\t\u0007I\u0011A\u0016\u0002\u001d9,H\u000e\\1cY\u0016\u001c6\r[3nC\"1a\r\u0001Q\u0001\n1\nqB\\;mY\u0006\u0014G.Z*dQ\u0016l\u0017\r\t\u0005\u0006Q\u0002!\t%X\u0001\t]VdG.\u00192mK\")A\u000b\u0001C\u0001UR!ak\u001b7n\u0011\u0015!\u0015\u000e1\u0001G\u0011\u0015Q\u0013\u000e1\u0001G\u0011\u0015)\u0014\u000e1\u00018\u0011\u0015!\u0006\u0001\"\u0001p)\r1\u0006/\u001d\u0005\u0006\t:\u0004\rA\u0012\u0005\u0006U9\u0004\rA\u0012\u0005\u0006)\u0002!\ta\u001d\u000b\u0005-R,h\u000fC\u0003Ee\u0002\u0007a\tC\u0003+e\u0002\u0007a\tC\u00036e\u0002\u0007a\tC\u0003y\u0001\u0011\u0005\u00130A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001{!\tYh0D\u0001}\u0015\tiH!\u0001\u0005b]\u0006d\u0017p]5t\u0013\tyHPA\bUsB,7\t[3dWJ+7/\u001e7u\u0011)\t\u0019\u0001\u0001EC\u0002\u0013\u0005\u0011QA\u0001\nG>tg/\u001a:uKJ,\"!a\u0002\u0011\u000f\u0005\nI!!\u0004\u0002.%\u0019\u00111\u0002\u0012\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CBA\b\u0003?\t)C\u0004\u0003\u0002\u0012\u0005ma\u0002BA\n\u00033i!!!\u0006\u000b\u0007\u0005]a\"\u0001\u0004=e>|GOP\u0005\u0002G%\u0019\u0011Q\u0004\u0012\u0002\u000fA\f7m[1hK&!\u0011\u0011EA\u0012\u0005\r\u0019V-\u001d\u0006\u0004\u0003;\u0011\u0003\u0003BA\u0014\u0003Si\u0011\u0001B\u0005\u0004\u0003W!!aC%oi\u0016\u0014h.\u00197S_^\u0014R!a\f'\u0003g1a!!\r\u0001\u0001\u00055\"\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\u0003BA\u001b\u0003\u007fi!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0005Y\u0006twM\u0003\u0002\u0002>\u0005!!.\u0019<b\u0013\u0011\t\t%a\u000e\u0003\r=\u0013'.Z2u\u0011)\t)\u0005\u0001E\u0001B\u0003&\u0011qA\u0001\u000bG>tg/\u001a:uKJ\u0004\u0003\u0006BA\"\u0003\u0013\u00022!IA&\u0013\r\tiE\t\u0002\niJ\fgn]5f]RD!\"!\u0015\u0001\u0011\u000b\u0007I\u0011AA*\u0003\u0019\u0001\u0018M]:feV\u0011\u0011Q\u000b\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111\f\u0003\u0002\t)\u001cxN\\\u0005\u0005\u0003?\nIFA\u0007KC\u000e\\7o\u001c8QCJ\u001cXM\u001d\u0005\u000b\u0003G\u0002\u0001\u0012!Q!\n\u0005U\u0013a\u00029beN,'\u000f\t\u0015\u0005\u0003C\nI\u0005\u0003\u0004\u0002j\u0001!\teK\u0001\tI\u0006$\u0018\rV=qK\"9\u0011Q\u000e\u0001\u0005B\u0005=\u0014\u0001D<ji\"$\u0016.\\3[_:,Gc\u0001\u000b\u0002r!1A*a\u001bA\u0002yBq!!\u001e\u0001\t\u0003\n9(\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003\u0002z\u0005}\u0004cA\u0011\u0002|%\u0019\u0011Q\u0010\u0012\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\\\u0005M\u0004\u0019AA=\u0011\u001d\t\u0019\t\u0001C!\u0003\u000b\u000b!\"\u001b8qkR$\u0016\u0010]3t+\t\t9\t\u0005\u0004\u0002\u0010\u0005}\u0011\u0011\u0012\t\u0004[\u0005-\u0015bAAG]\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/\u001a\u0005\u0007\u000f\u0001!\t%!%\u0016\u0003yB\u0011\"!&\u0001\u0003\u0003%\t!a&\u0002\t\r|\u0007/\u001f\u000b\n-\u0006e\u00151TAO\u0003?C\u0001BKAJ!\u0003\u0005\r\u0001\f\u0005\tk\u0005M\u0005\u0013!a\u0001o!AA)a%\u0011\u0002\u0003\u0007a\t\u0003\u0005M\u0003'\u0003\n\u00111\u0001O\u0011%\t\u0019\u000bAI\u0001\n\u0003\t)+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d&f\u0001\u0017\u0002*.\u0012\u00111\u0016\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003%)hn\u00195fG.,GMC\u0002\u00026\n\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI,a,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002>\u0002\t\n\u0011\"\u0001\u0002@\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAaU\r9\u0014\u0011\u0016\u0005\n\u0003\u000b\u0004\u0011\u0013!C\u0001\u0003\u000f\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002J*\u001aa)!+\t\u0013\u00055\u0007!%A\u0005\u0002\u0005=\u0017AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003#T3ATAU\u0011%\t)\u000eAA\u0001\n\u0003\n9.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00033\u0004B!!\u000e\u0002\\&\u0019\u0001)a\u000e\t\u0013\u0005}\u0007!!A\u0005\u0002\u0005\u0005\u0018\u0001\u00049s_\u0012,8\r^!sSRLXCAAr!\r\t\u0013Q]\u0005\u0004\u0003O\u0014#aA%oi\"I\u00111\u001e\u0001\u0002\u0002\u0013\u0005\u0011Q^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI(a<\t\u0015\u0005E\u0018\u0011^A\u0001\u0002\u0004\t\u0019/A\u0002yIEB\u0011\"!>\u0001\u0003\u0003%\t%a>\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!?\u0011\r\u0005m(\u0011AA=\u001b\t\tiPC\u0002\u0002\u0000\n\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019!!@\u0003\u0011%#XM]1u_JD\u0011Ba\u0002\u0001\u0003\u0003%\tA!\u0003\u0002\u0011\r\fg.R9vC2$2A\u0018B\u0006\u0011)\t\tP!\u0002\u0002\u0002\u0003\u0007\u0011\u0011\u0010\u0005\n\u0005\u001f\u0001\u0011\u0011!C!\u0005#\ta!Z9vC2\u001cHc\u00010\u0003\u0014!Q\u0011\u0011\u001fB\u0007\u0003\u0003\u0005\r!!\u001f)\u001f\u0001\u00119B!\b\u0003 \t\r\"Q\u0005B\u0015\u0005W\u00012!\u0005B\r\u0013\r\u0011YB\u0001\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\u0011\t#\u00012`\rVs5i\u0018\u0015kg>t7\u000b\u001e:-AM\u001c\u0007.Z7b72\u0002s\u000e\u001d;j_:\u001cX,\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007e\u001d;sk\u000e$\bE^1mk\u0016\u0004s/\u001b;iAQDW\rI4jm\u0016t\u0007\u0005\u00196t_:\u001cFO\u001d1!C:$\u0007\u0005Y:dQ\u0016l\u0017\r\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\n\u0002\u0003_T\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ>#C\nR\u0014\u0007\f\u0011#E\nR\u0004G\f\u001d~O1\u0002s%\u0019\u0011J\u001dRc\u0003E\u0019\u0011E\u001fV\u0013E*R\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(%\u0019\u0012;c1\u0002#E\u0019\u0012;a9BTP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(w\n\"\u0018.\\3#u\t\u0012dg\f\u00199_I\u0002\u0014'\u000e\u0012~O1\u0002s\u0005^5nK\u0002\"\u0016.\\3ti\u0006l\u0007o\n\u0017![\u0006\u0004\bf\n;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;(Y\u0001:C\rZ\u0018N\u001b>J\u00180_=(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012uS6,'E\u000f\u00123aE*T\u0006\r\u001d.eY\u0002\u0003\u0007\r\u001e1ai\u0002\u0004G\f\u0019#{*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003.\u0005)!G\f\u001a/a\u001dI!\u0011\u0007\u0002\u0002\u0002#\u0005!1G\u0001\u000e\u0015N|g\u000eV8TiJ,8\r^:\u0011\u0007E\u0011)D\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B\u001c'\u0015\u0011)D!\u000f'!%\u0011YD!\u0011-o\u0019se+\u0004\u0002\u0003>)\u0019!q\b\u0012\u0002\u000fI,h\u000e^5nK&!!1\tB\u001f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u0005\b)\nUB\u0011\u0001B$)\t\u0011\u0019\u0004\u0003\u0006\u0003L\tU\u0012\u0011!C#\u0005\u001b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033D!B!\u0015\u00036\u0005\u0005I\u0011\u0011B*\u0003\u0015\t\u0007\u000f\u001d7z)%1&Q\u000bB,\u00053\u0012Y\u0006\u0003\u0004+\u0005\u001f\u0002\r\u0001\f\u0005\u0007k\t=\u0003\u0019A\u001c\t\r\u0011\u0013y\u00051\u0001G\u0011!a%q\nI\u0001\u0002\u0004q\u0005B\u0003B0\u0005k\t\t\u0011\"!\u0003b\u00059QO\\1qa2LH\u0003\u0002B2\u0005W\u0002B!I(\u0003fA9\u0011Ea\u001a-o\u0019s\u0015b\u0001B5E\t1A+\u001e9mKRB\u0011B!\u001c\u0003^\u0005\u0005\t\u0019\u0001,\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003r\tU\u0012\u0013!C\u0001\u0003\u001f\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004B\u0003B;\u0005k\t\n\u0011\"\u0001\u0002P\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C\u0007\u0003\u0006\u0003z\tU\u0012\u0011!C\u0005\u0005w\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0007")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final boolean forceNullableSchema;
    private final DataType nullableSchema;
    private transient Function1<Seq<InternalRow>, Serializable> converter;
    private transient JacksonParser parser;
    private final boolean resolved;
    private final transient TimeZone timeZone;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> apply$default$4() {
        return JsonToStructs$.MODULE$.apply$default$4();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(JsonToStructs jsonToStructs) {
        return JsonToStructs$.MODULE$.unapply(jsonToStructs);
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, JsonToStructs> tupled() {
        return JsonToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, JsonToStructs>>>> curried() {
        return JsonToStructs$.MODULE$.curried();
    }

    private Function1 converter$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Object object;
                DataType dataType2 = this.nullableSchema();
                if (dataType2 instanceof StructType) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final InternalRow apply(Seq<InternalRow> rows) {
                            return rows.length() == 1 ? (InternalRow)rows.head() : null;
                        }
                    };
                } else if (dataType2 instanceof ArrayType) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ArrayData apply(Seq<InternalRow> rows) {
                            return ((SpecializedGetters)rows.head()).getArray(0);
                        }
                    };
                } else {
                    if (!(dataType2 instanceof MapType)) {
                        throw new MatchError((Object)dataType2);
                    }
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final MapData apply(Seq<InternalRow> rows) {
                            return ((SpecializedGetters)rows.head()).getMap(0);
                        }
                    };
                }
                this.converter = object;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.converter;
        }
    }

    private JacksonParser parser$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.parser = new JacksonParser(this.nullableSchema(), new JSONOptions((Map<String, String>)this.options().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)FailFastMode$.MODULE$.name())), (String)this.timeZoneId().get(), JSONOptions$.MODULE$.$lessinit$greater$default$3()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.parser;
        }
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback$class.doGenCode(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression$class.resolved(this);
                this.bitmap$0 = true;
            }
            return this.resolved;
        }
    }

    @Override
    public boolean resolved() {
        return this.bitmap$0 ? this.resolved : this.resolved$lzycompute();
    }

    private TimeZone timeZone$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.timeZone = TimeZoneAwareExpression$class.timeZone(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.timeZone;
        }
    }

    @Override
    public TimeZone timeZone() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.timeZone$lzycompute() : this.timeZone;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean forceNullableSchema() {
        return this.forceNullableSchema;
    }

    public DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType2 = this.nullableSchema();
        boolean bl = dataType2 instanceof StructType ? true : (dataType2 instanceof ArrayType ? true : dataType2 instanceof MapType);
        TypeCheckResult typeCheckResult = bl ? ExpectsInputTypes$class.checkInputDataTypes(this) : new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Input schema ", " must be a struct, an array or a map."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nullableSchema().catalogString()})));
        return typeCheckResult;
    }

    public Function1<Seq<InternalRow>, Serializable> converter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.converter$lzycompute() : this.converter;
    }

    public JacksonParser parser() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.parser$lzycompute() : this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$14 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$15 = this.copy$default$1();
        Map<String, String> x$16 = this.copy$default$2();
        Expression x$17 = this.copy$default$3();
        return this.copy(x$15, x$16, x$17, (Option<String>)x$14);
    }

    @Override
    public Object nullSafeEval(Object json) {
        Object object;
        if (json.toString().trim().isEmpty()) {
            return null;
        }
        try {
            object = this.converter().apply(this.parser().parse((UTF8String)json, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final JsonParser apply(JsonFactory jsonFactory, UTF8String record) {
                    return CreateJacksonParser$.MODULE$.utf8String(jsonFactory, record);
                }
            }, new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final UTF8String apply(UTF8String x) {
                    return (UTF8String)Predef$.MODULE$.identity((Object)x);
                }
            }));
        }
        catch (BadRecordException badRecordException) {
            object = null;
        }
        return object;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringType$ stringType$ = StringType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringType$);
    }

    @Override
    public String sql() {
        DataType dataType2 = this.schema();
        String string = dataType2 instanceof MapType ? "entries" : super.sql();
        return string;
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new JsonToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = this.timeZoneId();
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.options();
                break;
            }
            case 0: {
                object = this.schema();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        DataType dataType2 = this.schema();
        DataType dataType3 = jsonToStructs.schema();
        if (dataType2 == null) {
            if (dataType3 != null) {
                return false;
            }
        } else if (!dataType2.equals(dataType3)) return false;
        Map<String, String> map2 = this.options();
        Map<String, String> map3 = jsonToStructs.options();
        if (map2 == null) {
            if (map3 != null) {
                return false;
            }
        } else if (!map2.equals(map3)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression$class.$init$(this);
        CodegenFallback$class.$init$(this);
        ExpectsInputTypes$class.$init$(this);
        this.forceNullableSchema = BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.FROM_JSON_FORCE_NULLABLE_SCHEMA()));
        this.nullableSchema = this.forceNullableSchema() ? schema.asNullable() : schema;
    }

    public JsonToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(JsonExprUtils$.MODULE$.evalSchemaExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(JsonExprUtils$.MODULE$.evalSchemaExpr(schema), JsonExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

