/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RDG;
import org.apache.spark.sql.catalyst.expressions.Rand$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_([seed]) - Returns a random value with independent and identically distributed (i.i.d.) uniformly distributed values in [0, 1).", examples="\n    Examples:\n      > SELECT _FUNC_();\n       0.9629742951434543\n      > SELECT _FUNC_(0);\n       0.8446490682263027\n      > SELECT _FUNC_(null);\n       0.8446490682263027\n  ", note="The function is non-deterministic in general case.", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001>\u0011AAU1oI*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!Q9R\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t\u0019!\u000bR$\u0011\u0005E)\u0012B\u0001\f\u0003\u0005a)\u0005\u0010\u001d:fgNLwN\\,ji\"\u0014\u0016M\u001c3p[N+W\r\u001a\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%A\u0003dQ&dG-F\u0001$!\t\tB%\u0003\u0002&\u0005\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u001d\u0002!\u0011#Q\u0001\n\r\naa\u00195jY\u0012\u0004\u0003\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\b\u0006\u0002,YA\u0011\u0011\u0003\u0001\u0005\u0006C!\u0002\ra\t\u0005\u0006S\u0001!\tA\f\u000b\u0002W!)\u0001\u0007\u0001C!c\u0005Yq/\u001b;i\u001d\u0016<8+Z3e)\tY#\u0007C\u00034_\u0001\u0007A'\u0001\u0003tK\u0016$\u0007C\u0001\r6\u0013\t1\u0014D\u0001\u0003M_:<\u0007\"\u0002\u001d\u0001\t#J\u0014\u0001D3wC2Le\u000e^3s]\u0006dGC\u0001\u001e>!\tA2(\u0003\u0002=3\t1Ai\\;cY\u0016DQAP\u001cA\u0002}\nQ!\u001b8qkR\u0004\"\u0001Q!\u000e\u0003\u0011I!A\u0011\u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0006\t\u0002!\t%R\u0001\nI><UM\\\"pI\u0016$2A\u0012'R!\t9%*D\u0001I\u0015\tI%!A\u0004d_\u0012,w-\u001a8\n\u0005-C%\u0001C#yaJ\u001cu\u000eZ3\t\u000b5\u001b\u0005\u0019\u0001(\u0002\u0007\r$\b\u0010\u0005\u0002H\u001f&\u0011\u0001\u000b\u0013\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015\u00116\t1\u0001G\u0003\t)g\u000fC\u0003U\u0001\u0011\u0005c&A\u0005ge\u0016\u001c\bnQ8qs\"9a\u000bAA\u0001\n\u00039\u0016\u0001B2paf$\"a\u000b-\t\u000f\u0005*\u0006\u0013!a\u0001G!9!\fAI\u0001\n\u0003Y\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u00029*\u00121%X\u0016\u0002=B\u0011q\fZ\u0007\u0002A*\u0011\u0011MY\u0001\nk:\u001c\u0007.Z2lK\u0012T!aY\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002fA\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000f\u001d\u0004\u0011\u0011!C!Q\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012!\u001b\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\fA\u0001\\1oO*\ta.\u0001\u0003kCZ\f\u0017B\u00019l\u0005\u0019\u0019FO]5oO\"9!\u000fAA\u0001\n\u0003\u0019\u0018\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001;\u0011\u0005a)\u0018B\u0001<\u001a\u0005\rIe\u000e\u001e\u0005\bq\u0002\t\t\u0011\"\u0001z\u00039\u0001(o\u001c3vGR,E.Z7f]R$\"A_?\u0011\u0005aY\u0018B\u0001?\u001a\u0005\r\te.\u001f\u0005\b}^\f\t\u00111\u0001u\u0003\rAH%\r\u0005\n\u0003\u0003\u0001\u0011\u0011!C!\u0003\u0007\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u000b\u0001R!a\u0002\u0002\u000eil!!!\u0003\u000b\u0007\u0005-\u0011$\u0001\u0006d_2dWm\u0019;j_:LA!a\u0004\u0002\n\tA\u0011\n^3sCR|'\u000fC\u0005\u0002\u0014\u0001\t\t\u0011\"\u0001\u0002\u0016\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0018\u0005u\u0001c\u0001\r\u0002\u001a%\u0019\u00111D\r\u0003\u000f\t{w\u000e\\3b]\"Aa0!\u0005\u0002\u0002\u0003\u0007!\u0010C\u0005\u0002\"\u0001\t\t\u0011\"\u0011\u0002$\u00051Q-];bYN$B!a\u0006\u0002&!Aa0a\b\u0002\u0002\u0003\u0007!\u0010K\n\u0001\u0003S\ty#!\r\u00026\u0005]\u00121HA\u001f\u0003\u0003\n\u0019\u0005E\u0002\u0012\u0003WI1!!\f\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\r\u0002\u0003\u0017yf)\u0016(D?\"Z6/Z3e;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bAI\fg\u000eZ8nAY\fG.^3!o&$\b\u000eI5oI\u0016\u0004XM\u001c3f]R\u0004\u0013M\u001c3!S\u0012,g\u000e^5dC2d\u0017\u0010\t3jgR\u0014\u0018NY;uK\u0012\u0004\u0003&\u001b\u0018j]\u0011t\u0013\u0006I;oS\u001a|'/\u001c7zA\u0011L7\u000f\u001e:jEV$X\r\u001a\u0011wC2,Xm\u001d\u0011j]\u0002Z\u0006\u0007\f\u00112S9\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003s\t\u0011q\f\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003GL\u001d7ee:DGM\u001d6cQ\u001aD'\u000e\u001b4\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0002\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00111]a\"DG\u000e\u001b:aYB$G\r\u001c4aI:$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b8vY2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0019/qQ\"d\u0007N\u001d1ma\u0012$GN\u001a1e]R\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002@\u0005\u0011D\u000b[3!MVt7\r^5p]\u0002J7\u000f\t8p]6\"W\r^3s[&t\u0017n\u001d;jG\u0002Jg\u000eI4f]\u0016\u0014\u0018\r\u001c\u0011dCN,g&A\u0003tS:\u001cW-\t\u0002\u0002F\u0005)\u0011GL\u001b/a\u001d9\u0011\u0011\n\u0002\t\u0002\u0005-\u0013\u0001\u0002*b]\u0012\u00042!EA'\r\u0019\t!\u0001#\u0001\u0002PM)\u0011QJA);A\u0019\u0001$a\u0015\n\u0007\u0005U\u0013D\u0001\u0004B]f\u0014VM\u001a\u0005\bS\u00055C\u0011AA-)\t\tY\u0005\u0003\u0005\u0002^\u00055C\u0011AA0\u0003\u0015\t\u0007\u000f\u001d7z)\rY\u0013\u0011\r\u0005\u0007g\u0005m\u0003\u0019\u0001\u001b\t\u0015\u0005u\u0013QJA\u0001\n\u0003\u000b)\u0007F\u0002,\u0003OBa!IA2\u0001\u0004\u0019\u0003BCA6\u0003\u001b\n\t\u0011\"!\u0002n\u00059QO\\1qa2LH\u0003BA8\u0003k\u0002B\u0001GA9G%\u0019\u00111O\r\u0003\r=\u0003H/[8o\u0011%\t9(!\u001b\u0002\u0002\u0003\u00071&A\u0002yIAB!\"a\u001f\u0002N\u0005\u0005I\u0011BA?\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005}\u0004c\u00016\u0002\u0002&\u0019\u00111Q6\u0003\r=\u0013'.Z2u\u0001")
public class Rand
extends RDG
implements ExpressionWithRandomSeed,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Rand rand) {
        return Rand$.MODULE$.unapply(rand);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Rand withNewSeed(long seed) {
        return new Rand(new Literal(BoxesRunTime.boxToLong((long)seed), LongType$.MODULE$));
    }

    public double evalInternal(InternalRow input) {
        return this.rng().nextDouble();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = new ", "(", "L + partitionIndex);"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rngTerm, className, BoxesRunTime.boxToLong((long)this.seed())})));
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      final ", " ", " = ", ".nextDouble();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), rngTerm})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public Rand freshCopy() {
        return new Rand(this.child());
    }

    public Rand copy(Expression child) {
        return new Rand(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Rand";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Rand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Rand)) return false;
        boolean bl = true;
        if (!bl) return false;
        Rand rand = (Rand)x$1;
        Expression expression = this.child();
        Expression expression2 = rand.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!rand.canEqual(this)) return false;
        return true;
    }

    public Rand(Expression child) {
        this.child = child;
    }

    public Rand() {
        this(new Literal(BoxesRunTime.boxToLong((long)Utils$.MODULE$.random().nextLong()), LongType$.MODULE$));
    }
}

