/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

public final class UnsafeRowUtils$ {
    public static UnsafeRowUtils$ MODULE$;

    static {
        new UnsafeRowUtils$();
    }

    public boolean validateStructuralIntegrity(UnsafeRow row, StructType expectedSchema) {
        boolean bl;
        Object object = new Object();
        try {
            if (expectedSchema.fields().length != row.numFields()) {
                return false;
            }
            int bitSetWidthInBytes = UnsafeRow.calculateBitSetWidthInBytes(row.numFields());
            int rowSizeInBytes = row.getSizeInBytes();
            if (expectedSchema.fields().length > 0 && bitSetWidthInBytes >= rowSizeInBytes) {
                return false;
            }
            IntRef varLenFieldsSizeInBytes = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedSchema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
                UnsafeRowUtils$.$anonfun$validateStructuralIntegrity$1(row, bitSetWidthInBytes, rowSizeInBytes, object, varLenFieldsSizeInBytes, x0$1);
                return BoxedUnit.UNIT;
            });
            if (bitSetWidthInBytes + 8 * row.numFields() + varLenFieldsSizeInBytes.elem > rowSizeInBytes) {
                return false;
            }
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$validateStructuralIntegrity$1(UnsafeRow row$1, int bitSetWidthInBytes$1, int rowSizeInBytes$1, Object nonLocalReturnKey1$1, IntRef varLenFieldsSizeInBytes$1, Tuple2 x0$1) {
        int index;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index2 = tuple2._2$mcI$sp();
            if (!UnsafeRow.isFixedLength(field.dataType()) && !row$1.isNullAt(index2)) {
                long offsetAndSize = row$1.getLong(index2);
                int offset = (int)(offsetAndSize >> 32);
                int size = (int)offsetAndSize;
                if (size < 0) throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                if (offset < bitSetWidthInBytes$1 + 8 * row$1.numFields()) throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                if (offset + size > rowSizeInBytes$1) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
                varLenFieldsSizeInBytes$1.elem += size;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index3 = tuple2._2$mcI$sp();
            if (UnsafeRow.isFixedLength(field.dataType()) && !row$1.isNullAt(index3)) {
                DataType dataType = field.dataType();
                if (BooleanType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index3) >> 1 != 0L) {
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index3) >> 8 != 0L) {
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index3) >> 16 != 0L) {
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index3) >> 32 != 0L) {
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index3) >> 32 != 0L) {
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null && row$1.isNullAt(index = tuple2._2$mcI$sp())) {
            if (row$1.getLong(index) != 0L) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private UnsafeRowUtils$() {
        MODULE$ = this;
    }
}

