/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.WidthBucket$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function4;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(value, min_value, max_value, num_bucket) - Returns the bucket number to which\n      `value` would be assigned in an equiwidth histogram with `num_bucket` buckets,\n      in the range `min_value` to `max_value`.\"\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(5.3, 0.2, 10.6, 5);\n       3\n      > SELECT _FUNC_(-2.1, 1.3, 3.4, 3);\n       0\n      > SELECT _FUNC_(8.1, 0.0, 5.7, 4);\n       5\n      > SELECT _FUNC_(-0.9, 5.2, 0.5, 2);\n       3\n      > SELECT _FUNC_(INTERVAL '0' YEAR, INTERVAL '0' YEAR, INTERVAL '10' YEAR, 10);\n       1\n      > SELECT _FUNC_(INTERVAL '1' YEAR, INTERVAL '0' YEAR, INTERVAL '10' YEAR, 10);\n       2\n      > SELECT _FUNC_(INTERVAL '0' DAY, INTERVAL '0' DAY, INTERVAL '10' DAY, 10);\n       1\n      > SELECT _FUNC_(INTERVAL '1' DAY, INTERVAL '0' DAY, INTERVAL '10' DAY, 10);\n       2\n  ", since="3.1.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t]t!B\u0016-\u0011\u0003Id!B\u001e-\u0011\u0003a\u0004\"B&\u0002\t\u0003a\u0005\"B'\u0002\t\u0003q\u0005\"\u00022\u0002\t\u0003\u0019\u0007\"B6\u0002\t\u0003a\u0007bB9\u0002\u0003\u0003%\tI\u001d\u0005\n\u00053\n\u0011\u0011!CA\u00057B\u0011B!\u001c\u0002\u0003\u0003%IAa\u001c\u0007\tmb\u0003\t\u001e\u0005\n-&\u0011)\u001a!C\u0001\u0003?A!\"a\n\n\u0005#\u0005\u000b\u0011BA\u0011\u0011)\tI#\u0003BK\u0002\u0013\u0005\u0011q\u0004\u0005\u000b\u0003WI!\u0011#Q\u0001\n\u0005\u0005\u0002BCA\u0017\u0013\tU\r\u0011\"\u0001\u0002 !Q\u0011qF\u0005\u0003\u0012\u0003\u0006I!!\t\t\u0013}K!Q3A\u0005\u0002\u0005}\u0001BCA\u0019\u0013\tE\t\u0015!\u0003\u0002\"!11*\u0003C\u0001\u0003gAq!!\u0010\n\t\u0003\ny\u0004C\u0004\u0002T%!\t%!\u0016\t\u000f\u0005\r\u0014\u0002\"\u0011\u0002f!9\u0011QN\u0005\u0005B\u0005=\u0004bBA9\u0013\u0011\u0005\u00131\u000f\u0005\b\u0003\u000bKA\u0011KAD\u0011\u001d\tI*\u0003C!\u00037Cq!a.\n\t\u0003\ny\u0002C\u0004\u0002:&!\t%a\b\t\u000f\u0005m\u0016\u0002\"\u0011\u0002 !9\u0011QX\u0005\u0005B\u0005}\u0001bBA`\u0013\u0011E\u0013\u0011\u0019\u0005\n\u0003\u0017L\u0011\u0011!C\u0001\u0003\u001bD\u0011\"a6\n#\u0003%\t!!7\t\u0013\u0005=\u0018\"%A\u0005\u0002\u0005e\u0007\"CAy\u0013E\u0005I\u0011AAm\u0011%\t\u00190CI\u0001\n\u0003\tI\u000eC\u0005\u0002v&\t\t\u0011\"\u0011\u0002x\"I\u0011Q`\u0005\u0002\u0002\u0013\u0005\u0011q \u0005\n\u0005\u000fI\u0011\u0011!C\u0001\u0005\u0013A\u0011Ba\u0004\n\u0003\u0003%\tE!\u0005\t\u0013\t}\u0011\"!A\u0005\u0002\t\u0005\u0002\"\u0003B\u0013\u0013\u0005\u0005I\u0011\tB\u0014\u0011%\u0011Y#CA\u0001\n\u0003\u0012i#A\u0006XS\u0012$\bNQ;dW\u0016$(BA\u0017/\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005=\u0002\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005E\u0012\u0014aA:rY*\u00111\u0007N\u0001\u0006gB\f'o\u001b\u0006\u0003kY\na!\u00199bG\",'\"A\u001c\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005i\nQ\"\u0001\u0017\u0003\u0017]KG\r\u001e5Ck\u000e\\W\r^\n\u0004\u0003u\u001a\u0005C\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$AB!osJ+g\r\u0005\u0002E\u00136\tQI\u0003\u0002G\u000f\u0006\u0011\u0011n\u001c\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQUI\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0002s\u0005\u00192m\\7qkR,')^2lKRtU/\u001c2feR)q*\u0016.]=B\u0011\u0001kU\u0007\u0002#*\u0011!kR\u0001\u0005Y\u0006tw-\u0003\u0002U#\n!Aj\u001c8h\u0011\u001516\u00011\u0001X\u0003\u00151\u0018\r\\;f!\tq\u0004,\u0003\u0002Z\u007f\t1Ai\\;cY\u0016DQaW\u0002A\u0002]\u000b1!\\5o\u0011\u0015i6\u00011\u0001X\u0003\ri\u0017\r\u001f\u0005\u0006?\u000e\u0001\r\u0001Y\u0001\n]Vl')^2lKR\u0004\"AP1\n\u0005Q{\u0014AB5t\u001dVdG\u000eF\u0003eO\"L'\u000e\u0005\u0002?K&\u0011am\u0010\u0002\b\u0005>|G.Z1o\u0011\u00151F\u00011\u0001X\u0011\u0015YF\u00011\u0001X\u0011\u0015iF\u00011\u0001X\u0011\u0015yF\u00011\u0001a\u0003i\u0019w.\u001c9vi\u0016\u0014UoY6fi:+XNY3s\u001d>$h*\u001e7m)\u0015yUN\\8q\u0011\u00151V\u00011\u0001X\u0011\u0015YV\u00011\u0001X\u0011\u0015iV\u00011\u0001X\u0011\u0015yV\u00011\u0001a\u0003\u0015\t\u0007\u000f\u001d7z)%\u0019(\u0011\u000bB*\u0005+\u00129\u0006\u0005\u0002;\u0013MA\u0011\"\u001e=|\u0003\u000b\tY\u0001\u0005\u0002;m&\u0011q\u000f\f\u0002\u0015#V\fG/\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005iJ\u0018B\u0001>-\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001?\u0000\u001d\tQT0\u0003\u0002\u007fY\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0001\u0003\u0007\u0011aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002\u007fYA\u0019a(a\u0002\n\u0007\u0005%qHA\u0004Qe>$Wo\u0019;\u0011\t\u00055\u00111\u0004\b\u0005\u0003\u001f\tIB\u0004\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002O\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001K!A` \n\u0007)\u000biB\u0003\u0002\u007f\u007fU\u0011\u0011\u0011\u0005\t\u0004u\u0005\r\u0012bAA\u0013Y\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\rY\fG.^3!\u0003!i\u0017N\u001c,bYV,\u0017!C7j]Z\u000bG.^3!\u0003!i\u0017\r\u001f,bYV,\u0017!C7bqZ\u000bG.^3!\u0003)qW/\u001c\"vG.,G\u000f\t\u000b\ng\u0006U\u0012qGA\u001d\u0003wAaA\u0016\nA\u0002\u0005\u0005\u0002bBA\u0015%\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003[\u0011\u0002\u0019AA\u0011\u0011\u0019y&\u00031\u0001\u0002\"\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005\u0005\u0003CBA\u0007\u0003\u0007\n9%\u0003\u0003\u0002F\u0005u!aA*fcB!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002NA\nQ\u0001^=qKNLA!!\u0015\u0002L\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u0003/\u0002B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;r\u0013\u0001C1oC2L8/[:\n\t\u0005\u0005\u00141\f\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002hA!\u0011\u0011JA5\u0013\u0011\tY'a\u0013\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0002I\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005U\u0004\u0003BA<\u0003\u007frA!!\u001f\u0002|A\u0019\u0011\u0011C \n\u0007\u0005ut(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\u000b\u0019I\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003{z\u0014\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGCCAE\u0003\u001f\u000b\u0019*!&\u0002\u0018B\u0019a(a#\n\u0007\u00055uHA\u0002B]fDq!!%\u0019\u0001\u0004\tI)A\u0003j]B,H\u000f\u0003\u0004\\1\u0001\u0007\u0011\u0011\u0012\u0005\u0007;b\u0001\r!!#\t\r}C\u0002\u0019AAE\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u001e\u0006%\u00161\u0017\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*\u0019\u00111\u0015\u0017\u0002\u000f\r|G-Z4f]&!\u0011qUAQ\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBAV3\u0001\u0007\u0011QV\u0001\u0004GRD\b\u0003BAP\u0003_KA!!-\u0002\"\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA[3\u0001\u0007\u0011QT\u0001\u0003KZ\fQAZ5sgR\faa]3d_:$\u0017!\u0002;iSJ$\u0017A\u00024pkJ$\b.A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYRI1/a1\u0002F\u0006\u001d\u0017\u0011\u001a\u0005\b\u0003os\u0002\u0019AA\u0011\u0011\u001d\tIL\ba\u0001\u0003CAq!a/\u001f\u0001\u0004\t\t\u0003C\u0004\u0002>z\u0001\r!!\t\u0002\t\r|\u0007/\u001f\u000b\ng\u0006=\u0017\u0011[Aj\u0003+D\u0001BV\u0010\u0011\u0002\u0003\u0007\u0011\u0011\u0005\u0005\n\u0003Sy\u0002\u0013!a\u0001\u0003CA\u0011\"!\f !\u0003\u0005\r!!\t\t\u0011}{\u0002\u0013!a\u0001\u0003C\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\\*\"\u0011\u0011EAoW\t\ty\u000e\u0005\u0003\u0002b\u0006-XBAAr\u0015\u0011\t)/a:\u0002\u0013Ut7\r[3dW\u0016$'bAAu\u007f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00181\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA}!\r\u0001\u00161`\u0005\u0004\u0003\u0003\u000b\u0016\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0001!\rq$1A\u0005\u0004\u0005\u000by$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAE\u0005\u0017A\u0011B!\u0004'\u0003\u0003\u0005\rA!\u0001\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\u0019\u0002\u0005\u0004\u0003\u0016\tm\u0011\u0011R\u0007\u0003\u0005/Q1A!\u0007@\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005;\u00119B\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00013\u0003$!I!Q\u0002\u0015\u0002\u0002\u0003\u0007\u0011\u0011R\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002z\n%\u0002\"\u0003B\u0007S\u0005\u0005\t\u0019\u0001B\u0001\u0003\u0019)\u0017/^1mgR\u0019AMa\f\t\u0013\t5!&!AA\u0002\u0005%\u0005fE\u0005\u00034\te\"1\bB \u0005\u0003\u0012)Ea\u0012\u0003L\t5\u0003c\u0001\u001e\u00036%\u0019!q\u0007\u0017\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!QH\u0001\u0002D*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015wC2,X\r\f\u0011nS:|f/\u00197vK2\u0002S.\u0019=`m\u0006dW/\u001a\u0017!]VlwLY;dW\u0016$\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t2vG.,G\u000f\t8v[\n,'\u000f\t;pA]D\u0017n\u00195\u000bA\u0001\u0002\u0003\u0005\t\u0011am\u0006dW/\u001a1!o>,H\u000e\u001a\u0011cK\u0002\n7o]5h]\u0016$\u0007%\u001b8!C:\u0004S-];jo&$G\u000f\u001b\u0011iSN$xn\u001a:b[\u0002:\u0018\u000e\u001e5!A:,Xn\u00182vG.,G\u000f\u0019\u0011ck\u000e\\W\r^:-\u0015\u0001\u0002\u0003\u0005\t\u0011!S:\u0004C\u000f[3!e\u0006tw-\u001a\u0011a[&twL^1mk\u0016\u0004\u0007\u0005^8!A6\f\u0007p\u0018<bYV,\u0007M\f\u0012\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005\u0007\nAQ\u0014\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)k9\u001aD\u0006\t\u0019/e1\u0002\u0013\u0007\r\u00187Y\u0001*\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00114\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"j#GL\u0019-AEr3\u0007\f\u00114]Qb\u0003eM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006\u000f\u00182Y\u0001\u0002d\u0006\r\u0017!k9:D\u0006\t\u001b*w)\u0001\u0003\u0005\t\u0011!A\u0001*$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00171]eb\u0003%\u000e\u00183Y\u0001\u0002d&\u000e\u0017!e%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)\u0013:#VI\u0015,B\u0019\u0002:\u0003g\n\u0011Z\u000b\u0006\u0013F\u0006I%O)\u0016\u0013f+\u0011'!OA:\u0003%W#B%2\u0002\u0013J\u0014+F%Z\u000bE\nI\u00142a\u001d\u0002\u0013,R!SY\u0001\n\u0004'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013J\u0014+F%Z\u000bE\nI\u00142O\u0001JV)\u0011*-A%sE+\u0012*W\u00032\u0003s\u0005M\u0014!3\u0016\u000b%\u000b\f\u0011J\u001dR+%KV!MA\u001d\n\u0004g\n\u0011Z\u000b\u0006\u0013F\u0006I\u00191SmR\u0001\u0005\t\u0011!A\u0001\u0002#G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015J\u001dR+%KV!MA\u001d\u0002t\u0005\t#B32\u0002\u0013J\u0014+F%Z\u000bE\nI\u00141O\u0001\"\u0015)\u0017\u0017!\u0013:#VI\u0015,B\u0019\u0002:\u0013\u0007M\u0014!\t\u0006KF\u0006I\u00191SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015J\u001dR+%KV!MA\u001d\nt\u0005\t#B32\u0002\u0013J\u0014+F%Z\u000bE\nI\u00141O\u0001\"\u0015)\u0017\u0017!\u0013:#VI\u0015,B\u0019\u0002:\u0013\u0007M\u0014!\t\u0006KF\u0006I\u00191SmR\u0001\u0005\t\u0011!A\u0001\u0002#G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011I%A\u00034]Er\u0003'A\u0003he>,\b/\t\u0002\u0003P\u0005QQ.\u0019;i?\u001a,hnY:\t\rY3\u0001\u0019AA\u0011\u0011\u001d\tIC\u0002a\u0001\u0003CAq!!\f\u0007\u0001\u0004\t\t\u0003\u0003\u0004`\r\u0001\u0007\u0011\u0011E\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iF!\u001b\u0011\u000by\u0012yFa\u0019\n\u0007\t\u0005tH\u0001\u0004PaRLwN\u001c\t\f}\t\u0015\u0014\u0011EA\u0011\u0003C\t\t#C\u0002\u0003h}\u0012a\u0001V;qY\u0016$\u0004\u0002\u0003B6\u000f\u0005\u0005\t\u0019A:\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003rA\u0019\u0001Ka\u001d\n\u0007\tU\u0014K\u0001\u0004PE*,7\r\u001e")
public class WidthBucket
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression value;
    private final Expression minValue;
    private final Expression maxValue;
    private final Expression numBucket;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(WidthBucket x$0) {
        return WidthBucket$.MODULE$.unapply(x$0);
    }

    public static Long computeBucketNumberNotNull(double value, double min, double max, long numBucket) {
        return WidthBucket$.MODULE$.computeBucketNumberNotNull(value, min, max, numBucket);
    }

    public static boolean isNull(double value, double min, double max, long numBucket) {
        return WidthBucket$.MODULE$.isNull(value, min, max, numBucket);
    }

    public static Long computeBucketNumber(double value, double min, double max, long numBucket) {
        return WidthBucket$.MODULE$.computeBucketNumber(value, min, max, numBucket);
    }

    public Expression value() {
        return this.value;
    }

    public Expression minValue() {
        return this.minValue;
    }

    public Expression maxValue() {
        return this.maxValue;
    }

    public Expression numBucket() {
        return this.numBucket;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), LongType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        TypeCheckResult typeCheckResult2 = ExpectsInputTypes.checkInputDataTypes$(this);
        if (TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult2)) {
            TypeCheckResult typeCheckResult3;
            Tuple3 tuple3 = new Tuple3((Object)this.value().dataType(), (Object)this.minValue().dataType(), (Object)this.maxValue().dataType());
            if (tuple3 != null && tuple3._1() instanceof YearMonthIntervalType && tuple3._2() instanceof YearMonthIntervalType && tuple3._3() instanceof YearMonthIntervalType) {
                typeCheckResult3 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            } else if (tuple3 != null && tuple3._1() instanceof DayTimeIntervalType && tuple3._2() instanceof DayTimeIntervalType && tuple3._3() instanceof DayTimeIntervalType) {
                typeCheckResult3 = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            } else {
                Seq types = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataType[]{this.value().dataType(), this.minValue().dataType(), this.maxValue().dataType()}));
                typeCheckResult3 = TypeUtils$.MODULE$.checkForSameTypeInputExpr((Seq<DataType>)types, new StringBuilder(9).append("function ").append(this.prettyName()).toString());
            }
            typeCheckResult = typeCheckResult3;
        } else {
            typeCheckResult = typeCheckResult2;
        }
        return typeCheckResult;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "width_bucket";
    }

    @Override
    public Object nullSafeEval(Object input, Object min, Object max, Object numBucket) {
        return WidthBucket$.MODULE$.computeBucketNumber(((Number)input).doubleValue(), ((Number)min).doubleValue(), ((Number)max).doubleValue(), BoxesRunTime.unboxToLong((Object)numBucket));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable)(input, min, max, numBucket) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(236).append(ev.isNull()).append(" = org.apache.spark.sql.catalyst.expressions.WidthBucket\n         |  .isNull(").append((String)input).append(", ").append((String)min).append(", ").append((String)max).append(", ").append((String)numBucket).append(");\n         |if (!").append(ev.isNull()).append(") {\n         |  ").append(ev.value()).append(" = org.apache.spark.sql.catalyst.expressions.WidthBucket\n         |    .computeBucketNumberNotNull(").append((String)input).append(", ").append((String)min).append(", ").append((String)max).append(", ").append((String)numBucket).append(");\n         |}").toString())));
    }

    @Override
    public Expression first() {
        return this.value();
    }

    @Override
    public Expression second() {
        return this.minValue();
    }

    @Override
    public Expression third() {
        return this.maxValue();
    }

    @Override
    public Expression fourth() {
        return this.numBucket();
    }

    @Override
    public WidthBucket withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth);
    }

    public WidthBucket copy(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        return new WidthBucket(value, minValue, maxValue, numBucket);
    }

    public Expression copy$default$1() {
        return this.value();
    }

    public Expression copy$default$2() {
        return this.minValue();
    }

    public Expression copy$default$3() {
        return this.maxValue();
    }

    public Expression copy$default$4() {
        return this.numBucket();
    }

    @Override
    public String productPrefix() {
        return "WidthBucket";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.value();
                break;
            }
            case 1: {
                object = this.minValue();
                break;
            }
            case 2: {
                object = this.maxValue();
                break;
            }
            case 3: {
                object = this.numBucket();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WidthBucket;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "value";
                break;
            }
            case 1: {
                string = "minValue";
                break;
            }
            case 2: {
                string = "maxValue";
                break;
            }
            case 3: {
                string = "numBucket";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WidthBucket)) return false;
        boolean bl = true;
        if (!bl) return false;
        WidthBucket widthBucket = (WidthBucket)x$1;
        Expression expression = this.value();
        Expression expression2 = widthBucket.value();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.minValue();
        Expression expression4 = widthBucket.minValue();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.maxValue();
        Expression expression6 = widthBucket.maxValue();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.numBucket();
        Expression expression8 = widthBucket.numBucket();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!widthBucket.canEqual(this)) return false;
        return true;
    }

    public WidthBucket(Expression value, Expression minValue, Expression maxValue, Expression numBucket) {
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.numBucket = numBucket;
        ExpectsInputTypes.$init$(this);
    }
}

