/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is less than or equal to `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1.0 _FUNC_ '1';\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       true\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015a\u0006\u0001\"\u0015^\u0011\u0015)\u0007\u0001\"\u0015g\u0011\u001dY\u0007!!A\u0005\u00021Dqa\u001c\u0001\u0012\u0002\u0013\u0005\u0001\u000fC\u0004|\u0001E\u0005I\u0011\u00019\t\u000fq\u0004\u0011\u0011!C!{\"I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003+\u0001\u0011\u0011!C\u0001\u0003/A\u0011\"!\b\u0001\u0003\u0003%\t%a\b\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0002\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u0011%\ty\u0004AA\u0001\n\u0003\n\teB\u0005\u0002lm\t\t\u0011#\u0001\u0002n\u0019A!dGA\u0001\u0012\u0003\ty\u0007\u0003\u0004N)\u0011\u0005\u0011q\u0011\u0005\n\u0003\u0013#\u0012\u0011!C#\u0003\u0017C\u0011\"!$\u0015\u0003\u0003%\t)a$\t\u0013\u0005UE#!A\u0005\u0002\u0006]\u0005\"CAU)\u0005\u0005I\u0011BAV\u0005=aUm]:UQ\u0006twJ]#rk\u0006d'B\u0001\u000f\u001e\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005yy\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0001\n\u0013aA:rY*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001IS\u0006\u000e\u001e\u0011\u0005)ZS\"A\u000e\n\u00051Z\"\u0001\u0005\"j]\u0006\u0014\u0018pQ8na\u0006\u0014\u0018n]8o!\tq\u0013G\u0004\u0002+_%\u0011\u0001gG\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00114G\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005AZ\u0002CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$a\u0002)s_\u0012,8\r\u001e\t\u0003w\ts!\u0001P!\u000f\u0005u\u0002U\"\u0001 \u000b\u0005}:\u0013A\u0002\u001fs_>$h(C\u00018\u0013\t\u0001d'\u0003\u0002D\t\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001GN\u0001\u0005Y\u00164G/F\u0001H!\tQ\u0003*\u0003\u0002J7\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019q\nU)\u0011\u0005)\u0002\u0001\"B#\u0006\u0001\u00049\u0005\"B&\u0006\u0001\u00049\u0015AB:z[\n|G.F\u0001U!\t)\u0016L\u0004\u0002W/B\u0011QHN\u0005\u00031Z\na\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001LN\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004=\u0006\u001c\u0007CA\u001b`\u0013\t\u0001gGA\u0002B]fDQAY\u0004A\u0002y\u000ba!\u001b8qkR\f\u0004\"\u00023\b\u0001\u0004q\u0016AB5oaV$('A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u0019qiZ5\t\u000b!D\u0001\u0019A$\u0002\u000f9,w\u000fT3gi\")!\u000e\u0003a\u0001\u000f\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLHcA(n]\"9Q)\u0003I\u0001\u0002\u00049\u0005bB&\n!\u0003\u0005\raR\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005\t(FA$sW\u0005\u0019\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003%)hn\u00195fG.,GM\u0003\u0002ym\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005i,(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001\u007f!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005!A.\u00198h\u0015\t\t9!\u0001\u0003kCZ\f\u0017b\u0001.\u0002\u0002\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0002\t\u0004k\u0005E\u0011bAA\nm\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019a,!\u0007\t\u0013\u0005ma\"!AA\u0002\u0005=\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\"A)\u00111EA\u0015=6\u0011\u0011Q\u0005\u0006\u0004\u0003O1\u0014AC2pY2,7\r^5p]&!\u00111FA\u0013\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005E\u0012q\u0007\t\u0004k\u0005M\u0012bAA\u001bm\t9!i\\8mK\u0006t\u0007\u0002CA\u000e!\u0005\u0005\t\u0019\u00010\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0004}\u0006u\u0002\"CA\u000e#\u0005\u0005\t\u0019AA\b\u0003\u0019)\u0017/^1mgR!\u0011\u0011GA\"\u0011!\tYBEA\u0001\u0002\u0004q\u0006f\u0006\u0001\u0002H\u00055\u0013qJA*\u0003+\nI&a\u0017\u0002`\u0005\u0005\u0014QMA4!\rQ\u0013\u0011J\u0005\u0004\u0003\u0017Z\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003#\na*\u001a=qeF\u0002sLR+O\u0007~\u0003S\r\u001f9se\u0001j\u0003EU3ukJt7\u000f\t;sk\u0016\u0004\u0013N\u001a\u0011aKb\u0004(/\r1!SN\u0004C.Z:tAQD\u0017M\u001c\u0011pe\u0002*\u0017/^1mAQ|\u0007\u0005Y3yaJ\u0014\u0004ML\u0001\nCJ<W/\\3oiN\f#!a\u0016\u0002\u0005'S\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I3yaJ\fD\u0006I3yaJ\u0014\u0004%\f\u0011uQ\u0016\u0004Co^8!Kb\u0004(/Z:tS>t7\u000fI7vgR\u0004#-\u001a\u0011tC6,\u0007\u0005^=qK\u0002z'\u000fI2b]\u0002\u0012W\rI2bgR,G\r\t;pA\u0005\u00043m\\7n_:\u0004C/\u001f9fY)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I1oI\u0002jWo\u001d;!E\u0016\u0004\u0013\r\t;za\u0016\u0004C\u000f[1uA\r\fg\u000e\t2fA=\u0014H-\u001a:fI:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY\u0001j\u0017\r\u001d\u0011usB,\u0007%[:!]>$\be\u001c:eKJ\f'\r\\3-AM|\u0007%\u001b;\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013n\u001d\u0011o_R\u00043/\u001e9q_J$X\r\u001a\u0018!\r>\u0014\beY8na2,\u0007\u0010\t;za\u0016\u001c\be];dQ\u0002\n'O]1z_M$(/^2uY\u0001\"\b.\u001a\u0011eCR\f\u0007\u0005^=qKN\u0004sN\u001a\u0011gS\u0016dGm\u001d\u0011nkN$(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!E\u0016\u0004sN\u001d3fe\u0006\u0014G.\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003;\n!q\u0014\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!e\u0001zf)\u0016(D?\u0002\u00124H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\r\u00181A}3UKT\"`A\u001d\nte\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t;p?\u0012\fG/\u001a\u0015(eA\u0002\u0014(\f\u00198[M\u0002\u0004\u0005\r\u001b;c]RTGM\u0014*A}3UKT\"`AQ|w\fZ1uK\":#\u0007\r\u0019:[A:Tf\r\u0019!aQR\u0014g\u000e\u001e6e\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006M\u001c.gA\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015!?\u001a+fjQ0!i>|F-\u0019;fQ\u001d\u0012\u0004\u0007M\u001d.aaj\u0003'\r\u00111ii\ntGO\u001b3O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0013\u0007I0G+:\u001bu\f\t(V\u00192[$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002d\u0005)\u0011G\f\u0019/a\u0005)qM]8va\u0006\u0012\u0011\u0011N\u0001\u0010aJ,G-[2bi\u0016|f-\u001e8dg\u0006yA*Z:t)\"\fgn\u0014:FcV\fG\u000e\u0005\u0002+)M)A#!\u001d\u0002~A9\u00111OA=\u000f\u001e{UBAA;\u0015\r\t9HN\u0001\beVtG/[7f\u0013\u0011\tY(!\u001e\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\u0011\t\u0019)!\u0002\u0002\u0005%|\u0017bA\"\u0002\u0002R\u0011\u0011QN\u0001\ti>\u001cFO]5oOR\ta0A\u0003baBd\u0017\u0010F\u0003P\u0003#\u000b\u0019\nC\u0003F/\u0001\u0007q\tC\u0003L/\u0001\u0007q)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0015Q\u0015\t\u0006k\u0005m\u0015qT\u0005\u0004\u0003;3$AB(qi&|g\u000eE\u00036\u0003C;u)C\u0002\u0002$Z\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAT1\u0005\u0005\t\u0019A(\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002.B\u0019q0a,\n\t\u0005E\u0016\u0011\u0001\u0002\u0007\u001f\nTWm\u0019;")
public class LessThanOrEqual
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(LessThanOrEqual x$0) {
        return LessThanOrEqual$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, LessThanOrEqual> tupled() {
        return LessThanOrEqual$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, LessThanOrEqual>> curried() {
        return LessThanOrEqual$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<=";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().lteq(input1, input2));
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public LessThanOrEqual copy(Expression left, Expression right) {
        return new LessThanOrEqual(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "LessThanOrEqual";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LessThanOrEqual;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "left";
                break;
            }
            case 1: {
                string = "right";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LessThanOrEqual)) return false;
        boolean bl = true;
        if (!bl) return false;
        LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)x$1;
        Expression expression = this.left();
        Expression expression2 = lessThanOrEqual.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = lessThanOrEqual.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!lessThanOrEqual.canEqual(this)) return false;
        return true;
    }

    public LessThanOrEqual(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

