/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MakeInterval$;
import org.apache.spark.sql.catalyst.expressions.SeptenaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple8;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([years[, months[, weeks[, days[, hours[, mins[, secs]]]]]]]) - Make interval from years, months, weeks, days, hours, mins and secs.", arguments="\n    Arguments:\n      * years - the number of years, positive or negative\n      * months - the number of months, positive or negative\n      * weeks - the number of weeks, positive or negative\n      * days - the number of days, positive or negative\n      * hours - the number of hours, positive or negative\n      * mins - the number of minutes, positive or negative\n      * secs - the number of seconds with the fractional part in microsecond precision.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(100, 11, 1, 1, 12, 30, 01.001001);\n       100 years 11 months 8 days 12 hours 30 minutes 1.001001 seconds\n      > SELECT _FUNC_(100, null, 3);\n       NULL\n      > SELECT _FUNC_(0, 1, 0, 1, 0, 0, 100.000001);\n       1 months 1 days 1 minutes 40.000001 seconds\n  ", since="3.0.0", group="datetime_funcs")
@ScalaSignature(bytes="\u0006\u0005\tMh\u0001B\u001e=\u0001&C\u0001\"\u001b\u0001\u0003\u0016\u0004%\tA\u001b\u0005\t]\u0002\u0011\t\u0012)A\u0005W\"Aq\u000e\u0001BK\u0002\u0013\u0005!\u000e\u0003\u0005q\u0001\tE\t\u0015!\u0003l\u0011!\t\bA!f\u0001\n\u0003Q\u0007\u0002\u0003:\u0001\u0005#\u0005\u000b\u0011B6\t\u0011M\u0004!Q3A\u0005\u0002)D\u0001\u0002\u001e\u0001\u0003\u0012\u0003\u0006Ia\u001b\u0005\tk\u0002\u0011)\u001a!C\u0001U\"Aa\u000f\u0001B\tB\u0003%1\u000e\u0003\u0005x\u0001\tU\r\u0011\"\u0001k\u0011!A\bA!E!\u0002\u0013Y\u0007\u0002C=\u0001\u0005+\u0007I\u0011\u00016\t\u0011i\u0004!\u0011#Q\u0001\n-D\u0001b\u001f\u0001\u0003\u0016\u0004%\t\u0001 \u0005\n\u0003\u0003\u0001!\u0011#Q\u0001\nuDq!a\u0001\u0001\t\u0003\t)\u0001C\u0004\u0002\u0004\u0001!\t!!\u0007\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002,!9\u00111\u0001\u0001\u0005\u0002\u0005e\u0002bBA\u0002\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003\u0007\u0001A\u0011AA(\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003/Bq!a\u0001\u0001\t\u0003\ti\u0006C\u0004\u0002\u0004\u0001!\t!!\u0019\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002f!9\u0011Q\u000e\u0001\u0005B\u0005=\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\u0007\u0003\u0013\u0003A\u0011\t?\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\"9\u0011Q\u0017\u0001\u0005B\u0005]\u0006bBAj\u0001\u0011\u0005\u0013Q\u001b\u0005\b\u0003O\u0004A\u0011KAu\u0011%\t)\u0010AA\u0001\n\u0003\t9\u0010C\u0005\u0003\n\u0001\t\n\u0011\"\u0001\u0003\f!I!\u0011\u0005\u0001\u0012\u0002\u0013\u0005!1\u0002\u0005\n\u0005G\u0001\u0011\u0013!C\u0001\u0005\u0017A\u0011B!\n\u0001#\u0003%\tAa\u0003\t\u0013\t\u001d\u0002!%A\u0005\u0002\t-\u0001\"\u0003B\u0015\u0001E\u0005I\u0011\u0001B\u0006\u0011%\u0011Y\u0003AI\u0001\n\u0003\u0011Y\u0001C\u0005\u0003.\u0001\t\n\u0011\"\u0001\u00030!I!1\u0007\u0001\u0002\u0002\u0013\u0005#Q\u0007\u0005\n\u0005\u000b\u0002\u0011\u0011!C\u0001\u0005\u000fB\u0011Ba\u0014\u0001\u0003\u0003%\tA!\u0015\t\u0013\t]\u0003!!A\u0005B\te\u0003\"\u0003B4\u0001\u0005\u0005I\u0011\u0001B5\u0011%\u0011i\u0007AA\u0001\n\u0003\u0012y\u0007C\u0005\u0003t\u0001\t\t\u0011\"\u0011\u0003v\u001dI!q\u0014\u001f\u0002\u0002#\u0005!\u0011\u0015\u0004\twq\n\t\u0011#\u0001\u0003$\"9\u00111A\u001a\u0005\u0002\tm\u0006\"\u0003B_g\u0005\u0005IQ\tB`\u0011%\u0011\tmMA\u0001\n\u0003\u0013\u0019\rC\u0005\u0003VN\n\n\u0011\"\u0001\u00030!I!q[\u001a\u0002\u0002\u0013\u0005%\u0011\u001c\u0005\n\u0005O\u001c\u0014\u0013!C\u0001\u0005_A\u0011B!;4\u0003\u0003%IAa;\u0003\u00195\u000b7.Z%oi\u0016\u0014h/\u00197\u000b\u0005ur\u0014aC3yaJ,7o]5p]NT!a\u0010!\u0002\u0011\r\fG/\u00197zgRT!!\u0011\"\u0002\u0007M\fHN\u0003\u0002D\t\u0006)1\u000f]1sW*\u0011QIR\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\u000b1a\u001c:h\u0007\u0001\u0019b\u0001\u0001&O#bs\u0006CA&M\u001b\u0005a\u0014BA'=\u0005M\u0019V\r\u001d;f]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tYu*\u0003\u0002Qy\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002S+:\u00111jU\u0005\u0003)r\nq\u0001]1dW\u0006<W-\u0003\u0002W/\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(B\u0001+=!\tIF,D\u0001[\u0015\u0005Y\u0016!B:dC2\f\u0017BA/[\u0005\u001d\u0001&o\u001c3vGR\u0004\"a\u00184\u000f\u0005\u0001,gBA1e\u001b\u0005\u0011'BA2I\u0003\u0019a$o\\8u}%\t1,\u0003\u0002U5&\u0011q\r\u001b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003)j\u000bQ!_3beN,\u0012a\u001b\t\u0003\u00172L!!\u001c\u001f\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004zK\u0006\u00148\u000fI\u0001\u0007[>tG\u000f[:\u0002\u000f5|g\u000e\u001e5tA\u0005)q/Z3lg\u00061q/Z3lg\u0002\nA\u0001Z1zg\u0006)A-Y=tA\u0005)\u0001n\\;sg\u00061\u0001n\\;sg\u0002\nA!\\5og\u0006)Q.\u001b8tA\u0005!1/Z2t\u0003\u0015\u0019XmY:!\u0003-1\u0017-\u001b7P]\u0016\u0013(o\u001c:\u0016\u0003u\u0004\"!\u0017@\n\u0005}T&a\u0002\"p_2,\u0017M\\\u0001\rM\u0006LGn\u00148FeJ|'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015%\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0011q\u0003\t\u0003\u0017\u0002AQ![\tA\u0002-DQa\\\tA\u0002-DQ!]\tA\u0002-DQa]\tA\u0002-DQ!^\tA\u0002-DQa^\tA\u0002-DQ!_\tA\u0002-Dqa_\t\u0011\u0002\u0003\u0007Q\u0010\u0006\t\u0002\b\u0005m\u0011QDA\u0010\u0003C\t\u0019#!\n\u0002(!)\u0011N\u0005a\u0001W\")qN\u0005a\u0001W\")\u0011O\u0005a\u0001W\")1O\u0005a\u0001W\")QO\u0005a\u0001W\")qO\u0005a\u0001W\"1\u0011\u0011\u0006\nA\u0002-\f1a]3d)9\t9!!\f\u00020\u0005E\u00121GA\u001b\u0003oAQ![\nA\u0002-DQa\\\nA\u0002-DQ!]\nA\u0002-DQa]\nA\u0002-DQ!^\nA\u0002-DQa^\nA\u0002-$B\"a\u0002\u0002<\u0005u\u0012qHA!\u0003\u0007BQ!\u001b\u000bA\u0002-DQa\u001c\u000bA\u0002-DQ!\u001d\u000bA\u0002-DQa\u001d\u000bA\u0002-DQ!\u001e\u000bA\u0002-$\"\"a\u0002\u0002H\u0005%\u00131JA'\u0011\u0015IW\u00031\u0001l\u0011\u0015yW\u00031\u0001l\u0011\u0015\tX\u00031\u0001l\u0011\u0015\u0019X\u00031\u0001l)!\t9!!\u0015\u0002T\u0005U\u0003\"B5\u0017\u0001\u0004Y\u0007\"B8\u0017\u0001\u0004Y\u0007\"B9\u0017\u0001\u0004YGCBA\u0004\u00033\nY\u0006C\u0003j/\u0001\u00071\u000eC\u0003p/\u0001\u00071\u000e\u0006\u0003\u0002\b\u0005}\u0003\"B5\u0019\u0001\u0004YGCAA\u0004\u0003!\u0019\u0007.\u001b7ee\u0016tWCAA4!\u0011y\u0016\u0011N6\n\u0007\u0005-\u0004NA\u0002TKF\f!\"\u001b8qkR$\u0016\u0010]3t+\t\t\t\bE\u0003`\u0003S\n\u0019\b\u0005\u0003\u0002v\u0005mTBAA<\u0015\r\tI\bQ\u0001\u0006if\u0004Xm]\u0005\u0005\u0003{\n9H\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u0004B!\u0011QOAC\u0013\u0011\t9)a\u001e\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0011\u0003\u001f\u000b)*!'\u0002\u001e\u0006\u0005\u0016QUAU\u0003[\u00032!WAI\u0013\r\t\u0019J\u0017\u0002\u0004\u0003:L\bbBAL=\u0001\u0007\u0011qR\u0001\u0005s\u0016\f'\u000fC\u0004\u0002\u001cz\u0001\r!a$\u0002\u000b5|g\u000e\u001e5\t\u000f\u0005}e\u00041\u0001\u0002\u0010\u0006!q/Z3l\u0011\u001d\t\u0019K\ba\u0001\u0003\u001f\u000b1\u0001Z1z\u0011\u001d\t9K\ba\u0001\u0003\u001f\u000bA\u0001[8ve\"9\u00111\u0016\u0010A\u0002\u0005=\u0015aA7j]\"9\u0011\u0011\u0006\u0010A\u0002\u0005=\u0006#B-\u00022\u0006=\u0015bAAZ5\n1q\n\u001d;j_:\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005e\u0016QYAh!\u0011\tY,!1\u000e\u0005\u0005u&bAA`y\u000591m\u001c3fO\u0016t\u0017\u0002BAb\u0003{\u0013\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003\u000f|\u0002\u0019AAe\u0003\r\u0019G\u000f\u001f\t\u0005\u0003w\u000bY-\u0003\u0003\u0002N\u0006u&AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003#|\u0002\u0019AA]\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a6\u0011\t\u0005e\u0017\u0011\u001d\b\u0005\u00037\fi\u000e\u0005\u0002b5&\u0019\u0011q\u001c.\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019/!:\u0003\rM#(/\u001b8h\u0015\r\tyNW\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$B!a\u0002\u0002l\"9\u0011Q^\u0011A\u0002\u0005=\u0018a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004BaXAyW&\u0019\u00111\u001f5\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0003d_BLHCEA\u0004\u0003s\fY0!@\u0002\u0000\n\u0005!1\u0001B\u0003\u0005\u000fAq!\u001b\u0012\u0011\u0002\u0003\u00071\u000eC\u0004pEA\u0005\t\u0019A6\t\u000fE\u0014\u0003\u0013!a\u0001W\"91O\tI\u0001\u0002\u0004Y\u0007bB;#!\u0003\u0005\ra\u001b\u0005\bo\n\u0002\n\u00111\u0001l\u0011\u001dI(\u0005%AA\u0002-Dqa\u001f\u0012\u0011\u0002\u0003\u0007Q0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t5!fA6\u0003\u0010-\u0012!\u0011\u0003\t\u0005\u0005'\u0011i\"\u0004\u0002\u0003\u0016)!!q\u0003B\r\u0003%)hn\u00195fG.,GMC\u0002\u0003\u001ci\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yB!\u0006\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014AD2paf$C-\u001a4bk2$H%N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]\nabY8qs\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u00032)\u001aQPa\u0004\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00119\u0004\u0005\u0003\u0003:\t\rSB\u0001B\u001e\u0015\u0011\u0011iDa\u0010\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0003\nAA[1wC&!\u00111\u001dB\u001e\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011I\u0005E\u0002Z\u0005\u0017J1A!\u0014[\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tyIa\u0015\t\u0013\tUS&!AA\u0002\t%\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\\A1!Q\fB2\u0003\u001fk!Aa\u0018\u000b\u0007\t\u0005$,\u0001\u0006d_2dWm\u0019;j_:LAA!\u001a\u0003`\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ri(1\u000e\u0005\n\u0005+z\u0013\u0011!a\u0001\u0003\u001f\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!q\u0007B9\u0011%\u0011)\u0006MA\u0001\u0002\u0004\u0011I%\u0001\u0004fcV\fGn\u001d\u000b\u0004{\n]\u0004\"\u0003B+c\u0005\u0005\t\u0019AAHQ]\u0001!1\u0010BA\u0005\u0007\u00139I!#\u0003\u000e\n=%1\u0013BK\u00053\u0013Y\nE\u0002L\u0005{J1Aa =\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#A!\"\u0002\u0003+yf)\u0016(D?\"Z\u00160Z1sgnc\u0003%\\8oi\"\u001c8\f\f\u0011xK\u0016\\7o\u0017\u0017!I\u0006L8o\u0017\u0017!Q>,(o].-A5Lgn].-AM,7m]/^;vkV,X\u0015![\u0001j\u0015m[3!S:$XM\u001d<bY\u00022'o\\7!s\u0016\f'o\u001d\u0017![>tG\u000f[:-A],Wm[:-A\u0011\f\u0017p\u001d\u0017!Q>,(o\u001d\u0017![&t7\u000fI1oI\u0002\u001aXmY:/\u0003%\t'oZ;nK:$8/\t\u0002\u0003\f\u0006\u0019yI\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!s\u0016\f'o\u001d\u0011.AQDW\r\t8v[\n,'\u000fI8gAe,\u0017M]:-AA|7/\u001b;jm\u0016\u0004sN\u001d\u0011oK\u001e\fG/\u001b<f\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001jwN\u001c;ig\u0002j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007%\\8oi\"\u001cH\u0006\t9pg&$\u0018N^3!_J\u0004c.Z4bi&4XM\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011xK\u0016\\7\u000fI\u0017!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!o\u0016,7n\u001d\u0017!a>\u001c\u0018\u000e^5wK\u0002z'\u000f\t8fO\u0006$\u0018N^3\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0011\f\u0017p\u001d\u0011.AQDW\r\t8v[\n,'\u000fI8gA\u0011\f\u0017p\u001d\u0017!a>\u001c\u0018\u000e^5wK\u0002z'\u000f\t8fO\u0006$\u0018N^3\u000bA\u0001\u0002\u0003\u0005\t\u0011+A!|WO]:![\u0001\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002Bw.\u001e:tY\u0001\u0002xn]5uSZ,\u0007e\u001c:!]\u0016<\u0017\r^5wK*\u0001\u0003\u0005\t\u0011!A)\u0002S.\u001b8tA5\u0002C\u000f[3!]Vl'-\u001a:!_\u001a\u0004S.\u001b8vi\u0016\u001cH\u0006\t9pg&$\u0018N^3!_J\u0004c.Z4bi&4XM\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tK\u000e\u001c\b%\f\u0011uQ\u0016\u0004c.^7cKJ\u0004sN\u001a\u0011tK\u000e|g\u000eZ:!o&$\b\u000e\t;iK\u00022'/Y2uS>t\u0017\r\u001c\u0011qCJ$\b%\u001b8![&\u001c'o\\:fG>tG\r\t9sK\u000eL7/[8o])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011\t*\u0001B+\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n\u0004\u0007\r\u0017!cEb\u0003%\r\u0017!c1\u0002\u0013G\r\u0017!gAb\u0003\u0005M\u0019/aA\n\u0004\u0007M\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0004\u0007\r\u0011zK\u0006\u00148\u000fI\u00192A5|g\u000e\u001e5tAa\u0002C-Y=tAE\u0012\u0004\u0005[8veN\u00043\u0007\r\u0011nS:,H/Z:!c9\u0002\u0004'\r\u00191c\u0001\u001aXmY8oINT\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u00191Y\u0001rW\u000f\u001c7-AMJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006\r\u0017!c1\u0002\u0003\u0007\f\u00112Y\u0001\u0002D\u0006\t\u0019-AE\u0002\u0004G\f\u00191aA\u0002\u0014'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c\u0001jwN\u001c;ig\u0002\n\u0004\u0005Z1zg\u0002\n\u0004%\\5okR,7\u000f\t\u001b1]A\u0002\u0004\u0007\r\u00192AM,7m\u001c8eg*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003\u0018\u0006)1G\f\u0019/a\u0005)qM]8va\u0006\u0012!QT\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u00031i\u0015m[3J]R,'O^1m!\tY5gE\u00034\u0005K\u0013\t\f\u0005\b\u0003(\n56n[6lW.\\W0a\u0002\u000e\u0005\t%&b\u0001BV5\u00069!/\u001e8uS6,\u0017\u0002\u0002BX\u0005S\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c89!\u0011\u0011\u0019L!/\u000e\u0005\tU&\u0002\u0002B\\\u0005\u007f\t!![8\n\u0007\u001d\u0014)\f\u0006\u0002\u0003\"\u0006AAo\\*ue&tw\r\u0006\u0002\u00038\u0005)\u0011\r\u001d9msR\u0011\u0012q\u0001Bc\u0005\u000f\u0014IMa3\u0003N\n='\u0011\u001bBj\u0011\u0015Ig\u00071\u0001l\u0011\u0015yg\u00071\u0001l\u0011\u0015\th\u00071\u0001l\u0011\u0015\u0019h\u00071\u0001l\u0011\u0015)h\u00071\u0001l\u0011\u00159h\u00071\u0001l\u0011\u0015Ih\u00071\u0001l\u0011\u001dYh\u0007%AA\u0002u\fq\"\u00199qYf$C-\u001a4bk2$H\u0005O\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YNa9\u0011\u000be\u000b\tL!8\u0011\u0017e\u0013yn[6lW.\\7.`\u0005\u0004\u0005CT&A\u0002+va2,\u0007\bC\u0005\u0003fb\n\t\u00111\u0001\u0002\b\u0005\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011i\u000f\u0005\u0003\u0003:\t=\u0018\u0002\u0002By\u0005w\u0011aa\u00142kK\u000e$\b")
public class MakeInterval
extends SeptenaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression years;
    private final Expression months;
    private final Expression weeks;
    private final Expression days;
    private final Expression hours;
    private final Expression mins;
    private final Expression secs;
    private final boolean failOnError;

    public static boolean $lessinit$greater$default$8() {
        return MakeInterval$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Tuple8<Expression, Expression, Expression, Expression, Expression, Expression, Expression, Object>> unapply(MakeInterval x$0) {
        return MakeInterval$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$8() {
        return MakeInterval$.MODULE$.apply$default$8();
    }

    public static Function1<Tuple8<Expression, Expression, Expression, Expression, Expression, Expression, Expression, Object>, MakeInterval> tupled() {
        return MakeInterval$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, MakeInterval>>>>>>>> curried() {
        return MakeInterval$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression years() {
        return this.years;
    }

    public Expression months() {
        return this.months;
    }

    public Expression weeks() {
        return this.weeks;
    }

    public Expression days() {
        return this.days;
    }

    public Expression hours() {
        return this.hours;
    }

    public Expression mins() {
        return this.mins;
    }

    public Expression secs() {
        return this.secs;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.years(), this.months(), this.weeks(), this.days(), this.hours(), this.mins(), this.secs()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NumericType[]{IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, IntegerType$.MODULE$, new DecimalType(Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)}));
    }

    @Override
    public DataType dataType() {
        return CalendarIntervalType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return this.failOnError() ? this.children().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nullable())) : true;
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object week, Object day, Object hour, Object min, Option<Object> sec) {
        CalendarInterval calendarInterval;
        try {
            calendarInterval = IntervalUtils$.MODULE$.makeInterval(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)week), BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec.map((Function1 & Serializable)x$2 -> (Decimal)x$2).getOrElse((Function0 & Serializable)() -> Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)));
        }
        catch (ArithmeticException e) {
            if (this.failOnError()) {
                throw QueryExecutionErrors$.MODULE$.arithmeticOverflowError(e.getMessage(), QueryExecutionErrors$.MODULE$.arithmeticOverflowError$default$2(), QueryExecutionErrors$.MODULE$.arithmeticOverflowError$default$3());
            }
            calendarInterval = null;
        }
        return calendarInterval;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function7<String, String, String, String, String, String, Option<String>, String>)(Function7 & Serializable)(year, month, week, day, hour, min, sec) -> {
            String iu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getName()), "$");
            String secFrac = (String)sec.getOrElse((Function0 & Serializable)() -> "0");
            String failOnErrorBranch = this.failOnError() ? "throw QueryExecutionErrors.arithmeticOverflowError(e);" : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
            return new StringBuilder(136).append("\n        try {\n          ").append(ev.value()).append(" = ").append(iu).append(".makeInterval(").append((String)year).append(", ").append((String)month).append(", ").append((String)week).append(", ").append((String)day).append(", ").append((String)hour).append(", ").append((String)min).append(", ").append(secFrac).append(");\n        } catch (java.lang.ArithmeticException e) {\n          ").append(failOnErrorBranch).append("\n        }\n      ").toString();
        });
    }

    @Override
    public String prettyName() {
        return "make_interval";
    }

    @Override
    public MakeInterval withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4), (Expression)newChildren.apply(5), (Expression)newChildren.apply(6), this.copy$default$8());
    }

    public MakeInterval copy(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression secs, boolean failOnError) {
        return new MakeInterval(years, months, weeks, days, hours, mins, secs, failOnError);
    }

    public Expression copy$default$1() {
        return this.years();
    }

    public Expression copy$default$2() {
        return this.months();
    }

    public Expression copy$default$3() {
        return this.weeks();
    }

    public Expression copy$default$4() {
        return this.days();
    }

    public Expression copy$default$5() {
        return this.hours();
    }

    public Expression copy$default$6() {
        return this.mins();
    }

    public Expression copy$default$7() {
        return this.secs();
    }

    public boolean copy$default$8() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeInterval";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.years();
                break;
            }
            case 1: {
                object = this.months();
                break;
            }
            case 2: {
                object = this.weeks();
                break;
            }
            case 3: {
                object = this.days();
                break;
            }
            case 4: {
                object = this.hours();
                break;
            }
            case 5: {
                object = this.mins();
                break;
            }
            case 6: {
                object = this.secs();
                break;
            }
            case 7: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeInterval;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "years";
                break;
            }
            case 1: {
                string = "months";
                break;
            }
            case 2: {
                string = "weeks";
                break;
            }
            case 3: {
                string = "days";
                break;
            }
            case 4: {
                string = "hours";
                break;
            }
            case 5: {
                string = "mins";
                break;
            }
            case 6: {
                string = "secs";
                break;
            }
            case 7: {
                string = "failOnError";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeInterval)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeInterval makeInterval = (MakeInterval)x$1;
        if (this.failOnError() != makeInterval.failOnError()) return false;
        Expression expression = this.years();
        Expression expression2 = makeInterval.years();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.months();
        Expression expression4 = makeInterval.months();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.weeks();
        Expression expression6 = makeInterval.weeks();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.days();
        Expression expression8 = makeInterval.days();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.hours();
        Expression expression10 = makeInterval.hours();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.mins();
        Expression expression12 = makeInterval.mins();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Expression expression13 = this.secs();
        Expression expression14 = makeInterval.secs();
        if (expression13 == null) {
            if (expression14 != null) {
                return false;
            }
        } else if (!expression13.equals(expression14)) return false;
        if (!makeInterval.canEqual(this)) return false;
        return true;
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression secs, boolean failOnError) {
        this.years = years;
        this.months = months;
        this.weeks = weeks;
        this.days = days;
        this.hours = hours;
        this.mins = mins;
        this.secs = secs;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins, Expression sec) {
        this(years, months, weeks, days, hours, mins, sec, SQLConf$.MODULE$.get().ansiEnabled());
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours, Expression mins) {
        this(years, months, weeks, days, hours, mins, Literal$.MODULE$.apply(Decimal$.MODULE$.apply(0L, Decimal$.MODULE$.MAX_LONG_DIGITS(), 6)), SQLConf$.MODULE$.get().ansiEnabled());
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days, Expression hours) {
        this(years, months, weeks, days, hours, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months, Expression weeks, Expression days) {
        this(years, months, weeks, days, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months, Expression weeks) {
        this(years, months, weeks, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years, Expression months) {
        this(years, months, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval(Expression years) {
        this(years, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }

    public MakeInterval() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0)));
    }
}

