/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.fpm;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.Params$class;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Identifiable$class;
import org.apache.spark.mllib.fpm.PrefixSpan;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\u0001\u0003\u00055\u0011!\u0002\u0015:fM&D8\u000b]1o\u0015\t\u0019A!A\u0002ga6T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)\u0002$D\u0001\u0017\u0015\t9B!A\u0003qCJ\fW.\u0003\u0002\u001a-\t1\u0001+\u0019:b[ND\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0005H\u0001\u0004k&$W#A\u000f\u0011\u0005y\tcBA\b \u0013\t\u0001\u0003#\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\r\u0012aa\u0015;sS:<'B\u0001\u0011\u0011Q\rQRe\u000b\t\u0003M%j\u0011a\n\u0006\u0003Q\u0019\t!\"\u00198o_R\fG/[8o\u0013\tQsEA\u0003TS:\u001cW-I\u0001-\u0003\u0015\u0011d\u0006\u000e\u00181\u0011!q\u0003A!A!\u0002\u0013i\u0012\u0001B;jI\u0002B3!L\u0013,\u0011\u0015\t\u0004\u0001\"\u00013\u0003\u0019a\u0014N\\5u}Q\u00111'\u000e\t\u0003i\u0001i\u0011A\u0001\u0005\u00067A\u0002\r!\b\u0015\u0004k\u0015Z\u0003\"B\u0019\u0001\t\u0003AD#A\u001a)\u0007]*3\u0006C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\u0002\u00155LgnU;qa>\u0014H/F\u0001>!\t)b(\u0003\u0002@-\tYAi\\;cY\u0016\u0004\u0016M]1nQ\rQTe\u000b\u0005\u0007\u0005\u0002\u0001\u000b\u0011B\u001f\u0002\u00175LgnU;qa>\u0014H\u000f\t\u0015\u0004\u0003\u0016Z\u0003\"B#\u0001\t\u00031\u0015!D4fi6KgnU;qa>\u0014H/F\u0001H!\ty\u0001*\u0003\u0002J!\t1Ai\\;cY\u0016D3\u0001R\u0013,\u0011\u0015a\u0005\u0001\"\u0001N\u00035\u0019X\r^'j]N+\b\u000f]8siR\u0011ajT\u0007\u0002\u0001!)\u0001k\u0013a\u0001\u000f\u0006)a/\u00197vK\"\u001a1*J\u0016\t\u000fM\u0003!\u0019!C\u0001)\u0006\u0001R.\u0019=QCR$XM\u001d8MK:<G\u000f[\u000b\u0002+B\u0011QCV\u0005\u0003/Z\u0011\u0001\"\u00138u!\u0006\u0014\u0018-\u001c\u0015\u0004%\u0016Z\u0003B\u0002.\u0001A\u0003%Q+A\tnCb\u0004\u0016\r\u001e;fe:dUM\\4uQ\u0002B3!W\u0013,\u0011\u0015i\u0006\u0001\"\u0001_\u0003M9W\r^'bqB\u000bG\u000f^3s]2+gn\u001a;i+\u0005y\u0006CA\ba\u0013\t\t\u0007CA\u0002J]RD3\u0001X\u0013,\u0011\u0015!\u0007\u0001\"\u0001f\u0003M\u0019X\r^'bqB\u000bG\u000f^3s]2+gn\u001a;i)\tqe\rC\u0003QG\u0002\u0007q\fK\u0002dK-Bq!\u001b\u0001C\u0002\u0013\u0005!.\u0001\nnCbdunY1m!J|'\u000e\u0012\"TSj,W#A6\u0011\u0005Ua\u0017BA7\u0017\u0005%auN\\4QCJ\fW\u000eK\u0002iK-Ba\u0001\u001d\u0001!\u0002\u0013Y\u0017aE7bq2{7-\u00197Qe>TGIQ*ju\u0016\u0004\u0003fA8&W!)1\u000f\u0001C\u0001i\u0006)r-\u001a;NCbdunY1m!J|'\u000e\u0012\"TSj,W#A;\u0011\u0005=1\u0018BA<\u0011\u0005\u0011auN\\4)\u0007I,3\u0006C\u0003{\u0001\u0011\u000510A\u000btKRl\u0015\r\u001f'pG\u0006d\u0007K]8k\t\n\u001b\u0016N_3\u0015\u00059c\b\"\u0002)z\u0001\u0004)\bfA=&W!Aq\u0010\u0001b\u0001\n\u0003\t\t!A\u0006tKF,XM\\2f\u0007>dWCAA\u0002!\u0011)\u0012QA\u000f\n\u0007\u0005\u001daCA\u0003QCJ\fW\u000eK\u0002\u007fK-B\u0001\"!\u0004\u0001A\u0003%\u00111A\u0001\rg\u0016\fX/\u001a8dK\u000e{G\u000e\t\u0015\u0005\u0003\u0017)3\u0006\u0003\u0004\u0002\u0014\u0001!\t\u0001H\u0001\u000fO\u0016$8+Z9vK:\u001cWmQ8mQ\u0011\t\t\"J\u0016\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c\u0005q1/\u001a;TKF,XM\\2f\u0007>dGc\u0001(\u0002\u001e!1\u0001+a\u0006A\u0002uAC!a\u0006&W!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012A\b4j]\u00124%/Z9vK:$8+Z9vK:$\u0018.\u00197QCR$XM\u001d8t)\u0011\t9#a\u0014\u0011\t\u0005%\u0012\u0011\n\b\u0005\u0003W\t\u0019E\u0004\u0003\u0002.\u0005}b\u0002BA\u0018\u0003{qA!!\r\u0002<9!\u00111GA\u001d\u001b\t\t)DC\u0002\u000281\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\r\t\tEB\u0001\u0004gFd\u0017\u0002BA#\u0003\u000f\nq\u0001]1dW\u0006<WMC\u0002\u0002B\u0019IA!a\u0013\u0002N\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0005\u0003\u000b\n9\u0005\u0003\u0005\u0002R\u0005\u0005\u0002\u0019AA*\u0003\u001d!\u0017\r^1tKR\u0004D!!\u0016\u0002bA1\u0011qKA-\u0003;j!!a\u0012\n\t\u0005m\u0013q\t\u0002\b\t\u0006$\u0018m]3u!\u0011\ty&!\u0019\r\u0001\u0011a\u00111MA(\u0003\u0003\u0005\tQ!\u0001\u0002f\t\u0019q\fJ\u0019\u0012\t\u0005\u001d\u0014Q\u000e\t\u0004\u001f\u0005%\u0014bAA6!\t9aj\u001c;iS:<\u0007cA\b\u0002p%\u0019\u0011\u0011\u000f\t\u0003\u0007\u0005s\u0017\u0010\u000b\u0003\u0002\"\u0015Z\u0003bBA<\u0001\u0011\u0005\u0013\u0011P\u0001\u0005G>\u0004\u0018\u0010F\u00024\u0003wB\u0001\"! \u0002v\u0001\u0007\u0011qP\u0001\u0006Kb$(/\u0019\t\u0004+\u0005\u0005\u0015bAAB-\tA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0003\u0002v\u0015Z\u0003f\u0001\u0001\u0002\nB\u0019a%a#\n\u0007\u00055uE\u0001\u0007FqB,'/[7f]R\fG\u000eK\u0002\u0001K-\u0002")
public final class PrefixSpan
implements Params {
    private final String uid;
    private final DoubleParam minSupport;
    private final IntParam maxPatternLength;
    private final LongParam maxLocalProjDBSize;
    private final Param<String> sequenceCol;
    private final Param<?>[] params;
    private final ParamMap paramMap;
    private final ParamMap defaultParamMap;
    private volatile boolean bitmap$0;

    private Param[] params$lzycompute() {
        PrefixSpan prefixSpan = this;
        synchronized (prefixSpan) {
            if (!this.bitmap$0) {
                this.params = Params$class.params(this);
                this.bitmap$0 = true;
            }
            return this.params;
        }
    }

    @Override
    public Param<?>[] params() {
        return this.bitmap$0 ? this.params : this.params$lzycompute();
    }

    @Override
    public ParamMap paramMap() {
        return this.paramMap;
    }

    @Override
    public ParamMap defaultParamMap() {
        return this.defaultParamMap;
    }

    @Override
    public void org$apache$spark$ml$param$Params$_setter_$paramMap_$eq(ParamMap x$1) {
        this.paramMap = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$Params$_setter_$defaultParamMap_$eq(ParamMap x$1) {
        this.defaultParamMap = x$1;
    }

    @Override
    public String explainParam(Param<?> param) {
        return Params$class.explainParam(this, param);
    }

    @Override
    public String explainParams() {
        return Params$class.explainParams(this);
    }

    @Override
    public final boolean isSet(Param<?> param) {
        return Params$class.isSet(this, param);
    }

    @Override
    public final boolean isDefined(Param<?> param) {
        return Params$class.isDefined(this, param);
    }

    @Override
    public boolean hasParam(String paramName) {
        return Params$class.hasParam(this, paramName);
    }

    @Override
    public Param<Object> getParam(String paramName) {
        return Params$class.getParam(this, paramName);
    }

    @Override
    public final <T> Params set(Param<T> param, T value) {
        return Params$class.set((Params)this, param, value);
    }

    @Override
    public final Params set(String param, Object value) {
        return Params$class.set((Params)this, param, value);
    }

    @Override
    public final Params set(ParamPair<?> paramPair) {
        return Params$class.set(this, paramPair);
    }

    @Override
    public final <T> Option<T> get(Param<T> param) {
        return Params$class.get(this, param);
    }

    @Override
    public final Params clear(Param<?> param) {
        return Params$class.clear(this, param);
    }

    @Override
    public final <T> T getOrDefault(Param<T> param) {
        return (T)Params$class.getOrDefault(this, param);
    }

    @Override
    public final <T> T $(Param<T> param) {
        return (T)Params$class.$(this, param);
    }

    @Override
    public final <T> Params setDefault(Param<T> param, T value) {
        return Params$class.setDefault(this, param, value);
    }

    @Override
    public final Params setDefault(Seq<ParamPair<?>> paramPairs) {
        return Params$class.setDefault(this, paramPairs);
    }

    @Override
    public final <T> Option<T> getDefault(Param<T> param) {
        return Params$class.getDefault(this, param);
    }

    @Override
    public final <T> boolean hasDefault(Param<T> param) {
        return Params$class.hasDefault(this, param);
    }

    @Override
    public final <T extends Params> T defaultCopy(ParamMap extra) {
        return (T)Params$class.defaultCopy(this, extra);
    }

    @Override
    public final ParamMap extractParamMap(ParamMap extra) {
        return Params$class.extractParamMap(this, extra);
    }

    @Override
    public final ParamMap extractParamMap() {
        return Params$class.extractParamMap(this);
    }

    @Override
    public <T extends Params> T copyValues(T to, ParamMap extra) {
        return (T)Params$class.copyValues(this, to, extra);
    }

    @Override
    public <T extends Params> ParamMap copyValues$default$2() {
        return Params$class.copyValues$default$2(this);
    }

    @Override
    public String toString() {
        return Identifiable$class.toString(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam minSupport() {
        return this.minSupport;
    }

    public double getMinSupport() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.minSupport()));
    }

    public PrefixSpan setMinSupport(double value) {
        return (PrefixSpan)this.set(this.minSupport(), BoxesRunTime.boxToDouble((double)value));
    }

    public IntParam maxPatternLength() {
        return this.maxPatternLength;
    }

    public int getMaxPatternLength() {
        return BoxesRunTime.unboxToInt((Object)this.$(this.maxPatternLength()));
    }

    public PrefixSpan setMaxPatternLength(int value) {
        return (PrefixSpan)this.set(this.maxPatternLength(), BoxesRunTime.boxToInteger((int)value));
    }

    public LongParam maxLocalProjDBSize() {
        return this.maxLocalProjDBSize;
    }

    public long getMaxLocalProjDBSize() {
        return BoxesRunTime.unboxToLong((Object)this.$(this.maxLocalProjDBSize()));
    }

    public PrefixSpan setMaxLocalProjDBSize(long value) {
        return (PrefixSpan)this.set(this.maxLocalProjDBSize(), BoxesRunTime.boxToLong((long)value));
    }

    public Param<String> sequenceCol() {
        return this.sequenceCol;
    }

    public String getSequenceCol() {
        return this.$(this.sequenceCol());
    }

    public PrefixSpan setSequenceCol(String value) {
        return (PrefixSpan)this.set(this.sequenceCol(), value);
    }

    public Dataset<Row> findFrequentSequentialPatterns(Dataset<?> dataset) {
        String sequenceColParam = this.$(this.sequenceCol());
        DataType inputType = dataset.schema().apply(sequenceColParam).dataType();
        Predef$.MODULE$.require(inputType instanceof ArrayType && ((ArrayType)inputType).elementType() instanceof ArrayType, (Function0)new Serializable(this, inputType){
            public static final long serialVersionUID = 0L;
            private final DataType inputType$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column must be ArrayType and the array element type must also be ArrayType, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.inputType$1}))).toString();
            }
            {
                this.inputType$1 = inputType$1;
            }
        });
        Dataset data = dataset.select(sequenceColParam, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        RDD sequences = data.where(functions$.MODULE$.col(sequenceColParam).isNotNull()).rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Object[][] apply(Row r) {
                return (Object[][])((TraversableOnce)((TraversableLike)r.getAs(0)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object[] apply(Seq<Object> x$1) {
                        return (Object[])x$1.toArray(ClassTag$.MODULE$.Any());
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Object.class))));
        org.apache.spark.mllib.fpm.PrefixSpan mllibPrefixSpan = new org.apache.spark.mllib.fpm.PrefixSpan().setMinSupport(BoxesRunTime.unboxToDouble((Object)this.$(this.minSupport()))).setMaxPatternLength(BoxesRunTime.unboxToInt((Object)this.$(this.maxPatternLength()))).setMaxLocalProjDBSize(BoxesRunTime.unboxToLong((Object)this.$(this.maxLocalProjDBSize())));
        RDD rows = mllibPrefixSpan.run((RDD<Object[]>)sequences, ClassTag$.MODULE$.Any()).freqSequences().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(PrefixSpan.FreqSequence<Object> f) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.sequence(), BoxesRunTime.boxToLong((long)f.freq())}));
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        StructType schema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("sequence", dataset.schema().apply(sequenceColParam).dataType(), false, StructField$.MODULE$.apply$default$4()), new StructField("freq", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})));
        Dataset freqSequences = dataset.sparkSession().createDataFrame(rows, schema);
        return freqSequences;
    }

    @Override
    public PrefixSpan copy(ParamMap extra) {
        return (PrefixSpan)this.defaultCopy(extra);
    }

    public PrefixSpan(String uid) {
        this.uid = uid;
        Identifiable$class.$init$(this);
        Params$class.$init$(this);
        this.minSupport = new DoubleParam((Identifiable)this, "minSupport", "The minimal support level of the sequential pattern. Sequential pattern that appears more than (minSupport * size-of-the-dataset) times will be output.", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(0.0));
        this.maxPatternLength = new IntParam((Identifiable)this, "maxPatternLength", "The maximal length of the sequential pattern.", (Function1<Object, Object>)ParamValidators$.MODULE$.gt(0.0));
        this.maxLocalProjDBSize = new LongParam((Identifiable)this, "maxLocalProjDBSize", "The maximum number of items (including delimiters used in the internal storage format) allowed in a projected database before local processing. If a projected database exceeds this size, another iteration of distributed prefix growth is run.", (Function1<Object, Object>)ParamValidators$.MODULE$.gt(0.0));
        this.sequenceCol = new Param(this, "sequenceCol", "The name of the sequence column in dataset, rows with nulls in this column are ignored.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.minSupport().$minus$greater(BoxesRunTime.boxToDouble((double)0.1)), this.maxPatternLength().$minus$greater(BoxesRunTime.boxToInteger((int)10)), this.maxLocalProjDBSize().$minus$greater(BoxesRunTime.boxToLong((long)32000000L)), this.sequenceCol().$minus$greater("sequence")}));
    }

    public PrefixSpan() {
        this(Identifiable$.MODULE$.randomUID("prefixSpan"));
    }
}

