/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q3Q!\u0001\u0002\u0001\r1\u0011QcQ8tS:,G)[:uC:\u001cW-T3bgV\u0014XM\u0003\u0002\u0004\t\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0005\u0001i\u0001C\u0001\b\u0010\u001b\u0005\u0011\u0011B\u0001\t\u0003\u0005=!\u0015n\u001d;b]\u000e,W*Z1tkJ,\u0007\"\u0002\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003U\u0001\"A\u0004\u0001\t\u000b]\u0001A\u0011\t\r\u0002\u0011\u0011L7\u000f^1oG\u0016$2!G\u0010%!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019!u.\u001e2mK\")\u0001E\u0006a\u0001C\u0005\u0011a/\r\t\u0003\u001d\tJ!a\t\u0002\u0003\u001dY+7\r^8s/&$\bNT8s[\")QE\u0006a\u0001C\u0005\u0011aO\r\u0005\u0006O\u0001!\t\u0005K\u0001\u0011kB$\u0017\r^3DYV\u001cH/\u001a:Tk6$2!\u000b\u0017/!\tQ\"&\u0003\u0002,7\t!QK\\5u\u0011\u0015ic\u00051\u0001\"\u0003\u0015\u0001x.\u001b8u\u0011\u0015yc\u00051\u00011\u0003\r\u0019X/\u001c\t\u0003cQj\u0011A\r\u0006\u0003g\u0011\ta\u0001\\5oC2<\u0017BA\u001b3\u0005\u00191Vm\u0019;pe\")q\u0007\u0001C!q\u0005A1-\u001a8ue>LG\rF\u0002\"siBQa\f\u001cA\u0002ABQa\u000f\u001cA\u0002q\nQaY8v]R\u0004\"AG\u001f\n\u0005yZ\"\u0001\u0002'p]\u001eDQ\u0001\u0011\u0001\u0005B\u0005\u000b1b\u00197vgR,'oQ8tiR)\u0011DQ\"F\u000f\")qg\u0010a\u0001C!)Ai\u0010a\u0001C\u0005I\u0001o\\5oiN\u001cV/\u001c\u0005\u0006\r~\u0002\r\u0001P\u0001\u000f]Vl'-\u001a:PMB{\u0017N\u001c;t\u0011\u0015Au\b1\u0001\u001a\u0003E\u0001x.\u001b8ugN\u000bX/\u0019:fI:{'/\u001c\u0005\u0006\u0015\u0002!\teS\u0001\u0013gflW.\u001a;sS\u000e\u001cUM\u001c;s_&$7\u000f\u0006\u0003M\u001fF\u001b\u0006\u0003\u0002\u000eNC\u0005J!AT\u000e\u0003\rQ+\b\u000f\\33\u0011\u0015\u0001\u0016\n1\u0001\u001a\u0003\u0015aWM^3m\u0011\u0015\u0011\u0016\n1\u00011\u0003\u0015qw.[:f\u0011\u00159\u0014\n1\u00011\u0001")
public class CosineDistanceMeasure
extends DistanceMeasure {
    @Override
    public double distance(VectorWithNorm v1, VectorWithNorm v2) {
        Predef$.MODULE$.assert(v1.norm() > 0.0 && v2.norm() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cosine distance is not defined for zero-length vectors.";
            }
        });
        return 1.0 - BLAS$.MODULE$.dot(v1.vector(), v2.vector()) / v1.norm() / v2.norm();
    }

    @Override
    public void updateClusterSum(VectorWithNorm point, Vector sum) {
        Predef$.MODULE$.assert(point.norm() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cosine distance is not defined for zero-length vectors.";
            }
        });
        BLAS$.MODULE$.axpy(1.0 / point.norm(), point.vector(), sum);
    }

    @Override
    public VectorWithNorm centroid(Vector sum, long count) {
        BLAS$.MODULE$.scal(1.0 / (double)count, sum);
        double norm2 = Vectors$.MODULE$.norm(sum, 2.0);
        BLAS$.MODULE$.scal(1.0 / norm2, sum);
        return new VectorWithNorm(sum, 1.0);
    }

    @Override
    public double clusterCost(VectorWithNorm centroid, VectorWithNorm pointsSum, long numberOfPoints, double pointsSquaredNorm) {
        Vector costVector = pointsSum.vector().copy();
        return package$.MODULE$.max((double)numberOfPoints - BLAS$.MODULE$.dot(centroid.vector(), costVector) / centroid.norm(), 0.0);
    }

    @Override
    public Tuple2<VectorWithNorm, VectorWithNorm> symmetricCentroids(double level, Vector noise, Vector centroid) {
        Tuple2<VectorWithNorm, VectorWithNorm> tuple2 = super.symmetricCentroids(level, noise, centroid);
        if (tuple2 != null) {
            Tuple2 tuple22;
            VectorWithNorm left = (VectorWithNorm)tuple2._1();
            VectorWithNorm right = (VectorWithNorm)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)left, (Object)right);
            VectorWithNorm left2 = (VectorWithNorm)tuple23._1();
            VectorWithNorm right2 = (VectorWithNorm)tuple23._2();
            Vector leftVector = left2.vector();
            Vector rightVector = right2.vector();
            BLAS$.MODULE$.scal(1.0 / left2.norm(), leftVector);
            BLAS$.MODULE$.scal(1.0 / right2.norm(), rightVector);
            return new Tuple2((Object)new VectorWithNorm(leftVector, 1.0), (Object)new VectorWithNorm(rightVector, 1.0));
        }
        throw new MatchError(tuple2);
    }
}

