/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.CompoundPredicate;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.False;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.HasPredicate;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Predicate;
import org.spark_project.dmg.pmml.Rule;
import org.spark_project.dmg.pmml.SimplePredicate;
import org.spark_project.dmg.pmml.SimpleRule;
import org.spark_project.dmg.pmml.SimpleSetPredicate;
import org.spark_project.dmg.pmml.True;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "predicate", "rules"})
@XmlRootElement(name="CompoundRule", namespace="http://www.dmg.org/PMML-4_2")
public class CompoundRule
extends Rule
implements HasExtensions,
HasPredicate {
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElements(value={@XmlElement(name="SimplePredicate", namespace="http://www.dmg.org/PMML-4_2", type=SimplePredicate.class), @XmlElement(name="CompoundPredicate", namespace="http://www.dmg.org/PMML-4_2", type=CompoundPredicate.class), @XmlElement(name="SimpleSetPredicate", namespace="http://www.dmg.org/PMML-4_2", type=SimpleSetPredicate.class), @XmlElement(name="True", namespace="http://www.dmg.org/PMML-4_2", type=True.class), @XmlElement(name="False", namespace="http://www.dmg.org/PMML-4_2", type=False.class)})
    private Predicate predicate;
    @XmlElements(value={@XmlElement(name="SimpleRule", namespace="http://www.dmg.org/PMML-4_2", type=SimpleRule.class), @XmlElement(name="CompoundRule", namespace="http://www.dmg.org/PMML-4_2", type=CompoundRule.class)})
    private List<Rule> rules;

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public CompoundRule setPredicate(Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public List<Rule> getRules() {
        if (this.rules == null) {
            this.rules = new ArrayList<Rule>();
        }
        return this.rules;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public CompoundRule addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasRules() {
        return this.rules != null && this.rules.size() > 0;
    }

    public CompoundRule addRules(Rule ... rules) {
        this.getRules().addAll(Arrays.asList(rules));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getPredicate());
            }
            if (status == VisitorAction.CONTINUE && this.hasRules()) {
                status = PMMLObject.traverse(visitor, this.getRules());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

