/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.Array;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.HasId;
import org.spark_project.dmg.pmml.Indexable;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.RealSparseArray;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "realSparseArray", "array"})
@XmlRootElement(name="VectorInstance", namespace="http://www.dmg.org/PMML-4_2")
public class VectorInstance
extends PMMLObject
implements HasExtensions,
HasId,
Indexable<String> {
    @XmlAttribute(name="id", required=true)
    private String id;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="REAL-SparseArray", namespace="http://www.dmg.org/PMML-4_2")
    private RealSparseArray realSparseArray;
    @XmlElement(name="Array", namespace="http://www.dmg.org/PMML-4_2")
    private Array array;

    public VectorInstance() {
    }

    public VectorInstance(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public VectorInstance setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public RealSparseArray getRealSparseArray() {
        return this.realSparseArray;
    }

    public VectorInstance setRealSparseArray(RealSparseArray realSparseArray) {
        this.realSparseArray = realSparseArray;
        return this;
    }

    public Array getArray() {
        return this.array;
    }

    public VectorInstance setArray(Array array) {
        this.array = array;
        return this;
    }

    @Override
    public String getKey() {
        return this.getId();
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public VectorInstance addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getRealSparseArray(), this.getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

