/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jpmml.model.visitors;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.spark_project.dmg.pmml.DataField;
import org.spark_project.dmg.pmml.DerivedField;
import org.spark_project.dmg.pmml.Field;
import org.spark_project.dmg.pmml.LocalTransformations;
import org.spark_project.dmg.pmml.OutputField;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.TransformationDictionary;
import org.spark_project.dmg.pmml.Visitable;
import org.spark_project.dmg.pmml.VisitorAction;
import org.spark_project.jpmml.model.FieldUtil;
import org.spark_project.jpmml.model.visitors.FieldReferenceFinder;
import org.spark_project.jpmml.model.visitors.FieldResolver;
import org.spark_project.jpmml.model.visitors.VisitorUtil;

public class FieldDependencyResolver
extends FieldResolver {
    private Map<Field, Set<Field>> dependencies = new LinkedHashMap<Field, Set<Field>>();
    private Set<DerivedField> globalDerivedFields = new HashSet<DerivedField>();
    private Set<DerivedField> localDerivedFields = new HashSet<DerivedField>();

    @Override
    public void applyTo(Visitable visitable) {
        this.dependencies.clear();
        this.globalDerivedFields.clear();
        this.localDerivedFields.clear();
        super.applyTo(visitable);
    }

    @Override
    public VisitorAction visit(DataField dataField) {
        this.process(dataField);
        return super.visit(dataField);
    }

    @Override
    public VisitorAction visit(DerivedField derivedField) {
        PMMLObject parent = VisitorUtil.getParent(this);
        if (VisitorUtil.isDictionary(parent)) {
            this.process(derivedField);
        }
        return super.visit(derivedField);
    }

    @Override
    public VisitorAction visit(LocalTransformations localTransformations) {
        if (localTransformations.hasDerivedFields()) {
            this.localDerivedFields.addAll(localTransformations.getDerivedFields());
        }
        return super.visit(localTransformations);
    }

    @Override
    public VisitorAction visit(OutputField outputField) {
        this.process(outputField);
        return super.visit(outputField);
    }

    @Override
    public VisitorAction visit(TransformationDictionary transformationDictionary) {
        if (transformationDictionary.hasDerivedFields()) {
            this.globalDerivedFields.addAll(transformationDictionary.getDerivedFields());
        }
        return super.visit(transformationDictionary);
    }

    public Set<Field> getDependencies(Field field) {
        Map<Field, Set<Field>> dependencies = this.getDependencies();
        if (!dependencies.containsKey(field)) {
            throw new IllegalArgumentException();
        }
        return dependencies.get(field);
    }

    public Map<Field, Set<Field>> getDependencies() {
        return this.dependencies;
    }

    public void expand(Set<Field> fields) {
        this.expand(fields, this.globalDerivedFields);
    }

    public void expand(Set<Field> fields, Set<? extends Field> expandableFields) {
        LinkedHashSet<Field> removableFields = new LinkedHashSet<Field>();
        int i = 0;
        while (true) {
            if (i > 1000) {
                throw new IllegalStateException();
            }
            removableFields.clear();
            for (Field field : fields) {
                if (!expandableFields.contains(field)) continue;
                removableFields.add(field);
            }
            if (removableFields.isEmpty()) break;
            for (Field removableField : removableFields) {
                fields.addAll(this.getDependencies(removableField));
            }
            fields.removeAll(removableFields);
            ++i;
        }
    }

    private void process(Field field) {
        FieldReferenceFinder fieldReferenceFinder = new FieldReferenceFinder();
        fieldReferenceFinder.applyTo(field);
        Set<Field> activeFields = FieldUtil.selectAll(this.getFields(), fieldReferenceFinder.getFieldNames());
        this.dependencies.put(field, activeFields);
    }
}

