/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.classification.NaiveBayes$;
import org.apache.spark.ml.classification.NaiveBayesModel$;
import org.apache.spark.ml.classification.NaiveBayesModel$NaiveBayesModelWriter$;
import org.apache.spark.ml.classification.NaiveBayesModel$NaiveBayesModelWriter$Data$;
import org.apache.spark.ml.classification.NaiveBayesParams;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.util.VersionUtils$;
import org.json4s.DefaultFormats$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rub\u0001B%K\u0001UC\u0001B\u001b\u0001\u0003\u0006\u0004%\te\u001b\u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\n1D!\"!\u0003\u0001\u0005\u000b\u0007I\u0011AA\u0006\u0011%\t\u0019\u0002\u0001B\u0001B\u0003%!\f\u0003\u0006\u0002\u0018\u0001\u0011)\u0019!C\u0001\u00033A!\"a\t\u0001\u0005\u0003\u0005\u000b\u0011BA\u000e\u0011)\t9\u0003\u0001BC\u0002\u0013\u0005\u0011\u0011\u0004\u0005\u000b\u0003_\u0001!\u0011!Q\u0001\n\u0005m\u0001\u0002CA\u001a\u0001\u0011\u0005A*!\u000e\t\u0015\u0005\u001d\u0003\u00011A\u0005\u00029\u000bI\u0005\u0003\u0006\u0002Z\u0001\u0001\r\u0011\"\u0001O\u00037B\u0001\"a\u001a\u0001A\u0003&\u00111\n\u0005\t\u0003S\u0002A\u0011\u0001(\u0002l!Q\u00111\u000f\u0001\t\u0006\u0004%I!!\u0007\t\u0015\u0005u\u0004\u0001#b\u0001\n\u0013\ty\b\u0003\u0006\u0002\n\u0002A)\u0019!C\u0005\u0003\u0013B\u0011\"!$\u0001\u0005\u0004%\t%a$\t\u0011\u0005u\u0005\u0001)A\u0005\u0003#C\u0011\"!)\u0001\u0005\u0004%\t%a$\t\u0011\u0005\u0015\u0006\u0001)A\u0005\u0003#Cq!!+\u0001\t\u0013\tY\u000bC\u0004\u00022\u0002!I!a-\t\u000f\u0005]\u0006\u0001\"\u0003\u0002:\"9\u0011Q\u0018\u0001\u0005\n\u0005}\u0006BCAb\u0001!\u0015\r\u0011\"\u0003\u0002F\"9\u0011q\u001a\u0001\u0005B\u0005E\u0007bBAl\u0001\u0011E\u0013\u0011\u001c\u0005\b\u0003?\u0004A\u0011IAq\u0011\u001d\t)\u0010\u0001C!\u0003oDq!a?\u0001\t\u0003\nipB\u0004\u0003\n)C\tAa\u0003\u0007\r%S\u0005\u0012\u0001B\u0007\u0011\u001d\t\u0019\u0004\tC\u0001\u0005WAqA!\f!\t\u0003\u0012y\u0003C\u0004\u0003:\u0001\"\tEa\u000f\u0007\u000f\t\r\u0003\u0005\u0001\u0011\u0003F!I!q\t\u0013\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\b\u0003g!C\u0011\u0001B%\r\u0019\u0011\t\u0006\n#\u0003T!Q\u0011\u0011B\u0014\u0003\u0016\u0004%\t!a\u0003\t\u0013\u0005MqE!E!\u0002\u0013Q\u0006BCA\fO\tU\r\u0011\"\u0001\u0002\u001a!Q\u00111E\u0014\u0003\u0012\u0003\u0006I!a\u0007\t\u0015\u0005\u001drE!f\u0001\n\u0003\tI\u0002\u0003\u0006\u00020\u001d\u0012\t\u0012)A\u0005\u00037Aq!a\r(\t\u0003\u0011Y\u0007C\u0005\u0002`\u001e\n\t\u0011\"\u0001\u0003x!I!qP\u0014\u0012\u0002\u0013\u0005!\u0011\u0011\u0005\n\u0005+;\u0013\u0013!C\u0001\u0005/C\u0011Ba'(#\u0003%\tAa&\t\u0013\tuu%!A\u0005B\t}\u0005\"\u0003BVO\u0005\u0005I\u0011AAH\u0011%\u0011ikJA\u0001\n\u0003\u0011y\u000bC\u0005\u0003:\u001e\n\t\u0011\"\u0011\u0003<\"I!\u0011Z\u0014\u0002\u0002\u0013\u0005!1\u001a\u0005\n\u0005+<\u0013\u0011!C!\u0005/D\u0011Ba7(\u0003\u0003%\tE!8\t\u0013\u0005Ux%!A\u0005B\t}\u0007\"\u0003BqO\u0005\u0005I\u0011\tBr\u000f%\u00119\u000fJA\u0001\u0012\u0013\u0011IOB\u0005\u0003R\u0011\n\t\u0011#\u0003\u0003l\"9\u00111G\u001f\u0005\u0002\te\b\"CA{{\u0005\u0005IQ\tBp\u0011%\u0011Y0PA\u0001\n\u0003\u0013i\u0010C\u0005\u0004\u0006u\n\t\u0011\"!\u0004\b!91\u0011\u0004\u0013\u0005R\rmaABB\u0010A\u0011\u0019\t\u0003C\u0004\u00024\r#\taa\t\t\u0013\r\u001d2I1A\u0005\n\t}\u0005\u0002CB\u0015\u0007\u0002\u0006IA!)\t\u000f\te2\t\"\u0011\u0004,!I1q\u0006\u0011\u0002\u0002\u0013%1\u0011\u0007\u0002\u0010\u001d\u0006Lg/\u001a\"bs\u0016\u001cXj\u001c3fY*\u00111\nT\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\tie*\u0001\u0002nY*\u0011q\nU\u0001\u0006gB\f'o\u001b\u0006\u0003#J\u000ba!\u00199bG\",'\"A*\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00011\u0016\r\u001a\t\u0005/bS\u0006-D\u0001K\u0013\tI&J\u0001\u0011Qe>\u0014\u0017MY5mSN$\u0018nY\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d\u0007CA._\u001b\u0005a&BA/M\u0003\u0019a\u0017N\\1mO&\u0011q\f\u0018\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005]\u0003\u0001CA,c\u0013\t\u0019'J\u0001\tOC&4XMQ1zKN\u0004\u0016M]1ngB\u0011Q\r[\u0007\u0002M*\u0011q\rT\u0001\u0005kRLG.\u0003\u0002jM\nQQ\nT,sSR\f'\r\\3\u0002\u0007ULG-F\u0001m!\tigO\u0004\u0002oiB\u0011qN]\u0007\u0002a*\u0011\u0011\u000fV\u0001\u0007yI|w\u000e\u001e \u000b\u0003M\fQa]2bY\u0006L!!\u001e:\u0002\rA\u0013X\rZ3g\u0013\t9\bP\u0001\u0004TiJLgn\u001a\u0006\u0003kJDC!\u0001>\u0002\u0002A\u00111P`\u0007\u0002y*\u0011QPT\u0001\u000bC:tw\u000e^1uS>t\u0017BA@}\u0005\u0015\u0019\u0016N\\2fC\t\t\u0019!A\u00032]Ur\u0003'\u0001\u0003vS\u0012\u0004\u0003\u0006\u0002\u0002{\u0003\u0003\t!\u0001]5\u0016\u0003iCCa\u0001>\u0002\u0010\u0005\u0012\u0011\u0011C\u0001\u0006e9\u0002d\u0006M\u0001\u0004a&\u0004\u0003\u0006\u0002\u0003{\u0003\u001f\tQ\u0001\u001e5fi\u0006,\"!a\u0007\u0011\u0007m\u000bi\"C\u0002\u0002 q\u0013a!T1ue&D\b\u0006B\u0003{\u0003\u001f\ta\u0001\u001e5fi\u0006\u0004\u0003\u0006\u0002\u0004{\u0003\u001f\tQa]5h[\u0006DCa\u0002>\u0002,\u0005\u0012\u0011QF\u0001\u0006g9\u0002d\u0006M\u0001\u0007g&<W.\u0019\u0011)\t!Q\u00181F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013\u0001\f9$a\u000f\u0002@\u0005\r\u0003\"\u00026\n\u0001\u0004a\u0007&BA\u001cu\u0006\u0005\u0001BBA\u0005\u0013\u0001\u0007!\fK\u0003\u0002<i\fy\u0001C\u0004\u0002\u0018%\u0001\r!a\u0007)\u000b\u0005}\"0a\u0004\t\u000f\u0005\u001d\u0012\u00021\u0001\u0002\u001c!*\u00111\t>\u0002,\u0005Iq\u000e\u001c3MC\n,Gn]\u000b\u0003\u0003\u0017\u0002b!!\u0014\u0002P\u0005MS\"\u0001:\n\u0007\u0005E#OA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002N\u0005U\u0013bAA,e\n1Ai\\;cY\u0016\fQb\u001c7e\u0019\u0006\u0014W\r\\:`I\u0015\fH\u0003BA/\u0003G\u0002B!!\u0014\u0002`%\u0019\u0011\u0011\r:\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003KZ\u0011\u0011!a\u0001\u0003\u0017\n1\u0001\u001f\u00132\u0003)yG\u000e\u001a'bE\u0016d7\u000fI\u0001\rg\u0016$x\n\u001c3MC\n,Gn\u001d\u000b\u0005\u0003[\ny'D\u0001\u0001\u0011\u001d\t\t(\u0004a\u0001\u0003\u0017\na\u0001\\1cK2\u001c\u0018A\u0005;iKR\fW*\u001b8vg:+w\r\u00165fi\u0006D3ADA<!\u0011\ti%!\u001f\n\u0007\u0005m$OA\u0005ue\u0006t7/[3oi\u0006y\u0001/['j]V\u001cH\u000b[3uCN+X.\u0006\u0002\u0002\u0002B\u00191,a!\n\u0007\u0005\u0015ELA\u0006EK:\u001cXMV3di>\u0014\bfA\b\u0002x\u0005IAn\\4WCJ\u001cV/\u001c\u0015\u0004!\u0005]\u0014a\u00038v[\u001a+\u0017\r^;sKN,\"!!%\u0011\t\u00055\u00131S\u0005\u0004\u0003+\u0013(aA%oi\"\"\u0011C_AMC\t\tY*A\u00032]Yr\u0003'\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005\u000b\u0003\u0013u\u0006e\u0015A\u00038v[\u000ec\u0017m]:fg\"\"1C_A\u0001\u0003-qW/\\\"mCN\u001cXm\u001d\u0011)\tQQ\u0018\u0011A\u0001\u0017[VdG/\u001b8p[&\fGnQ1mGVd\u0017\r^5p]R!\u0011\u0011QAW\u0011\u0019\ty+\u0006a\u00015\u0006Aa-Z1ukJ,7/A\u000bd_6\u0004H.Z7f]R\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\u0007i\u000b)\f\u0003\u0004\u00020Z\u0001\rAW\u0001\u0015E\u0016\u0014hn\\;mY&\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\t\u0005\u0005\u00151\u0018\u0005\u0007\u0003_;\u0002\u0019\u0001.\u0002'\u001d\fWo]:jC:\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\u0007i\u000b\t\r\u0003\u0004\u00020b\u0001\rAW\u0001\u000faJ,G-[2u%\u0006<h)\u001e8d+\t\t9\r\u0005\u0004\u0002N\u0005%'LW\u0005\u0004\u0003\u0017\u0014(!\u0003$v]\u000e$\u0018n\u001c82Q\rI\u0012qO\u0001\u000baJ,G-[2u%\u0006<Hc\u0001.\u0002T\"1\u0011q\u0016\u000eA\u0002iCCA\u0007>\u0002,\u00051\"/Y<3aJ|'-\u00192jY&$\u00180\u00138QY\u0006\u001cW\rF\u0002[\u00037Da!!8\u001c\u0001\u0004Q\u0016!\u0004:boB\u0013X\rZ5di&|g.\u0001\u0003d_BLHc\u00011\u0002d\"9\u0011Q\u001d\u000fA\u0002\u0005\u001d\u0018!B3yiJ\f\u0007\u0003BAu\u0003_l!!a;\u000b\u0007\u00055H*A\u0003qCJ\fW.\u0003\u0003\u0002r\u0006-(\u0001\u0003)be\u0006lW*\u00199)\tqQ\u0018\u0011A\u0001\ti>\u001cFO]5oOR\tA\u000e\u000b\u0003\u001eu\u0006\u0005\u0011!B<sSR,WCAA\u0000!\r)'\u0011A\u0005\u0004\u0005\u00071'\u0001C'M/JLG/\u001a:)\tyQ\u0018\u0011\u0014\u0015\u0005\u0001i\f\t!A\bOC&4XMQ1zKNlu\u000eZ3m!\t9\u0006eE\u0004!\u0005\u001f\u0011)Ba\u0007\u0011\t\u00055#\u0011C\u0005\u0004\u0005'\u0011(AB!osJ+g\r\u0005\u0003f\u0005/\u0001\u0017b\u0001B\rM\nQQ\n\u0014*fC\u0012\f'\r\\3\u0011\t\tu!qE\u0007\u0003\u0005?QAA!\t\u0003$\u0005\u0011\u0011n\u001c\u0006\u0003\u0005K\tAA[1wC&!!\u0011\u0006B\u0010\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011Y!\u0001\u0003sK\u0006$WC\u0001B\u0019!\u0011)'1\u00071\n\u0007\tUbM\u0001\u0005N\u0019J+\u0017\rZ3sQ\u0011\u0011#0!'\u0002\t1|\u0017\r\u001a\u000b\u0004A\nu\u0002B\u0002B G\u0001\u0007A.\u0001\u0003qCRD\u0007\u0006B\u0012{\u00033\u0013QCT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\\,sSR,'oE\u0002%\u0003\u007f\f\u0001\"\u001b8ti\u0006t7-\u001a\u000b\u0005\u0005\u0017\u0012y\u0005E\u0002\u0003N\u0011j\u0011\u0001\t\u0005\u0007\u0005\u000f2\u0003\u0019\u00011\u0003\t\u0011\u000bG/Y\n\bO\t=!Q\u000bB.!\u0011\tiEa\u0016\n\u0007\te#OA\u0004Qe>$Wo\u0019;\u0011\t\tu#q\r\b\u0005\u0005?\u0012\u0019GD\u0002p\u0005CJ\u0011a]\u0005\u0004\u0005K\u0012\u0018a\u00029bG.\fw-Z\u0005\u0005\u0005S\u0011IGC\u0002\u0003fI$\u0002B!\u001c\u0003r\tM$Q\u000f\t\u0004\u0005_:S\"\u0001\u0013\t\r\u0005%a\u00061\u0001[\u0011\u001d\t9B\fa\u0001\u00037Aq!a\n/\u0001\u0004\tY\u0002\u0006\u0005\u0003n\te$1\u0010B?\u0011!\tIa\fI\u0001\u0002\u0004Q\u0006\"CA\f_A\u0005\t\u0019AA\u000e\u0011%\t9c\fI\u0001\u0002\u0004\tY\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\r%f\u0001.\u0003\u0006.\u0012!q\u0011\t\u0005\u0005\u0013\u0013\t*\u0004\u0002\u0003\f*!!Q\u0012BH\u0003%)hn\u00195fG.,GM\u0003\u0002~e&!!1\u0013BF\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IJ\u000b\u0003\u0002\u001c\t\u0015\u0015AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u0005\u0006\u0003\u0002BR\u0005Sk!A!*\u000b\t\t\u001d&1E\u0001\u0005Y\u0006tw-C\u0002x\u0005K\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00032\n]\u0006\u0003BA'\u0005gK1A!.s\u0005\r\te.\u001f\u0005\n\u0003K*\u0014\u0011!a\u0001\u0003#\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005{\u0003bAa0\u0003F\nEVB\u0001Ba\u0015\r\u0011\u0019M]\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002Bd\u0005\u0003\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!Q\u001aBj!\u0011\tiEa4\n\u0007\tE'OA\u0004C_>dW-\u00198\t\u0013\u0005\u0015t'!AA\u0002\tE\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!)\u0003Z\"I\u0011Q\r\u001d\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011\u0013\u000b\u0003\u0005C\u000ba!Z9vC2\u001cH\u0003\u0002Bg\u0005KD\u0011\"!\u001a<\u0003\u0003\u0005\rA!-\u0002\t\u0011\u000bG/\u0019\t\u0004\u0005_j4#B\u001f\u0003n\nm\u0001c\u0003Bx\u0005kT\u00161DA\u000e\u0005[j!A!=\u000b\u0007\tM(/A\u0004sk:$\u0018.\\3\n\t\t](\u0011\u001f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDC\u0001Bu\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011iGa@\u0004\u0002\r\r\u0001BBA\u0005\u0001\u0002\u0007!\fC\u0004\u0002\u0018\u0001\u0003\r!a\u0007\t\u000f\u0005\u001d\u0002\t1\u0001\u0002\u001c\u00059QO\\1qa2LH\u0003BB\u0005\u0007+\u0001b!!\u0014\u0004\f\r=\u0011bAB\u0007e\n1q\n\u001d;j_:\u0004\u0012\"!\u0014\u0004\u0012i\u000bY\"a\u0007\n\u0007\rM!O\u0001\u0004UkBdWm\r\u0005\n\u0007/\t\u0015\u0011!a\u0001\u0005[\n1\u0001\u001f\u00131\u0003!\u0019\u0018M^3J[BdG\u0003BA/\u0007;AaAa\u0010C\u0001\u0004a'!\u0006(bSZ,')Y=fg6{G-\u001a7SK\u0006$WM]\n\u0004\u0007\nEBCAB\u0013!\r\u0011ieQ\u0001\nG2\f7o\u001d(b[\u0016\f!b\u00197bgNt\u0015-\\3!)\r\u00017Q\u0006\u0005\u0007\u0005\u007f9\u0005\u0019\u00017\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\rM\u0002\u0003\u0002BR\u0007kIAaa\u000e\u0003&\n1qJ\u00196fGRDC\u0001\t>\u0002\u001a\"\"qD_AM\u0001")
public class NaiveBayesModel
extends ProbabilisticClassificationModel<Vector, NaiveBayesModel>
implements NaiveBayesParams,
MLWritable {
    private transient Matrix thetaMinusNegTheta;
    private transient DenseVector piMinusThetaSum;
    private transient double[] logVarSum;
    private transient Function1<Vector, Vector> predictRawFunc;
    private final String uid;
    private final Vector pi;
    private final Matrix theta;
    private final Matrix sigma;
    private double[] oldLabels;
    private final int numFeatures;
    private final int numClasses;
    private DoubleParam smoothing;
    private Param<String> modelType;
    private Param<String> weightCol;
    private volatile transient byte bitmap$trans$0;

    public static NaiveBayesModel load(String path) {
        return NaiveBayesModel$.MODULE$.load(path);
    }

    public static MLReader<NaiveBayesModel> read() {
        return NaiveBayesModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getSmoothing() {
        return NaiveBayesParams.getSmoothing$(this);
    }

    @Override
    public final String getModelType() {
        return NaiveBayesParams.getModelType$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final DoubleParam smoothing() {
        return this.smoothing;
    }

    @Override
    public final Param<String> modelType() {
        return this.modelType;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$smoothing_$eq(DoubleParam x$1) {
        this.smoothing = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$modelType_$eq(Param<String> x$1) {
        this.modelType = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector pi() {
        return this.pi;
    }

    public Matrix theta() {
        return this.theta;
    }

    public Matrix sigma() {
        return this.sigma;
    }

    public double[] oldLabels() {
        return this.oldLabels;
    }

    public void oldLabels_$eq(double[] x$1) {
        this.oldLabels = x$1;
    }

    public NaiveBayesModel setOldLabels(double[] labels) {
        this.oldLabels_$eq(labels);
        return this;
    }

    private Matrix thetaMinusNegTheta$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Bernoulli();
                String string3 = string;
                if (string2 != null ? !string2.equals(string3) : string3 != null) {
                    throw new IllegalArgumentException(new StringBuilder(72).append(new StringBuilder(21).append("Invalid modelType: ").append((Object)this.$(this.modelType())).append(". ").toString()).append("Variables thetaMinusNegTheta should only be precomputed in Bernoulli NB.").toString());
                }
                Matrix matrix = this.theta().map((Function1)(JFunction1.mcDD.sp & Serializable)value -> value - scala.math.package$.MODULE$.log1p(-scala.math.package$.MODULE$.exp(value)));
                this.thetaMinusNegTheta = matrix;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.thetaMinusNegTheta;
    }

    private Matrix thetaMinusNegTheta() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.thetaMinusNegTheta$lzycompute() : this.thetaMinusNegTheta;
    }

    private DenseVector piMinusThetaSum$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Bernoulli();
                String string3 = string;
                if (string2 != null ? !string2.equals(string3) : string3 != null) {
                    throw new IllegalArgumentException(new StringBuilder(69).append(new StringBuilder(21).append("Invalid modelType: ").append((Object)this.$(this.modelType())).append(". ").toString()).append("Variables piMinusThetaSum should only be precomputed in Bernoulli NB.").toString());
                }
                Matrix negTheta = this.theta().map((Function1)(JFunction1.mcDD.sp & Serializable)value -> scala.math.package$.MODULE$.log1p(-scala.math.package$.MODULE$.exp(value)));
                DenseVector ones = new DenseVector((double[])Array$.MODULE$.fill(this.theta().numCols(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0, (ClassTag)ClassTag$.MODULE$.Double()));
                DenseVector piMinusThetaSum = this.pi().toDense().copy();
                BLAS$.MODULE$.gemv(1.0, negTheta, (Vector)ones, 1.0, piMinusThetaSum);
                DenseVector denseVector = piMinusThetaSum;
                this.piMinusThetaSum = denseVector;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.piMinusThetaSum;
    }

    private DenseVector piMinusThetaSum() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.piMinusThetaSum$lzycompute() : this.piMinusThetaSum;
    }

    private double[] logVarSum$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Gaussian();
                String string3 = string;
                if (string2 != null ? !string2.equals(string3) : string3 != null) {
                    throw new IllegalArgumentException(new StringBuilder(62).append(new StringBuilder(21).append("Invalid modelType: ").append((Object)this.$(this.modelType())).append(". ").toString()).append("Variables logVarSum should only be precomputed in Gaussian NB.").toString());
                }
                double[] dArray = (double[])Array$.MODULE$.tabulate(this.numClasses(), (Function1)(JFunction1.mcDI.sp & Serializable)i -> BoxesRunTime.unboxToDouble((Object)package$.MODULE$.Iterator().range(0, this.numFeatures()).map((Function1)(JFunction1.mcDI.sp & Serializable)j -> scala.math.package$.MODULE$.log(this.sigma().apply(i, j))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), (ClassTag)ClassTag$.MODULE$.Double());
                this.logVarSum = dArray;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.logVarSum;
    }

    private double[] logVarSum() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.logVarSum$lzycompute() : this.logVarSum;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector multinomialCalculation(Vector features) {
        void var2_2;
        NaiveBayes$.MODULE$.requireNonnegativeValues(features);
        DenseVector prob = this.pi().toDense().copy();
        BLAS$.MODULE$.gemv(1.0, this.theta(), features, 1.0, prob);
        return var2_2;
    }

    private Vector complementCalculation(Vector features) {
        int j;
        NaiveBayes$.MODULE$.requireNonnegativeValues(features);
        double[] probArray = this.theta().multiply(features).toArray();
        double max = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(probArray).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        double sumExp = 0.0;
        for (j = 0; j < probArray.length; ++j) {
            sumExp += scala.math.package$.MODULE$.exp(probArray[j] - max);
        }
        double logSumExp = scala.math.package$.MODULE$.log(sumExp) + max;
        for (j = 0; j < probArray.length; ++j) {
            probArray[j] = probArray[j] - logSumExp;
        }
        return Vectors$.MODULE$.dense(probArray);
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector bernoulliCalculation(Vector features) {
        void var2_2;
        NaiveBayes$.MODULE$.requireZeroOneBernoulliValues(features);
        DenseVector prob = this.piMinusThetaSum().copy();
        BLAS$.MODULE$.gemv(1.0, this.thetaMinusNegTheta(), features, 1.0, prob);
        return var2_2;
    }

    private Vector gaussianCalculation(Vector features) {
        double[] prob = (double[])Array$.MODULE$.ofDim(this.numClasses(), (ClassTag)ClassTag$.MODULE$.Double());
        for (int i = 0; i < this.numClasses(); ++i) {
            double s = 0.0;
            for (int j = 0; j < this.numFeatures(); ++j) {
                double d = features.apply(j) - this.theta().apply(i, j);
                s += d * d / this.sigma().apply(i, j);
            }
            prob[i] = this.pi().apply(i) - (s + this.logVarSum()[i]) / (double)2;
        }
        return Vectors$.MODULE$.dense(prob);
    }

    private Function1<Vector, Vector> predictRawFunc$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                Function1 & Serializable intersect;
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Multinomial();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    intersect = (Function1 & Serializable)features -> this.multinomialCalculation((Vector)features);
                } else {
                    String string4 = NaiveBayes$.MODULE$.Complement();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        intersect = (Function1 & Serializable)features -> this.complementCalculation((Vector)features);
                    } else {
                        String string6 = NaiveBayes$.MODULE$.Bernoulli();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            intersect = (Function1 & Serializable)features -> this.bernoulliCalculation((Vector)features);
                        } else {
                            String string8 = NaiveBayes$.MODULE$.Gaussian();
                            String string9 = string;
                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                intersect = (Function1 & Serializable)features -> this.gaussianCalculation((Vector)features);
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
                this.predictRawFunc = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.predictRawFunc;
    }

    private Function1<Vector, Vector> predictRawFunc() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.predictRawFunc$lzycompute() : this.predictRawFunc;
    }

    @Override
    public Vector predictRaw(Vector features) {
        return (Vector)this.predictRawFunc().apply((Object)features);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (!(vector instanceof DenseVector)) {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in NaiveBayesModel: raw2probabilityInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector = (DenseVector)vector;
        Utils$.MODULE$.softmax(denseVector.values());
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    @Override
    public NaiveBayesModel copy(ParamMap extra) {
        return (NaiveBayesModel)this.copyValues(new NaiveBayesModel(this.uid(), this.pi(), this.theta(), this.sigma()).setParent(this.parent()), extra);
    }

    @Override
    public String toString() {
        return new StringBuilder(0).append(new StringBuilder(48).append("NaiveBayesModel: uid=").append(this.uid()).append(", modelType=").append((Object)this.$(this.modelType())).append(", numClasses=").append(this.numClasses()).append(", ").toString()).append(new StringBuilder(12).append("numFeatures=").append(this.numFeatures()).toString()).toString();
    }

    @Override
    public MLWriter write() {
        return new NaiveBayesModelWriter(this);
    }

    public NaiveBayesModel(String uid, Vector pi, Matrix theta, Matrix sigma) {
        this.uid = uid;
        this.pi = pi;
        this.theta = theta;
        this.sigma = sigma;
        HasWeightCol.$init$(this);
        NaiveBayesParams.$init$(this);
        MLWritable.$init$(this);
        this.oldLabels = null;
        this.numFeatures = theta.numCols();
        this.numClasses = pi.size();
        Statics.releaseFence();
    }

    private static class NaiveBayesModelReader
    extends MLReader<NaiveBayesModel> {
        private final String className = NaiveBayesModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public NaiveBayesModel load(String path) {
            NaiveBayesModel naiveBayesModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Matrix matrix;
                Vector vector;
                Object sigma;
                block12: {
                    Row row;
                    block11: {
                        Some some;
                        Dataset<Row> vecConverted;
                        block7: {
                            Vector vector2;
                            Object theta;
                            block9: {
                                Row row2;
                                block8: {
                                    Some some2;
                                    DefaultFormats$ format = DefaultFormats$.MODULE$;
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int major = tuple2._1$mcI$sp();
                                    int minor = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
                                    Tuple2.mcII.sp sp3 = sp2;
                                    int major2 = sp3._1$mcI$sp();
                                    int minor2 = sp3._2$mcI$sp();
                                    String dataPath = new Path(path, "data").toString();
                                    Dataset data = this.sparkSession().read().parquet(dataPath);
                                    vecConverted = MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pi"}));
                                    if (major2 >= 3) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertMatrixColumnsToML(vecConverted, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"theta"})).select("pi", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"theta"})).head();
                                    if (row2 == null || (some2 = Row$.MODULE$.unapplySeq(row2)).isEmpty() || some2.get() == null || ((SeqOps)some2.get()).lengthCompare(2) != 0) break block8;
                                    Object pi = ((SeqOps)some2.get()).apply(0);
                                    theta = ((SeqOps)some2.get()).apply(1);
                                    if (!(pi instanceof Vector)) break block8;
                                    vector2 = (Vector)pi;
                                    if (theta instanceof Matrix) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Matrix matrix2 = (Matrix)theta;
                            Tuple2 tuple2 = new Tuple2((Object)vector2, (Object)matrix2);
                            Tuple2 tuple22 = tuple2;
                            Vector pi = (Vector)tuple22._1();
                            Matrix theta2 = (Matrix)tuple22._2();
                            naiveBayesModel = new NaiveBayesModel(metadata.uid(), pi, theta2, Matrices$.MODULE$.zeros(0, 0));
                            break block10;
                        }
                        row = (Row)MLUtils$.MODULE$.convertMatrixColumnsToML(vecConverted, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"theta", "sigma"})).select("pi", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"theta", "sigma"})).head();
                        if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(3) != 0) break block11;
                        Object pi = ((SeqOps)some.get()).apply(0);
                        Object theta = ((SeqOps)some.get()).apply(1);
                        sigma = ((SeqOps)some.get()).apply(2);
                        if (!(pi instanceof Vector)) break block11;
                        vector = (Vector)pi;
                        if (!(theta instanceof Matrix)) break block11;
                        matrix = (Matrix)theta;
                        if (sigma instanceof Matrix) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                Matrix matrix3 = (Matrix)sigma;
                Tuple3 tuple3 = new Tuple3((Object)vector, (Object)matrix, (Object)matrix3);
                Tuple3 tuple32 = tuple3;
                Vector pi = (Vector)tuple32._1();
                Matrix theta = (Matrix)tuple32._2();
                Matrix sigma2 = (Matrix)tuple32._3();
                naiveBayesModel = new NaiveBayesModel(metadata.uid(), pi, theta, sigma2);
            }
            NaiveBayesModel model = naiveBayesModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class NaiveBayesModelWriter
    extends MLWriter {
        private volatile NaiveBayesModel$NaiveBayesModelWriter$Data$ Data$module;
        private final NaiveBayesModel instance;

        private NaiveBayesModel$NaiveBayesModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            boolean bl;
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            String dataPath = new Path(path, "data").toString();
            String string = this.instance.getModelType();
            String string2 = NaiveBayes$.MODULE$.Multinomial();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                bl = true;
            } else {
                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    bl = true;
                } else {
                    String string6 = NaiveBayes$.MODULE$.Complement();
                    String string7 = string;
                    bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
                }
            }
            if (bl) {
                Predef$.MODULE$.require(this.instance.sigma().numRows() == 0 && this.instance.sigma().numCols() == 0);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string8 = NaiveBayes$.MODULE$.Gaussian();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    Predef$.MODULE$.require(this.instance.sigma().numRows() != 0 && this.instance.sigma().numCols() != 0);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)string);
                }
            }
            Data data = new Data(this, this.instance.pi(), this.instance.theta(), this.instance.sigma());
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayesModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.NaiveBayesModel.NaiveBayesModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.NaiveBayesModel.NaiveBayesModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$2(NaiveBayesModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$2(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            NaiveBayesModelWriter naiveBayesModelWriter = this;
            synchronized (naiveBayesModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new NaiveBayesModel$NaiveBayesModelWriter$Data$(this);
                }
            }
        }

        public NaiveBayesModelWriter(NaiveBayesModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        Serializable {
            private final Vector pi;
            private final Matrix theta;
            private final Matrix sigma;
            public final /* synthetic */ NaiveBayesModelWriter $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public Vector pi() {
                return this.pi;
            }

            public Matrix theta() {
                return this.theta;
            }

            public Matrix sigma() {
                return this.sigma;
            }

            public Data copy(Vector pi, Matrix theta, Matrix sigma) {
                return new Data(this.org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer(), pi, theta, sigma);
            }

            public Vector copy$default$1() {
                return this.pi();
            }

            public Matrix copy$default$2() {
                return this.theta();
            }

            public Matrix copy$default$3() {
                return this.sigma();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = this.pi();
                        break;
                    }
                    case 1: {
                        object = this.theta();
                        break;
                    }
                    case 2: {
                        object = this.sigma();
                        break;
                    }
                    default: {
                        object = Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public String productElementName(int x$1) {
                String string;
                int n = x$1;
                switch (n) {
                    case 0: {
                        string = "pi";
                        break;
                    }
                    case 1: {
                        string = "theta";
                        break;
                    }
                    case 2: {
                        string = "sigma";
                        break;
                    }
                    default: {
                        string = (String)Statics.ioobe((int)x$1);
                        break;
                    }
                }
                return string;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer() != this.org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                Vector vector = this.pi();
                Vector vector2 = data.pi();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.theta();
                Matrix matrix2 = data.theta();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                Matrix matrix3 = this.sigma();
                Matrix matrix4 = data.sigma();
                if (matrix3 == null) {
                    if (matrix4 != null) {
                        return false;
                    }
                } else if (!matrix3.equals(matrix4)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ NaiveBayesModelWriter org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(NaiveBayesModelWriter $outer, Vector pi, Matrix theta, Matrix sigma) {
                this.pi = pi;
                this.theta = theta;
                this.sigma = sigma;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

