/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.normalize$;
import breeze.numerics.package;
import breeze.storage.Zero;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.LDA$;
import org.apache.spark.ml.clustering.LDAModel$;
import org.apache.spark.ml.clustering.LDAParams;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LDAUtils$;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t-a!B\r\u001b\u0003\u0003)\u0003\u0002C\u001e\u0001\u0005\u000b\u0007I\u0011\t\u001f\t\u0011M\u0003!\u0011!Q\u0001\nuB\u0001\"\u0016\u0001\u0003\u0006\u0004%\tA\u0016\u0005\t9\u0002\u0011\t\u0011)A\u0005/\"Ia\f\u0001BC\u0002\u0013\u0005Ad\u0018\u0005\tO\u0002\u0011\t\u0011)A\u0005A\"1Q\u000e\u0001C\u000199Da!\u001e\u0001\u0007\u0002i1\bbB@\u0001\r\u0003Q\u0012\u0011\u0001\u0005\t\u0003\u0013\u0001A\u0011\u0001\u000f\u0002\f!A\u0011\u0011\u0004\u0001\u0005\u0002q\tY\u0002C\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA\"\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003\u001b\u0003A\u0011BAH\u0011\u001d\t\u0019\u000b\u0001C!\u0003KCq!!/\u0001\t\u0003\tY\fC\u0004\u0002@\u0002!\t!!1\t\u000f\u0005-\u0007A\"\u0001\u0002N\"9\u0011q\u001b\u0001\u0005\u0002\u0005e\u0007bBAu\u0001\u0011\u0005\u00111\u001e\u0005\b\u0003w\u0004A\u0011AA\u007f\u0011\u001d\tY\u0010\u0001C\u0001\u0005\u000b\u0011\u0001\u0002\u0014#B\u001b>$W\r\u001c\u0006\u00037q\t!b\u00197vgR,'/\u001b8h\u0015\tib$\u0001\u0002nY*\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u00011CfL\u001b\u0011\u0007\u001dB#&D\u0001\u001d\u0013\tICDA\u0003N_\u0012,G\u000e\u0005\u0002,\u00015\t!\u0004\u0005\u0002,[%\u0011aF\u0007\u0002\n\u0019\u0012\u000b\u0005+\u0019:b[N\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u0010\u0002\u0011%tG/\u001a:oC2L!\u0001N\u0019\u0003\u000f1{wmZ5oOB\u0011a'O\u0007\u0002o)\u0011\u0001\bH\u0001\u0005kRLG.\u0003\u0002;o\tQQ\nT,sSR\f'\r\\3\u0002\u0007ULG-F\u0001>!\tqtI\u0004\u0002@\u000bB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tJ\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\r\u000eC3!A&R!\tau*D\u0001N\u0015\tqe$\u0001\u0006b]:|G/\u0019;j_:L!\u0001U'\u0003\u000bMKgnY3\"\u0003I\u000bQ!\r\u00187]A\nA!^5eA!\u001a!aS)\u0002\u0013Y|7-\u00192TSj,W#A,\u0011\u0005aKV\"A\"\n\u0005i\u001b%aA%oi\"\u001a1aS)\u0002\u0015Y|7-\u00192TSj,\u0007\u0005K\u0002\u0005\u0017F\u000bAb\u001d9be.\u001cVm]:j_:,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0003Gz\t1a]9m\u0013\t)'M\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eK\u0002\u0006\u0017F\u000bQb\u001d9be.\u001cVm]:j_:\u0004\u0003F\u0001\u0004j!\tA&.\u0003\u0002l\u0007\nIAO]1og&,g\u000e\u001e\u0015\u0004\r-\u000b\u0016A\u0002\u001fj]&$h\b\u0006\u0003+_F\u001c\b\"B\u001e\b\u0001\u0004i\u0004fA8L#\")Qk\u0002a\u0001/\"\u001a\u0011oS)\t\u000by;\u0001\u0019\u00011)\u0007M\\\u0015+A\u0007pY\u0012dunY1m\u001b>$W\r\\\u000b\u0002oB\u0011\u0001\u0010`\u0007\u0002s*\u00111D\u001f\u0006\u0003wz\tQ!\u001c7mS\nL!!`=\u0003\u001b1{7-\u00197M\t\u0006ku\u000eZ3mQ\rA1*U\u0001\tO\u0016$Xj\u001c3fYV\u0011\u00111\u0001\t\u0004q\u0006\u0015\u0011BA\rzQ\rI1*U\u0001\u001dO\u0016$XI\u001a4fGRLg/\u001a#pG\u000e{gnY3oiJ\fG/[8o+\t\ti\u0001E\u0003Y\u0003\u001f\t\u0019\"C\u0002\u0002\u0012\r\u0013Q!\u0011:sCf\u00042\u0001WA\u000b\u0013\r\t9b\u0011\u0002\u0007\t>,(\r\\3\u0002=\u001d,G/\u00124gK\u000e$\u0018N^3U_BL7mQ8oG\u0016tGO]1uS>tWCAA\n\u00039\u0019X\r\u001e$fCR,(/Z:D_2$B!!\t\u0002$5\t\u0001\u0001\u0003\u0004\u0002&1\u0001\r!P\u0001\u0006m\u0006dW/\u001a\u0015\u0004\u0019-\u000b\u0016aF:fiR{\u0007/[2ESN$(/\u001b2vi&|gnQ8m)\u0011\t\t#!\f\t\r\u0005\u0015R\u00021\u0001>Q\u0011i1*!\r\"\u0005\u0005M\u0012!\u0002\u001a/e9\u0002\u0014aB:fiN+W\r\u001a\u000b\u0005\u0003C\tI\u0004C\u0004\u0002&9\u0001\r!a\u000f\u0011\u0007a\u000bi$C\u0002\u0002@\r\u0013A\u0001T8oO\"\u001aabS)\u0002\u0013Q\u0014\u0018M\\:g_JlG\u0003BA$\u0003K\u0002B!!\u0013\u0002`9!\u00111JA.\u001d\u0011\ti%!\u0017\u000f\t\u0005=\u0013q\u000b\b\u0005\u0003#\n)FD\u0002A\u0003'J\u0011aI\u0005\u0003C\tJ!a\b\u0011\n\u0005\rt\u0012bAA/E\u00069\u0001/Y2lC\u001e,\u0017\u0002BA1\u0003G\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005u#\rC\u0004\u0002h=\u0001\r!!\u001b\u0002\u000f\u0011\fG/Y:fiB\"\u00111NA;!\u0015\t\u0017QNA9\u0013\r\tyG\u0019\u0002\b\t\u0006$\u0018m]3u!\u0011\t\u0019(!\u001e\r\u0001\u0011a\u0011qOA3\u0003\u0003\u0005\tQ!\u0001\u0002z\t\u0019q\fJ\u0019\u0012\t\u0005m\u0014\u0011\u0011\t\u00041\u0006u\u0014bAA@\u0007\n9aj\u001c;iS:<\u0007c\u0001-\u0002\u0004&\u0019\u0011QQ\"\u0003\u0007\u0005s\u0017\u0010\u000b\u0003\u0010\u0017\u0006%\u0015EAAF\u0003\u0015\u0011d\u0006\r\u00181\u0003i9W\r\u001e+pa&\u001cG)[:ue&\u0014W\u000f^5p]6+G\u000f[8e+\t\t\t\nE\u0004Y\u0003'\u000b9*a&\n\u0007\u0005U5IA\u0005Gk:\u001cG/[8ocA!\u0011\u0011TAP\u001b\t\tYJC\u0002\u0002\u001er\ta\u0001\\5oC2<\u0017\u0002BAQ\u00037\u0013aAV3di>\u0014\u0018a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005\u001d\u00161\u0017\t\u0005\u0003S\u000by+\u0004\u0002\u0002,*\u0019\u0011Q\u00162\u0002\u000bQL\b/Z:\n\t\u0005E\u00161\u0016\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA[#\u0001\u0007\u0011qU\u0001\u0007g\u000eDW-\\1)\u0007EY\u0015+A\rfgRLW.\u0019;fI\u0012{7mQ8oG\u0016tGO]1uS>tWCAALQ\u0011\u00112*!#\u0002\u0019Q|\u0007/[2t\u001b\u0006$(/\u001b=\u0016\u0005\u0005\r\u0007\u0003BAM\u0003\u000bLA!a2\u0002\u001c\n1Q*\u0019;sSbDCaE&\u0002\n\u0006i\u0011n\u001d#jgR\u0014\u0018NY;uK\u0012,\"!a4\u0011\u0007a\u000b\t.C\u0002\u0002T\u000e\u0013qAQ8pY\u0016\fg\u000eK\u0002\u0015\u0017F\u000bQ\u0002\\8h\u0019&\\W\r\\5i_>$G\u0003BA\n\u00037Dq!a\u001a\u0016\u0001\u0004\ti\u000e\r\u0003\u0002`\u0006\r\b#B1\u0002n\u0005\u0005\b\u0003BA:\u0003G$A\"!:\u0002\\\u0006\u0005\t\u0011!B\u0001\u0003s\u00121a\u0018\u00133Q\u0011)2*!#\u0002\u001b1|w\rU3sa2,\u00070\u001b;z)\u0011\t\u0019\"!<\t\u000f\u0005\u001dd\u00031\u0001\u0002pB\"\u0011\u0011_A{!\u0015\t\u0017QNAz!\u0011\t\u0019(!>\u0005\u0019\u0005]\u0018Q^A\u0001\u0002\u0003\u0015\t!!\u001f\u0003\u0007}#3\u0007\u000b\u0003\u0017\u0017\u0006%\u0015A\u00043fg\u000e\u0014\u0018NY3U_BL7m\u001d\u000b\u0005\u0003\u000f\ny\u0010\u0003\u0004\u0003\u0002]\u0001\raV\u0001\u0011[\u0006DH+\u001a:ngB+'\u000fV8qS\u000eD3aF&R)\t\t9\u0005K\u0002\u0019\u0017FC3\u0001A&R\u0001")
public abstract class LDAModel
extends Model<LDAModel>
implements LDAParams,
MLWritable {
    private final String uid;
    private final int vocabSize;
    private final transient SparkSession sparkSession;
    private IntParam k;
    private DoubleArrayParam docConcentration;
    private DoubleParam topicConcentration;
    private String[] supportedOptimizers;
    private Param<String> optimizer;
    private Param<String> topicDistributionCol;
    private DoubleParam learningOffset;
    private DoubleParam learningDecay;
    private DoubleParam subsamplingRate;
    private BooleanParam optimizeDocConcentration;
    private BooleanParam keepLastCheckpoint;
    private IntParam checkpointInterval;
    private LongParam seed;
    private IntParam maxIter;
    private Param<String> featuresCol;

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return LDAParams.getK$(this);
    }

    @Override
    public double[] getDocConcentration() {
        return LDAParams.getDocConcentration$(this);
    }

    @Override
    public org.apache.spark.ml.linalg.Vector getOldDocConcentration() {
        return LDAParams.getOldDocConcentration$(this);
    }

    @Override
    public double getTopicConcentration() {
        return LDAParams.getTopicConcentration$(this);
    }

    @Override
    public double getOldTopicConcentration() {
        return LDAParams.getOldTopicConcentration$(this);
    }

    @Override
    public String getOptimizer() {
        return LDAParams.getOptimizer$(this);
    }

    @Override
    public String getTopicDistributionCol() {
        return LDAParams.getTopicDistributionCol$(this);
    }

    @Override
    public double getLearningOffset() {
        return LDAParams.getLearningOffset$(this);
    }

    @Override
    public double getLearningDecay() {
        return LDAParams.getLearningDecay$(this);
    }

    @Override
    public double getSubsamplingRate() {
        return LDAParams.getSubsamplingRate$(this);
    }

    @Override
    public boolean getOptimizeDocConcentration() {
        return LDAParams.getOptimizeDocConcentration$(this);
    }

    @Override
    public boolean getKeepLastCheckpoint() {
        return LDAParams.getKeepLastCheckpoint$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return LDAParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public LDAOptimizer getOldOptimizer() {
        return LDAParams.getOldOptimizer$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final DoubleArrayParam docConcentration() {
        return this.docConcentration;
    }

    @Override
    public final DoubleParam topicConcentration() {
        return this.topicConcentration;
    }

    @Override
    public final String[] supportedOptimizers() {
        return this.supportedOptimizers;
    }

    @Override
    public final Param<String> optimizer() {
        return this.optimizer;
    }

    @Override
    public final Param<String> topicDistributionCol() {
        return this.topicDistributionCol;
    }

    @Override
    public final DoubleParam learningOffset() {
        return this.learningOffset;
    }

    @Override
    public final DoubleParam learningDecay() {
        return this.learningDecay;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final BooleanParam optimizeDocConcentration() {
        return this.optimizeDocConcentration;
    }

    @Override
    public final BooleanParam keepLastCheckpoint() {
        return this.keepLastCheckpoint;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$docConcentration_$eq(DoubleArrayParam x$1) {
        this.docConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicConcentration_$eq(DoubleParam x$1) {
        this.topicConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$supportedOptimizers_$eq(String[] x$1) {
        this.supportedOptimizers = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizer_$eq(Param<String> x$1) {
        this.optimizer = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicDistributionCol_$eq(Param<String> x$1) {
        this.topicDistributionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningOffset_$eq(DoubleParam x$1) {
        this.learningOffset = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningDecay_$eq(DoubleParam x$1) {
        this.learningDecay = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizeDocConcentration_$eq(BooleanParam x$1) {
        this.optimizeDocConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$keepLastCheckpoint_$eq(BooleanParam x$1) {
        this.keepLastCheckpoint = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public int vocabSize() {
        return this.vocabSize;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public abstract LocalLDAModel oldLocalModel();

    public abstract org.apache.spark.mllib.clustering.LDAModel getModel();

    public double[] getEffectiveDocConcentration() {
        return this.getModel().docConcentration().toArray();
    }

    public double getEffectiveTopicConcentration() {
        return this.getModel().topicConcentration();
    }

    public LDAModel setFeaturesCol(String value) {
        return (LDAModel)this.set(this.featuresCol(), value);
    }

    public LDAModel setTopicDistributionCol(String value) {
        return (LDAModel)this.set(this.topicDistributionCol(), value);
    }

    public LDAModel setSeed(long value) {
        return (LDAModel)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Function1<org.apache.spark.ml.linalg.Vector, org.apache.spark.ml.linalg.Vector> func = this.getTopicDistributionMethod();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(LDAModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(LDAModel $outer) {
            }
        }
        UserDefinedFunction transformer = functions$.MODULE$.udf(func, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(null)));
        return dataset.withColumn(this.$(this.topicDistributionCol()), transformer.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.getFeaturesCol())})), outputSchema.apply(this.$(this.topicDistributionCol())).metadata());
    }

    private Function1<org.apache.spark.ml.linalg.Vector, org.apache.spark.ml.linalg.Vector> getTopicDistributionMethod() {
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp((ClassTag)ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$).t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp((ClassTag)ClassTag$.MODULE$.Double())));
        LocalLDAModel oldModel = this.oldLocalModel();
        breeze.linalg.Vector<Object> docConcentrationBrz = oldModel.docConcentration().asBreeze();
        double gammaShape = oldModel.gammaShape();
        int k = oldModel.k();
        long gammaSeed = oldModel.seed();
        return (Function1 & Serializable)vector -> {
            org.apache.spark.ml.linalg.Vector vector2;
            block9: {
                DenseVector gamma;
                List list;
                double[] cts;
                block11: {
                    Tuple2 tuple2;
                    block10: {
                        Tuple2 tuple22;
                        block8: {
                            if (vector.numNonzeros() != 0) break block8;
                            vector2 = Vectors$.MODULE$.zeros(k);
                            break block9;
                        }
                        org.apache.spark.ml.linalg.Vector vector3 = vector;
                        if (vector3 instanceof org.apache.spark.ml.linalg.DenseVector) {
                            org.apache.spark.ml.linalg.DenseVector denseVector = (org.apache.spark.ml.linalg.DenseVector)vector3;
                            tuple22 = new Tuple2(package$.MODULE$.List().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)denseVector.size()), (Integral)Numeric.IntIsIntegral$.MODULE$), (Object)denseVector.values());
                        } else if (vector3 instanceof SparseVector) {
                            SparseVector sparseVector = (SparseVector)vector3;
                            tuple22 = new Tuple2((Object)Predef$.MODULE$.wrapIntArray(sparseVector.indices()).toList(), (Object)sparseVector.values());
                        } else {
                            throw new UnsupportedOperationException(new StringBuilder(53).append("Only sparse and dense vectors are supported but got ").append(vector3.getClass()).append(".").toString());
                        }
                        tuple2 = tuple22;
                        if (tuple2 == null) break block10;
                        List ids = (List)tuple2._1();
                        cts = (double[])tuple2._2();
                        if (ids == null) break block10;
                        list = ids;
                        if (cts != null) break block11;
                    }
                    throw new MatchError((Object)tuple2);
                }
                double[] dArray = cts;
                Tuple2 tuple2 = new Tuple2((Object)list, (Object)dArray);
                Tuple2 tuple23 = tuple2;
                List ids = (List)tuple23._1();
                double[] cts2 = (double[])tuple23._2();
                Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference((List<Object>)ids, cts2, (DenseMatrix<Object>)expElogbeta, docConcentrationBrz, gammaShape, k, gammaSeed);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                DenseVector denseVector = gamma = (DenseVector)tuple3._1();
                DenseVector gamma2 = denseVector;
                vector2 = Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()))).toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double()));
            }
            return vector2;
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block0: {
            StructType outputSchema = this.validateAndTransformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.topicDistributionCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.topicDistributionCol()), this.oldLocalModel().k());
        }
        return var2_2;
    }

    public org.apache.spark.ml.linalg.Vector estimatedDocConcentration() {
        return VectorImplicits$.MODULE$.mllibVectorToMLVector(this.getModel().docConcentration());
    }

    public Matrix topicsMatrix() {
        return this.oldLocalModel().topicsMatrix().asML();
    }

    public abstract boolean isDistributed();

    public double logLikelihood(Dataset<?> dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logLikelihood(oldDataset);
    }

    public double logPerplexity(Dataset<?> dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logPerplexity(oldDataset);
    }

    public Dataset<Row> describeTopics(int maxTermsPerTopic) {
        Tuple3[] topics = (Tuple3[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])this.getModel().describeTopics(maxTermsPerTopic)))), (Function1 & Serializable)x0$1 -> {
            int topic;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    topic = tuple22._2$mcI$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int[] termIndices = (int[])tuple2._1();
            double[] termWeights = (double[])tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)topic), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(termIndices)), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.doubleArrayOps(termWeights)));
            return tuple3;
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_ml_clustering_LDAModel$$typecreator1$2(LDAModel $outer) {
            }
        }
        return this.sparkSession().createDataFrame((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)topics), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator1$2(null))).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"topic", "termIndices", "termWeights"}));
    }

    public Dataset<Row> describeTopics() {
        return this.describeTopics(10);
    }

    public LDAModel(String uid, int vocabSize, SparkSession sparkSession) {
        this.uid = uid;
        this.vocabSize = vocabSize;
        this.sparkSession = sparkSession;
        HasFeaturesCol.$init$(this);
        HasMaxIter.$init$(this);
        HasSeed.$init$(this);
        HasCheckpointInterval.$init$(this);
        LDAParams.$init$(this);
        MLWritable.$init$(this);
        Statics.releaseFence();
    }
}

