/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.rdd.RDD;
import scala.;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class InstanceBlock$
implements Serializable {
    public static final InstanceBlock$ MODULE$ = new InstanceBlock$();
    private static final double DefaultBlockSizeInMB = 1.0;

    public double DefaultBlockSizeInMB() {
        return DefaultBlockSizeInMB;
    }

    public long org$apache$spark$ml$feature$InstanceBlock$$getBlockMemUsage(long numCols, long numRows, long nnz, boolean allUnitWeight) {
        int doubleBytes = 8;
        long arrayHeader = 12L;
        long denseSize = Matrices$.MODULE$.getDenseSize(numCols, numRows);
        long sparseSize = Matrices$.MODULE$.getSparseSize(nnz, numRows + 1L);
        long matrixSize = package$.MODULE$.min(denseSize, sparseSize);
        return allUnitWeight ? matrixSize + (long)doubleBytes * numRows + arrayHeader * 2L : matrixSize + (long)doubleBytes * numRows * 2L + arrayHeader * 2L;
    }

    public InstanceBlock fromInstances(Seq<Instance> instances) {
        double[] labels = (double[])((IterableOnceOps)instances.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.label()))).toArray((ClassTag)ClassTag$.MODULE$.Double());
        double[] weights = instances.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)InstanceBlock$.$anonfun$fromInstances$2(x$4))) ? (double[])((IterableOnceOps)instances.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5.weight()))).toArray((ClassTag)ClassTag$.MODULE$.Double()) : Array$.MODULE$.emptyDoubleArray();
        Matrix matrix = Matrices$.MODULE$.fromVectors((Seq)instances.map((Function1 & Serializable)x$6 -> x$6.features()));
        return new InstanceBlock(labels, weights, matrix);
    }

    public RDD<InstanceBlock> blokify(RDD<Instance> instances, int blockSize) {
        return instances.mapPartitions((Function1 & Serializable)x$7 -> x$7.grouped(blockSize).map((Function1 & Serializable)instances -> MODULE$.fromInstances((Seq<Instance>)instances)), instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InstanceBlock.class));
    }

    public Iterator<InstanceBlock> blokifyWithMaxMemUsage(Iterator<Instance> instanceIterator, long maxMemUsage) {
        Predef$.MODULE$.require(maxMemUsage > 0L);
        return new Iterator<InstanceBlock>(instanceIterator, maxMemUsage){
            private long numCols;
            private final Iterator instanceIterator$1;
            private final long maxMemUsage$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<InstanceBlock> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<InstanceBlock> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<InstanceBlock> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<InstanceBlock>, Iterator<InstanceBlock>> partition(Function1<InstanceBlock, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, InstanceBlock, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<InstanceBlock, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<InstanceBlock, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<InstanceBlock> filter(Function1<InstanceBlock, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<InstanceBlock> filterNot(Function1<InstanceBlock, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<InstanceBlock> filterImpl(Function1<InstanceBlock, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<InstanceBlock> withFilter(Function1<InstanceBlock, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<InstanceBlock, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<InstanceBlock> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<InstanceBlock> distinctBy(Function1<InstanceBlock, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<InstanceBlock, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<InstanceBlock, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<InstanceBlock, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<InstanceBlock> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<InstanceBlock> takeWhile(Function1<InstanceBlock, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<InstanceBlock> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<InstanceBlock> dropWhile(Function1<InstanceBlock, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<InstanceBlock>, Iterator<InstanceBlock>> span(Function1<InstanceBlock, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<InstanceBlock> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<InstanceBlock> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<InstanceBlock, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<InstanceBlock, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<InstanceBlock>, Iterator<InstanceBlock>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<InstanceBlock> tapEach(Function1<InstanceBlock, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<InstanceBlock> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<InstanceBlock>, Iterator<InstanceBlock>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<InstanceBlock, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<InstanceBlock, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<InstanceBlock, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<InstanceBlock, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<InstanceBlock> find(Function1<InstanceBlock, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, InstanceBlock, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<InstanceBlock, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, InstanceBlock, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<InstanceBlock, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, InstanceBlock, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<InstanceBlock, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, InstanceBlock, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<InstanceBlock, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<InstanceBlock> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<InstanceBlock> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<InstanceBlock> maxByOption(Function1<InstanceBlock, B> f, Ordering<B> cmp) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
            }

            public <B> Option<InstanceBlock> minByOption(Function1<InstanceBlock, B> f, Ordering<B> cmp) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
            }

            public <B> Option<B> collectFirst(PartialFunction<InstanceBlock, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, InstanceBlock, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<InstanceBlock, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<InstanceBlock, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<InstanceBlock> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<InstanceBlock> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<InstanceBlock> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<InstanceBlock, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<InstanceBlock> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<InstanceBlock> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<InstanceBlock> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<InstanceBlock> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<InstanceBlock, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private long numCols() {
                return this.numCols;
            }

            private void numCols_$eq(long x$1) {
                this.numCols = x$1;
            }

            public boolean hasNext() {
                return this.instanceIterator$1.hasNext();
            }

            public InstanceBlock next() {
                ArrayBuilder buff = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Instance.class));
                long buffCnt = 0L;
                long buffNnz = 0L;
                boolean buffUnitWeight = true;
                long blockMemUsage = 0L;
                while (this.instanceIterator$1.hasNext() && blockMemUsage < this.maxMemUsage$1) {
                    Instance instance = (Instance)this.instanceIterator$1.next();
                    if (this.numCols() < 0L) {
                        this.numCols_$eq(instance.features().size());
                    }
                    Predef$.MODULE$.require(this.numCols() == (long)instance.features().size());
                    buff.$plus$eq((Object)instance);
                    buffUnitWeight = buffUnitWeight && instance.weight() == 1.0;
                    blockMemUsage = InstanceBlock$.MODULE$.org$apache$spark$ml$feature$InstanceBlock$$getBlockMemUsage(this.numCols(), ++buffCnt, buffNnz += (long)instance.features().numNonzeros(), buffUnitWeight);
                }
                return InstanceBlock$.MODULE$.fromInstances((Seq<Instance>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(buff.result()));
            }
            {
                this.instanceIterator$1 = instanceIterator$1;
                this.maxMemUsage$1 = maxMemUsage$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.numCols = -1L;
            }
        };
    }

    public RDD<InstanceBlock> blokifyWithMaxMemUsage(RDD<Instance> instances, long maxMemUsage) {
        Predef$.MODULE$.require(maxMemUsage > 0L);
        return instances.mapPartitions((Function1 & Serializable)iter -> MODULE$.blokifyWithMaxMemUsage((Iterator<Instance>)iter, maxMemUsage), instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InstanceBlock.class));
    }

    public InstanceBlock apply(double[] labels, double[] weights, Matrix matrix) {
        return new InstanceBlock(labels, weights, matrix);
    }

    public Option<Tuple3<double[], double[], Matrix>> unapply(InstanceBlock x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.labels(), (Object)x$0.weights(), (Object)x$0.matrix()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(InstanceBlock$.class);
    }

    public static final /* synthetic */ boolean $anonfun$fromInstances$2(Instance x$4) {
        return x$4.weight() != 1.0;
    }

    private InstanceBlock$() {
    }
}

