/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.execution.command.AlterTableAddColumnsCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.types.StructField;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001>\u00111$\u00117uKJ$\u0016M\u00197f\u0003\u0012$7i\u001c7v[:\u001c8i\\7nC:$'BA\u0002\u0005\u0003\u001d\u0019w.\\7b]\u0012T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u00115y!\u0003CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u001dawnZ5dC2T!!\u0006\f\u0002\u000bAd\u0017M\\:\u000b\u0005]1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e\u0011\"\u0001\u0003'fC\u001atu\u000eZ3\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\u000fA\u0013x\u000eZ;diB\u0011q$J\u0005\u0003M\u0001\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u000b\u0001\u0003\u0016\u0004%\t!K\u0001\u0006i\u0006\u0014G.Z\u000b\u0002UA\u00111\u0006L\u0007\u0002-%\u0011QF\u0006\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"Aq\u0006\u0001B\tB\u0003%!&\u0001\u0004uC\ndW\r\t\u0005\tc\u0001\u0011)\u001a!C\u0001e\u000591m\u001c7v[:\u001cX#A\u001a\u0011\u0007QbtH\u0004\u00026u9\u0011a'O\u0007\u0002o)\u0011\u0001HD\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!a\u000f\u0011\u0002\u000fA\f7m[1hK&\u0011QH\u0010\u0002\u0004'\u0016\f(BA\u001e!!\t\u00015)D\u0001B\u0015\t\u0011e!A\u0003usB,7/\u0003\u0002E\u0003\nY1\u000b\u001e:vGR4\u0015.\u001a7e\u0011!1\u0005A!E!\u0002\u0013\u0019\u0014\u0001C2pYVlgn\u001d\u0011\t\u000b!\u0003A\u0011A%\u0002\rqJg.\u001b;?)\rQ5\n\u0014\t\u00037\u0001AQ\u0001K$A\u0002)BQ!M$A\u0002MBQA\u0014\u0001\u0005B=\u000b1A];o)\t\u0001V\u000bE\u00025yE\u0003\"AU*\u000e\u0003\u0019I!\u0001\u0016\u0004\u0003\u0007I{w\u000fC\u0003W\u001b\u0002\u0007q+\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002S1&\u0011\u0011L\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\u00067\u0002!I\u0001X\u0001\u001am\u0016\u0014\u0018NZ=BYR,'\u000fV1cY\u0016\fE\rZ\"pYVlg\u000eF\u0002^G\u001e\u0004\"AX1\u000e\u0003}S!\u0001\u0019\f\u0002\u000f\r\fG/\u00197pO&\u0011!m\u0018\u0002\r\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0005\u0006Aj\u0003\r\u0001\u001a\t\u0003=\u0016L!AZ0\u0003\u001dM+7o]5p]\u000e\u000bG/\u00197pO\")\u0001F\u0017a\u0001U!9\u0011\u000eAA\u0001\n\u0003Q\u0017\u0001B2paf$2AS6m\u0011\u001dA\u0003\u000e%AA\u0002)Bq!\r5\u0011\u0002\u0003\u00071\u0007C\u0004o\u0001E\u0005I\u0011A8\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0001O\u000b\u0002+c.\n!\u000f\u0005\u0002tq6\tAO\u0003\u0002vm\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003o\u0002\n!\"\u00198o_R\fG/[8o\u0013\tIHOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dqa\u001f\u0001\u0012\u0002\u0013\u0005A0\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003uT#aM9\t\u0011}\u0004\u0011\u0011!C!\u0003\u0003\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0002!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\tA\u0001\\1oO*\u0011\u0011QB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0012\u0005\u001d!AB*ue&tw\rC\u0005\u0002\u0016\u0001\t\t\u0011\"\u0001\u0002\u0018\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0004\t\u0004?\u0005m\u0011bAA\u000fA\t\u0019\u0011J\u001c;\t\u0013\u0005\u0005\u0002!!A\u0005\u0002\u0005\r\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003K\tY\u0003E\u0002 \u0003OI1!!\u000b!\u0005\r\te.\u001f\u0005\u000b\u0003[\ty\"!AA\u0002\u0005e\u0011a\u0001=%c!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00131G\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0007\t\u0007\u0003o\ti$!\n\u000e\u0005\u0005e\"bAA\u001eA\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0012\u0011\b\u0002\t\u0013R,'/\u0019;pe\"I\u00111\t\u0001\u0002\u0002\u0013\u0005\u0011QI\u0001\tG\u0006tW)];bYR!\u0011qIA'!\ry\u0012\u0011J\u0005\u0004\u0003\u0017\u0002#a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003[\t\t%!AA\u0002\u0005\u0015\u0002\"CA)\u0001\u0005\u0005I\u0011IA*\u0003\u0019)\u0017/^1mgR!\u0011qIA+\u0011)\ti#a\u0014\u0002\u0002\u0003\u0007\u0011QE\u0004\n\u00033\u0012\u0011\u0011!E\u0001\u00037\n1$\u00117uKJ$\u0016M\u00197f\u0003\u0012$7i\u001c7v[:\u001c8i\\7nC:$\u0007cA\u000e\u0002^\u0019A\u0011AAA\u0001\u0012\u0003\tyfE\u0003\u0002^\u0005\u0005D\u0005E\u0004\u0002d\u0005%$f\r&\u000e\u0005\u0005\u0015$bAA4A\u00059!/\u001e8uS6,\u0017\u0002BA6\u0003K\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001dA\u0015Q\fC\u0001\u0003_\"\"!a\u0017\t\u0015\u0005M\u0014QLA\u0001\n\u000b\n)(\u0001\u0005u_N#(/\u001b8h)\t\t\u0019\u0001\u0003\u0006\u0002z\u0005u\u0013\u0011!CA\u0003w\nQ!\u00199qYf$RASA?\u0003\u007fBa\u0001KA<\u0001\u0004Q\u0003BB\u0019\u0002x\u0001\u00071\u0007\u0003\u0006\u0002\u0004\u0006u\u0013\u0011!CA\u0003\u000b\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\b\u0006M\u0005#B\u0010\u0002\n\u00065\u0015bAAFA\t1q\n\u001d;j_:\u0004RaHAHUMJ1!!%!\u0005\u0019!V\u000f\u001d7fe!I\u0011QSAA\u0003\u0003\u0005\rAS\u0001\u0004q\u0012\u0002\u0004BCAM\u0003;\n\t\u0011\"\u0003\u0002\u001c\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\n\u0005\u0003\u0002\u0006\u0005}\u0015\u0002BAQ\u0003\u000f\u0011aa\u00142kK\u000e$\b")
public class AlterTableAddColumnsCommand
extends LeafNode
implements RunnableCommand,
Serializable {
    private final TableIdentifier table;
    private final Seq<StructField> columns;

    public static Option<Tuple2<TableIdentifier, Seq<StructField>>> unapply(AlterTableAddColumnsCommand alterTableAddColumnsCommand) {
        return AlterTableAddColumnsCommand$.MODULE$.unapply(alterTableAddColumnsCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Seq<StructField>>, AlterTableAddColumnsCommand> tupled() {
        return AlterTableAddColumnsCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<StructField>, AlterTableAddColumnsCommand>> curried() {
        return AlterTableAddColumnsCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier table() {
        return this.table;
    }

    public Seq<StructField> columns() {
        return this.columns;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog2 = sparkSession.sessionState().catalog();
        CatalogTable catalogTable = this.verifyAlterTableAddColumn(catalog2, this.table());
        try {
            sparkSession.catalog().uncacheTable(this.table().quotedString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when attempting to uncache table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table().quotedString()})), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        catalog2.refreshTable(this.table());
        Seq reorderedSchema = (Seq)((TraversableLike)catalogTable.dataSchema().$plus$plus(this.columns(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)catalogTable.partitionSchema(), Seq$.MODULE$.canBuildFrom());
        catalog2.alterTableSchema(this.table(), catalogTable.schema().copy((StructField[])reorderedSchema.toArray(ClassTag$.MODULE$.apply(StructField.class))));
        return (Seq)Seq$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     */
    private CatalogTable verifyAlterTableAddColumn(SessionCatalog catalog2, TableIdentifier table) {
        void var3_3;
        CatalogTable catalogTable = catalog2.getTempViewOrPermanentTableMetadata(table);
        CatalogTableType catalogTableType = catalogTable.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |ALTER ADD COLUMNS does not support views.\n          |You must drop and re-create the views for adding the new columns. Views: ", "\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (DDLUtils$.MODULE$.isDatasourceTable(catalogTable)) {
            Object obj = DataSource$.MODULE$.lookupDataSource((String)catalogTable.provider().get()).newInstance();
            boolean bl = obj instanceof JsonFileFormat ? true : (obj instanceof CSVFileFormat ? true : obj instanceof ParquetFileFormat);
            if (bl) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n              |ALTER ADD COLUMNS does not support datasource table with type ", ".\n              |You must drop and re-create the table for adding the new columns. Tables: ", "\n             "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{obj, table})))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        return var3_3;
    }

    public AlterTableAddColumnsCommand copy(TableIdentifier table, Seq<StructField> columns2) {
        return new AlterTableAddColumnsCommand(table, columns2);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public Seq<StructField> copy$default$2() {
        return this.columns();
    }

    public String productPrefix() {
        return "AlterTableAddColumnsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        TableIdentifier tableIdentifier;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                tableIdentifier = this.columns();
                break;
            }
            case 0: {
                tableIdentifier = this.table();
            }
        }
        return tableIdentifier;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableAddColumnsCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableAddColumnsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableAddColumnsCommand alterTableAddColumnsCommand = (AlterTableAddColumnsCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = alterTableAddColumnsCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<StructField> seq = this.columns();
        Seq<StructField> seq2 = alterTableAddColumnsCommand.columns();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!alterTableAddColumnsCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableAddColumnsCommand(TableIdentifier table, Seq<StructField> columns2) {
        this.table = table;
        this.columns = columns2;
        Command.class.$init$((Command)this);
    }
}

