/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.streaming.FileStreamOptions;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset$;
import org.apache.spark.sql.execution.streaming.MetadataLogFileIndex;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.Source$class;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r\u0005h\u0001B\u0001\u0003\u0001=\u0011\u0001CR5mKN#(/Z1n'>,(oY3\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\f\u001b!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0007'>,(oY3\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005}a\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005a1\u000f]1sWN+7o]5p]B\u00111\u0005J\u0007\u0002\r%\u0011QE\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005!\u0001/\u0019;i!\tICF\u0004\u0002\u0012U%\u00111FE\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,%!A\u0001\u0007\u0001B\u0001B\u0003%\u0001&A\ngS2,gi\u001c:nCR\u001cE.Y:t\u001d\u0006lW\r\u0003\u00053\u0001\t\u0015\r\u0011\"\u00114\u0003\u0019\u00198\r[3nCV\tA\u0007\u0005\u00026q5\taG\u0003\u00028\r\u0005)A/\u001f9fg&\u0011\u0011H\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u000fM\u001c\u0007.Z7bA!AQ\b\u0001B\u0001B\u0003%a(\u0001\tqCJ$\u0018\u000e^5p]\u000e{G.^7ogB\u0019qh\u0012\u0015\u000f\u0005\u0001+eBA!E\u001b\u0005\u0011%BA\"\u000f\u0003\u0019a$o\\8u}%\t1#\u0003\u0002G%\u00059\u0001/Y2lC\u001e,\u0017B\u0001%J\u0005\r\u0019V-\u001d\u0006\u0003\rJA\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\u00069q\u000e\u001d;j_:\u001c\b\u0003B\u0015PQ!J!\u0001\u0015\u0018\u0003\u00075\u000b\u0007\u000fC\u0003S\u0001\u0011\u00051+\u0001\u0004=S:LGO\u0010\u000b\t)V3v\u000bW-[7B\u0011q\u0003\u0001\u0005\u0006CE\u0003\rA\t\u0005\u0006OE\u0003\r\u0001\u000b\u0005\u0006aE\u0003\r\u0001\u000b\u0005\u0006eE\u0003\r\u0001\u000e\u0005\u0006{E\u0003\rA\u0010\u0005\u0006\u0017F\u0003\r\u0001\u000b\u0005\u0006\u001bF\u0003\rA\u0014\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u00035\u0019x.\u001e:dK>\u0003H/[8ogV\tq\f\u0005\u0002\u0018A&\u0011\u0011M\u0001\u0002\u0012\r&dWm\u0015;sK\u0006lw\n\u001d;j_:\u001c\bBB2\u0001A\u0003%q,\u0001\bt_V\u00148-Z(qi&|gn\u001d\u0011\t\u000f\u0015\u0004!\u0019!C\u0005M\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0016\u0003\u001d\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\t\r|gN\u001a\u0006\u0003Y*\ta\u0001[1e_>\u0004\u0018B\u00018j\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"1\u0001\u000f\u0001Q\u0001\n\u001d\f1\u0002[1e_>\u00048i\u001c8gA!9!\u000f\u0001b\u0001\n\u0013\u0019\u0018!E9vC2Lg-[3e\u0005\u0006\u001cX\rU1uQV\tA\u000f\u0005\u0002vq6\taO\u0003\u0002xW\u0006\u0011am]\u0005\u0003sZ\u0014A\u0001U1uQ\"11\u0010\u0001Q\u0001\nQ\f!#];bY&4\u0017.\u001a3CCN,\u0007+\u0019;iA!9Q\u0010\u0001b\u0001\n\u0013q\u0018\u0001H8qi&|gn],ji\"\u0004\u0016M\u001d;ji&|gNQ1tKB\u000bG\u000f[\u000b\u0002\u007fB1\u0011\u0011AA\u0006Q!j!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\nS6lW\u000f^1cY\u0016T1!!\u0003\u0013\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004!\u0006\r\u0001bBA\b\u0001\u0001\u0006Ia`\u0001\u001e_B$\u0018n\u001c8t/&$\b\u000eU1si&$\u0018n\u001c8CCN,\u0007+\u0019;iA!I\u00111\u0003\u0001C\u0002\u0013%\u0011QC\u0001\f[\u0016$\u0018\rZ1uC2{w-\u0006\u0002\u0002\u0018A\u0019q#!\u0007\n\u0007\u0005m!AA\nGS2,7\u000b\u001e:fC6\u001cv.\u001e:dK2{w\r\u0003\u0005\u0002 \u0001\u0001\u000b\u0011BA\f\u00031iW\r^1eCR\fGj\\4!\u0011%\t\u0019\u0003\u0001a\u0001\n\u0013\t)#\u0001\rnKR\fG-\u0019;b\u0019><7)\u001e:sK:$xJ\u001a4tKR,\"!a\n\u0011\u0007E\tI#C\u0002\u0002,I\u0011A\u0001T8oO\"I\u0011q\u0006\u0001A\u0002\u0013%\u0011\u0011G\u0001\u001d[\u0016$\u0018\rZ1uC2{wmQ;se\u0016tGo\u00144gg\u0016$x\fJ3r)\u0011\t\u0019$!\u000f\u0011\u0007E\t)$C\u0002\u00028I\u0011A!\u00168ji\"Q\u00111HA\u0017\u0003\u0003\u0005\r!a\n\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002@\u0001\u0001\u000b\u0015BA\u0014\u0003eiW\r^1eCR\fGj\\4DkJ\u0014XM\u001c;PM\u001a\u001cX\r\u001e\u0011\t\u0013\u0005\r\u0003A1A\u0005\n\u0005\u0015\u0013\u0001E7bq\u001aKG.Z:QKJ\u0014\u0015\r^2i+\t\t9\u0005E\u0003\u0012\u0003\u0013\ni%C\u0002\u0002LI\u0011aa\u00149uS>t\u0007cA\t\u0002P%\u0019\u0011\u0011\u000b\n\u0003\u0007%sG\u000f\u0003\u0005\u0002V\u0001\u0001\u000b\u0011BA$\u0003Ei\u0017\r\u001f$jY\u0016\u001c\b+\u001a:CCR\u001c\u0007\u000e\t\u0005\n\u00033\u0002!\u0019!C\u0005\u00037\nQBZ5mKN{'\u000f^(sI\u0016\u0014XCAA/!\u0019\ty&!\u001a\u0002(5\u0011\u0011\u0011\r\u0006\u0004\u0003G\u0012\u0012\u0001B7bi\"LA!a\u001a\u0002b\tAqJ\u001d3fe&tw\r\u0003\u0005\u0002l\u0001\u0001\u000b\u0011BA/\u000391\u0017\u000e\\3T_J$xJ\u001d3fe\u0002B\u0011\"a\u001c\u0001\u0005\u0004%I!!\n\u0002\u00195\f\u0007PR5mK\u0006;W-T:\t\u0011\u0005M\u0004\u0001)A\u0005\u0003O\tQ\"\\1y\r&dW-Q4f\u001bN\u0004\u0003\"CA<\u0001\t\u0007I\u0011BA=\u000311\u0017\u000e\\3OC6,wJ\u001c7z+\t\tY\bE\u0002\u0012\u0003{J1!a \u0013\u0005\u001d\u0011un\u001c7fC:D\u0001\"a!\u0001A\u0003%\u00111P\u0001\u000eM&dWMT1nK>sG.\u001f\u0011\t\u0013\u0005\u001d\u0005A1A\u0005\u0002\u0005%\u0015!C:fK:4\u0015\u000e\\3t+\t\tY\t\u0005\u0003\u0002\u000e\n-fbA\f\u0002\u0010\u001e9\u0011\u0011\u0013\u0002\t\u0002\u0005M\u0015\u0001\u0005$jY\u0016\u001cFO]3b[N{WO]2f!\r9\u0012Q\u0013\u0004\u0007\u0003\tA\t!a&\u0014\u0007\u0005U\u0005\u0003C\u0004S\u0003+#\t!a'\u0015\u0005\u0005MUaBAP\u0003+\u0003\u0011q\u0005\u0002\n)&lWm\u001d;b[B4q!a)\u0002\u0016\u0002\u000b)KA\u0005GS2,WI\u001c;ssN9\u0011\u0011\u0015\t\u0002(\u00065\u0006cA\t\u0002*&\u0019\u00111\u0016\n\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0007E\ty+C\u0002\u00022J\u0011q\u0001\u0015:pIV\u001cG\u000f\u0003\u0006(\u0003C\u0013)\u001a!C\u0001\u0003k+\u0012\u0001\u000b\u0005\u000b\u0003s\u000b\tK!E!\u0002\u0013A\u0013!\u00029bi\"\u0004\u0003bCA_\u0003C\u0013)\u001a!C\u0001\u0003\u007f\u000b\u0011\u0002^5nKN$\u0018-\u001c9\u0016\u0005\u0005\u0005\u0007\u0003BAb\u0003;k!!!&\t\u0017\u0005\u001d\u0017\u0011\u0015B\tB\u0003%\u0011\u0011Y\u0001\u000bi&lWm\u001d;b[B\u0004\u0003bCAf\u0003C\u0013)\u001a!C\u0001\u0003K\tqAY1uG\"LE\rC\u0006\u0002P\u0006\u0005&\u0011#Q\u0001\n\u0005\u001d\u0012\u0001\u00032bi\u000eD\u0017\n\u001a\u0011\t\u000fI\u000b\t\u000b\"\u0001\u0002TRA\u0011Q[Al\u00033\fY\u000e\u0005\u0003\u0002D\u0006\u0005\u0006BB\u0014\u0002R\u0002\u0007\u0001\u0006\u0003\u0005\u0002>\u0006E\u0007\u0019AAa\u0011!\tY-!5A\u0002\u0005\u001d\u0002BCAp\u0003C\u000b\t\u0011\"\u0001\u0002b\u0006!1m\u001c9z)!\t).a9\u0002f\u0006\u001d\b\u0002C\u0014\u0002^B\u0005\t\u0019\u0001\u0015\t\u0015\u0005u\u0016Q\u001cI\u0001\u0002\u0004\t\t\r\u0003\u0006\u0002L\u0006u\u0007\u0013!a\u0001\u0003OA!\"a;\u0002\"F\u0005I\u0011AAw\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a<+\u0007!\n\tp\u000b\u0002\u0002tB!\u0011Q_A\u0000\u001b\t\t9P\u0003\u0003\u0002z\u0006m\u0018!C;oG\",7m[3e\u0015\r\tiPE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0001\u0003o\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011)!!)\u0012\u0002\u0013\u0005!qA\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IA\u000b\u0003\u0002B\u0006E\bB\u0003B\u0007\u0003C\u000b\n\u0011\"\u0001\u0003\u0010\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B\tU\u0011\t9#!=\t\u0015\tU\u0011\u0011UA\u0001\n\u0003\u00129\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00053\u0001BAa\u0007\u0003&5\u0011!Q\u0004\u0006\u0005\u0005?\u0011\t#\u0001\u0003mC:<'B\u0001B\u0012\u0003\u0011Q\u0017M^1\n\u00075\u0012i\u0002\u0003\u0006\u0003*\u0005\u0005\u0016\u0011!C\u0001\u0005W\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0014\t\u0015\t=\u0012\u0011UA\u0001\n\u0003\u0011\t$\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tM\"\u0011\b\t\u0004#\tU\u0012b\u0001B\u001c%\t\u0019\u0011I\\=\t\u0015\u0005m\"QFA\u0001\u0002\u0004\ti\u0005\u0003\u0006\u0003>\u0005\u0005\u0016\u0011!C!\u0005\u007f\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u0003\u0002bAa\u0011\u0003F\tMRBAA\u0004\u0013\u0011\u00119%a\u0002\u0003\u0011%#XM]1u_JD!Ba\u0013\u0002\"\u0006\u0005I\u0011\u0001B'\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA>\u0005\u001fB!\"a\u000f\u0003J\u0005\u0005\t\u0019\u0001B\u001a\u0011)\u0011\u0019&!)\u0002\u0002\u0013\u0005#QK\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011Q\n\u0005\u000b\u00053\n\t+!A\u0005B\tm\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\te\u0001B\u0003B0\u0003C\u000b\t\u0011\"\u0011\u0003b\u00051Q-];bYN$B!a\u001f\u0003d!Q\u00111\bB/\u0003\u0003\u0005\rAa\r\b\u0015\t\u001d\u0014QSA\u0001\u0012\u0003\u0011I'A\u0005GS2,WI\u001c;ssB!\u00111\u0019B6\r)\t\u0019+!&\u0002\u0002#\u0005!QN\n\u0007\u0005W\u0012y'a*\u0011\u0017\tE$q\u000f\u0015\u0002B\u0006\u001d\u0012Q[\u0007\u0003\u0005gR1A!\u001e\u0013\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u001f\u0003t\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000fI\u0013Y\u0007\"\u0001\u0003~Q\u0011!\u0011\u000e\u0005\u000b\u00053\u0012Y'!A\u0005F\tm\u0003B\u0003BB\u0005W\n\t\u0011\"!\u0003\u0006\u0006)\u0011\r\u001d9msRA\u0011Q\u001bBD\u0005\u0013\u0013Y\t\u0003\u0004(\u0005\u0003\u0003\r\u0001\u000b\u0005\t\u0003{\u0013\t\t1\u0001\u0002B\"A\u00111\u001aBA\u0001\u0004\t9\u0003\u0003\u0006\u0003\u0010\n-\u0014\u0011!CA\u0005#\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0014\nm\u0005#B\t\u0002J\tU\u0005\u0003C\t\u0003\u0018\"\n\t-a\n\n\u0007\te%C\u0001\u0004UkBdWm\r\u0005\u000b\u0005;\u0013i)!AA\u0002\u0005U\u0017a\u0001=%a!Q!\u0011\u0015B6\u0003\u0003%IAa)\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005K\u0003BAa\u0007\u0003(&!!\u0011\u0016B\u000f\u0005\u0019y%M[3di\u001a9!QVAK\u0001\t=&\u0001D*fK:4\u0015\u000e\\3t\u001b\u0006\u00048c\u0001BV!!Y!1\u0017BV\u0005\u0003\u0005\u000b\u0011BA\u0014\u0003!i\u0017\r_!hK6\u001b\bb\u0004B\\\u0005W#\t\u0011!B\u0003\u0002\u0003\u0006I!a\u001f\u0002)>\u0014x\rJ1qC\u000eDW\rJ:qCJ\\Ge]9mI\u0015DXmY;uS>tGe\u001d;sK\u0006l\u0017N\\4%\r&dWm\u0015;sK\u0006l7k\\;sG\u0016$3+Z3o\r&dWm]'ba\u0012\"c-\u001b7f\u001d\u0006lWm\u00148ms\"9!Ka+\u0005\u0002\tmFC\u0002B_\u0005\u007f\u0013\t\r\u0005\u0003\u0002D\n-\u0006\u0002\u0003BZ\u0005s\u0003\r!a\n\t\u0011\u0005]$\u0011\u0018a\u0001\u0003wB!B!2\u0003,\n\u0007I\u0011\u0002Bd\u0003\ri\u0017\r]\u000b\u0003\u0005\u0013\u0004rAa3\u0003R\"\n\t-\u0004\u0002\u0003N*!!q\u001aB\u0011\u0003\u0011)H/\u001b7\n\t\tM'Q\u001a\u0002\b\u0011\u0006\u001c\b.T1q\u0011%\u00119Na+!\u0002\u0013\u0011I-\u0001\u0003nCB\u0004\u0003B\u0003Bn\u0005W\u0003\r\u0011\"\u0003\u0002@\u0006yA.\u0019;fgR$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0006\u0003`\n-\u0006\u0019!C\u0005\u0005C\f1\u0003\\1uKN$H+[7fgR\fW\u000e]0%KF$B!a\r\u0003d\"Q\u00111\bBo\u0003\u0003\u0005\r!!1\t\u0013\t\u001d(1\u0016Q!\n\u0005\u0005\u0017\u0001\u00057bi\u0016\u001cH\u000fV5nKN$\u0018-\u001c9!\u0011)\u0011YOa+A\u0002\u0013%\u0011qX\u0001\u0013Y\u0006\u001cH\u000fU;sO\u0016$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0006\u0003p\n-\u0006\u0019!C\u0005\u0005c\fa\u0003\\1tiB+(oZ3US6,7\u000f^1na~#S-\u001d\u000b\u0005\u0003g\u0011\u0019\u0010\u0003\u0006\u0002<\t5\u0018\u0011!a\u0001\u0003\u0003D\u0011Ba>\u0003,\u0002\u0006K!!1\u0002'1\f7\u000f\u001e)ve\u001e,G+[7fgR\fW\u000e\u001d\u0011\t\u0011\tm(1\u0016C\u0005\u0005{\fAc\u001d;sSB\u0004\u0016\r\u001e5JM:+7-Z:tCJLH\u0003\u0002B\r\u0005\u007fDaa\nB}\u0001\u0004A\u0003\u0006\u0002B}\u0007\u0007\u00012!EB\u0003\u0013\r\u00199A\u0005\u0002\u0007S:d\u0017N\\3\t\u0011\r-!1\u0016C\u0001\u0007\u001b\t1!\u00193e)\u0019\t\u0019da\u0004\u0004\u0012!1qe!\u0003A\u0002!B\u0001\"!0\u0004\n\u0001\u0007\u0011\u0011\u0019\u0005\t\u0007+\u0011Y\u000b\"\u0001\u0004\u0018\u0005I\u0011n\u001d(fo\u001aKG.\u001a\u000b\u0007\u0003w\u001aIba\u0007\t\r\u001d\u001a\u0019\u00021\u0001)\u0011!\tila\u0005A\u0002\u0005\u0005\u0007\u0002CB\u0010\u0005W#\tA!\u0016\u0002\u000bA,(oZ3\t\u0011\r\r\"1\u0016C\u0001\u0005W\tAa]5{K\"A1q\u0005\u0001!\u0002\u0013\tY)\u0001\u0006tK\u0016tg)\u001b7fg\u0002Bqaa\u000b\u0001\t\u0013\u0019i#\u0001\bgKR\u001c\u0007.T1y\u001f\u001a47/\u001a;\u0015\u0005\r=\u0002cA\f\u00042%\u001911\u0007\u0002\u0003-\u0019KG.Z*ue\u0016\fWnU8ve\u000e,wJ\u001a4tKRDqaa\u000e\u0001\t\u0003\u0019I$\u0001\nxSRD')\u0019;dQ&tw\rT8dW\u0016$W\u0003BB\u001e\u0007\u0003\"Ba!\u0010\u0004NA!1qHB!\u0019\u0001!\u0001ba\u0011\u00046\t\u00071Q\t\u0002\u0002)F!1q\tB\u001a!\r\t2\u0011J\u0005\u0004\u0007\u0017\u0012\"a\u0002(pi\"Lgn\u001a\u0005\n\u0007\u001f\u001a)\u0004\"a\u0001\u0007#\nAAZ;oGB)\u0011ca\u0015\u0004>%\u00191Q\u000b\n\u0003\u0011q\u0012\u0017P\\1nKzBqa!\u0017\u0001\t\u0003\t)#\u0001\tdkJ\u0014XM\u001c;M_\u001e|eMZ:fi\"91Q\f\u0001\u0005B\r}\u0013\u0001C4fi\n\u000bGo\u00195\u0015\r\r\u00054QPBE!\u0011\u0019\u0019ga\u001e\u000f\t\r\u00154Q\u000f\b\u0005\u0007O\u001a\u0019H\u0004\u0003\u0004j\rEd\u0002BB6\u0007_r1!QB7\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011aIB\u0005\u0005\u0007s\u001aYHA\u0005ECR\fgI]1nK*\u0011aI\u0002\u0005\t\u0007\u007f\u001aY\u00061\u0001\u0004\u0002\u0006)1\u000f^1siB)\u0011#!\u0013\u0004\u0004B\u0019qc!\"\n\u0007\r\u001d%A\u0001\u0004PM\u001a\u001cX\r\u001e\u0005\t\u0007\u0017\u001bY\u00061\u0001\u0004\u0004\u0006\u0019QM\u001c3\t\u0015\r=\u0005\u00011A\u0005\u0002\u0019\u0019\t*A\tt_V\u00148-\u001a%bg6+G/\u00193bi\u0006,\"aa%\u0011\u000bE\tI%a\u001f\t\u0015\r]\u0005\u00011A\u0005\u0002\u0019\u0019I*A\u000bt_V\u00148-\u001a%bg6+G/\u00193bi\u0006|F%Z9\u0015\t\u0005M21\u0014\u0005\u000b\u0003w\u0019)*!AA\u0002\rM\u0005\u0002CBP\u0001\u0001\u0006Kaa%\u0002%M|WO]2f\u0011\u0006\u001cX*\u001a;bI\u0006$\u0018\r\t\u0015\u0005\u0007;\u001b\u0019\u000bE\u0002\u0012\u0007KK1aa*\u0013\u0005!1x\u000e\\1uS2,\u0007bBBV\u0001\u0011%1QV\u0001\u001fC2dg)\u001b7fgV\u001b\u0018N\\4J]6+Wn\u001c:z\r&dW-\u00138eKb$\"aa,\u0011\t}:5\u0011\u0017\t\u0004k\u000eM\u0016bAB[m\nQa)\u001b7f'R\fG/^:\t\u000f\re\u0006\u0001\"\u0003\u0004.\u0006\t\u0013\r\u001c7GS2,7/V:j]\u001elU\r^1eCR\fGj\\4GS2,\u0017J\u001c3fq\"91Q\u0018\u0001\u0005\n\r}\u0016!\u00044fi\u000eD\u0017\t\u001c7GS2,7\u000f\u0006\u0002\u0004BB!qhRBb!\u0019\t2Q\u0019\u0015\u0002(%\u00191q\u0019\n\u0003\rQ+\b\u000f\\33\u0011\u001d\u0019Y\r\u0001C!\u0007\u001b\f\u0011bZ3u\u001f\u001a47/\u001a;\u0016\u0005\r\u0005\u0005b\u0002B-\u0001\u0011\u00053\u0011\u001b\u000b\u0002Q!91Q\u001b\u0001\u0005B\r]\u0017AB2p[6LG\u000f\u0006\u0003\u00024\re\u0007\u0002CBF\u0007'\u0004\raa!\t\u000f\ru\u0007\u0001\"\u0011\u0004`\u0006!1\u000f^8q)\t\t\u0019\u0004")
public class FileStreamSource
implements Source,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final String fileFormatClassName;
    private final StructType schema;
    private final Seq<String> partitionColumns;
    private final Map<String, String> options;
    private final FileStreamOptions sourceOptions;
    private final Configuration hadoopConf;
    private final Path qualifiedBasePath;
    private final Map<String, String> optionsWithPartitionBasePath;
    private final FileStreamSourceLog metadataLog;
    private long org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset;
    private final Option<Object> org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch;
    private final Ordering<Object> fileSortOrder;
    private final long org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs;
    private final boolean fileNameOnly;
    private final SeenFilesMap seenFiles;
    private volatile Option<Object> sourceHasMetadata;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    private FileStreamOptions sourceOptions() {
        return this.sourceOptions;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private Path qualifiedBasePath() {
        return this.qualifiedBasePath;
    }

    private Map<String, String> optionsWithPartitionBasePath() {
        return this.optionsWithPartitionBasePath;
    }

    private FileStreamSourceLog metadataLog() {
        return this.metadataLog;
    }

    public long org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset;
    }

    private void org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset_$eq(long x$1) {
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset = x$1;
    }

    public Option<Object> org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch;
    }

    private Ordering<Object> fileSortOrder() {
        return this.fileSortOrder;
    }

    public long org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs;
    }

    private boolean fileNameOnly() {
        return this.fileNameOnly;
    }

    public SeenFilesMap seenFiles() {
        return this.seenFiles;
    }

    private synchronized FileStreamSourceOffset fetchMaxOffset() {
        Seq newFiles = (Seq)this.fetchAllFiles().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final boolean apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String path = (String)tuple2._1();
                    long timestamp = tuple2._2$mcJ$sp();
                    boolean bl = this.$outer.seenFiles().isNewFile(path, timestamp);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq batchFiles = this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().nonEmpty() ? (Seq)newFiles.take(BoxesRunTime.unboxToInt((Object)this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().get())) : newFiles;
        batchFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(Tuple2<String, Object> file) {
                this.$outer.seenFiles().add((String)file._1(), file._2$mcJ$sp());
                this.$outer.logDebug((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int numPurged = this.seenFiles().purge();
        this.logTrace((Function0<String>)new Serializable(this, newFiles, batchFiles, numPurged){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;
            private final Seq newFiles$1;
            private final Seq batchFiles$1;
            private final int numPurged$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |Number of new files = ", "\n         |Number of files selected for batch = ", "\n         |Number of seen files = ", "\n         |Number of files purged from tracking map = ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.newFiles$1.size()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.seenFiles().size()), BoxesRunTime.boxToInteger((int)this.numPurged$1)})))).stripMargin();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newFiles$1 = newFiles$1;
                this.batchFiles$1 = batchFiles$1;
                this.numPurged$1 = numPurged$1;
            }
        });
        if (batchFiles.nonEmpty()) {
            this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset_$eq(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset() + 1L);
            this.metadataLog().add(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset(), (FileEntry[])((TraversableOnce)batchFiles.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileStreamSource $outer;

                public final FileEntry apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String p = (String)tuple2._1();
                        long timestamp = tuple2._2$mcJ$sp();
                        FileEntry fileEntry = new FileEntry(p, timestamp, this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset());
                        return fileEntry;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileEntry.class)));
            this.logInfo((Function0<String>)new Serializable(this, batchFiles){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileStreamSource $outer;
                private final Seq batchFiles$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log offset set to ", " with ", " new files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batchFiles$1 = batchFiles$1;
                }
            });
        }
        return new FileStreamSourceOffset(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset());
    }

    public synchronized <T> T withBatchingLocked(Function0<T> func) {
        return (T)func.apply();
    }

    public synchronized long currentLogOffset() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset();
    }

    @Override
    public Dataset<Row> getBatch(Option<Offset> start2, Offset end) {
        long endOffset;
        long startOffset = BoxesRunTime.unboxToLong((Object)start2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Offset x$2) {
                return FileStreamSourceOffset$.MODULE$.apply(x$2).logOffset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        Predef$.MODULE$.assert(startOffset <= (endOffset = FileStreamSourceOffset$.MODULE$.apply(end).logOffset()));
        FileEntry[] files = (FileEntry[])Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().get((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(startOffset + 1L))), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<FileEntry> apply(Tuple2<Object, FileEntry[]> x$3) {
                return Predef$.MODULE$.refArrayOps((Object[])x$3._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileEntry.class)));
        this.logInfo((Function0<String>)new Serializable(this, startOffset, endOffset, files){
            public static final long serialVersionUID = 0L;
            private final long startOffset$1;
            private final long endOffset$1;
            private final FileEntry[] files$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing ", " files from ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$1.length), BoxesRunTime.boxToLong((long)(this.startOffset$1 + 1L)), BoxesRunTime.boxToLong((long)this.endOffset$1)}));
            }
            {
                this.startOffset$1 = startOffset$1;
                this.endOffset$1 = endOffset$1;
                this.files$1 = files$1;
            }
        });
        this.logTrace((Function0<String>)new Serializable(this, files){
            public static final long serialVersionUID = 0L;
            private final FileEntry[] files$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)Predef$.MODULE$.refArrayOps((Object[])this.files$1).mkString("\n\t")).toString();
            }
            {
                this.files$1 = files$1;
            }
        });
        SparkSession x$7 = this.sparkSession;
        Seq x$8 = (Seq)Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileEntry x$4) {
                return x$4.path();
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Some x$9 = new Some((Object)this.schema());
        Seq<String> x$10 = this.partitionColumns;
        String x$11 = this.fileFormatClassName;
        Map<String, String> x$12 = this.optionsWithPartitionBasePath();
        Option<BucketSpec> x$13 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$14 = DataSource$.MODULE$.apply$default$8();
        DataSource newDataSource = new DataSource(x$7, x$11, (Seq<String>)x$8, (Option<StructType>)x$9, x$10, x$13, x$12, x$14);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)LogicalRelation$.MODULE$.apply(newDataSource.resolveRelation(false)));
    }

    public Option<Object> sourceHasMetadata() {
        return this.sourceHasMetadata;
    }

    public void sourceHasMetadata_$eq(Option<Object> x$1) {
        this.sourceHasMetadata = x$1;
    }

    private Seq<FileStatus> allFilesUsingInMemoryFileIndex() {
        Seq globbedPaths = SparkHadoopUtil$.MODULE$.get().globPathIfNecessary(this.qualifiedBasePath());
        InMemoryFileIndex fileIndex = new InMemoryFileIndex(this.sparkSession, (Seq<Path>)globbedPaths, this.options, (Option<StructType>)new Some((Object)new StructType()), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5());
        return fileIndex.allFiles();
    }

    private Seq<FileStatus> allFilesUsingMetadataLogFileIndex() {
        return new MetadataLogFileIndex(this.sparkSession, this.qualifiedBasePath()).allFiles();
    }

    private Seq<Tuple2<String, Object>> fetchAllFiles() {
        Option<Object> option;
        block14: {
            Seq<FileStatus> allFiles2;
            long startTime;
            block12: {
                boolean bl;
                Some some;
                boolean bl2;
                block13: {
                    block11: {
                        BoxedUnit boxedUnit;
                        startTime = System.nanoTime();
                        allFiles2 = null;
                        bl2 = false;
                        some = null;
                        option = this.sourceHasMetadata();
                        if (!None$.MODULE$.equals(option)) break block11;
                        if (FileStreamSink$.MODULE$.hasMetadata((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.path}))), this.hadoopConf())) {
                            this.sourceHasMetadata_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                            allFiles2 = this.allFilesUsingMetadataLogFileIndex();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            allFiles2 = this.allFilesUsingInMemoryFileIndex();
                            if (allFiles2.isEmpty()) {
                                boxedUnit = BoxedUnit.UNIT;
                            } else if (FileStreamSink$.MODULE$.hasMetadata((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.path}))), this.hadoopConf())) {
                                this.sourceHasMetadata_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                                allFiles2 = this.allFilesUsingMetadataLogFileIndex();
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.sourceHasMetadata_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        break block12;
                    }
                    if (!(option instanceof Some)) break block13;
                    bl2 = true;
                    some = (Some)option;
                    boolean bl3 = BoxesRunTime.unboxToBoolean((Object)some.x());
                    if (!bl3) break block13;
                    allFiles2 = this.allFilesUsingMetadataLogFileIndex();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block12;
                }
                if (!bl2 || (bl = BoxesRunTime.unboxToBoolean((Object)some.x()))) break block14;
                allFiles2 = this.allFilesUsingInMemoryFileIndex();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Seq files = (Seq)((TraversableLike)allFiles2.sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(FileStatus x$5) {
                    return x$5.getModificationTime();
                }
            }, this.fileSortOrder())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object> apply(FileStatus status) {
                    return new Tuple2((Object)status.getPath().toUri().toString(), (Object)BoxesRunTime.boxToLong((long)status.getModificationTime()));
                }
            }, Seq$.MODULE$.canBuildFrom());
            long endTime = System.nanoTime();
            double listingTimeMs = ((double)endTime - (double)startTime) / (double)1000000;
            if (listingTimeMs > (double)2000) {
                this.logWarning((Function0<String>)new Serializable(this, files, listingTimeMs){
                    public static final long serialVersionUID = 0L;
                    private final Seq files$2;
                    private final double listingTimeMs$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                    }
                    {
                        this.files$2 = files$2;
                        this.listingTimeMs$1 = listingTimeMs$1;
                    }
                });
            } else {
                this.logTrace((Function0<String>)new Serializable(this, files, listingTimeMs){
                    public static final long serialVersionUID = 0L;
                    private final Seq files$2;
                    private final double listingTimeMs$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                    }
                    {
                        this.files$2 = files$2;
                        this.listingTimeMs$1 = listingTimeMs$1;
                    }
                });
            }
            this.logTrace((Function0<String>)new Serializable(this, files){
                public static final long serialVersionUID = 0L;
                private final Seq files$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)this.files$2.mkString("\n\t")).toString();
                }
                {
                    this.files$2 = files$2;
                }
            });
            return files;
        }
        throw new MatchError(option);
    }

    @Override
    public Option<Offset> getOffset() {
        return new Some((Object)this.fetchMaxOffset()).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStreamSourceOffset x$6) {
                return x$6.logOffset() == -1L;
            }
        });
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileStreamSource[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.qualifiedBasePath()}));
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    public FileStreamSource(SparkSession sparkSession, String path, String fileFormatClassName, StructType schema, Seq<String> partitionColumns, String metadataPath, Map<String, String> options) {
        Ordering ordering;
        this.sparkSession = sparkSession;
        this.path = path;
        this.fileFormatClassName = fileFormatClassName;
        this.schema = schema;
        this.partitionColumns = partitionColumns;
        this.options = options;
        Source$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.sourceOptions = new FileStreamOptions(options);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        FileSystem fs = new Path(path).getFileSystem(this.hadoopConf());
        this.qualifiedBasePath = fs.makeQualified(new Path(path));
        this.optionsWithPartitionBasePath = this.sourceOptions().optionMapWithoutPath().$plus$plus((GenTraversableOnce)(!SparkHadoopUtil$.MODULE$.get().isGlobPath(new Path(path)) && options.contains((Object)"path") ? Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"basePath"), (Object)path)})) : Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), sparkSession, metadataPath);
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset = BoxesRunTime.unboxToLong((Object)this.metadataLog().getLatest().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, FileEntry[]> x$1) {
                return x$1._1$mcJ$sp();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch = this.sourceOptions().maxFilesPerTrigger();
        if (this.sourceOptions().latestFirst()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("'latestFirst' is true. New files will be processed first, which may affect the watermark\n          |value. In addition, 'maxFileAge' will be ignored.")).stripMargin();
                }
            });
            ordering = ((Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$)).reverse();
        } else {
            ordering = (Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$);
        }
        this.fileSortOrder = ordering;
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs = this.sourceOptions().latestFirst() && this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().isDefined() ? Long.MAX_VALUE : this.sourceOptions().maxFileAgeMs();
        this.fileNameOnly = this.sourceOptions().fileNameOnly();
        if (this.fileNameOnly()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "'fileNameOnly' is enabled. Make sure your file names are unique (e.g. using UUID), otherwise, files with the same name but under different paths will be considered the same and causes data lost.";
                }
            });
        }
        this.seenFiles = new SeenFilesMap(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs(), this.fileNameOnly());
        Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().allFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(FileEntry entry2) {
                this.$outer.seenFiles().add(entry2.path(), entry2.timestamp());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.seenFiles().purge();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxFilesPerBatch = ", ", maxFileAgeMs = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch(), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.sourceHasMetadata = SparkHadoopUtil$.MODULE$.get().isGlobPath(new Path(path)) ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)) : None$.MODULE$;
    }

    public static class FileEntry
    implements Serializable,
    Product {
        private final String path;
        private final long timestamp;
        private final long batchId;

        public String path() {
            return this.path;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long batchId() {
            return this.batchId;
        }

        public FileEntry copy(String path, long timestamp, long batchId) {
            return new FileEntry(path, timestamp, batchId);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.batchId();
        }

        public String productPrefix() {
            return "FileEntry";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.batchId());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                case 0: {
                    object = this.path();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileEntry;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.batchId()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileEntry)) return false;
            boolean bl = true;
            if (!bl) return false;
            FileEntry fileEntry = (FileEntry)x$1;
            String string = this.path();
            String string2 = fileEntry.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.timestamp() != fileEntry.timestamp()) return false;
            if (this.batchId() != fileEntry.batchId()) return false;
            if (!fileEntry.canEqual(this)) return false;
            return true;
        }

        public FileEntry(String path, long timestamp, long batchId) {
            this.path = path;
            this.timestamp = timestamp;
            this.batchId = batchId;
            Product.class.$init$((Product)this);
        }
    }

    public static class SeenFilesMap {
        private final long maxAgeMs;
        public final boolean org$apache$spark$sql$execution$streaming$FileStreamSource$SeenFilesMap$$fileNameOnly;
        private final HashMap<String, Object> map;
        private long latestTimestamp;
        private long lastPurgeTimestamp;

        private HashMap<String, Object> map() {
            return this.map;
        }

        private long latestTimestamp() {
            return this.latestTimestamp;
        }

        private void latestTimestamp_$eq(long x$1) {
            this.latestTimestamp = x$1;
        }

        private long lastPurgeTimestamp() {
            return this.lastPurgeTimestamp;
        }

        private void lastPurgeTimestamp_$eq(long x$1) {
            this.lastPurgeTimestamp = x$1;
        }

        private String stripPathIfNecessary(String path) {
            return this.org$apache$spark$sql$execution$streaming$FileStreamSource$SeenFilesMap$$fileNameOnly ? new Path(new URI(path)).getName() : path;
        }

        public void add(String path, long timestamp) {
            this.map().put(this.stripPathIfNecessary(path), BoxesRunTime.boxToLong((long)timestamp));
            if (timestamp > this.latestTimestamp()) {
                this.latestTimestamp_$eq(timestamp);
            }
        }

        public boolean isNewFile(String path, long timestamp) {
            return timestamp >= this.lastPurgeTimestamp() && !this.map().containsKey(this.stripPathIfNecessary(path));
        }

        /*
         * WARNING - void declaration
         */
        public int purge() {
            void var2_2;
            this.lastPurgeTimestamp_$eq(this.latestTimestamp() - this.maxAgeMs);
            java.util.Iterator<Map.Entry<String, Object>> iter = this.map().entrySet().iterator();
            int count2 = 0;
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry2 = iter.next();
                if (BoxesRunTime.unboxToLong((Object)entry2.getValue()) >= this.lastPurgeTimestamp()) continue;
                ++count2;
                iter.remove();
            }
            return (int)var2_2;
        }

        public int size() {
            return this.map().size();
        }

        public SeenFilesMap(long maxAgeMs, boolean fileNameOnly) {
            this.maxAgeMs = maxAgeMs;
            this.org$apache$spark$sql$execution$streaming$FileStreamSource$SeenFilesMap$$fileNameOnly = fileNameOnly;
            Predef$.MODULE$.require(maxAgeMs >= 0L);
            this.map = new HashMap();
            this.latestTimestamp = 0L;
            this.lastPurgeTimestamp = 0L;
        }
    }
}

