/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.sources.v2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.InputPartitionReader;
import org.apache.spark.sql.sources.v2.reader.SupportsPushDownFilters;
import org.apache.spark.sql.sources.v2.reader.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.types.StructType;

public class JavaAdvancedDataSourceV2
implements DataSourceV2,
ReadSupport {
    public DataSourceReader createReader(DataSourceOptions options) {
        return new Reader();
    }

    static class JavaAdvancedInputPartition
    implements InputPartition<InternalRow>,
    InputPartitionReader<InternalRow> {
        private int start;
        private int end;
        private StructType requiredSchema;

        JavaAdvancedInputPartition(int start, int end, StructType requiredSchema) {
            this.start = start;
            this.end = end;
            this.requiredSchema = requiredSchema;
        }

        public InputPartitionReader<InternalRow> createPartitionReader() {
            return new JavaAdvancedInputPartition(this.start - 1, this.end, this.requiredSchema);
        }

        public boolean next() {
            ++this.start;
            return this.start < this.end;
        }

        public InternalRow get() {
            Object[] values = new Object[this.requiredSchema.size()];
            for (int i = 0; i < values.length; ++i) {
                if ("i".equals(this.requiredSchema.apply(i).name())) {
                    values[i] = this.start;
                    continue;
                }
                if (!"j".equals(this.requiredSchema.apply(i).name())) continue;
                values[i] = -this.start;
            }
            return new GenericInternalRow(values);
        }

        public void close() throws IOException {
        }
    }

    public class Reader
    implements DataSourceReader,
    SupportsPushDownRequiredColumns,
    SupportsPushDownFilters {
        public StructType requiredSchema = new StructType().add("i", "int").add("j", "int");
        public Filter[] filters = new Filter[0];

        public StructType readSchema() {
            return this.requiredSchema;
        }

        public void pruneColumns(StructType requiredSchema) {
            this.requiredSchema = requiredSchema;
        }

        public Filter[] pushFilters(Filter[] filters) {
            Filter[] supported = (Filter[])Arrays.stream(filters).filter(f -> {
                if (f instanceof GreaterThan) {
                    GreaterThan gt = (GreaterThan)f;
                    return gt.attribute().equals("i") && gt.value() instanceof Integer;
                }
                return false;
            }).toArray(Filter[]::new);
            Filter[] unsupported = (Filter[])Arrays.stream(filters).filter(f -> {
                if (f instanceof GreaterThan) {
                    GreaterThan gt = (GreaterThan)f;
                    return !gt.attribute().equals("i") || !(gt.value() instanceof Integer);
                }
                return true;
            }).toArray(Filter[]::new);
            this.filters = supported;
            return unsupported;
        }

        public Filter[] pushedFilters() {
            return this.filters;
        }

        public List<InputPartition<InternalRow>> planInputPartitions() {
            ArrayList<InputPartition<InternalRow>> res = new ArrayList<InputPartition<InternalRow>>();
            Integer lowerBound = null;
            for (Filter filter : this.filters) {
                GreaterThan f;
                if (!(filter instanceof GreaterThan) || !"i".equals((f = (GreaterThan)filter).attribute()) || !(f.value() instanceof Integer)) continue;
                lowerBound = (Integer)f.value();
                break;
            }
            if (lowerBound == null) {
                res.add(new JavaAdvancedInputPartition(0, 5, this.requiredSchema));
                res.add(new JavaAdvancedInputPartition(5, 10, this.requiredSchema));
            } else if (lowerBound < 4) {
                res.add(new JavaAdvancedInputPartition(lowerBound + 1, 5, this.requiredSchema));
                res.add(new JavaAdvancedInputPartition(5, 10, this.requiredSchema));
            } else if (lowerBound < 9) {
                res.add(new JavaAdvancedInputPartition(lowerBound + 1, 10, this.requiredSchema));
            }
            return res;
        }
    }
}

