/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.sources.v2;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.InputPartitionReader;
import org.apache.spark.sql.sources.v2.reader.SupportsReportPartitioning;
import org.apache.spark.sql.sources.v2.reader.partitioning.ClusteredDistribution;
import org.apache.spark.sql.sources.v2.reader.partitioning.Distribution;
import org.apache.spark.sql.sources.v2.reader.partitioning.Partitioning;
import org.apache.spark.sql.types.StructType;

public class JavaPartitionAwareDataSource
implements DataSourceV2,
ReadSupport {
    public DataSourceReader createReader(DataSourceOptions options) {
        return new Reader();
    }

    static class SpecificInputPartition
    implements InputPartition<InternalRow>,
    InputPartitionReader<InternalRow> {
        private int[] i;
        private int[] j;
        private int current = -1;

        SpecificInputPartition(int[] i, int[] j) {
            assert (i.length == j.length);
            this.i = i;
            this.j = j;
        }

        public boolean next() throws IOException {
            ++this.current;
            return this.current < this.i.length;
        }

        public InternalRow get() {
            return new GenericInternalRow(new Object[]{this.i[this.current], this.j[this.current]});
        }

        public void close() throws IOException {
        }

        public InputPartitionReader<InternalRow> createPartitionReader() {
            return this;
        }
    }

    static class MyPartitioning
    implements Partitioning {
        MyPartitioning() {
        }

        public int numPartitions() {
            return 2;
        }

        public boolean satisfy(Distribution distribution) {
            if (distribution instanceof ClusteredDistribution) {
                String[] clusteredCols = ((ClusteredDistribution)distribution).clusteredColumns;
                return Arrays.asList(clusteredCols).contains("a");
            }
            return false;
        }
    }

    class Reader
    implements DataSourceReader,
    SupportsReportPartitioning {
        private final StructType schema = new StructType().add("a", "int").add("b", "int");

        Reader() {
        }

        public StructType readSchema() {
            return this.schema;
        }

        public List<InputPartition<InternalRow>> planInputPartitions() {
            return Arrays.asList(new SpecificInputPartition(new int[]{1, 1, 3}, new int[]{4, 4, 6}), new SpecificInputPartition(new int[]{2, 4, 4}, new int[]{6, 2, 2}));
        }

        public Partitioning outputPartitioning() {
            return new MyPartitioning();
        }
    }
}

