/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Unit$;
import scala.collection.AbstractIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rUh\u0001B\u0001\u0003\u0001=\u0011\u0011#\u00138NK6|'/\u001f$jY\u0016Le\u000eZ3y\u0015\t\u0019A!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0003\u0007\u0003%)\u00070Z2vi&|gN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u001b!\u0006\u0014H/\u001b;j_:LgnZ!xCJ,g)\u001b7f\u0013:$W\r\u001f\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005a1\u000f]1sWN+7o]5p]B\u0011q\u0003G\u0007\u0002\r%\u0011\u0011D\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005\u0011\"o\\8u!\u0006$\bn]*qK\u000eLg-[3e!\rirE\u000b\b\u0003=\u0011r!a\b\u0012\u000e\u0003\u0001R!!\t\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013'\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011aI\u0005\u0003Q%\u00121aU3r\u0015\t)c\u0005\u0005\u0002,a5\tAF\u0003\u0002.]\u0005\u0011am\u001d\u0006\u0003_)\ta\u0001[1e_>\u0004\u0018BA\u0019-\u0005\u0011\u0001\u0016\r\u001e5\t\u0011M\u0002!\u0011!Q\u0001\nQ\n!\u0002]1sC6,G/\u001a:t!\u0011)\u0014\b\u0010\u001f\u000f\u0005Y:T\"\u0001\u0014\n\u0005a2\u0013A\u0002)sK\u0012,g-\u0003\u0002;w\t\u0019Q*\u00199\u000b\u0005a2\u0003CA\u001b>\u0013\tq4H\u0001\u0004TiJLgn\u001a\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\u0006\u0019Ro]3s'B,7-\u001b4jK\u0012\u001c6\r[3nCB\u0019aG\u0011#\n\u0005\r3#AB(qi&|g\u000e\u0005\u0002F\u00116\taI\u0003\u0002H\r\u0005)A/\u001f9fg&\u0011\u0011J\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\u0002\u001f\u0019LG.Z*uCR,8oQ1dQ\u0016\u0004\"!E'\n\u00059\u0013!a\u0004$jY\u0016\u001cF/\u0019;vg\u000e\u000b7\r[3\t\u000bA\u0003A\u0011A)\u0002\rqJg.\u001b;?)\u0019\u00116\u000bV+W/B\u0011\u0011\u0003\u0001\u0005\u0006+=\u0003\rA\u0006\u0005\u00067=\u0003\r\u0001\b\u0005\u0006g=\u0003\r\u0001\u000e\u0005\u0006\u0001>\u0003\r!\u0011\u0005\b\u0017>\u0003\n\u00111\u0001M\u0011\u001dI\u0006A1A\u0005Bi\u000b\u0011B]8piB\u000bG\u000f[:\u0016\u0003m\u00032\u0001X0+\u001b\u0005i&B\u00010'\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003QuCa!\u0019\u0001!\u0002\u0013Y\u0016A\u0003:p_R\u0004\u0016\r\u001e5tA!I1\r\u0001a\u0001\u0002\u0004%I\u0001Z\u0001\u0010G\u0006\u001c\u0007.\u001a3MK\u00064g)\u001b7fgV\tQ\r\u0005\u0003gS*ZW\"A4\u000b\u0005!l\u0016aB7vi\u0006\u0014G.Z\u0005\u0003U\u001e\u0014Q\u0002T5oW\u0016$\u0007*Y:i\u001b\u0006\u0004\bCA\u0016m\u0013\tiGF\u0001\u0006GS2,7\u000b^1ukND\u0011b\u001c\u0001A\u0002\u0003\u0007I\u0011\u00029\u0002'\r\f7\r[3e\u0019\u0016\fgMR5mKN|F%Z9\u0015\u0005E$\bC\u0001\u001cs\u0013\t\u0019hE\u0001\u0003V]&$\bbB;o\u0003\u0003\u0005\r!Z\u0001\u0004q\u0012\n\u0004BB<\u0001A\u0003&Q-\u0001\tdC\u000eDW\r\u001a'fC\u001a4\u0015\u000e\\3tA!\u0012a/\u001f\t\u0003miL!a\u001f\u0014\u0003\u0011Y|G.\u0019;jY\u0016D\u0011\" \u0001A\u0002\u0003\u0007I\u0011\u0002@\u00029\r\f7\r[3e\u0019\u0016\fg\rR5s)>\u001c\u0005.\u001b7ee\u0016tg)\u001b7fgV\tq\u0010E\u00036s)\n\t\u0001\u0005\u00037\u0003\u0007Y\u0017bAA\u0003M\t)\u0011I\u001d:bs\"Y\u0011\u0011\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0006\u0003\u0001\u001a\u0017m\u00195fI2+\u0017M\u001a#jeR{7\t[5mIJ,gNR5mKN|F%Z9\u0015\u0007E\fi\u0001\u0003\u0005v\u0003\u000f\t\t\u00111\u0001\u0000\u0011\u001d\t\t\u0002\u0001Q!\n}\fQdY1dQ\u0016$G*Z1g\t&\u0014Hk\\\"iS2$'/\u001a8GS2,7\u000f\t\u0015\u0004\u0003\u001fI\bbCA\f\u0001\u0001\u0007\t\u0019!C\u0005\u00033\t1cY1dQ\u0016$\u0007+\u0019:uSRLwN\\*qK\u000e,\"!a\u0007\u0011\u0007E\ti\"C\u0002\u0002 \t\u0011Q\u0002U1si&$\u0018n\u001c8Ta\u0016\u001c\u0007bCA\u0012\u0001\u0001\u0007\t\u0019!C\u0005\u0003K\tqcY1dQ\u0016$\u0007+\u0019:uSRLwN\\*qK\u000e|F%Z9\u0015\u0007E\f9\u0003C\u0005v\u0003C\t\t\u00111\u0001\u0002\u001c!A\u00111\u0006\u0001!B\u0013\tY\"\u0001\u000bdC\u000eDW\r\u001a)beRLG/[8o'B,7\r\t\u0015\u0004\u0003SI\bbBA\u0019\u0001\u0011\u0005\u00131G\u0001\u000ea\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u0015\u0005\u0005m\u0001BBA\u001c\u0001\u0011EC-A\u0005mK\u00064g)\u001b7fg\"1\u00111\b\u0001\u0005Ry\fa\u0003\\3bM\u0012K'\u000fV8DQ&dGM]3o\r&dWm\u001d\u0005\b\u0003\u007f\u0001A\u0011IA!\u0003\u001d\u0011XM\u001a:fg\"$\u0012!\u001d\u0005\b\u0003\u000b\u0002A\u0011BA!\u0003!\u0011XM\u001a:fg\"\u0004\u0004bBA%\u0001\u0011\u0005\u00131J\u0001\u0007KF,\u0018\r\\:\u0015\t\u00055\u00131\u000b\t\u0004m\u0005=\u0013bAA)M\t9!i\\8mK\u0006t\u0007\u0002CA+\u0003\u000f\u0002\r!a\u0016\u0002\u000b=$\b.\u001a:\u0011\u0007Y\nI&C\u0002\u0002\\\u0019\u00121!\u00118z\u0011\u001d\ty\u0006\u0001C!\u0003C\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003G\u00022ANA3\u0013\r\t9G\n\u0002\u0004\u0013:$\bbBA6\u0001\u0011\u0005\u0011QN\u0001\u000eY&\u001cH\u000fT3bM\u001aKG.Z:\u0015\t\u0005=\u0014Q\u000f\t\u0005M\u0006E4.C\u0002\u0002t\u001d\u0014Q\u0002T5oW\u0016$\u0007*Y:i'\u0016$\bbBA<\u0003S\u0002\r\u0001H\u0001\u0006a\u0006$\bn]\u0004\b\u0003w\u0012\u0001\u0012AA?\u0003EIe.T3n_JLh)\u001b7f\u0013:$W\r\u001f\t\u0004#\u0005}dAB\u0001\u0003\u0011\u0003\t\ti\u0005\u0004\u0002\u0000\u0005\r\u0015\u0011\u0012\t\u0004m\u0005\u0015\u0015bAADM\t1\u0011I\\=SK\u001a\u0004B!a#\u0002\u00126\u0011\u0011Q\u0012\u0006\u0004\u0003\u001fC\u0011\u0001C5oi\u0016\u0014h.\u00197\n\t\u0005M\u0015Q\u0012\u0002\b\u0019><w-\u001b8h\u0011\u001d\u0001\u0016q\u0010C\u0001\u0003/#\"!! \u0007\u000f\u0005m\u0015q\u0010#\u0002\u001e\nI2+\u001a:jC2L'0\u00192mK\ncwnY6M_\u000e\fG/[8o'!\tI*a!\u0002 \u0006\u0015\u0006c\u0001\u001c\u0002\"&\u0019\u00111\u0015\u0014\u0003\u000fA\u0013x\u000eZ;diB\u0019a'a*\n\u0007\u0005%fE\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0006\u0002.\u0006e%Q3A\u0005\u0002\u0005=\u0016!\u00028b[\u0016\u001cXCAAY!\u00111\u00141\u0001\u001f\t\u0017\u0005U\u0016\u0011\u0014B\tB\u0003%\u0011\u0011W\u0001\u0007]\u0006lWm\u001d\u0011\t\u0017\u0005e\u0016\u0011\u0014BK\u0002\u0013\u0005\u0011qV\u0001\u0006Q>\u001cHo\u001d\u0005\f\u0003{\u000bIJ!E!\u0002\u0013\t\t,\u0001\u0004i_N$8\u000f\t\u0005\f\u0003\u0003\fIJ!f\u0001\n\u0003\t\u0019-\u0001\u0004pM\u001a\u001cX\r^\u000b\u0003\u0003\u000b\u00042ANAd\u0013\r\tIM\n\u0002\u0005\u0019>tw\rC\u0006\u0002N\u0006e%\u0011#Q\u0001\n\u0005\u0015\u0017aB8gMN,G\u000f\t\u0005\f\u0003#\fIJ!f\u0001\n\u0003\t\u0019-\u0001\u0004mK:<G\u000f\u001b\u0005\f\u0003+\fIJ!E!\u0002\u0013\t)-A\u0004mK:<G\u000f\u001b\u0011\t\u000fA\u000bI\n\"\u0001\u0002ZRQ\u00111\\Ap\u0003C\f\u0019/!:\u0011\t\u0005u\u0017\u0011T\u0007\u0003\u0003\u007fB\u0001\"!,\u0002X\u0002\u0007\u0011\u0011\u0017\u0005\t\u0003s\u000b9\u000e1\u0001\u00022\"A\u0011\u0011YAl\u0001\u0004\t)\r\u0003\u0005\u0002R\u0006]\u0007\u0019AAc\u0011)\tI/!'\u0002\u0002\u0013\u0005\u00111^\u0001\u0005G>\u0004\u0018\u0010\u0006\u0006\u0002\\\u00065\u0018q^Ay\u0003gD!\"!,\u0002hB\u0005\t\u0019AAY\u0011)\tI,a:\u0011\u0002\u0003\u0007\u0011\u0011\u0017\u0005\u000b\u0003\u0003\f9\u000f%AA\u0002\u0005\u0015\u0007BCAi\u0003O\u0004\n\u00111\u0001\u0002F\"Q\u0011q_AM#\u0003%\t!!?\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111 \u0016\u0005\u0003c\u000bip\u000b\u0002\u0002\u0000B!!\u0011\u0001B\u0006\u001b\t\u0011\u0019A\u0003\u0003\u0003\u0006\t\u001d\u0011!C;oG\",7m[3e\u0015\r\u0011IAJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0007\u0005\u0007\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011\t\"!'\u0012\u0002\u0013\u0005\u0011\u0011`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011)\u0011)\"!'\u0012\u0002\u0013\u0005!qC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011IB\u000b\u0003\u0002F\u0006u\bB\u0003B\u000f\u00033\u000b\n\u0011\"\u0001\u0003\u0018\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0004B\u0003B\u0011\u00033\u000b\t\u0011\"\u0011\u0003$\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\n\u0011\t\t\u001d\"\u0011G\u0007\u0003\u0005SQAAa\u000b\u0003.\u0005!A.\u00198h\u0015\t\u0011y#\u0001\u0003kCZ\f\u0017b\u0001 \u0003*!Q!QGAM\u0003\u0003%\tAa\u000e\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\r\u0004B\u0003B\u001e\u00033\u000b\t\u0011\"\u0001\u0003>\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA,\u0005\u007fA\u0011\"\u001eB\u001d\u0003\u0003\u0005\r!a\u0019\t\u0015\t\r\u0013\u0011TA\u0001\n\u0003\u0012)%A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\u0005E\u0003]\u0005\u0013\n9&C\u0002\u0003Lu\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u000b\u0005\u001f\nI*!A\u0005\u0002\tE\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u00055#1\u000b\u0005\nk\n5\u0013\u0011!a\u0001\u0003/B!\"a\u0018\u0002\u001a\u0006\u0005I\u0011IA1\u0011)\u0011I&!'\u0002\u0002\u0013\u0005#1L\u0001\ti>\u001cFO]5oOR\u0011!Q\u0005\u0005\u000b\u0003\u0013\nI*!A\u0005B\t}C\u0003BA'\u0005CB\u0011\"\u001eB/\u0003\u0003\u0005\r!a\u0016\b\u0015\t\u0015\u0014qPA\u0001\u0012\u0013\u00119'A\rTKJL\u0017\r\\5{C\ndWM\u00117pG.dunY1uS>t\u0007\u0003BAo\u0005S2!\"a'\u0002\u0000\u0005\u0005\t\u0012\u0002B6'\u0019\u0011IG!\u001c\u0002&Bq!q\u000eB;\u0003c\u000b\t,!2\u0002F\u0006mWB\u0001B9\u0015\r\u0011\u0019HJ\u0001\beVtG/[7f\u0013\u0011\u00119H!\u001d\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007C\u0004Q\u0005S\"\tAa\u001f\u0015\u0005\t\u001d\u0004B\u0003B-\u0005S\n\t\u0011\"\u0012\u0003\\!Q!\u0011\u0011B5\u0003\u0003%\tIa!\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\u0005m'Q\u0011BD\u0005\u0013\u0013Y\t\u0003\u0005\u0002.\n}\u0004\u0019AAY\u0011!\tILa A\u0002\u0005E\u0006\u0002CAa\u0005\u007f\u0002\r!!2\t\u0011\u0005E'q\u0010a\u0001\u0003\u000bD!Ba$\u0003j\u0005\u0005I\u0011\u0011BI\u0003\u001d)h.\u00199qYf$BAa%\u0003\u001cB!aG\u0011BK!-1$qSAY\u0003c\u000b)-!2\n\u0007\teeE\u0001\u0004UkBdW\r\u000e\u0005\u000b\u0005;\u0013i)!AA\u0002\u0005m\u0017a\u0001=%a!Q!\u0011\u0015B5\u0003\u0003%IAa)\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005K\u0003BAa\n\u0003(&!!\u0011\u0016B\u0015\u0005\u0019y%M[3di\u001a9!QVA@\t\n=&AF*fe&\fG.\u001b>bE2,g)\u001b7f'R\fG/^:\u0014\u0011\t-\u00161QAP\u0003KC1Ba-\u0003,\nU\r\u0011\"\u0001\u00036\u0006!\u0001/\u0019;i+\u0005a\u0004B\u0003B]\u0005W\u0013\t\u0012)A\u0005y\u0005)\u0001/\u0019;iA!Y\u0011\u0011\u001bBV\u0005+\u0007I\u0011AAb\u0011-\t)Na+\u0003\u0012\u0003\u0006I!!2\t\u0017\t\u0005'1\u0016BK\u0002\u0013\u0005!1Y\u0001\u0006SN$\u0015N]\u000b\u0003\u0003\u001bB1Ba2\u0003,\nE\t\u0015!\u0003\u0002N\u00051\u0011n\u001d#je\u0002B1Ba3\u0003,\nU\r\u0011\"\u0001\u0003N\u0006\u0001\"\r\\8dWJ+\u0007\u000f\\5dCRLwN\\\u000b\u0003\u0005\u001f\u00042A\u000eBi\u0013\r\u0011\u0019N\n\u0002\u0006'\"|'\u000f\u001e\u0005\f\u0005/\u0014YK!E!\u0002\u0013\u0011y-A\tcY>\u001c7NU3qY&\u001c\u0017\r^5p]\u0002B1Ba7\u0003,\nU\r\u0011\"\u0001\u0002D\u0006I!\r\\8dWNK'0\u001a\u0005\f\u0005?\u0014YK!E!\u0002\u0013\t)-\u0001\u0006cY>\u001c7nU5{K\u0002B1Ba9\u0003,\nU\r\u0011\"\u0001\u0002D\u0006\u0001Rn\u001c3jM&\u001c\u0017\r^5p]RKW.\u001a\u0005\f\u0005O\u0014YK!E!\u0002\u0013\t)-A\tn_\u0012Lg-[2bi&|g\u000eV5nK\u0002B1Ba;\u0003,\nU\r\u0011\"\u0001\u0002D\u0006Q\u0011mY2fgN$\u0016.\\3\t\u0017\t=(1\u0016B\tB\u0003%\u0011QY\u0001\fC\u000e\u001cWm]:US6,\u0007\u0005C\u0006\u0003t\n-&Q3A\u0005\u0002\tU\u0018A\u00042m_\u000e\\Gj\\2bi&|gn]\u000b\u0003\u0005o\u0004RANA\u0002\u00037D1Ba?\u0003,\nE\t\u0015!\u0003\u0003x\u0006y!\r\\8dW2{7-\u0019;j_:\u001c\b\u0005C\u0004Q\u0005W#\tAa@\u0015%\r\u000511AB\u0003\u0007\u000f\u0019Iaa\u0003\u0004\u000e\r=1\u0011\u0003\t\u0005\u0003;\u0014Y\u000bC\u0004\u00034\nu\b\u0019\u0001\u001f\t\u0011\u0005E'Q a\u0001\u0003\u000bD\u0001B!1\u0003~\u0002\u0007\u0011Q\n\u0005\t\u0005\u0017\u0014i\u00101\u0001\u0003P\"A!1\u001cB\u007f\u0001\u0004\t)\r\u0003\u0005\u0003d\nu\b\u0019AAc\u0011!\u0011YO!@A\u0002\u0005\u0015\u0007\u0002\u0003Bz\u0005{\u0004\rAa>\t\u0015\u0005%(1VA\u0001\n\u0003\u0019)\u0002\u0006\n\u0004\u0002\r]1\u0011DB\u000e\u0007;\u0019yb!\t\u0004$\r\u0015\u0002\"\u0003BZ\u0007'\u0001\n\u00111\u0001=\u0011)\t\tna\u0005\u0011\u0002\u0003\u0007\u0011Q\u0019\u0005\u000b\u0005\u0003\u001c\u0019\u0002%AA\u0002\u00055\u0003B\u0003Bf\u0007'\u0001\n\u00111\u0001\u0003P\"Q!1\\B\n!\u0003\u0005\r!!2\t\u0015\t\r81\u0003I\u0001\u0002\u0004\t)\r\u0003\u0006\u0003l\u000eM\u0001\u0013!a\u0001\u0003\u000bD!Ba=\u0004\u0014A\u0005\t\u0019\u0001B|\u0011)\t9Pa+\u0012\u0002\u0013\u00051\u0011F\u000b\u0003\u0007WQ3\u0001PA\u007f\u0011)\u0011\tBa+\u0012\u0002\u0013\u0005!q\u0003\u0005\u000b\u0005+\u0011Y+%A\u0005\u0002\rERCAB\u001aU\u0011\ti%!@\t\u0015\tu!1VI\u0001\n\u0003\u00199$\u0006\u0002\u0004:)\"!qZA\u007f\u0011)\u0019iDa+\u0012\u0002\u0013\u0005!qC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0011)\u0019\tEa+\u0012\u0002\u0013\u0005!qC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u0011)\u0019)Ea+\u0012\u0002\u0013\u0005!qC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138\u0011)\u0019IEa+\u0012\u0002\u0013\u000511J\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00139+\t\u0019iE\u000b\u0003\u0003x\u0006u\bB\u0003B\u0011\u0005W\u000b\t\u0011\"\u0011\u0003$!Q!Q\u0007BV\u0003\u0003%\tAa\u000e\t\u0015\tm\"1VA\u0001\n\u0003\u0019)\u0006\u0006\u0003\u0002X\r]\u0003\"C;\u0004T\u0005\u0005\t\u0019AA2\u0011)\u0011\u0019Ea+\u0002\u0002\u0013\u0005#Q\t\u0005\u000b\u0005\u001f\u0012Y+!A\u0005\u0002\ruC\u0003BA'\u0007?B\u0011\"^B.\u0003\u0003\u0005\r!a\u0016\t\u0015\u0005}#1VA\u0001\n\u0003\n\t\u0007\u0003\u0006\u0003Z\t-\u0016\u0011!C!\u00057B!\"!\u0013\u0003,\u0006\u0005I\u0011IB4)\u0011\tie!\u001b\t\u0013U\u001c)'!AA\u0002\u0005]sACB7\u0003\u007f\n\t\u0011#\u0003\u0004p\u000512+\u001a:jC2L'0\u00192mK\u001aKG.Z*uCR,8\u000f\u0005\u0003\u0002^\u000eEdA\u0003BW\u0003\u007f\n\t\u0011#\u0003\u0004tM11\u0011OB;\u0003K\u0003RCa\u001c\u0004xq\n)-!\u0014\u0003P\u0006\u0015\u0017QYAc\u0005o\u001c\t!\u0003\u0003\u0004z\tE$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oq!9\u0001k!\u001d\u0005\u0002\ruDCAB8\u0011)\u0011If!\u001d\u0002\u0002\u0013\u0015#1\f\u0005\u000b\u0005\u0003\u001b\t(!A\u0005\u0002\u000e\rECEB\u0001\u0007\u000b\u001b9i!#\u0004\f\u000e55qRBI\u0007'CqAa-\u0004\u0002\u0002\u0007A\b\u0003\u0005\u0002R\u000e\u0005\u0005\u0019AAc\u0011!\u0011\tm!!A\u0002\u00055\u0003\u0002\u0003Bf\u0007\u0003\u0003\rAa4\t\u0011\tm7\u0011\u0011a\u0001\u0003\u000bD\u0001Ba9\u0004\u0002\u0002\u0007\u0011Q\u0019\u0005\t\u0005W\u001c\t\t1\u0001\u0002F\"A!1_BA\u0001\u0004\u00119\u0010\u0003\u0006\u0003\u0010\u000eE\u0014\u0011!CA\u0007/#Ba!'\u0004\"B!aGQBN!I14Q\u0014\u001f\u0002F\u00065#qZAc\u0003\u000b\f)Ma>\n\u0007\r}eE\u0001\u0004UkBdW\r\u000f\u0005\u000b\u0005;\u001b)*!AA\u0002\r\u0005\u0001B\u0003BQ\u0007c\n\t\u0011\"\u0003\u0003$\"I1qUA@\t\u000311\u0011V\u0001\u0012EVd7\u000eT5ti2+\u0017M\u001a$jY\u0016\u001cHCCBV\u0007k\u001b9la2\u0004RB!QdJBW!\u001914q\u0016\u0016\u00044&\u00191\u0011\u0017\u0014\u0003\rQ+\b\u000f\\33!\rire\u001b\u0005\b\u0003o\u001a)\u000b1\u0001\u001d\u0011!\u0019Il!*A\u0002\rm\u0016A\u00035bI>|\u0007oQ8oMB!1QXBb\u001b\t\u0019yLC\u0002\u0004B:\nAaY8oM&!1QYB`\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"A1\u0011ZBS\u0001\u0004\u0019Y-\u0001\u0004gS2$XM\u001d\t\u0004W\r5\u0017bABhY\tQ\u0001+\u0019;i\r&dG/\u001a:\t\rU\u0019)\u000b1\u0001\u0017\u0011!\tY'a \u0005\n\rUGCCBZ\u0007/\u001cIna7\u0004^\"9!1WBj\u0001\u0004Q\u0003\u0002CB]\u0007'\u0004\raa/\t\u0011\r%71\u001ba\u0001\u0007\u0017D\u0001ba8\u0004T\u0002\u00071\u0011]\u0001\u000bg\u0016\u001c8/[8o\u001fB$\bc\u0001\u001cC-!A1Q]A@\t\u0003\u00199/A\btQ>,H\u000e\u001a$jYR,'oT;u)\u0011\tie!;\t\u000f\r-81\u001da\u0001y\u0005A\u0001/\u0019;i\u001d\u0006lW\r\u0003\u0006\u0004p\u0006}\u0014\u0013!C\u0001\u0007c\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCABzU\ra\u0015Q ")
public class InMemoryFileIndex
extends PartitioningAwareFileIndex {
    private final SparkSession sparkSession;
    public final FileStatusCache org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$fileStatusCache;
    private final Seq<Path> rootPaths;
    private volatile LinkedHashMap<Path, FileStatus> cachedLeafFiles;
    private volatile Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles;
    private volatile PartitionSpec org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$cachedPartitionSpec;

    public static FileStatusCache $lessinit$greater$default$5() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean shouldFilterOut(String string) {
        return InMemoryFileIndex$.MODULE$.shouldFilterOut(string);
    }

    @Override
    public Seq<Path> rootPaths() {
        return this.rootPaths;
    }

    private LinkedHashMap<Path, FileStatus> cachedLeafFiles() {
        return this.cachedLeafFiles;
    }

    private void cachedLeafFiles_$eq(LinkedHashMap<Path, FileStatus> x$1) {
        this.cachedLeafFiles = x$1;
    }

    private Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles;
    }

    private void cachedLeafDirToChildrenFiles_$eq(Map<Path, FileStatus[]> x$1) {
        this.cachedLeafDirToChildrenFiles = x$1;
    }

    public PartitionSpec org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$cachedPartitionSpec() {
        return this.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$cachedPartitionSpec;
    }

    private void org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$cachedPartitionSpec_$eq(PartitionSpec x$1) {
        this.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$cachedPartitionSpec = x$1;
    }

    @Override
    public PartitionSpec partitionSpec() {
        if (this.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$cachedPartitionSpec() == null) {
            this.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$cachedPartitionSpec_$eq(this.inferPartitioning());
        }
        this.logTrace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InMemoryFileIndex $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition spec: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$cachedPartitionSpec()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$cachedPartitionSpec();
    }

    @Override
    public LinkedHashMap<Path, FileStatus> leafFiles() {
        return this.cachedLeafFiles();
    }

    @Override
    public Map<Path, FileStatus[]> leafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles();
    }

    @Override
    public void refresh() {
        this.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$fileStatusCache.invalidateAll();
        this.refresh0();
    }

    private void refresh0() {
        LinkedHashSet<FileStatus> files = this.listLeafFiles(this.rootPaths());
        this.cachedLeafFiles_$eq((LinkedHashMap<Path, FileStatus>)((LinkedHashMap)new LinkedHashMap().$plus$plus$eq((TraversableOnce)files.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Path, FileStatus> apply(FileStatus f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getPath()), (Object)f);
            }
        }, LinkedHashSet$.MODULE$.canBuildFrom()))));
        this.cachedLeafDirToChildrenFiles_$eq((Map<Path, FileStatus[]>)Predef$.MODULE$.refArrayOps((Object[])files.toArray(ClassTag$.MODULE$.apply(FileStatus.class))).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Path apply(FileStatus x$2) {
                return x$2.getPath().getParent();
            }
        }));
        this.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$cachedPartitionSpec_$eq(null);
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof InMemoryFileIndex) {
            InMemoryFileIndex inMemoryFileIndex = (InMemoryFileIndex)object;
            Set set = this.rootPaths().toSet();
            Set set2 = inMemoryFileIndex.rootPaths().toSet();
            bl = !(set != null ? !set.equals(set2) : set2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.rootPaths().toSet().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public LinkedHashSet<FileStatus> listLeafFiles(Seq<Path> paths) {
        void var2_2;
        LinkedHashSet output2 = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer pathsToFetch = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        paths.foreach((Function1)new Serializable(this, output2, pathsToFetch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InMemoryFileIndex $outer;
            private final LinkedHashSet output$1;
            private final ArrayBuffer pathsToFetch$1;

            public final Unit$ apply(Path path) {
                Option<FileStatus[]> option;
                block4: {
                    block3: {
                        ArrayBuffer arrayBuffer;
                        block2: {
                            option = this.$outer.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$fileStatusCache.getLeafFiles(path);
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            FileStatus[] files = (FileStatus[])some.x();
                            HiveCatalogMetrics$.MODULE$.incrementFileCacheHits(files.length);
                            arrayBuffer = (AbstractIterable)this.output$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])files));
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        arrayBuffer = this.pathsToFetch$1.$plus$eq((Object)path);
                    }
                    return Unit$.MODULE$;
                }
                throw new MatchError(option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.output$1 = output$1;
                this.pathsToFetch$1 = pathsToFetch$1;
            }
        });
        PathFilter filter = FileInputFormat.getInputPathFilter((JobConf)new JobConf(this.hadoopConf(), this.getClass()));
        Seq<Tuple2<Path, Seq<FileStatus>>> discovered = InMemoryFileIndex$.MODULE$.bulkListLeafFiles((Seq<Path>)pathsToFetch, this.hadoopConf(), filter, this.sparkSession);
        discovered.foreach((Function1)new Serializable(this, output2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InMemoryFileIndex $outer;
            private final LinkedHashSet output$1;

            public final LinkedHashSet<FileStatus> apply(Tuple2<Path, Seq<FileStatus>> x0$1) {
                Tuple2<Path, Seq<FileStatus>> tuple2 = x0$1;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    Seq leafFiles = (Seq)tuple2._2();
                    HiveCatalogMetrics$.MODULE$.incrementFilesDiscovered(leafFiles.size());
                    this.$outer.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$fileStatusCache.putLeafFiles(path, (FileStatus[])leafFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)));
                    LinkedHashSet linkedHashSet = (LinkedHashSet)this.output$1.$plus$plus$eq((TraversableOnce)leafFiles);
                    return linkedHashSet;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.output$1 = output$1;
            }
        });
        return var2_2;
    }

    public InMemoryFileIndex(SparkSession sparkSession, Seq<Path> rootPathsSpecified, Map<String, String> parameters, Option<StructType> userSpecifiedSchema, FileStatusCache fileStatusCache) {
        this.sparkSession = sparkSession;
        this.org$apache$spark$sql$execution$datasources$InMemoryFileIndex$$fileStatusCache = fileStatusCache;
        super(sparkSession, parameters, userSpecifiedSchema, fileStatusCache);
        this.rootPaths = (Seq)rootPathsSpecified.filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InMemoryFileIndex $outer;

            public final boolean apply(Path x$1) {
                return FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(x$1, this.$outer.hadoopConf());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.refresh0();
    }

    public static class SerializableFileStatus
    implements Product,
    Serializable {
        private final String path;
        private final long length;
        private final boolean isDir;
        private final short blockReplication;
        private final long blockSize;
        private final long modificationTime;
        private final long accessTime;
        private final SerializableBlockLocation[] blockLocations;

        public String path() {
            return this.path;
        }

        public long length() {
            return this.length;
        }

        public boolean isDir() {
            return this.isDir;
        }

        public short blockReplication() {
            return this.blockReplication;
        }

        public long blockSize() {
            return this.blockSize;
        }

        public long modificationTime() {
            return this.modificationTime;
        }

        public long accessTime() {
            return this.accessTime;
        }

        public SerializableBlockLocation[] blockLocations() {
            return this.blockLocations;
        }

        public SerializableFileStatus copy(String path, long length, boolean isDir, short blockReplication, long blockSize, long modificationTime, long accessTime, SerializableBlockLocation[] blockLocations) {
            return new SerializableFileStatus(path, length, isDir, blockReplication, blockSize, modificationTime, accessTime, blockLocations);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.length();
        }

        public boolean copy$default$3() {
            return this.isDir();
        }

        public short copy$default$4() {
            return this.blockReplication();
        }

        public long copy$default$5() {
            return this.blockSize();
        }

        public long copy$default$6() {
            return this.modificationTime();
        }

        public long copy$default$7() {
            return this.accessTime();
        }

        public SerializableBlockLocation[] copy$default$8() {
            return this.blockLocations();
        }

        public String productPrefix() {
            return "SerializableFileStatus";
        }

        public int productArity() {
            return 8;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 7: {
                    object = this.blockLocations();
                    break;
                }
                case 6: {
                    object = BoxesRunTime.boxToLong((long)this.accessTime());
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToLong((long)this.modificationTime());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToLong((long)this.blockSize());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToShort((short)this.blockReplication());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.isDir());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.length());
                    break;
                }
                case 0: {
                    object = this.path();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializableFileStatus;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.length()));
            n = Statics.mix((int)n, (int)(this.isDir() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.blockReplication());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.blockSize()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.modificationTime()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.accessTime()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.blockLocations()));
            return Statics.finalizeHash((int)n, (int)8);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializableFileStatus)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializableFileStatus serializableFileStatus = (SerializableFileStatus)x$1;
            String string = this.path();
            String string2 = serializableFileStatus.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.length() != serializableFileStatus.length()) return false;
            if (this.isDir() != serializableFileStatus.isDir()) return false;
            if (this.blockReplication() != serializableFileStatus.blockReplication()) return false;
            if (this.blockSize() != serializableFileStatus.blockSize()) return false;
            if (this.modificationTime() != serializableFileStatus.modificationTime()) return false;
            if (this.accessTime() != serializableFileStatus.accessTime()) return false;
            if (this.blockLocations() != serializableFileStatus.blockLocations()) return false;
            if (!serializableFileStatus.canEqual(this)) return false;
            return true;
        }

        public SerializableFileStatus(String path, long length, boolean isDir, short blockReplication, long blockSize, long modificationTime, long accessTime, SerializableBlockLocation[] blockLocations) {
            this.path = path;
            this.length = length;
            this.isDir = isDir;
            this.blockReplication = blockReplication;
            this.blockSize = blockSize;
            this.modificationTime = modificationTime;
            this.accessTime = accessTime;
            this.blockLocations = blockLocations;
            Product.class.$init$((Product)this);
        }
    }

    public static class SerializableBlockLocation
    implements Product,
    Serializable {
        private final String[] names;
        private final String[] hosts;
        private final long offset;
        private final long length;

        public String[] names() {
            return this.names;
        }

        public String[] hosts() {
            return this.hosts;
        }

        public long offset() {
            return this.offset;
        }

        public long length() {
            return this.length;
        }

        public SerializableBlockLocation copy(String[] names, String[] hosts, long offset, long length) {
            return new SerializableBlockLocation(names, hosts, offset, length);
        }

        public String[] copy$default$1() {
            return this.names();
        }

        public String[] copy$default$2() {
            return this.hosts();
        }

        public long copy$default$3() {
            return this.offset();
        }

        public long copy$default$4() {
            return this.length();
        }

        public String productPrefix() {
            return "SerializableBlockLocation";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 3: {
                    object = BoxesRunTime.boxToLong((long)this.length());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.offset());
                    break;
                }
                case 1: {
                    object = this.hosts();
                    break;
                }
                case 0: {
                    object = this.names();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializableBlockLocation;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.names()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.hosts()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.offset()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.length()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializableBlockLocation)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializableBlockLocation serializableBlockLocation = (SerializableBlockLocation)x$1;
            if (this.names() != serializableBlockLocation.names()) return false;
            if (this.hosts() != serializableBlockLocation.hosts()) return false;
            if (this.offset() != serializableBlockLocation.offset()) return false;
            if (this.length() != serializableBlockLocation.length()) return false;
            if (!serializableBlockLocation.canEqual(this)) return false;
            return true;
        }

        public SerializableBlockLocation(String[] names, String[] hosts, long offset, long length) {
            this.names = names;
            this.hosts = hosts;
            this.offset = offset;
            this.length = length;
            Product.class.$init$((Product)this);
        }
    }
}

