/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import scala.collection.Iterator;

public abstract class BufferedRowIterator {
    protected LinkedList<InternalRow> currentRows = new LinkedList();
    protected UnsafeRow unsafeRow = new UnsafeRow(0);
    private long startTimeNs = System.nanoTime();
    protected int partitionIndex = -1;

    public boolean hasNext() throws IOException {
        if (this.currentRows.isEmpty()) {
            this.processNext();
        }
        return !this.currentRows.isEmpty();
    }

    public InternalRow next() {
        return this.currentRows.remove();
    }

    public long durationMs() {
        return (System.nanoTime() - this.startTimeNs) / 1000000L;
    }

    public abstract void init(int var1, Iterator<InternalRow>[] var2);

    public void append(InternalRow row) {
        this.currentRows.add(row);
    }

    public boolean stopEarly() {
        return false;
    }

    public boolean shouldStop() {
        return !this.currentRows.isEmpty();
    }

    public void incPeakExecutionMemory(long size) {
        TaskContext.get().taskMetrics().incPeakExecutionMemory(size);
    }

    protected abstract void processNext() throws IOException;
}

