/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.spark.Logging;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]c!B\u0001\u0003\u0005\tQ!\u0001\u0004#TiJ,\u0017-\\$sCBD'BA\u0002\u0005\u0003%\u0019HO]3b[&twM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\u0011\u00011\"\u0005\u000b\u0011\u00051yQ\"A\u0007\u000b\u00039\tQa]2bY\u0006L!\u0001E\u0007\u0003\r\u0005s\u0017PU3g!\ta!#\u0003\u0002\u0014\u001b\ta1+\u001a:jC2L'0\u00192mKB\u0011QCF\u0007\u0002\t%\u0011q\u0003\u0002\u0002\b\u0019><w-\u001b8h\u0011\u0015I\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u000f\u0011\u0005u\u0001Q\"\u0001\u0002\t\u000f}\u0001!\u0019!C\u0005A\u0005a\u0011N\u001c9viN#(/Z1ngV\t\u0011\u0005E\u0002#O%j\u0011a\t\u0006\u0003I\u0015\nq!\\;uC\ndWM\u0003\u0002'\u001b\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005!\u001a#aC!se\u0006L()\u001e4gKJ\u0004$A\u000b\u001a\u0011\u0007-r\u0003'D\u0001-\u0015\ti#!A\u0004egR\u0014X-Y7\n\u0005=b#\u0001D%oaV$Hi\u0015;sK\u0006l\u0007CA\u00193\u0019\u0001!\u0011b\r\u001b\u0002\u0002\u0003\u0005)\u0011\u0001\u001c\u0003\u0007}#\u0013\u0007\u0003\u00046\u0001\u0001\u0006I!I\u0001\u000eS:\u0004X\u000f^*ue\u0016\fWn\u001d\u0011\u0012\u0005]R\u0004C\u0001\u00079\u0013\tITBA\u0004O_RD\u0017N\\4\u0011\u00051Y\u0014B\u0001\u001f\u000e\u0005\r\te.\u001f\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u00035yW\u000f\u001e9viN#(/Z1ngV\t\u0001\tE\u0002#O\u0005\u0003$A\u0011$\u0011\u0007-\u001aU)\u0003\u0002EY\t9Ai\u0015;sK\u0006l\u0007CA\u0019G\t%9\u0005*!A\u0001\u0002\u000b\u0005aGA\u0002`IIBa!\u0013\u0001!\u0002\u0013\u0001\u0015AD8viB,Ho\u0015;sK\u0006l7\u000f\t\u0005\b\u0017\u0002\u0001\r\u0011\"\u0001M\u0003A\u0011X-\\3nE\u0016\u0014H)\u001e:bi&|g.F\u0001N!\tib*\u0003\u0002P\u0005\tAA)\u001e:bi&|g\u000eC\u0004R\u0001\u0001\u0007I\u0011\u0001*\u0002)I,W.Z7cKJ$UO]1uS>tw\fJ3r)\t\u0019f\u000b\u0005\u0002\r)&\u0011Q+\u0004\u0002\u0005+:LG\u000fC\u0004X!\u0006\u0005\t\u0019A'\u0002\u0007a$\u0013\u0007\u0003\u0004Z\u0001\u0001\u0006K!T\u0001\u0012e\u0016lW-\u001c2fe\u0012+(/\u0019;j_:\u0004\u0003bB.\u0001\u0001\u0004%\t\u0001X\u0001\u0015G\",7m\u001b9pS:$\u0018J\u001c)s_\u001e\u0014Xm]:\u0016\u0003u\u0003\"\u0001\u00040\n\u0005}k!a\u0002\"p_2,\u0017M\u001c\u0005\bC\u0002\u0001\r\u0011\"\u0001c\u0003a\u0019\u0007.Z2la>Lg\u000e^%o!J|wM]3tg~#S-\u001d\u000b\u0003'\u000eDqa\u00161\u0002\u0002\u0003\u0007Q\f\u0003\u0004f\u0001\u0001\u0006K!X\u0001\u0016G\",7m\u001b9pS:$\u0018J\u001c)s_\u001e\u0014Xm]:!\u0011\u001d9\u0007\u00011A\u0005\u0002!\f\u0001B_3s_RKW.Z\u000b\u0002SB\u0011QD[\u0005\u0003W\n\u0011A\u0001V5nK\"9Q\u000e\u0001a\u0001\n\u0003q\u0017\u0001\u0004>fe>$\u0016.\\3`I\u0015\fHCA*p\u0011\u001d9F.!AA\u0002%Da!\u001d\u0001!B\u0013I\u0017!\u0003>fe>$\u0016.\\3!\u0011\u001d\u0019\b\u00011A\u0005\u0002!\f\u0011b\u001d;beR$\u0016.\\3\t\u000fU\u0004\u0001\u0019!C\u0001m\u0006i1\u000f^1siRKW.Z0%KF$\"aU<\t\u000f]#\u0018\u0011!a\u0001S\"1\u0011\u0010\u0001Q!\n%\f!b\u001d;beR$\u0016.\\3!\u0011\u001dY\b\u00011A\u0005\u00021\u000bQBY1uG\"$UO]1uS>t\u0007bB?\u0001\u0001\u0004%\tA`\u0001\u0012E\u0006$8\r\u001b#ve\u0006$\u0018n\u001c8`I\u0015\fHCA*\u0000\u0011\u001d9F0!AA\u00025Cq!a\u0001\u0001A\u0003&Q*\u0001\bcCR\u001c\u0007\u000eR;sCRLwN\u001c\u0011\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n\u0005)1\u000f^1siR\u00191+a\u0003\t\u000f\u00055\u0011Q\u0001a\u0001S\u0006!A/[7f\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\tqA]3ti\u0006\u0014H\u000fF\u0002T\u0003+Aq!!\u0004\u0002\u0010\u0001\u0007\u0011\u000eC\u0004\u0002\u001a\u0001!\t!a\u0007\u0002\tM$x\u000e\u001d\u000b\u0002'\"9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0012AC:fi\u000e{g\u000e^3yiR\u00191+a\t\t\u0011\u0005\u0015\u0012Q\u0004a\u0001\u0003O\t1a]:d!\ri\u0012\u0011F\u0005\u0004\u0003W\u0011!\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011\u001d\ty\u0003\u0001C\u0001\u0003c\t\u0001c]3u\u0005\u0006$8\r\u001b#ve\u0006$\u0018n\u001c8\u0015\u0007M\u000b\u0019\u0004C\u0004\u00026\u00055\u0002\u0019A'\u0002\u0011\u0011,(/\u0019;j_:Dq!!\u000f\u0001\t\u0003\tY$\u0001\u0005sK6,WNY3s)\r\u0019\u0016Q\b\u0005\b\u0003k\t9\u00041\u0001N\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007\na\"\u00193e\u0013:\u0004X\u000f^*ue\u0016\fW\u000eF\u0002T\u0003\u000bB\u0001\"a\u0012\u0002@\u0001\u0007\u0011\u0011J\u0001\fS:\u0004X\u000f^*ue\u0016\fW\u000e\r\u0003\u0002L\u0005=\u0003\u0003B\u0016/\u0003\u001b\u00022!MA(\t-\t\t&!\u0012\u0002\u0002\u0003\u0005)\u0011\u0001\u001c\u0003\u0007}#3\u0007C\u0004\u0002V\u0001!\t!a\u0016\u0002\u001f\u0005$GmT;uaV$8\u000b\u001e:fC6$2aUA-\u0011!\tY&a\u0015A\u0002\u0005u\u0013\u0001D8viB,Ho\u0015;sK\u0006l\u0007\u0007BA0\u0003G\u0002BaK\"\u0002bA\u0019\u0011'a\u0019\u0005\u0017\u0005\u0015\u0014\u0011LA\u0001\u0002\u0003\u0015\tA\u000e\u0002\u0004?\u0012\"\u0004bBA5\u0001\u0011\u0005\u00111N\u0001\u0010O\u0016$\u0018J\u001c9viN#(/Z1ngR\u0011\u0011Q\u000e\t\u0006\u0019\u0005=\u00141O\u0005\u0004\u0003cj!!B!se\u0006L\b\u0007BA;\u0003s\u0002Ba\u000b\u0018\u0002xA\u0019\u0011'!\u001f\u0005\u0017\u0005m\u0014qMA\u0001\u0002\u0003\u0015\tA\u000e\u0002\u0004?\u0012*\u0004bBA@\u0001\u0011\u0005\u0011\u0011Q\u0001\u0011O\u0016$x*\u001e;qkR\u001cFO]3b[N$\"!a!\u0011\u000b1\ty'!\"1\t\u0005\u001d\u00151\u0012\t\u0005W\r\u000bI\tE\u00022\u0003\u0017#1\"!$\u0002~\u0005\u0005\t\u0011!B\u0001m\t\u0019q\f\n\u001c\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\u00069r-\u001a;SK\u000e,\u0017N^3s\u0013:\u0004X\u000f^*ue\u0016\fWn\u001d\u000b\u0003\u0003+\u0003R\u0001DA8\u0003/\u0003D!!'\u0002\"B)1&a'\u0002 &\u0019\u0011Q\u0014\u0017\u0003)I+7-Z5wKJLe\u000e];u\tN#(/Z1n!\r\t\u0014\u0011\u0015\u0003\f\u0003G\u000by)!A\u0001\u0002\u000b\u0005aGA\u0002`I]Bq!a*\u0001\t\u0003\tI+\u0001\nhKRLe\u000e];u'R\u0014X-Y7OC6,G\u0003BAV\u0003\u007f\u0003R\u0001DAW\u0003cK1!a,\u000e\u0005\u0019y\u0005\u000f^5p]B!\u00111WA]\u001d\ra\u0011QW\u0005\u0004\u0003ok\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002<\u0006u&AB*ue&twMC\u0002\u000286A\u0001\"!1\u0002&\u0002\u0007\u00111Y\u0001\tgR\u0014X-Y7JIB\u0019A\"!2\n\u0007\u0005\u001dWBA\u0002J]RDq!a3\u0001\t\u0003\ti-\u0001\u0007hK:,'/\u0019;f\u0015>\u00147\u000f\u0006\u0003\u0002P\u0006M\bCBAi\u0003C\f9O\u0004\u0003\u0002T\u0006ug\u0002BAk\u00037l!!a6\u000b\u0007\u0005e'$\u0001\u0004=e>|GOP\u0005\u0002\u001d%\u0019\u0011q\\\u0007\u0002\u000fA\f7m[1hK&!\u00111]As\u0005\r\u0019V-\u001d\u0006\u0004\u0003?l\u0001\u0003BAu\u0003_l!!a;\u000b\u0007\u00055(!A\u0005tG\",G-\u001e7fe&!\u0011\u0011_Av\u0005\rQuN\u0019\u0005\b\u0003\u001b\tI\r1\u0001j\u0011\u001d\t9\u0010\u0001C\u0001\u0003s\fQb\u00197fCJlU\r^1eCR\fGcA*\u0002|\"9\u0011QBA{\u0001\u0004I\u0007bBA\u0000\u0001\u0011\u0005!\u0011A\u0001\u0015kB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\u0015\u0007M\u0013\u0019\u0001C\u0004\u0002\u000e\u0005u\b\u0019A5\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n\u0005\u00192\r\\3be\u000eCWmY6q_&tG\u000fR1uCR\u00191Ka\u0003\t\u000f\u00055!Q\u0001a\u0001S\"9!q\u0002\u0001\u0005\u0002\u0005m\u0011!\u0006:fgR|'/Z\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u0005\b\u0005'\u0001A\u0011AA\u000e\u0003!1\u0018\r\\5eCR,\u0007b\u0002B\f\u0001\u0011\u0005!\u0011D\u0001\"O\u0016$X*\u0019=J]B,Ho\u0015;sK\u0006l'+Z7f[\n,'\u000fR;sCRLwN\u001c\u000b\u0002\u001b\"9!Q\u0004\u0001\u0005\n\t}\u0011aC<sSR,wJ\u00196fGR$2a\u0015B\u0011\u0011!\u0011\u0019Ca\u0007A\u0002\t\u0015\u0012aA8pgB!!q\u0005B\u0019\u001b\t\u0011IC\u0003\u0003\u0003,\t5\u0012AA5p\u0015\t\u0011y#\u0001\u0003kCZ\f\u0017\u0002\u0002B\u001a\u0005S\u0011!c\u00142kK\u000e$x*\u001e;qkR\u001cFO]3b[\"2!1\u0004B\u001c\u0005\u0007\u0002R\u0001\u0004B\u001d\u0005{I1Aa\u000f\u000e\u0005\u0019!\bN]8xgB!!q\u0005B \u0013\u0011\u0011\tE!\u000b\u0003\u0017%{U\t_2faRLwN\\\u0012\u0003\u0005{AqAa\u0012\u0001\t\u0013\u0011I%\u0001\u0006sK\u0006$wJ\u00196fGR$2a\u0015B&\u0011!\u0011iE!\u0012A\u0002\t=\u0013aA8jgB!!q\u0005B)\u0013\u0011\u0011\u0019F!\u000b\u0003#=\u0013'.Z2u\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u000b\u0004\u0003F\t]\"1\t")
public final class DStreamGraph
implements Serializable,
Logging {
    private final ArrayBuffer<InputDStream<?>> inputStreams;
    private final ArrayBuffer<DStream<?>> outputStreams;
    private Duration rememberDuration;
    private boolean checkpointInProgress;
    private Time zeroTime;
    private Time startTime;
    private Duration batchDuration;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private ArrayBuffer<InputDStream<?>> inputStreams() {
        return this.inputStreams;
    }

    private ArrayBuffer<DStream<?>> outputStreams() {
        return this.outputStreams;
    }

    public Duration rememberDuration() {
        return this.rememberDuration;
    }

    public void rememberDuration_$eq(Duration x$1) {
        this.rememberDuration = x$1;
    }

    public boolean checkpointInProgress() {
        return this.checkpointInProgress;
    }

    public void checkpointInProgress_$eq(boolean x$1) {
        this.checkpointInProgress = x$1;
    }

    public Time zeroTime() {
        return this.zeroTime;
    }

    public void zeroTime_$eq(Time x$1) {
        this.zeroTime = x$1;
    }

    public Time startTime() {
        return this.startTime;
    }

    public void startTime_$eq(Time x$1) {
        this.startTime = x$1;
    }

    public Duration batchDuration() {
        return this.batchDuration;
    }

    public void batchDuration_$eq(Duration x$1) {
        this.batchDuration = x$1;
    }

    public synchronized void start(Time time) {
        if (this.zeroTime() == null) {
            this.zeroTime_$eq(time);
            this.startTime_$eq(time);
            this.outputStreams().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DStreamGraph $outer;

                public final void apply(DStream<?> x$1) {
                    x$1.initialize(this.$outer.zeroTime());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.outputStreams().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DStreamGraph $outer;

                public final void apply(DStream<?> x$2) {
                    x$2.remember(this.$outer.rememberDuration());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.outputStreams().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(DStream<?> x$3) {
                    x$3.validateAtStart();
                }
            });
            this.inputStreams().par().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(InputDStream<?> x$4) {
                    x$4.start();
                }
            });
            return;
        }
        throw new Exception("DStream graph computation already started");
    }

    public synchronized void restart(Time time) {
        this.startTime_$eq(time);
    }

    public synchronized void stop() {
        this.inputStreams().par().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(InputDStream<?> x$5) {
                x$5.stop();
            }
        });
    }

    public synchronized void setContext(StreamingContext ssc) {
        this.outputStreams().foreach((Function1)new Serializable(this, ssc){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$1;

            public final void apply(DStream<?> x$6) {
                x$6.setContext(this.ssc$1);
            }
            {
                this.ssc$1 = ssc$1;
            }
        });
    }

    public synchronized void setBatchDuration(Duration duration) {
        if (this.batchDuration() == null) {
            this.batchDuration_$eq(duration);
            return;
        }
        throw new Exception(new StringBuilder().append((Object)"Batch duration already set as ").append((Object)this.batchDuration()).append((Object)". cannot set it again.").toString());
    }

    public synchronized void remember(Duration duration) {
        if (this.rememberDuration() == null) {
            this.rememberDuration_$eq(duration);
            return;
        }
        throw new Exception(new StringBuilder().append((Object)"Remember duration already set as ").append((Object)this.batchDuration()).append((Object)". cannot set it again.").toString());
    }

    public void addInputStream(InputDStream<?> inputStream) {
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            inputStream.setGraph(this);
            this.inputStreams().$plus$eq(inputStream);
            return;
        }
    }

    public void addOutputStream(DStream<?> outputStream) {
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            outputStream.setGraph(this);
            this.outputStreams().$plus$eq(outputStream);
            return;
        }
    }

    public synchronized InputDStream<?>[] getInputStreams() {
        return (InputDStream[])this.inputStreams().toArray(ClassTag$.MODULE$.apply(InputDStream.class));
    }

    public synchronized DStream<?>[] getOutputStreams() {
        return (DStream[])this.outputStreams().toArray(ClassTag$.MODULE$.apply(DStream.class));
    }

    public synchronized ReceiverInputDStream<?>[] getReceiverInputStreams() {
        return (ReceiverInputDStream[])((TraversableOnce)((TraversableLike)this.inputStreams().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(InputDStream<?> x$7) {
                return x$7 instanceof ReceiverInputDStream;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReceiverInputDStream<?> apply(InputDStream<?> x$8) {
                return (ReceiverInputDStream)x$8;
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ReceiverInputDStream.class));
    }

    public synchronized Option<String> getInputStreamName(int streamId) {
        return this.inputStreams().find((Function1)new Serializable(this, streamId){
            public static final long serialVersionUID = 0L;
            private final int streamId$1;

            public final boolean apply(InputDStream<?> x$9) {
                return x$9.id() == this.streamId$1;
            }
            {
                this.streamId$1 = streamId$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(InputDStream<?> x$10) {
                return x$10.name();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Seq<Job> generateJobs(Time time) {
        Object object;
        this.logDebug((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Generating jobs for time ").append((Object)this.time$1).toString();
            }
            {
                this.time$1 = time$1;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            object = this.outputStreams().flatMap((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$1;

                public final Iterable<Job> apply(DStream<?> outputStream) {
                    return Option$.MODULE$.option2Iterable(outputStream.generateJob(this.time$1));
                }
                {
                    this.time$1 = time$1;
                }
            }, ArrayBuffer$.MODULE$.canBuildFrom());
        }
        ArrayBuffer jobs = (ArrayBuffer)object;
        this.logDebug((Function0<String>)new Serializable(this, time, jobs){
            public static final long serialVersionUID = 0L;
            private final Time time$1;
            private final ArrayBuffer jobs$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Generated ").append((Object)BoxesRunTime.boxToInteger((int)this.jobs$1.length())).append((Object)" jobs for time ").append((Object)this.time$1).toString();
            }
            {
                this.time$1 = time$1;
                this.jobs$1 = jobs$1;
            }
        });
        return jobs;
    }

    public void clearMetadata(Time time) {
        this.logDebug((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Clearing metadata for time ").append((Object)this.time$2).toString();
            }
            {
                this.time$2 = time$2;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$2;

                public final void apply(DStream<?> x$11) {
                    x$11.clearMetadata(this.time$2);
                }
                {
                    this.time$2 = time$2;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            this.logDebug((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Cleared old metadata for time ").append((Object)this.time$2).toString();
                }
                {
                    this.time$2 = time$2;
                }
            });
            return;
        }
    }

    public void updateCheckpointData(Time time) {
        this.logInfo((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$3;

            public final String apply() {
                return new StringBuilder().append((Object)"Updating checkpoint data for time ").append((Object)this.time$3).toString();
            }
            {
                this.time$3 = time$3;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$3;

                public final void apply(DStream<?> x$12) {
                    x$12.updateCheckpointData(this.time$3);
                }
                {
                    this.time$3 = time$3;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            this.logInfo((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$3;

                public final String apply() {
                    return new StringBuilder().append((Object)"Updated checkpoint data for time ").append((Object)this.time$3).toString();
                }
                {
                    this.time$3 = time$3;
                }
            });
            return;
        }
    }

    public void clearCheckpointData(Time time) {
        this.logInfo((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$4;

            public final String apply() {
                return new StringBuilder().append((Object)"Clearing checkpoint data for time ").append((Object)this.time$4).toString();
            }
            {
                this.time$4 = time$4;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$4;

                public final void apply(DStream<?> x$13) {
                    x$13.clearCheckpointData(this.time$4);
                }
                {
                    this.time$4 = time$4;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            this.logInfo((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$4;

                public final String apply() {
                    return new StringBuilder().append((Object)"Cleared checkpoint data for time ").append((Object)this.time$4).toString();
                }
                {
                    this.time$4 = time$4;
                }
            });
            return;
        }
    }

    public void restoreCheckpointData() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Restoring checkpoint data";
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(DStream<?> x$14) {
                    x$14.restoreCheckpointData();
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Restored checkpoint data";
                }
            });
            return;
        }
    }

    public synchronized void validate() {
        Predef$.MODULE$.require(this.batchDuration() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Batch duration has not been set";
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])this.getOutputStreams()).size() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "No output operations registered, so nothing to execute";
            }
        });
    }

    public Duration getMaxInputStreamRememberDuration() {
        return (Duration)((TraversableOnce)this.inputStreams().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Duration apply(InputDStream<?> x$15) {
                return x$15.rememberDuration();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).maxBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Duration x$16) {
                return x$16.milliseconds();
            }
        }, (Ordering)Ordering.Long$.MODULE$);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)new Serializable(this, oos){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;
            private final ObjectOutputStream oos$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "DStreamGraph.writeObject used";
                    }
                });
                DStreamGraph dStreamGraph = this.$outer;
                synchronized (dStreamGraph) {
                    this.$outer.checkpointInProgress_$eq(true);
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Enabled checkpoint mode";
                        }
                    });
                    this.oos$1.defaultWriteObject();
                    this.$outer.checkpointInProgress_$eq(false);
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Disabled checkpoint mode";
                        }
                    });
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.oos$1 = oos$1;
            }
        });
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)new Serializable(this, ois){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;
            private final ObjectInputStream ois$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "DStreamGraph.readObject used";
                    }
                });
                DStreamGraph dStreamGraph = this.$outer;
                synchronized (dStreamGraph) {
                    this.$outer.checkpointInProgress_$eq(true);
                    this.ois$1.defaultReadObject();
                    this.$outer.checkpointInProgress_$eq(false);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ois$1 = ois$1;
            }
        });
    }

    public DStreamGraph() {
        Logging.class.$init$((Logging)this);
        this.inputStreams = new ArrayBuffer();
        this.outputStreams = new ArrayBuffer();
        this.rememberDuration = null;
        this.checkpointInProgress = false;
        this.zeroTime = null;
        this.startTime = null;
        this.batchDuration = null;
    }
}

