/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import org.apache.spark.rdd.BlockRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD$;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005mb!B\u0001\u0003\u0003\u0003i!\u0001\u0006*fG\u0016Lg/\u001a:J]B,H\u000fR*ue\u0016\fWN\u0003\u0002\u0004\t\u00059Am\u001d;sK\u0006l'BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001)\"AD\u000b\u0014\u0005\u0001y\u0001c\u0001\t\u0012'5\t!!\u0003\u0002\u0013\u0005\ta\u0011J\u001c9vi\u0012\u001bFO]3b[B\u0011A#\u0006\u0007\u0001\t\u00151\u0002A1\u0001\u0018\u0005\u0005!\u0016C\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!G\u0010\n\u0005\u0001R\"aA!os\"A!\u0005\u0001B\u0001B\u0003%1%\u0001\u0003tg\u000e|\u0006C\u0001\u0013&\u001b\u0005!\u0011B\u0001\u0014\u0005\u0005A\u0019FO]3b[&twmQ8oi\u0016DH\u000f\u000b\u0002\"QA\u0011\u0011$K\u0005\u0003Ui\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u00111\u0002!1!Q\u0001\f5\n!\"\u001a<jI\u0016t7-\u001a\u00132!\rq\u0013gE\u0007\u0002_)\u0011\u0001GG\u0001\be\u00164G.Z2u\u0013\t\u0011tF\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011\u0015!\u0004\u0001\"\u00016\u0003\u0019a\u0014N\\5u}Q\u0011a'\u000f\u000b\u0003oa\u00022\u0001\u0005\u0001\u0014\u0011\u0015a3\u0007q\u0001.\u0011\u0015\u00113\u00071\u0001$\u0011!Y\u0004A1A\u0005R\u0011a\u0014A\u0004:bi\u0016\u001cuN\u001c;s_2dWM]\u000b\u0002{A\u0019\u0011D\u0010!\n\u0005}R\"AB(qi&|g\u000e\u0005\u0002B\t6\t!I\u0003\u0002D\t\u0005I1o\u00195fIVdWM]\u0005\u0003\u000b\n\u0013aBU1uK\u000e{g\u000e\u001e:pY2,'\u000f\u0003\u0004H\u0001\u0001\u0006I!P\u0001\u0010e\u0006$XmQ8oiJ|G\u000e\\3sA!)\u0011\n\u0001D\u0001\u0015\u0006Yq-\u001a;SK\u000e,\u0017N^3s)\u0005Y\u0005c\u0001'P'5\tQJ\u0003\u0002O\t\u0005A!/Z2fSZ,'/\u0003\u0002Q\u001b\nA!+Z2fSZ,'\u000fC\u0003S\u0001\u0011\u00051+A\u0003ti\u0006\u0014H\u000fF\u0001U!\tIR+\u0003\u0002W5\t!QK\\5u\u0011\u0015A\u0006\u0001\"\u0001T\u0003\u0011\u0019Ho\u001c9\t\u000bi\u0003A\u0011I.\u0002\u000f\r|W\u000e];uKR\u0011Al\u0019\t\u00043yj\u0006c\u00010b'5\tqL\u0003\u0002a\r\u0005\u0019!\u000f\u001a3\n\u0005\t|&a\u0001*E\t\")A-\u0017a\u0001K\u0006Ia/\u00197jIRKW.\u001a\t\u0003I\u0019L!a\u001a\u0003\u0003\tQKW.\u001a\u0005\u0007S\u0002!\t\u0001\u00026\u0002\u001d\r\u0014X-\u0019;f\u00052|7m\u001b*E\tR\u0019Ql[7\t\u000b1D\u0007\u0019A3\u0002\tQLW.\u001a\u0005\u0006]\"\u0004\ra\\\u0001\u000bE2|7m[%oM>\u001c\bc\u00019yw:\u0011\u0011O\u001e\b\u0003eVl\u0011a\u001d\u0006\u0003i2\ta\u0001\u0010:p_Rt\u0014\"A\u000e\n\u0005]T\u0012a\u00029bG.\fw-Z\u0005\u0003sj\u00141aU3r\u0015\t9(\u0004\u0005\u0002By&\u0011QP\u0011\u0002\u0012%\u0016\u001cW-\u001b<fI\ncwnY6J]\u001a|gAB@\u0001\u0001\u0011\t\tA\u0001\fSK\u000e,\u0017N^3s%\u0006$XmQ8oiJ|G\u000e\\3s'\tq\b\t\u0003\u0007\u0002\u0006y\u0014\t\u0011)A\u0005\u0003\u000f\ti!\u0001\u0002jIB\u0019\u0011$!\u0003\n\u0007\u0005-!DA\u0002J]RL1!a\u0004E\u0003%\u0019HO]3b[VKE\t\u0003\u0006\u0002\u0014y\u0014\t\u0011)A\u0005\u0003+\t\u0011\"Z:uS6\fGo\u001c:\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007C\u0003\u0011\u0011\u0018\r^3\n\t\u0005}\u0011\u0011\u0004\u0002\u000e%\u0006$X-R:uS6\fGo\u001c:\t\rQrH\u0011AA\u0012)\u0019\t)#!\u000b\u0002,A\u0019\u0011q\u0005@\u000e\u0003\u0001A\u0001\"!\u0002\u0002\"\u0001\u0007\u0011q\u0001\u0005\t\u0003'\t\t\u00031\u0001\u0002\u0016!9\u0011q\u0006@\u0005B\u0005E\u0012a\u00029vE2L7\u000f\u001b\u000b\u0004)\u0006M\u0002\u0002CA\u000e\u0003[\u0001\r!!\u000e\u0011\u0007e\t9$C\u0002\u0002:i\u0011A\u0001T8oO\u0002")
public abstract class ReceiverInputDStream<T>
extends InputDStream<T> {
    private final ClassTag<T> evidence$1;
    private final Option<RateController> rateController;

    @Override
    public Option<RateController> rateController() {
        return this.rateController;
    }

    public abstract Receiver<T> getReceiver();

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Option<RDD<T>> compute(Time validTime) {
        RDD<T> rDD;
        if (validTime.$less(this.graph().startTime())) {
            rDD = new RDD<T>(this.ssc().sc(), (BlockId[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(BlockId.class)), this.evidence$1);
        } else {
            ReceiverTracker receiverTracker = this.ssc().scheduler().receiverTracker();
            Seq blockInfos = (Seq)receiverTracker.getBlocksOfBatch(validTime).getOrElse((Object)BoxesRunTime.boxToInteger((int)this.id()), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Seq<Nothing$> apply() {
                    return (Seq)Seq$.MODULE$.empty();
                }
            });
            StreamInputInfo inputInfo = new StreamInputInfo(this.id(), BoxesRunTime.unboxToLong((Object)((TraversableOnce)blockInfos.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<Object> apply(ReceivedBlockInfo x$1) {
                    return Option$.MODULE$.option2Iterable(x$1.numRecords());
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), StreamInputInfo$.MODULE$.apply$default$3());
            this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
            rDD = this.createBlockRDD(validTime, (Seq<ReceivedBlockInfo>)blockInfos);
        }
        RDD<T> blockRDD = rDD;
        return new Some((Object)blockRDD);
    }

    public RDD<T> createBlockRDD(Time time, Seq<ReceivedBlockInfo> blockInfos) {
        WriteAheadLogBackedBlockRDD<T> writeAheadLogBackedBlockRDD;
        if (blockInfos.nonEmpty()) {
            BlockId[] blockIds = (BlockId[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BlockId apply(ReceivedBlockInfo x$2) {
                    return x$2.blockId();
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(BlockId.class));
            boolean areWALRecordHandlesPresent = blockInfos.forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ReceivedBlockInfo x$3) {
                    return x$3.walRecordHandleOption().nonEmpty();
                }
            });
            if (areWALRecordHandlesPresent) {
                boolean[] isBlockIdValid = (boolean[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ReceivedBlockInfo x$4) {
                        return x$4.isBlockIdValid();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
                WriteAheadLogRecordHandle[] walRecordHandles = (WriteAheadLogRecordHandle[])((TraversableOnce)blockInfos.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final WriteAheadLogRecordHandle apply(ReceivedBlockInfo x$5) {
                        return (WriteAheadLogRecordHandle)x$5.walRecordHandleOption().get();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class));
                writeAheadLogBackedBlockRDD = new WriteAheadLogBackedBlockRDD<T>(this.ssc().sparkContext(), blockIds, walRecordHandles, isBlockIdValid, WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$5(), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), this.evidence$1);
            } else {
                BlockId[] validBlockIds;
                if (blockInfos.find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ReceivedBlockInfo x$6) {
                        return x$6.walRecordHandleOption().nonEmpty();
                    }
                }).nonEmpty()) {
                    if (WriteAheadLogUtils$.MODULE$.enableReceiverLog(this.ssc().conf())) {
                        this.logError((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Some blocks do not have Write Ahead Log information; this is unexpected and data may not be recoverable after driver failures";
                            }
                        });
                    } else {
                        this.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Some blocks have Write Ahead Log information; this is unexpected";
                            }
                        });
                    }
                }
                if (Predef$.MODULE$.refArrayOps((Object[])(validBlockIds = (BlockId[])Predef$.MODULE$.refArrayOps((Object[])blockIds).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReceiverInputDStream $outer;

                    public final boolean apply(BlockId id) {
                        return this.$outer.ssc().sparkContext().env().blockManager().master().contains(id);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }))).size() != Predef$.MODULE$.refArrayOps((Object[])blockIds).size()) {
                    this.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Some blocks could not be recovered as they were not found in memory. To prevent such data loss, enabled Write Ahead Log (see programming guide for more details.";
                        }
                    });
                }
                writeAheadLogBackedBlockRDD = new BlockRDD(this.ssc().sc(), validBlockIds, this.evidence$1);
            }
        } else {
            writeAheadLogBackedBlockRDD = WriteAheadLogUtils$.MODULE$.enableReceiverLog(this.ssc().conf()) ? new WriteAheadLogBackedBlockRDD<T>(this.ssc().sparkContext(), (BlockId[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(BlockId.class)), (WriteAheadLogRecordHandle[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class)), (boolean[])Array$.MODULE$.empty(ClassTag$.MODULE$.Boolean()), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$5(), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), this.evidence$1) : new BlockRDD(this.ssc().sc(), (BlockId[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(BlockId.class)), this.evidence$1);
        }
        return writeAheadLogBackedBlockRDD;
    }

    public ReceiverInputDStream(StreamingContext ssc_, ClassTag<T> evidence$1) {
        this.evidence$1 = evidence$1;
        super(ssc_, evidence$1);
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some((Object)new ReceiverRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.ssc().graph().batchDuration()))) : None$.MODULE$;
    }

    public class ReceiverRateController
    extends RateController {
        @Override
        public void publish(long rate) {
            this.org$apache$spark$streaming$dstream$ReceiverInputDStream$ReceiverRateController$$$outer().ssc().scheduler().receiverTracker().sendRateUpdate(super.streamUID(), rate);
        }

        public /* synthetic */ ReceiverInputDStream org$apache$spark$streaming$dstream$ReceiverInputDStream$ReceiverRateController$$$outer() {
            return ReceiverInputDStream.this;
        }

        public ReceiverRateController(int id, RateEstimator estimator) {
            if (ReceiverInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }
}

