/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.BlockGenerator$;
import org.apache.spark.streaming.receiver.BlockGenerator$Block$;
import org.apache.spark.streaming.receiver.BlockGenerator$GeneratorState$;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.RateLimiter;
import org.apache.spark.streaming.util.RecurringTimer;
import org.apache.spark.util.Clock;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\ra!B\u0001\u0003\u0001\u0011a!A\u0004\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d\u0006\u0003\u0007\u0011\t\u0001B]3dK&4XM\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0012!\tqq\"D\u0001\u0003\u0013\t\u0001\"AA\u0006SCR,G*[7ji\u0016\u0014\bC\u0001\n\u0014\u001b\u00051\u0011B\u0001\u000b\u0007\u0005\u001daunZ4j]\u001eD\u0001B\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\tY&\u001cH/\u001a8fe\u000e\u0001\u0001C\u0001\b\u001a\u0013\tQ\"A\u0001\fCY>\u001c7nR3oKJ\fGo\u001c:MSN$XM\\3s\u0011!a\u0002A!A!\u0002\u0013i\u0012A\u0003:fG\u0016Lg/\u001a:JIB\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t\u0019\u0011J\u001c;\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\nAaY8oMB\u0011!CJ\u0005\u0003O\u0019\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011%\u0002!\u0011!Q\u0001\n)\nQa\u00197pG.\u0004\"a\u000b\u0018\u000e\u00031R!!\f\u0004\u0002\tU$\u0018\u000e\\\u0005\u0003_1\u0012Qa\u00117pG.DQ!\r\u0001\u0005\u0002I\na\u0001P5oSRtD#B\u001a5kY:\u0004C\u0001\b\u0001\u0011\u00151\u0002\u00071\u0001\u0019\u0011\u0015a\u0002\u00071\u0001\u001e\u0011\u0015!\u0003\u00071\u0001&\u0011\u001dI\u0003\u0007%AA\u0002)2A!\u000f\u0001Eu\t)!\t\\8dWN!\u0001h\u000f B!\tqB(\u0003\u0002>?\t1\u0011I\\=SK\u001a\u0004\"AH \n\u0005\u0001{\"a\u0002)s_\u0012,8\r\u001e\t\u0003=\tK!aQ\u0010\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0015C$Q3A\u0005\u0002\u0019\u000b!!\u001b3\u0016\u0003\u001d\u0003\"\u0001S&\u000e\u0003%S!A\u0013\u0004\u0002\u000fM$xN]1hK&\u0011A*\u0013\u0002\u000e'R\u0014X-Y7CY>\u001c7.\u00133\t\u00119C$\u0011#Q\u0001\n\u001d\u000b1!\u001b3!\u0011!\u0001\u0006H!f\u0001\n\u0003\t\u0016A\u00022vM\u001a,'/F\u0001S!\r\u0019\u0006LW\u0007\u0002)*\u0011QKV\u0001\b[V$\u0018M\u00197f\u0015\t9v$\u0001\u0006d_2dWm\u0019;j_:L!!\u0017+\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003=mK!\u0001X\u0010\u0003\u0007\u0005s\u0017\u0010\u0003\u0005_q\tE\t\u0015!\u0003S\u0003\u001d\u0011WO\u001a4fe\u0002BQ!\r\u001d\u0005\u0002\u0001$2!Y2e!\t\u0011\u0007(D\u0001\u0001\u0011\u0015)u\f1\u0001H\u0011\u0015\u0001v\f1\u0001S\u0011\u001d1\u0007(!A\u0005\u0002\u001d\fAaY8qsR\u0019\u0011\r[5\t\u000f\u0015+\u0007\u0013!a\u0001\u000f\"9\u0001+\u001aI\u0001\u0002\u0004\u0011\u0006bB69#\u0003%\t\u0001\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005i'FA$oW\u0005y\u0007C\u00019v\u001b\u0005\t(B\u0001:t\u0003%)hn\u00195fG.,GM\u0003\u0002u?\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\f(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9\u0001\u0010OI\u0001\n\u0003I\u0018AD2paf$C-\u001a4bk2$HEM\u000b\u0002u*\u0012!K\u001c\u0005\byb\n\t\u0011\"\u0011~\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\ta\u0010E\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0005Y\u0006twM\u0003\u0002\u0002\b\u0005!!.\u0019<b\u0013\u0011\tY!!\u0001\u0003\rM#(/\u001b8h\u0011%\ty\u0001OA\u0001\n\u0003\t\t\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001\u001e\u0011%\t)\u0002OA\u0001\n\u0003\t9\"\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007i\u000bI\u0002C\u0005\u0002\u001c\u0005M\u0011\u0011!a\u0001;\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005}\u0001(!A\u0005B\u0005\u0005\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\r\u0002#BA\u0013\u0003OQV\"\u0001,\n\u0007\u0005%bK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\ti\u0003OA\u0001\n\u0003\ty#\u0001\u0005dC:,\u0015/^1m)\u0011\t\t$a\u000e\u0011\u0007y\t\u0019$C\u0002\u00026}\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002\u001c\u0005-\u0012\u0011!a\u00015\"I\u00111\b\u001d\u0002\u0002\u0013\u0005\u0013QH\u0001\tQ\u0006\u001c\bnQ8eKR\tQ\u0004C\u0005\u0002Ba\n\t\u0011\"\u0011\u0002D\u0005AAo\\*ue&tw\rF\u0001\u007f\u0011%\t9\u0005OA\u0001\n\u0003\nI%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003c\tY\u0005C\u0005\u0002\u001c\u0005\u0015\u0013\u0011!a\u00015\u001eI\u0011q\n\u0001\u0002\u0002#%\u0011\u0011K\u0001\u0006\u00052|7m\u001b\t\u0004E\u0006Mc\u0001C\u001d\u0001\u0003\u0003EI!!\u0016\u0014\u000b\u0005M\u0013qK!\u0011\u000f\u0005e\u0013qL$SC6\u0011\u00111\f\u0006\u0004\u0003;z\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003C\nYFA\tBEN$(/Y2u\rVt7\r^5p]JBq!MA*\t\u0003\t)\u0007\u0006\u0002\u0002R!Q\u0011\u0011IA*\u0003\u0003%)%a\u0011\t\u0015\u0005-\u00141KA\u0001\n\u0003\u000bi'A\u0003baBd\u0017\u0010F\u0003b\u0003_\n\t\b\u0003\u0004F\u0003S\u0002\ra\u0012\u0005\u0007!\u0006%\u0004\u0019\u0001*\t\u0015\u0005U\u00141KA\u0001\n\u0003\u000b9(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0014Q\u0011\t\u0006=\u0005m\u0014qP\u0005\u0004\u0003{z\"AB(qi&|g\u000eE\u0003\u001f\u0003\u0003;%+C\u0002\u0002\u0004~\u0011a\u0001V;qY\u0016\u0014\u0004\"CAD\u0003g\n\t\u00111\u0001b\u0003\rAH\u0005\r\u0005\u000b\u0003\u0017\u000b\u0019&!A\u0005\n\u00055\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a$\u0011\u0007}\f\t*\u0003\u0003\u0002\u0014\u0006\u0005!AB(cU\u0016\u001cGoB\u0004\u0002\u0018\u0002AI!!'\u0002\u001d\u001d+g.\u001a:bi>\u00148\u000b^1uKB\u0019!-a'\u0007\u000f\u0005u\u0005\u0001#\u0003\u0002 \nqq)\u001a8fe\u0006$xN]*uCR,7\u0003BAN\u0003C\u00032AHAR\u0013\r\t)k\b\u0002\f\u000b:,X.\u001a:bi&|g\u000eC\u00042\u00037#\t!!+\u0015\u0005\u0005eUaBAO\u00037\u0003\u0011Q\u0016\t\u0005\u0003_\u000b\t,\u0004\u0002\u0002\u001c&!\u00111WAR\u0005\u00151\u0016\r\\;f\u0011)\t9,a'C\u0002\u0013\u0005\u0011\u0011X\u0001\f\u0013:LG/[1mSj,G-\u0006\u0002\u0002.\"I\u0011QXANA\u0003%\u0011QV\u0001\r\u0013:LG/[1mSj,G\r\t\u0005\u000b\u0003\u0003\fYJ1A\u0005\u0002\u0005e\u0016AB!di&4X\rC\u0005\u0002F\u0006m\u0005\u0015!\u0003\u0002.\u00069\u0011i\u0019;jm\u0016\u0004\u0003BCAe\u00037\u0013\r\u0011\"\u0001\u0002:\u0006\t2\u000b^8qa\u0016$\u0017\t\u001a3j]\u001e$\u0015\r^1\t\u0013\u00055\u00171\u0014Q\u0001\n\u00055\u0016AE*u_B\u0004X\rZ!eI&tw\rR1uC\u0002B!\"!5\u0002\u001c\n\u0007I\u0011AA]\u0003]\u0019Fo\u001c9qK\u0012<UM\\3sCRLgn\u001a\"m_\u000e\\7\u000fC\u0005\u0002V\u0006m\u0005\u0015!\u0003\u0002.\u0006A2\u000b^8qa\u0016$w)\u001a8fe\u0006$\u0018N\\4CY>\u001c7n\u001d\u0011\t\u0015\u0005e\u00171\u0014b\u0001\n\u0003\tI,\u0001\u0006Ti>\u0004\b/\u001a3BY2D\u0011\"!8\u0002\u001c\u0002\u0006I!!,\u0002\u0017M#x\u000e\u001d9fI\u0006cG\u000e\t\u0005\n\u0003C\u0004!\u0019!C\u0005\u0003G\fqB\u00197pG.Le\u000e^3sm\u0006dWj]\u000b\u0003\u0003K\u00042AHAt\u0013\r\tIo\b\u0002\u0005\u0019>tw\r\u0003\u0005\u0002n\u0002\u0001\u000b\u0011BAs\u0003A\u0011Gn\\2l\u0013:$XM\u001d<bY6\u001b\b\u0005C\u0005\u0002r\u0002\u0011\r\u0011\"\u0003\u0002t\u0006\u0011\"\r\\8dW&sG/\u001a:wC2$\u0016.\\3s+\t\t)\u0010\u0005\u0003\u0002x\u0006mXBAA}\u0015\tiC!\u0003\u0003\u0002~\u0006e(A\u0004*fGV\u0014(/\u001b8h)&lWM\u001d\u0005\t\u0005\u0003\u0001\u0001\u0015!\u0003\u0002v\u0006\u0019\"\r\\8dW&sG/\u001a:wC2$\u0016.\\3sA!I!Q\u0001\u0001C\u0002\u0013%\u0011\u0011C\u0001\u000fE2|7m[)vKV,7+\u001b>f\u0011\u001d\u0011I\u0001\u0001Q\u0001\nu\tqB\u00197pG.\fV/Z;f'&TX\r\t\u0005\n\u0005\u001b\u0001!\u0019!C\u0005\u0005\u001f\t\u0001C\u00197pG.\u001chi\u001c:QkND\u0017N\\4\u0016\u0005\tE\u0001#\u0002B\n\u00057\tWB\u0001B\u000b\u0015\u0011\u00119B!\u0007\u0002\u0015\r|gnY;se\u0016tGOC\u0002.\u0003\u000bIAA!\b\u0003\u0016\t\u0011\u0012I\u001d:bs\ncwnY6j]\u001e\fV/Z;f\u0011!\u0011\t\u0003\u0001Q\u0001\n\tE\u0011!\u00052m_\u000e\\7OR8s!V\u001c\b.\u001b8hA!I!Q\u0005\u0001C\u0002\u0013%!qE\u0001\u0013E2|7m\u001b)vg\"Lgn\u001a+ie\u0016\fG-\u0006\u0002\u0003*A\u0019qPa\u000b\n\t\t5\u0012\u0011\u0001\u0002\u0007)\"\u0014X-\u00193\t\u0011\tE\u0002\u0001)A\u0005\u0005S\t1C\u00197pG.\u0004Vo\u001d5j]\u001e$\u0006N]3bI\u0002B\u0001B!\u000e\u0001\u0001\u0004%I!U\u0001\u000eGV\u0014(/\u001a8u\u0005V4g-\u001a:\t\u0013\te\u0002\u00011A\u0005\n\tm\u0012!E2veJ,g\u000e\u001e\"vM\u001a,'o\u0018\u0013fcR!!Q\bB\"!\rq\"qH\u0005\u0004\u0005\u0003z\"\u0001B+oSRD\u0011\"a\u0007\u00038\u0005\u0005\t\u0019\u0001*\t\u000f\t\u001d\u0003\u0001)Q\u0005%\u0006q1-\u001e:sK:$()\u001e4gKJ\u0004\u0003\u0006\u0002B#\u0005\u0017\u00022A\bB'\u0013\r\u0011ye\b\u0002\tm>d\u0017\r^5mK\"I!1\u000b\u0001A\u0002\u0013%!QK\u0001\u0006gR\fG/Z\u000b\u0003\u0005/\u0002BA!\u0017\u00022:\u0019!-!&\t\u0013\tu\u0003\u00011A\u0005\n\t}\u0013!C:uCR,w\fJ3r)\u0011\u0011iD!\u0019\t\u0015\u0005m!1LA\u0001\u0002\u0004\u00119\u0006\u0003\u0005\u0003f\u0001\u0001\u000b\u0015\u0002B,\u0003\u0019\u0019H/\u0019;fA!\"!1\rB&\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005[\nQa\u001d;beR$\"A!\u0010\t\u000f\tE\u0004\u0001\"\u0001\u0003n\u0005!1\u000f^8q\u0011\u001d\u0011)\b\u0001C\u0001\u0005o\nq!\u00193e\t\u0006$\u0018\r\u0006\u0003\u0003>\te\u0004b\u0002B>\u0005g\u0002\rAW\u0001\u0005I\u0006$\u0018\rC\u0004\u0003\u0000\u0001!\tA!!\u0002'\u0005$G\rR1uC^KG\u000f[\"bY2\u0014\u0017mY6\u0015\r\tu\"1\u0011BC\u0011\u001d\u0011YH! A\u0002iCqAa\"\u0003~\u0001\u0007!,\u0001\u0005nKR\fG-\u0019;b\u0011\u001d\u0011Y\t\u0001C\u0001\u0005\u001b\u000b1$\u00193e\u001bVdG/\u001b9mK\u0012\u000bG/Y,ji\"\u001c\u0015\r\u001c7cC\u000e\\GC\u0002B\u001f\u0005\u001f\u0013I\u000b\u0003\u0005\u0003\u0012\n%\u0005\u0019\u0001BJ\u00031!\u0017\r^1Ji\u0016\u0014\u0018\r^8s!\u0015\u0011)J!*[\u001d\u0011\u00119J!)\u000f\t\te%qT\u0007\u0003\u00057S1A!(\u0018\u0003\u0019a$o\\8u}%\t\u0001%C\u0002\u0003$~\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002*\t\u001d&b\u0001BR?!9!q\u0011BE\u0001\u0004Q\u0006b\u0002BW\u0001\u0011\u0005!qV\u0001\tSN\f5\r^5wKR\u0011\u0011\u0011\u0007\u0005\b\u0005g\u0003A\u0011\u0001BX\u0003%I7o\u0015;paB,G\rC\u0004\u00038\u0002!IA!/\u0002'U\u0004H-\u0019;f\u0007V\u0014(/\u001a8u\u0005V4g-\u001a:\u0015\t\tu\"1\u0018\u0005\t\u0005{\u0013)\f1\u0001\u0002f\u0006!A/[7f\u0011\u001d\u0011\t\r\u0001C\u0005\u0005[\n\u0011c[3faB+8\u000f[5oO\ncwnY6t\u0011\u001d\u0011)\r\u0001C\u0005\u0005\u000f\f1B]3q_J$XI\u001d:peR1!Q\bBe\u00053D\u0001Ba3\u0003D\u0002\u0007!QZ\u0001\b[\u0016\u001c8/Y4f!\u0011\u0011yM!6\u000f\u0007y\u0011\t.C\u0002\u0003T~\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0005/T1Aa5 \u0011!\u0011YNa1A\u0002\tu\u0017!\u0001;\u0011\t\tU%q\\\u0005\u0005\u0005C\u00149KA\u0005UQJ|w/\u00192mK\"9!Q\u001d\u0001\u0005\n\t\u001d\u0018!\u00039vg\"\u0014En\\2l)\u0011\u0011iD!;\t\u000f\t-(1\u001da\u0001C\u0006)!\r\\8dW\u001eQ!q\u001e\u0002\u0002\u0002#\u0005AA!=\u0002\u001d\tcwnY6HK:,'/\u0019;peB\u0019aBa=\u0007\u0013\u0005\u0011\u0011\u0011!E\u0001\t\tU8c\u0001Bzw!9\u0011Ga=\u0005\u0002\teHC\u0001By\u0011)\u0011iPa=\u0012\u0002\u0013\u0005!q`\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\u0005!F\u0001\u0016o\u0001")
public class BlockGenerator
extends RateLimiter {
    private final BlockGeneratorListener listener;
    private final int receiverId;
    private final long blockIntervalMs;
    private final RecurringTimer blockIntervalTimer;
    private final int blockQueueSize;
    private final ArrayBlockingQueue<Block> org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing;
    private final Thread blockPushingThread;
    private volatile ArrayBuffer<Object> currentBuffer;
    private volatile Enumeration.Value org$apache$spark$streaming$receiver$BlockGenerator$$state;
    private volatile BlockGenerator$Block$ Block$module;
    private volatile BlockGenerator$GeneratorState$ GeneratorState$module;

    public static Clock $lessinit$greater$default$4() {
        return BlockGenerator$.MODULE$.$lessinit$greater$default$4();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlockGenerator$Block$ org$apache$spark$streaming$receiver$BlockGenerator$$Block$lzycompute() {
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            if (this.Block$module != null) return this.Block$module;
            this.Block$module = new BlockGenerator$Block$(this);
            return this.Block$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlockGenerator$GeneratorState$ GeneratorState$lzycompute() {
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            if (this.GeneratorState$module != null) return this.GeneratorState$module;
            this.GeneratorState$module = new BlockGenerator$GeneratorState$(this);
            return this.GeneratorState$module;
        }
    }

    public BlockGenerator$Block$ org$apache$spark$streaming$receiver$BlockGenerator$$Block() {
        return this.Block$module == null ? this.org$apache$spark$streaming$receiver$BlockGenerator$$Block$lzycompute() : this.Block$module;
    }

    private BlockGenerator$GeneratorState$ GeneratorState() {
        return this.GeneratorState$module == null ? this.GeneratorState$lzycompute() : this.GeneratorState$module;
    }

    private long blockIntervalMs() {
        return this.blockIntervalMs;
    }

    private RecurringTimer blockIntervalTimer() {
        return this.blockIntervalTimer;
    }

    private int blockQueueSize() {
        return this.blockQueueSize;
    }

    public ArrayBlockingQueue<Block> org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing() {
        return this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing;
    }

    private Thread blockPushingThread() {
        return this.blockPushingThread;
    }

    private ArrayBuffer<Object> currentBuffer() {
        return this.currentBuffer;
    }

    private void currentBuffer_$eq(ArrayBuffer<Object> x$1) {
        this.currentBuffer = x$1;
    }

    public Enumeration.Value org$apache$spark$streaming$receiver$BlockGenerator$$state() {
        return this.org$apache$spark$streaming$receiver$BlockGenerator$$state;
    }

    private void org$apache$spark$streaming$receiver$BlockGenerator$$state_$eq(Enumeration.Value x$1) {
        this.org$apache$spark$streaming$receiver$BlockGenerator$$state = x$1;
    }

    public synchronized void start() {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().Initialized();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.org$apache$spark$streaming$receiver$BlockGenerator$$state_$eq(this.GeneratorState().Active());
            this.blockIntervalTimer().start();
            this.blockPushingThread().start();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Started BlockGenerator";
                }
            });
            return;
        }
        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot start BlockGenerator as its not in the Initialized state [state = ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$streaming$receiver$BlockGenerator$$state()})));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void stop() {
        block10: {
            BlockGenerator blockGenerator = this;
            // MONITORENTER : blockGenerator
            Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
            Enumeration.Value value2 = this.GeneratorState().Active();
            if (value != null ? !value.equals(value2) : value2 != null) break block10;
            this.org$apache$spark$streaming$receiver$BlockGenerator$$state_$eq(this.GeneratorState().StoppedAddingData());
            // MONITOREXIT : blockGenerator
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopping BlockGenerator";
                }
            });
            this.blockIntervalTimer().stop(false);
            BlockGenerator blockGenerator2 = this;
            // MONITORENTER : blockGenerator2
            this.org$apache$spark$streaming$receiver$BlockGenerator$$state_$eq(this.GeneratorState().StoppedGeneratingBlocks());
            // MONITOREXIT : blockGenerator2
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Waiting for block pushing thread to terminate";
                }
            });
            this.blockPushingThread().join();
            BlockGenerator blockGenerator3 = this;
            // MONITORENTER : blockGenerator3
            this.org$apache$spark$streaming$receiver$BlockGenerator$$state_$eq(this.GeneratorState().StoppedAll());
            // MONITOREXIT : blockGenerator3
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Stopped BlockGenerator";
                }
            });
            return;
        }
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockGenerator $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot stop BlockGenerator as its not in the Active state [state = ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$state()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        // MONITOREXIT : blockGenerator
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addData(Object data) {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        if (value != null ? !value.equals(value2) : value2 != null) throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
        this.waitToPush();
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            Enumeration.Value value3 = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
            Enumeration.Value value4 = this.GeneratorState().Active();
            if (value3 != null ? !value3.equals(value4) : value4 != null) throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
            this.currentBuffer().$plus$eq(data);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDataWithCallback(Object data, Object metadata) {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        if (value != null ? !value.equals(value2) : value2 != null) throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
        this.waitToPush();
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            Enumeration.Value value3 = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
            Enumeration.Value value4 = this.GeneratorState().Active();
            if (value3 != null ? !value3.equals(value4) : value4 != null) throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
            this.currentBuffer().$plus$eq(data);
            this.listener.onAddData(data, metadata);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addMultipleDataWithCallback(Iterator<Object> dataIterator, Object metadata) {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        if (value != null ? !value.equals(value2) : value2 != null) throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
        ArrayBuffer tempBuffer = new ArrayBuffer();
        dataIterator.foreach((Function1)new Serializable(this, tempBuffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockGenerator $outer;
            private final ArrayBuffer tempBuffer$1;

            public final ArrayBuffer<Object> apply(Object data) {
                this.$outer.waitToPush();
                return this.tempBuffer$1.$plus$eq(data);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tempBuffer$1 = tempBuffer$1;
            }
        });
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            Enumeration.Value value3 = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
            Enumeration.Value value4 = this.GeneratorState().Active();
            if (value3 != null ? !value3.equals(value4) : value4 != null) throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
            this.currentBuffer().$plus$plus$eq((TraversableOnce)tempBuffer);
            this.listener.onAddData(tempBuffer, metadata);
            return;
        }
    }

    public boolean isActive() {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean isStopped() {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().StoppedAll();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void org$apache$spark$streaming$receiver$BlockGenerator$$updateCurrentBuffer(long time) {
        try {
            Block newBlock = null;
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                BoxedUnit boxedUnit;
                if (this.currentBuffer().nonEmpty()) {
                    ArrayBuffer<Object> newBlockBuffer = this.currentBuffer();
                    this.currentBuffer_$eq((ArrayBuffer<Object>)new ArrayBuffer());
                    StreamBlockId blockId = new StreamBlockId(this.receiverId, time - this.blockIntervalMs());
                    this.listener.onGenerateBlock(blockId);
                    newBlock = new Block(this, blockId, newBlockBuffer);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : blockGenerator
                if (newBlock == null) return;
            }
            this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().put(newBlock);
            return;
        }
        catch (Exception exception) {
            this.reportError("Error in block updating thread", exception);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Block updating timer thread was interrupted";
                }
            });
        }
    }

    public void org$apache$spark$streaming$receiver$BlockGenerator$$keepPushingBlocks() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Started block pushing thread";
            }
        });
        try {
            while (this.areBlocksBeingGenerated$1()) {
                BoxedUnit boxedUnit;
                Option option = Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().poll(10L, TimeUnit.MILLISECONDS));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Block block = (Block)some.x();
                    this.pushBlock(block);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)option);
            }
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BlockGenerator $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Pushing out the last ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().size())).append((Object)" blocks").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            while (true) {
                if (this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().isEmpty()) {
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Stopped block pushing thread";
                        }
                    });
                    break;
                }
                Block block = this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().take();
                this.logDebug((Function0<String>)new Serializable(this, block){
                    public static final long serialVersionUID = 0L;
                    private final Block block$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pushing block ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.block$2}));
                    }
                    {
                        this.block$2 = block$2;
                    }
                });
                this.pushBlock(block);
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BlockGenerator $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Blocks left to push ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing().size())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }
        catch (Exception exception) {
            this.reportError("Error in block pushing thread", exception);
        }
        catch (InterruptedException interruptedException) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Block pushing thread was interrupted";
                }
            });
        }
    }

    private void reportError(String message, Throwable t) {
        this.logError((Function0<String>)new Serializable(this, message){
            public static final long serialVersionUID = 0L;
            private final String message$1;

            public final String apply() {
                return this.message$1;
            }
            {
                this.message$1 = message$1;
            }
        }, t);
        this.listener.onError(message, t);
    }

    private void pushBlock(Block block) {
        this.listener.onPushBlock(block.id(), block.buffer());
        this.logInfo((Function0<String>)new Serializable(this, block){
            public static final long serialVersionUID = 0L;
            private final Block block$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Pushed block ").append((Object)this.block$1.id()).toString();
            }
            {
                this.block$1 = block$1;
            }
        });
    }

    private final synchronized boolean areBlocksBeingGenerated$1() {
        Enumeration.Value value = this.org$apache$spark$streaming$receiver$BlockGenerator$$state();
        Enumeration.Value value2 = this.GeneratorState().StoppedGeneratingBlocks();
        return value != null ? !value.equals(value2) : value2 != null;
    }

    public BlockGenerator(BlockGeneratorListener listener, int receiverId, SparkConf conf, Clock clock) {
        this.listener = listener;
        this.receiverId = receiverId;
        super(conf);
        this.blockIntervalMs = conf.getTimeAsMs("spark.streaming.blockInterval", "200ms");
        Predef$.MODULE$.require(this.blockIntervalMs() > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'spark.streaming.blockInterval' should be a positive value"})).s((Seq)Nil$.MODULE$);
            }
        });
        this.blockIntervalTimer = new RecurringTimer(clock, this.blockIntervalMs(), (Function1<Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockGenerator $outer;

            public final void apply(long time) {
                this.apply$mcVJ$sp(time);
            }

            public void apply$mcVJ$sp(long time) {
                this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$updateCurrentBuffer(time);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "BlockGenerator");
        this.blockQueueSize = conf.getInt("spark.streaming.blockQueueSize", 10);
        this.org$apache$spark$streaming$receiver$BlockGenerator$$blocksForPushing = new ArrayBlockingQueue(this.blockQueueSize());
        this.blockPushingThread = new Thread(this){
            private final /* synthetic */ BlockGenerator $outer;

            public void run() {
                this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$keepPushingBlocks();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.currentBuffer = new ArrayBuffer();
        this.org$apache$spark$streaming$receiver$BlockGenerator$$state = this.GeneratorState().Initialized();
    }

    public class Block
    implements Product,
    Serializable {
        private final StreamBlockId id;
        private final ArrayBuffer<Object> buffer;
        public final /* synthetic */ BlockGenerator $outer;

        public StreamBlockId id() {
            return this.id;
        }

        public ArrayBuffer<Object> buffer() {
            return this.buffer;
        }

        public Block copy(StreamBlockId id, ArrayBuffer<Object> buffer) {
            return new Block(this.org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer(), id, buffer);
        }

        public StreamBlockId copy$default$1() {
            return this.id();
        }

        public ArrayBuffer<Object> copy$default$2() {
            return this.buffer();
        }

        public String productPrefix() {
            return "Block";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            StreamBlockId streamBlockId;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    streamBlockId = this.buffer();
                    break;
                }
                case 0: {
                    streamBlockId = this.id();
                }
            }
            return streamBlockId;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Block;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Block)) return false;
            boolean bl = true;
            if (!bl) return false;
            Block block = (Block)x$1;
            StreamBlockId streamBlockId = this.id();
            StreamBlockId streamBlockId2 = block.id();
            if (streamBlockId == null) {
                if (streamBlockId2 != null) {
                    return false;
                }
            } else if (!streamBlockId.equals(streamBlockId2)) return false;
            ArrayBuffer<Object> arrayBuffer = this.buffer();
            ArrayBuffer<Object> arrayBuffer2 = block.buffer();
            if (arrayBuffer == null) {
                if (arrayBuffer2 != null) {
                    return false;
                }
            } else if (!arrayBuffer.equals(arrayBuffer2)) return false;
            if (!block.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BlockGenerator org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer() {
            return this.$outer;
        }

        public Block(BlockGenerator $outer, StreamBlockId id, ArrayBuffer<Object> buffer) {
            this.id = id;
            this.buffer = buffer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

