/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.Logging;
import org.apache.spark.SimpleFutureAction;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.CleanupOldBlocks;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl;
import org.apache.spark.streaming.receiver.StopReceiver$;
import org.apache.spark.streaming.receiver.UpdateRateLimit;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.AllReceiverIds$;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.ReceivedBlockTracker;
import org.apache.spark.streaming.scheduler.ReceiverErrorInfo;
import org.apache.spark.streaming.scheduler.ReceiverSchedulingPolicy;
import org.apache.spark.streaming.scheduler.ReceiverState$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$receive$1$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$TrackerState$;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo$;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.streaming.scheduler.RestartReceiver;
import org.apache.spark.streaming.scheduler.StartAllReceivers;
import org.apache.spark.streaming.scheduler.StopAllReceivers$;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.streaming.scheduler.UpdateReceiverRateLimit;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\ruc!B\u0001\u0003\u0001\u0011a!a\u0004*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0004gN\u001c7\u0001\u0001\t\u00037qi\u0011\u0001B\u0005\u0003;\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n!c]6jaJ+7-Z5wKJd\u0015-\u001e8dQB\u0011a\"I\u0005\u0003E=\u0011qAQ8pY\u0016\fg\u000eC\u0003%\u0001\u0011\u0005Q%\u0001\u0004=S:LGO\u0010\u000b\u0004M!J\u0003CA\u0014\u0001\u001b\u0005\u0011\u0001\"\u0002\r$\u0001\u0004Q\u0002bB\u0010$!\u0003\u0005\r\u0001\t\u0005\bW\u0001\u0011\r\u0011\"\u0003-\u0003Q\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ngV\tQ\u0006E\u0002\u000f]AJ!aL\b\u0003\u000b\u0005\u0013(/Y=1\u0005EJ\u0004c\u0001\u001a6o5\t1G\u0003\u00025\t\u00059Am\u001d;sK\u0006l\u0017B\u0001\u001c4\u0005Q\u0011VmY3jm\u0016\u0014\u0018J\u001c9vi\u0012\u001bFO]3b[B\u0011\u0001(\u000f\u0007\u0001\t%Q\u0004!!A\u0001\u0002\u000b\u0005qHA\u0002`I]J!\u0001P\u001f\u0002/\u001d,GOU3dK&4XM]%oaV$8\u000b\u001e:fC6\u001c\u0018B\u0001 \u0005\u00051!5\u000b\u001e:fC6<%/\u00199i#\t\u00015\t\u0005\u0002\u000f\u0003&\u0011!i\u0004\u0002\b\u001d>$\b.\u001b8h!\tqA)\u0003\u0002F\u001f\t\u0019\u0011I\\=\t\r\u001d\u0003\u0001\u0015!\u0003.\u0003U\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ng\u0002Bq!\u0013\u0001C\u0002\u0013%!*\u0001\fsK\u000e,\u0017N^3s\u0013:\u0004X\u000f^*ue\u0016\fW.\u00133t+\u0005Y\u0005c\u0001\b/\u0019B\u0011a\"T\u0005\u0003\u001d>\u00111!\u00138u\u0011\u0019\u0001\u0006\u0001)A\u0005\u0017\u00069\"/Z2fSZ,'/\u00138qkR\u001cFO]3b[&#7\u000f\t\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0003Q\u0011XmY3jm\u0016$'\t\\8dWR\u0013\u0018mY6feV\tA\u000b\u0005\u0002(+&\u0011aK\u0001\u0002\u0015%\u0016\u001cW-\u001b<fI\ncwnY6Ue\u0006\u001c7.\u001a:\t\ra\u0003\u0001\u0015!\u0003U\u0003U\u0011XmY3jm\u0016$'\t\\8dWR\u0013\u0018mY6fe\u0002BqA\u0017\u0001C\u0002\u0013%1,A\u0006mSN$XM\\3s\u0005V\u001cX#\u0001/\u0011\u0005\u001dj\u0016B\u00010\u0003\u0005Q\u0019FO]3b[&tw\rT5ti\u0016tWM\u001d\"vg\"1\u0001\r\u0001Q\u0001\nq\u000bA\u0002\\5ti\u0016tWM\u001d\"vg\u0002:QA\u0019\u0001\t\u0002\r\fA\u0002\u0016:bG.,'o\u0015;bi\u0016\u0004\"\u0001Z3\u000e\u0003\u00011QA\u001a\u0001\t\u0002\u001d\u0014A\u0002\u0016:bG.,'o\u0015;bi\u0016\u001c\"!\u001a5\u0011\u00059I\u0017B\u00016\u0010\u0005-)e.^7fe\u0006$\u0018n\u001c8\t\u000b\u0011*G\u0011\u00017\u0015\u0003\r,AAZ3\u0001]B\u0011q\u000e]\u0007\u0002K&\u0011\u0011/\u001b\u0002\u0006-\u0006dW/\u001a\u0005\bg\u0016\u0014\r\u0011\"\u0001u\u0003-Ie.\u001b;jC2L'0\u001a3\u0016\u00039DaA^3!\u0002\u0013q\u0017\u0001D%oSRL\u0017\r\\5{K\u0012\u0004\u0003b\u0002=f\u0005\u0004%\t\u0001^\u0001\b'R\f'\u000f^3e\u0011\u0019QX\r)A\u0005]\u0006A1\u000b^1si\u0016$\u0007\u0005C\u0004}K\n\u0007I\u0011\u0001;\u0002\u0011M#x\u000e\u001d9j]\u001eDaA`3!\u0002\u0013q\u0017!C*u_B\u0004\u0018N\\4!\u0011!\t\t!\u001ab\u0001\n\u0003!\u0018aB*u_B\u0004X\r\u001a\u0005\b\u0003\u000b)\u0007\u0015!\u0003o\u0003!\u0019Fo\u001c9qK\u0012\u0004\u0003\"CA\u0005\u0001\u0001\u0007I\u0011BA\u0006\u00031!(/Y2lKJ\u001cF/\u0019;f+\t\ti\u0001E\u0002\u0002\u0010At!\u0001Z1\t\u0013\u0005M\u0001\u00011A\u0005\n\u0005U\u0011\u0001\u0005;sC\u000e\\WM]*uCR,w\fJ3r)\u0011\t9\"!\b\u0011\u00079\tI\"C\u0002\u0002\u001c=\u0011A!\u00168ji\"Q\u0011qDA\t\u0003\u0003\u0005\r!!\u0004\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002$\u0001\u0001\u000b\u0015BA\u0007\u00035!(/Y2lKJ\u001cF/\u0019;fA!\"\u0011\u0011EA\u0014!\rq\u0011\u0011F\u0005\u0004\u0003Wy!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005=\u0002\u00011A\u0005\n\u0005E\u0012\u0001C3oIB|\u0017N\u001c;\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005eb!A\u0002sa\u000eLA!!\u0010\u00028\tq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007\"CA!\u0001\u0001\u0007I\u0011BA\"\u00031)g\u000e\u001a9pS:$x\fJ3r)\u0011\t9\"!\u0012\t\u0015\u0005}\u0011qHA\u0001\u0002\u0004\t\u0019\u0004\u0003\u0005\u0002J\u0001\u0001\u000b\u0015BA\u001a\u0003%)g\u000e\u001a9pS:$\b\u0005C\u0005\u0002N\u0001\u0011\r\u0011\"\u0003\u0002P\u0005\u00012o\u00195fIVd\u0017N\\4Q_2L7-_\u000b\u0003\u0003#\u00022aJA*\u0013\r\t)F\u0001\u0002\u0019%\u0016\u001cW-\u001b<feN\u001b\u0007.\u001a3vY&tw\rU8mS\u000eL\b\u0002CA-\u0001\u0001\u0006I!!\u0015\u0002#M\u001c\u0007.\u001a3vY&tw\rU8mS\u000eL\b\u0005C\u0005\u0002^\u0001\u0011\r\u0011\"\u0003\u0002`\u0005!\"/Z2fSZ,'OS8c\u000bbLG\u000fT1uG\",\"!!\u0019\u0011\t\u0005\r\u0014\u0011O\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005-\u0014QN\u0001\u0005kRLGN\u0003\u0002\u0002p\u0005!!.\u0019<b\u0013\u0011\t\u0019(!\u001a\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\"A\u0011q\u000f\u0001!\u0002\u0013\t\t'A\u000bsK\u000e,\u0017N^3s\u0015>\u0014W\t_5u\u0019\u0006$8\r\u001b\u0011\t\u0013\u0005m\u0004A1A\u0005\n\u0005u\u0014!\u0006:fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001b8h\u0013:4wn]\u000b\u0003\u0003\u007f\u0002r!!!\u0002\f2\u000by)\u0004\u0002\u0002\u0004*!\u0011QQAD\u0003\u001diW\u000f^1cY\u0016T1!!#\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\u000b\u0019IA\u0004ICNDW*\u00199\u0011\u0007\u001d\n\t*C\u0002\u0002\u0014\n\u0011ACU3dK&4XM\u001d+sC\u000e\\\u0017N\\4J]\u001a|\u0007\u0002CAL\u0001\u0001\u0006I!a \u0002-I,7-Z5wKJ$&/Y2lS:<\u0017J\u001c4pg\u0002B\u0011\"a'\u0001\u0005\u0004%I!!(\u00025I,7-Z5wKJ\u0004&/\u001a4feJ,G\rT8dCRLwN\\:\u0016\u0005\u0005}\u0005cBAA\u0003\u0017c\u0015\u0011\u0015\t\u0006\u001d\u0005\r\u0016qU\u0005\u0004\u0003K{!AB(qi&|g\u000e\u0005\u0003\u0002*\u0006=fb\u0001\b\u0002,&\u0019\u0011QV\b\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t,a-\u0003\rM#(/\u001b8h\u0015\r\tik\u0004\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u0002 \u0006Y\"/Z2fSZ,'\u000f\u0015:fM\u0016\u0014(/\u001a3M_\u000e\fG/[8og\u0002Bq!a/\u0001\t\u0003\ti,A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002\u0018!9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0017\u0001B:u_B$B!a\u0006\u0002F\"9\u0011qYA`\u0001\u0004\u0001\u0013\u0001C4sC\u000e,g-\u001e7\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\u0006)\u0012\r\u001c7pG\u0006$XM\u00117pG.\u001cHk\u001c\"bi\u000eDG\u0003BA\f\u0003\u001fD\u0001\"!5\u0002J\u0002\u0007\u00111[\u0001\nE\u0006$8\r\u001b+j[\u0016\u00042aGAk\u0013\r\t9\u000e\u0002\u0002\u0005)&lW\rC\u0004\u0002\\\u0002!\t!!8\u0002!\u001d,GO\u00117pG.\u001cxJ\u001a\"bi\u000eDG\u0003BAp\u0005\u0007\u0001r!!+\u0002b2\u000b)/\u0003\u0003\u0002d\u0006M&aA'baB1\u0011q]A|\u0003{tA!!;\u0002t:!\u00111^Ay\u001b\t\tiOC\u0002\u0002pf\ta\u0001\u0010:p_Rt\u0014\"\u0001\t\n\u0007\u0005Ux\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00181 \u0002\u0004'\u0016\f(bAA{\u001fA\u0019q%a@\n\u0007\t\u0005!AA\tSK\u000e,\u0017N^3e\u00052|7m[%oM>D\u0001\"!5\u0002Z\u0002\u0007\u00111\u001b\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0003e9W\r\u001e\"m_\u000e\\7o\u00144CCR\u001c\u0007.\u00118e'R\u0014X-Y7\u0015\r\u0005\u0015(1\u0002B\u0007\u0011!\t\tN!\u0002A\u0002\u0005M\u0007b\u0002B\b\u0005\u000b\u0001\r\u0001T\u0001\tgR\u0014X-Y7JI\"9!1\u0003\u0001\u0005\u0002\tU\u0011AG2mK\u0006tW\u000f](mI\ncwnY6t\u0003:$')\u0019;dQ\u0016\u001cH\u0003BA\f\u0005/A\u0001B!\u0007\u0003\u0012\u0001\u0007\u00111[\u0001\u0012G2,\u0017M\\;q)\"\u0014Xm\u001d5US6,\u0007b\u0002B\u000f\u0001\u0011%!qD\u0001\u0011e\u0016<\u0017n\u001d;feJ+7-Z5wKJ$2\u0002\tB\u0011\u0005G\u00119Ca\u000b\u00030!9!q\u0002B\u000e\u0001\u0004a\u0005\u0002\u0003B\u0013\u00057\u0001\r!a*\u0002\u0007QL\b\u000f\u0003\u0005\u0003*\tm\u0001\u0019AAT\u0003!Awn\u001d;Q_J$\b\u0002\u0003B\u0017\u00057\u0001\r!a\r\u0002!I,7-Z5wKJ,e\u000e\u001a9pS:$\b\u0002\u0003B\u0019\u00057\u0001\rAa\r\u0002\u001bM,g\u000eZ3s\u0003\u0012$'/Z:t!\u0011\t)D!\u000e\n\t\t]\u0012q\u0007\u0002\u000b%B\u001c\u0017\t\u001a3sKN\u001c\bb\u0002B\u001e\u0001\u0011%!QH\u0001\u0013I\u0016\u0014XmZ5ti\u0016\u0014(+Z2fSZ,'\u000f\u0006\u0005\u0002\u0018\t}\"\u0011\tB#\u0011\u001d\u0011yA!\u000fA\u00021C\u0001Ba\u0011\u0003:\u0001\u0007\u0011qU\u0001\b[\u0016\u001c8/Y4f\u0011!\u00119E!\u000fA\u0002\u0005\u001d\u0016!B3se>\u0014\bb\u0002B&\u0001\u0011\u0005!QJ\u0001\u000fg\u0016tGMU1uKV\u0003H-\u0019;f)\u0019\t9Ba\u0014\u0003T!9!\u0011\u000bB%\u0001\u0004a\u0015!C:ue\u0016\fW.V%E\u0011!\u0011)F!\u0013A\u0002\t]\u0013a\u00028foJ\u000bG/\u001a\t\u0004\u001d\te\u0013b\u0001B.\u001f\t!Aj\u001c8h\u0011\u001d\u0011y\u0006\u0001C\u0005\u0005C\n\u0001\"\u00193e\u00052|7m\u001b\u000b\u0004A\t\r\u0004\u0002\u0003B3\u0005;\u0002\r!!@\u0002#I,7-Z5wK\u0012\u0014En\\2l\u0013:4w\u000eC\u0004\u0003j\u0001!IAa\u001b\u0002\u0017I,\u0007o\u001c:u\u000bJ\u0014xN\u001d\u000b\t\u0003/\u0011iGa\u001c\u0003r!9!q\u0002B4\u0001\u0004a\u0005\u0002\u0003B\"\u0005O\u0002\r!a*\t\u0011\t\u001d#q\ra\u0001\u0003OCqA!\u001e\u0001\t\u0013\u00119(\u0001\ttG\",G-\u001e7f%\u0016\u001cW-\u001b<feR!!\u0011\u0010B>!\u0019\t9/a>\u0002(\"9!Q\u0010B:\u0001\u0004a\u0015A\u0003:fG\u0016Lg/\u001a:JI\"9!\u0011\u0011\u0001\u0005\n\t\r\u0015\u0001I;qI\u0006$XMU3dK&4XM]*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN$b!a\u0006\u0003\u0006\n\u001d\u0005b\u0002B?\u0005\u007f\u0002\r\u0001\u0014\u0005\t\u0005\u0013\u0013y\b1\u0001\u0003z\u0005\u00112o\u00195fIVdW\rZ#yK\u000e,Ho\u001c:t\u0011\u001d\u0011i\t\u0001C\u0001\u0005\u001f\u000bA\u0003[1t+:\fG\u000e\\8dCR,GM\u00117pG.\u001cX#\u0001\u0011\t\u000f\tM\u0005\u0001\"\u0003\u0003\u0016\u0006aq-\u001a;Fq\u0016\u001cW\u000f^8sgV\u0011!\u0011\u0010\u0005\b\u00053\u0003A\u0011BA_\u0003A\u0011XO\u001c#v[6L8\u000b]1sW*{'\rC\u0004\u0003\u001e\u0002!I!!0\u0002\u001f1\fWO\\2i%\u0016\u001cW-\u001b<feNDqA!)\u0001\t\u0013\u0011y)\u0001\tjgR\u0013\u0018mY6feN#\u0018M\u001d;fI\"9!Q\u0015\u0001\u0005\n\t=\u0015!E5t)J\f7m[3s'R|\u0007\u000f]5oO\"9!\u0011\u0016\u0001\u0005\n\t=\u0015\u0001E5t)J\f7m[3s'R|\u0007\u000f]3e\r\u0019\u0011i\u000b\u0001\u0003\u00030\n9\"+Z2fSZ,'\u000f\u0016:bG.,'/\u00128ea>Lg\u000e^\n\u0006\u0005Wk!\u0011\u0017\t\u0005\u0003k\u0011\u0019,\u0003\u0003\u00036\u0006]\"!\u0006+ie\u0016\fGmU1gKJ\u00038-\u00128ea>Lg\u000e\u001e\u0005\f\u0005s\u0013YK!b\u0001\n\u0003\u0012Y,\u0001\u0004sa\u000e,eN^\u000b\u0003\u0005{\u0003B!!\u000e\u0003@&!!\u0011YA\u001c\u0005\u0019\u0011\u0006oY#om\"Y!Q\u0019BV\u0005\u0003\u0005\u000b\u0011\u0002B_\u0003\u001d\u0011\boY#om\u0002Bq\u0001\nBV\t\u0003\u0011I\r\u0006\u0003\u0003L\n5\u0007c\u00013\u0003,\"A!\u0011\u0018Bd\u0001\u0004\u0011i\f\u0003\u0006\u0003R\n-&\u0019!C\u0005\u0005'\f1c];c[&$(j\u001c2UQJ,\u0017\r\u001a)p_2,\"A!6\u0011\t\t]'1\\\u0007\u0003\u00053T1!a\u001a\u0010\u0013\u0011\u0011iN!7\u0003?\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'oU3sm&\u001cW\rC\u0005\u0003b\n-\u0006\u0015!\u0003\u0003V\u0006!2/\u001e2nSRTuN\u0019+ie\u0016\fG\rU8pY\u0002B\u0001B!:\u0003,\u0012\u0005#q]\u0001\be\u0016\u001cW-\u001b<f+\t\u0011I\u000f\u0005\u0004\u000f\u0005W\u001c\u0015qC\u0005\u0004\u0005[|!a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\t\u0011\tE(1\u0016C!\u0005g\fqB]3dK&4X-\u00118e%\u0016\u0004H.\u001f\u000b\u0005\u0005S\u0014)\u0010\u0003\u0005\u0003x\n=\b\u0019\u0001B}\u0003\u001d\u0019wN\u001c;fqR\u0004B!!\u000e\u0003|&!!Q`A\u001c\u00059\u0011\u0006oY\"bY2\u001cuN\u001c;fqRD\u0001b!\u0001\u0003,\u0012%11A\u0001\u001cO\u0016$8\u000b^8sK\u0012\u001c6\r[3ek2,G-\u0012=fGV$xN]:\u0015\t\te4Q\u0001\u0005\b\u0005{\u0012y\u00101\u0001M\u0011!\u0019IAa+\u0005\n\r-\u0011!D:uCJ$(+Z2fSZ,'\u000f\u0006\u0004\u0002\u0018\r511\u0005\u0005\t\u0007\u001f\u00199\u00011\u0001\u0004\u0012\u0005A!/Z2fSZ,'\u000f\r\u0003\u0004\u0014\r}\u0001CBB\u000b\u00073\u0019i\"\u0004\u0002\u0004\u0018)\u00191q\u0002\u0003\n\t\rm1q\u0003\u0002\t%\u0016\u001cW-\u001b<feB\u0019\u0001ha\b\u0005\u0017\r\u00052QBA\u0001\u0002\u0003\u0015\ta\u0010\u0002\u0004?\u0012\u001a\u0004\u0002\u0003BE\u0007\u000f\u0001\rA!\u001f\t\u0011\r\u001d\"1\u0016C!\u0003{\u000baa\u001c8Ti>\u0004\b\u0002CB\u0016\u0005W#Ia!\f\u0002'=t'+Z2fSZ,'OS8c\r&t\u0017n\u001d5\u0015\t\u0005]1q\u0006\u0005\b\u0005{\u001aI\u00031\u0001M\u0011!\u0019\u0019Da+\u0005\n\u0005u\u0016!D:u_B\u0014VmY3jm\u0016\u00148o\u0002\u0006\u00048\t\t\t\u0011#\u0001\u0005\u0007s\tqBU3dK&4XM\u001d+sC\u000e\\WM\u001d\t\u0004O\rmb!C\u0001\u0003\u0003\u0003E\t\u0001BB\u001f'\r\u0019Y$\u0004\u0005\bI\rmB\u0011AB!)\t\u0019I\u0004\u0003\u0006\u0004F\rm\u0012\u0013!C\u0001\u0007\u000f\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAB%U\r\u000131J\u0016\u0003\u0007\u001b\u0002Baa\u0014\u0004Z5\u00111\u0011\u000b\u0006\u0005\u0007'\u001a)&A\u0005v]\u000eDWmY6fI*\u00191qK\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\\\rE#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ReceiverTracker
implements Logging {
    public final StreamingContext org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc;
    private final boolean skipReceiverLaunch;
    private final ReceiverInputDStream<?>[] receiverInputStreams;
    private final int[] receiverInputStreamIds;
    private final ReceivedBlockTracker receivedBlockTracker;
    private final StreamingListenerBus listenerBus;
    private volatile Enumeration.Value trackerState;
    private RpcEndpointRef endpoint;
    private final ReceiverSchedulingPolicy org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy;
    private final CountDownLatch org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch;
    private final HashMap<Object, ReceiverTrackingInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos;
    private final HashMap<Object, Option<String>> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations;
    private volatile ReceiverTracker$TrackerState$ TrackerState$module;
    private transient Logger org$apache$spark$Logging$$log_;

    public static boolean $lessinit$greater$default$2() {
        return ReceiverTracker$.MODULE$.$lessinit$greater$default$2();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReceiverTracker$TrackerState$ TrackerState$lzycompute() {
        ReceiverTracker receiverTracker = this;
        synchronized (receiverTracker) {
            if (this.TrackerState$module != null) return this.TrackerState$module;
            this.TrackerState$module = new ReceiverTracker$TrackerState$(this);
            return this.TrackerState$module;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private ReceiverInputDStream<?>[] receiverInputStreams() {
        return this.receiverInputStreams;
    }

    private int[] receiverInputStreamIds() {
        return this.receiverInputStreamIds;
    }

    private ReceivedBlockTracker receivedBlockTracker() {
        return this.receivedBlockTracker;
    }

    private StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    public ReceiverTracker$TrackerState$ TrackerState() {
        return this.TrackerState$module == null ? this.TrackerState$lzycompute() : this.TrackerState$module;
    }

    private Enumeration.Value trackerState() {
        return this.trackerState;
    }

    private void trackerState_$eq(Enumeration.Value x$1) {
        this.trackerState = x$1;
    }

    private RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    private void endpoint_$eq(RpcEndpointRef x$1) {
        this.endpoint = x$1;
    }

    public ReceiverSchedulingPolicy org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy;
    }

    public CountDownLatch org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch;
    }

    public HashMap<Object, ReceiverTrackingInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos;
    }

    public HashMap<Object, Option<String>> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations;
    }

    public synchronized void start() {
        if (this.isTrackerStarted()) {
            throw new SparkException("ReceiverTracker already started");
        }
        if (!Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).isEmpty()) {
            this.endpoint_$eq(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv().setupEndpoint("ReceiverTracker", (RpcEndpoint)new ReceiverTrackerEndpoint(this, this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv())));
            if (!this.skipReceiverLaunch) {
                this.launchReceivers();
            }
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "ReceiverTracker started";
                }
            });
            this.trackerState_$eq(this.TrackerState().Started());
        }
    }

    public synchronized void stop(boolean graceful) {
        if (this.isTrackerStarted()) {
            this.trackerState_$eq(this.TrackerState().Stopping());
            if (!this.skipReceiverLaunch) {
                Seq receivers;
                this.endpoint().askWithRetry((Object)StopAllReceivers$.MODULE$, ClassTag$.MODULE$.Boolean());
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().await(10L, TimeUnit.SECONDS);
                if (graceful) {
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Waiting for receiver job to terminate gracefully";
                        }
                    });
                    this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().await();
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Waited for receiver job to terminate gracefully";
                        }
                    });
                }
                if ((receivers = (Seq)this.endpoint().askWithRetry((Object)AllReceiverIds$.MODULE$, ClassTag$.MODULE$.apply(Seq.class))).nonEmpty()) {
                    this.logWarning((Function0<String>)new Serializable(this, receivers){
                        public static final long serialVersionUID = 0L;
                        private final Seq receivers$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Not all of the receivers have deregistered, ").append((Object)this.receivers$1).toString();
                        }
                        {
                            this.receivers$1 = receivers$1;
                        }
                    });
                } else {
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "All of the receivers have deregistered successfully";
                        }
                    });
                }
            }
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv().stop(this.endpoint());
            this.endpoint_$eq(null);
            this.receivedBlockTracker().stop();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "ReceiverTracker stopped";
                }
            });
            this.trackerState_$eq(this.TrackerState().Stopped());
        }
    }

    public void allocateBlocksToBatch(Time batchTime) {
        if (Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).nonEmpty()) {
            this.receivedBlockTracker().allocateBlocksToBatch(batchTime);
        }
    }

    public scala.collection.immutable.Map<Object, Seq<ReceivedBlockInfo>> getBlocksOfBatch(Time batchTime) {
        return this.receivedBlockTracker().getBlocksOfBatch(batchTime);
    }

    public Seq<ReceivedBlockInfo> getBlocksOfBatchAndStream(Time batchTime, int streamId) {
        return this.receivedBlockTracker().getBlocksOfBatchAndStream(batchTime, streamId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cleanupOldBlocksAndBatches(Time cleanupThreshTime) {
        this.receivedBlockTracker().cleanupOldBatches(cleanupThreshTime, false);
        if (!WriteAheadLogUtils$.MODULE$.enableReceiverLog(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.conf())) return;
        this.logInfo((Function0<String>)new Serializable(this, cleanupThreshTime){
            public static final long serialVersionUID = 0L;
            private final Time cleanupThreshTime$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleanup old received batch data: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanupThreshTime$1}));
            }
            {
                this.cleanupThreshTime$1 = cleanupThreshTime$1;
            }
        });
        ReceiverTracker receiverTracker = this;
        synchronized (receiverTracker) {
            BoxedUnit boxedUnit;
            if (this.isTrackerStarted()) {
                this.endpoint().send((Object)new CleanupOldBlocks(cleanupThreshTime));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(int streamId, String typ, String hostPort, RpcEndpointRef receiverEndpoint, RpcAddress senderAddress) {
        if (Predef$.MODULE$.intArrayOps(this.receiverInputStreamIds()).contains((Object)BoxesRunTime.boxToInteger((int)streamId))) {
            boolean bl;
            Seq<String> accetableExecutors;
            if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() || this.org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped()) {
                return false;
            }
            Option<Seq<String>> scheduledExecutors = ((ReceiverTrackingInfo)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)streamId))).scheduledExecutors();
            Seq<String> seq = accetableExecutors = scheduledExecutors.nonEmpty() ? (Seq<String>)scheduledExecutors.get() : this.scheduleReceiver(streamId);
            if (accetableExecutors.contains((Object)hostPort)) {
                String name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typ, BoxesRunTime.boxToInteger((int)streamId)}));
                ReceiverTrackingInfo receiverTrackingInfo = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.ACTIVE(), (Option<Seq<String>>)None$.MODULE$, (Option<String>)new Some((Object)hostPort), (Option<String>)new Some((Object)name), (Option<RpcEndpointRef>)new Some((Object)receiverEndpoint), ReceiverTrackingInfo$.MODULE$.apply$default$7());
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().put((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)receiverTrackingInfo);
                this.listenerBus().post(new StreamingListenerReceiverStarted(receiverTrackingInfo.toReceiverInfo()));
                this.logInfo((Function0<String>)new Serializable(this, streamId, senderAddress){
                    public static final long serialVersionUID = 0L;
                    private final int streamId$1;
                    private final RpcAddress senderAddress$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Registered receiver for stream ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId$1)).append((Object)" from ").append((Object)this.senderAddress$1).toString();
                    }
                    {
                        this.streamId$1 = streamId$1;
                        this.senderAddress$1 = senderAddress$1;
                    }
                });
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }
        throw new SparkException(new StringBuilder().append((Object)"Register received for unexpected id ").append((Object)BoxesRunTime.boxToInteger((int)streamId)).toString());
    }

    /*
     * Unable to fully structure code
     */
    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(int streamId, String message, String error) {
        block7: {
            block6: {
                block5: {
                    if (error == null) ** GOTO lbl-1000
                    v0 = error;
                    var4_4 = "";
                    if (!(v0 != null ? v0.equals(var4_4) == false : var4_4 != null)) lbl-1000:
                    // 2 sources

                    {
                        v1 = -1L;
                    } else {
                        v1 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().clock().getTimeMillis();
                    }
                    lastErrorTime = v1;
                    errorInfo = new ReceiverErrorInfo(message, error, lastErrorTime);
                    var8_7 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(var8_7 instanceof Some)) break block5;
                    var9_8 = (Some)var8_7;
                    oldInfo = (ReceiverTrackingInfo)var9_8.x();
                    x$12 = ReceiverState$.MODULE$.INACTIVE();
                    x$13 = new Some((Object)errorInfo);
                    x$14 = oldInfo.copy$default$1();
                    x$15 = oldInfo.copy$default$3();
                    x$16 = oldInfo.copy$default$4();
                    x$17 = oldInfo.copy$default$5();
                    x$18 = oldInfo.copy$default$6();
                    var18_17 = oldInfo.copy(x$14, x$12, x$15, x$16, x$17, x$18, (Option<ReceiverErrorInfo>)x$13);
                    break block6;
                }
                if (!None$.MODULE$.equals(var8_7)) break block7;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                var18_17 = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.INACTIVE(), (Option<Seq<String>>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<RpcEndpointRef>)None$.MODULE$, (Option<ReceiverErrorInfo>)new Some((Object)errorInfo));
            }
            newReceiverTrackingInfo = var18_17;
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverTrackingInfo);
            this.listenerBus().post(new StreamingListenerReceiverStopped(newReceiverTrackingInfo.toReceiverInfo()));
            messageWithError = error == null || error.isEmpty() != false ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logError((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$2;
                private final String messageWithError$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deregistered receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$2), this.messageWithError$1}));
                }
                {
                    this.streamId$2 = streamId$2;
                    this.messageWithError$1 = messageWithError$1;
                }
            });
            return;
        }
        throw new MatchError((Object)var8_7);
    }

    public synchronized void sendRateUpdate(int streamUID, long newRate) {
        if (this.isTrackerStarted()) {
            this.endpoint().send((Object)new UpdateReceiverRateLimit(streamUID, newRate));
        }
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(ReceivedBlockInfo receivedBlockInfo) {
        return this.receivedBlockTracker().addBlock(receivedBlockInfo);
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(int streamId, String message, String error) {
        Option option;
        block4: {
            ReceiverTrackingInfo receiverTrackingInfo;
            block3: {
                block2: {
                    option = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ReceiverTrackingInfo oldInfo = (ReceiverTrackingInfo)some.x();
                    ReceiverErrorInfo errorInfo = new ReceiverErrorInfo(message, error, BoxesRunTime.unboxToLong((Object)oldInfo.errorInfo().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(ReceiverErrorInfo x$2) {
                            return x$2.lastErrorTime();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return -1L;
                        }
                    })));
                    Some x$19 = new Some((Object)errorInfo);
                    int x$20 = oldInfo.copy$default$1();
                    Enumeration.Value x$21 = oldInfo.copy$default$2();
                    Option<Seq<String>> x$22 = oldInfo.copy$default$3();
                    Option<String> x$23 = oldInfo.copy$default$4();
                    Option<String> x$24 = oldInfo.copy$default$5();
                    Option<RpcEndpointRef> x$25 = oldInfo.copy$default$6();
                    receiverTrackingInfo = oldInfo.copy(x$20, x$21, x$22, x$23, x$24, x$25, (Option<ReceiverErrorInfo>)x$19);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                ReceiverErrorInfo errorInfo = new ReceiverErrorInfo(message, error, this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().clock().getTimeMillis());
                receiverTrackingInfo = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.INACTIVE(), (Option<Seq<String>>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<RpcEndpointRef>)None$.MODULE$, (Option<ReceiverErrorInfo>)new Some((Object)errorInfo));
            }
            ReceiverTrackingInfo newReceiverTrackingInfo = receiverTrackingInfo;
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverTrackingInfo);
            this.listenerBus().post(new StreamingListenerReceiverError(newReceiverTrackingInfo.toReceiverInfo()));
            String messageWithError = error == null || error.isEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logWarning((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$3;
                private final String messageWithError$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reported by receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$3), this.messageWithError$2}));
                }
                {
                    this.streamId$3 = streamId$3;
                    this.messageWithError$2 = messageWithError$2;
                }
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<String> scheduleReceiver(int receiverId) {
        void var3_3;
        Option preferredLocation = (Option)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations().getOrElse((Object)BoxesRunTime.boxToInteger((int)receiverId), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        });
        Seq<String> scheduledExecutors = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().rescheduleReceiver(receiverId, (Option<String>)preferredLocation, (Map<Object, ReceiverTrackingInfo>)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos(), this.org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(receiverId, scheduledExecutors);
        return var3_3;
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(int receiverId, Seq<String> scheduledExecutors) {
        Option option;
        block4: {
            ReceiverTrackingInfo receiverTrackingInfo;
            block3: {
                block2: {
                    option = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)receiverId));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ReceiverTrackingInfo oldInfo = (ReceiverTrackingInfo)some.x();
                    Enumeration.Value x$26 = ReceiverState$.MODULE$.SCHEDULED();
                    Some x$27 = new Some(scheduledExecutors);
                    int x$28 = oldInfo.copy$default$1();
                    Option<String> x$29 = oldInfo.copy$default$4();
                    Option<String> x$30 = oldInfo.copy$default$5();
                    Option<RpcEndpointRef> x$31 = oldInfo.copy$default$6();
                    Option<ReceiverErrorInfo> x$32 = oldInfo.copy$default$7();
                    receiverTrackingInfo = oldInfo.copy(x$28, x$26, (Option<Seq<String>>)x$27, x$29, x$30, x$31, x$32);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                receiverTrackingInfo = new ReceiverTrackingInfo(receiverId, ReceiverState$.MODULE$.SCHEDULED(), (Option<Seq<String>>)new Some(scheduledExecutors), (Option<String>)None$.MODULE$, ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7());
            }
            ReceiverTrackingInfo newReceiverTrackingInfo = receiverTrackingInfo;
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().put((Object)BoxesRunTime.boxToInteger((int)receiverId), (Object)newReceiverTrackingInfo);
            return;
        }
        throw new MatchError((Object)option);
    }

    public boolean hasUnallocatedBlocks() {
        return this.receivedBlockTracker().hasUnallocatedReceivedBlocks();
    }

    public Seq<String> org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().isLocal() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().env().blockManager().blockManagerId().hostPort()})) : ((TraversableOnce)((TraversableLike)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().env().blockManager().master().getMemoryStatus().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<BlockManagerId, Tuple2<Object, Object>> x0$1) {
                Tuple2<BlockManagerId, Tuple2<Object, Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                    String string = blockManagerId.executorId();
                    String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
                    boolean bl = string != null ? !string.equals(string2) : string2 != null;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<BlockManagerId, Tuple2<Object, Object>> x0$2) {
                Tuple2<BlockManagerId, Tuple2<Object, Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                    String string = blockManagerId.hostPort();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private void runDummySparkJob() {
        Object object = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().isLocal() ? BoxedUnit.UNIT : RDD$.MODULE$.rddToPairRDDFunctions(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50), 50, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(int x) {
                return new Tuple2.mcII.sp(x, 1);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$3, int x$4) {
                return this.apply$mcIII$sp(x$3, x$4);
            }

            public int apply$mcIII$sp(int x$3, int x$4) {
                return x$3 + x$4;
            }
        }, 20).collect();
        Predef$.MODULE$.assert(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors().nonEmpty());
    }

    private void launchReceivers() {
        Receiver[] receivers = (Receiver[])Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final Receiver<?> apply(ReceiverInputDStream<?> nis) {
                void var2_2;
                Receiver<?> rcvr = nis.getReceiver();
                rcvr.setReceiverId(nis.id());
                return var2_2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Receiver.class)));
        this.runDummySparkJob();
        this.logInfo((Function0<String>)new Serializable(this, receivers){
            public static final long serialVersionUID = 0L;
            private final Receiver[] receivers$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Starting ").append((Object)BoxesRunTime.boxToInteger((int)this.receivers$2.length)).append((Object)" receivers").toString();
            }
            {
                this.receivers$2 = receivers$2;
            }
        });
        this.endpoint().send((Object)new StartAllReceivers((Seq<Receiver<?>>)Predef$.MODULE$.wrapRefArray((Object[])receivers)));
    }

    private boolean isTrackerStarted() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Started();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Stopping();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Stopped();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public ReceiverTracker(StreamingContext ssc, boolean skipReceiverLaunch) {
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc = ssc;
        this.skipReceiverLaunch = skipReceiverLaunch;
        Logging.class.$init$((Logging)this);
        this.receiverInputStreams = ssc.graph().getReceiverInputStreams();
        this.receiverInputStreamIds = (int[])Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ReceiverInputDStream<?> x$1) {
                return x$1.id();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        this.receivedBlockTracker = new ReceivedBlockTracker(ssc.sparkContext().conf(), ssc.sparkContext().hadoopConfiguration(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(this.receiverInputStreamIds()), ssc.scheduler().clock(), ssc.isCheckpointPresent(), (Option<String>)Option$.MODULE$.apply((Object)ssc.checkpointDir()));
        this.listenerBus = ssc.scheduler().listenerBus();
        this.trackerState = this.TrackerState().Initialized();
        this.endpoint = null;
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy = new ReceiverSchedulingPolicy();
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch = new CountDownLatch(Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).size());
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos = new HashMap();
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations = new HashMap();
    }

    public class ReceiverTrackerEndpoint
    implements ThreadSafeRpcEndpoint {
        private final RpcEnv rpcEnv;
        private final ExecutionContextExecutorService submitJobThreadPool;
        public final /* synthetic */ ReceiverTracker $outer;

        public final RpcEndpointRef self() {
            return RpcEndpoint.class.self((RpcEndpoint)this);
        }

        public void onError(Throwable cause) {
            RpcEndpoint.class.onError((RpcEndpoint)this, (Throwable)cause);
        }

        public void onStart() {
            RpcEndpoint.class.onStart((RpcEndpoint)this);
        }

        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint.class.onConnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onDisconnected(RpcAddress remoteAddress) {
            RpcEndpoint.class.onDisconnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint.class.onNetworkError((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
        }

        public final void stop() {
            RpcEndpoint.class.stop((RpcEndpoint)this);
        }

        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        private ExecutionContextExecutorService submitJobThreadPool() {
            return this.submitJobThreadPool;
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof StartAllReceivers) {
                        StartAllReceivers startAllReceivers = (StartAllReceivers)A1;
                        Seq<Receiver<?>> receivers = startAllReceivers.receiver();
                        Map<Object, Seq<String>> scheduledExecutors = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().scheduleReceivers(receivers, this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
                        receivers.foreach((Function1)new Serializable(this, scheduledExecutors){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$receive$1 $outer;
                            private final Map scheduledExecutors$1;

                            public final void apply(Receiver<?> receiver) {
                                Seq executors = (Seq)this.scheduledExecutors$1.apply((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()));
                                this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(receiver.streamId(), (Seq<String>)executors);
                                this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations().update((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()), receiver.preferredLocation());
                                this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(receiver, (Seq<String>)executors);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.scheduledExecutors$1 = scheduledExecutors$1;
                            }
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof RestartReceiver) {
                        Seq<String> seq;
                        RestartReceiver restartReceiver2 = (RestartReceiver)A1;
                        Receiver<?> receiver = restartReceiver2.receiver();
                        Seq<String> oldScheduledExecutors = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$getStoredScheduledExecutors(receiver.streamId());
                        if (oldScheduledExecutors.nonEmpty()) {
                            seq = oldScheduledExecutors;
                        } else {
                            ReceiverTrackingInfo oldReceiverInfo = (ReceiverTrackingInfo)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()));
                            Enumeration.Value x$33 = ReceiverState$.MODULE$.INACTIVE();
                            None$ x$34 = None$.MODULE$;
                            int x$35 = oldReceiverInfo.copy$default$1();
                            Option<String> x$36 = oldReceiverInfo.copy$default$4();
                            Option<String> x$37 = oldReceiverInfo.copy$default$5();
                            Option<RpcEndpointRef> x$38 = oldReceiverInfo.copy$default$6();
                            Option<ReceiverErrorInfo> x$39 = oldReceiverInfo.copy$default$7();
                            ReceiverTrackingInfo newReceiverInfo = oldReceiverInfo.copy(x$35, x$33, (Option<Seq<String>>)x$34, x$36, x$37, x$38, x$39);
                            this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()), (Object)newReceiverInfo);
                            seq = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().rescheduleReceiver(receiver.streamId(), receiver.preferredLocation(), (Map<Object, ReceiverTrackingInfo>)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos(), this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
                        }
                        Seq<String> scheduledExecutors = seq;
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(receiver, scheduledExecutors);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CleanupOldBlocks) {
                        CleanupOldBlocks cleanupOldBlocks2 = (CleanupOldBlocks)A1;
                        ((IterableLike)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().values().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterable<RpcEndpointRef> apply(ReceiverTrackingInfo x$5) {
                                return Option$.MODULE$.option2Iterable(x$5.endpoint());
                            }
                        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, cleanupOldBlocks2){
                            public static final long serialVersionUID = 0L;
                            private final CleanupOldBlocks x6$1;

                            public final void apply(RpcEndpointRef x$6) {
                                x$6.send((Object)this.x6$1);
                            }
                            {
                                this.x6$1 = x6$1;
                            }
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof UpdateReceiverRateLimit) {
                        UpdateReceiverRateLimit updateReceiverRateLimit = (UpdateReceiverRateLimit)A1;
                        int streamUID = updateReceiverRateLimit.streamUID();
                        long newRate = updateReceiverRateLimit.newRate();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamUID)).foreach((Function1)new Serializable(this, newRate){
                            public static final long serialVersionUID = 0L;
                            public final long newRate$1;

                            public final void apply(ReceiverTrackingInfo info) {
                                info.endpoint().foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$receive$1$$anonfun$applyOrElse$4 $outer;

                                    public final void apply(RpcEndpointRef eP) {
                                        eP.send((Object)new UpdateRateLimit(this.$outer.newRate$1));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.newRate$1 = newRate$1;
                            }
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ReportError) {
                        ReportError reportError2 = (ReportError)A1;
                        int streamId = reportError2.streamId();
                        String message = reportError2.message();
                        String error = reportError2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(streamId, message, error);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof StartAllReceivers ? true : (object instanceof RestartReceiver ? true : (object instanceof CleanupOldBlocks ? true : (object instanceof UpdateReceiverRateLimit ? true : object instanceof ReportError)));
                    return bl;
                }

                public /* synthetic */ ReceiverTrackerEndpoint org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;
                private final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof RegisterReceiver) {
                        RegisterReceiver registerReceiver2 = (RegisterReceiver)A1;
                        int streamId = registerReceiver2.streamId();
                        String typ = registerReceiver2.typ();
                        String hostPort = registerReceiver2.hostPort();
                        RpcEndpointRef receiverEndpoint = registerReceiver2.receiverEndpoint();
                        boolean successful = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(streamId, typ, hostPort, receiverEndpoint, this.context$1.sender().address());
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)successful));
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof AddBlock) {
                        AddBlock addBlock2 = (AddBlock)A1;
                        ReceivedBlockInfo receivedBlockInfo = addBlock2.receivedBlockInfo();
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(receivedBlockInfo)));
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof DeregisterReceiver) {
                        DeregisterReceiver deregisterReceiver2 = (DeregisterReceiver)A1;
                        int streamId = deregisterReceiver2.streamId();
                        String message = deregisterReceiver2.msg();
                        String error = deregisterReceiver2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(streamId, message, error);
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                    } else if (AllReceiverIds$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)((MapLike)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<Object, ReceiverTrackingInfo> x$7) {
                                Enumeration.Value value = ((ReceiverTrackingInfo)x$7._2()).state();
                                Enumeration.Value value2 = ReceiverState$.MODULE$.INACTIVE();
                                return value != null ? !value.equals(value2) : value2 != null;
                            }
                        })).keys().toSeq());
                        object = BoxedUnit.UNIT;
                    } else if (StopAllReceivers$.MODULE$.equals(A1)) {
                        Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() || this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped());
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$stopReceivers();
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x2) {
                    Object object = x2;
                    boolean bl = object instanceof RegisterReceiver ? true : (object instanceof AddBlock ? true : (object instanceof DeregisterReceiver ? true : (AllReceiverIds$.MODULE$.equals(object) ? true : StopAllReceivers$.MODULE$.equals(object))));
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            };
        }

        public Seq<String> org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$getStoredScheduledExecutors(int receiverId) {
            Nil$ nil$;
            if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().contains((Object)BoxesRunTime.boxToInteger((int)receiverId))) {
                Option<Seq<String>> scheduledExecutors = ((ReceiverTrackingInfo)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)receiverId))).scheduledExecutors();
                if (scheduledExecutors.nonEmpty()) {
                    Set executors = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors().toSet();
                    nil$ = (Seq)((TraversableLike)scheduledExecutors.get()).filter((Function1)executors);
                } else {
                    nil$ = Nil$.MODULE$;
                }
            } else {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        }

        /*
         * WARNING - void declaration
         */
        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(Receiver<?> receiver, Seq<String> scheduledExecutors) {
            void var3_3;
            int receiverId = receiver.streamId();
            if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$shouldStartReceiver$1()) {
                RDD rDD;
                Option checkpointDirOption = Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.checkpointDir());
                SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().hadoopConfiguration());
                Serializable startReceiverFunc = new Serializable(this, checkpointDirOption, serializableHadoopConf){
                    public static final long serialVersionUID = 0L;
                    private final Option checkpointDirOption$1;
                    private final SerializableConfiguration serializableHadoopConf$1;

                    public final void apply(Iterator<Receiver<?>> iterator) {
                        if (iterator.hasNext()) {
                            if (TaskContext$.MODULE$.get().attemptNumber() == 0) {
                                Receiver receiver = (Receiver)iterator.next();
                                Predef$.MODULE$.assert(!iterator.hasNext());
                                ReceiverSupervisorImpl supervisor2 = new ReceiverSupervisorImpl(receiver, SparkEnv$.MODULE$.get(), this.serializableHadoopConf$1.value(), (Option<String>)this.checkpointDirOption$1);
                                supervisor2.start();
                                supervisor2.awaitTermination();
                            }
                            return;
                        }
                        throw new SparkException("Could not start receiver as object not found.");
                    }
                    {
                        this.checkpointDirOption$1 = checkpointDirOption$1;
                        this.serializableHadoopConf$1 = serializableHadoopConf$1;
                    }
                };
                if (scheduledExecutors.isEmpty()) {
                    rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Receiver[]{receiver})), 1, ClassTag$.MODULE$.apply(Receiver.class));
                } else {
                    Seq preferredLocations = (Seq)((SeqLike)scheduledExecutors.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String hostPort) {
                            return (String)Utils$.MODULE$.parseHostPort(hostPort)._1();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).distinct();
                    rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(receiver), (Object)preferredLocations)})), ClassTag$.MODULE$.apply(Receiver.class));
                }
                RDD receiverRDD = rDD;
                receiverRDD.setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)receiverId)})));
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().setJobDescription(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming job running receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)receiverId)})));
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().setCallSite((CallSite)Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.getStartSite()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CallSite apply() {
                        return Utils$.MODULE$.getCallSite(Utils$.MODULE$.getCallSite$default$1());
                    }
                }));
                SimpleFutureAction future = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().submitJob(receiverRDD, (Function1)startReceiverFunc, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(int x$8, BoxedUnit x$9) {
                    }
                }, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                    }
                });
                future.onComplete((Function1)new Serializable(this, receiver, receiverId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReceiverTrackerEndpoint $outer;
                    private final Receiver receiver$1;
                    public final int receiverId$1;

                    public final void apply(Try<BoxedUnit> x0$3) {
                        Try<BoxedUnit> try_;
                        block9: {
                            block8: {
                                BoxedUnit boxedUnit;
                                block7: {
                                    BoxedUnit boxedUnit2;
                                    try_ = x0$3;
                                    if (!(try_ instanceof Success)) break block7;
                                    if (this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$shouldStartReceiver$1()) {
                                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver$2 $outer;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restarting Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.receiverId$1)}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        this.$outer.self().send((Object)new RestartReceiver(this.receiver$1));
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish(this.receiverId$1);
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit3 = boxedUnit2;
                                    break block8;
                                }
                                if (!(try_ instanceof Failure)) break block9;
                                Failure failure = (Failure)try_;
                                Throwable e = failure.exception();
                                if (this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$shouldStartReceiver$1()) {
                                    this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logError((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "Receiver has been stopped. Try to restart it.";
                                        }
                                    }, e);
                                    this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver$2 $outer;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restarting Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.receiverId$1)}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    this.$outer.self().send((Object)new RestartReceiver(this.receiver$1));
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish(this.receiverId$1);
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit4 = boxedUnit;
                            }
                            return;
                        }
                        throw new MatchError(try_);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.receiver$1 = receiver$1;
                        this.receiverId$1 = receiverId$1;
                    }
                }, (ExecutionContext)this.submitJobThreadPool());
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)new Serializable(this, receiver){
                    public static final long serialVersionUID = 0L;
                    private final Receiver receiver$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receiver ", " started"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.receiver$1.streamId())}));
                    }
                    {
                        this.receiver$1 = receiver$1;
                    }
                });
                return;
            }
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish((int)var3_3);
        }

        public void onStop() {
            this.submitJobThreadPool().shutdownNow();
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish(int receiverId) {
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().countDown();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().remove((Object)BoxesRunTime.boxToInteger((int)receiverId)).foreach((Function1)new Serializable(this, receiverId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;
                public final int receiverId$2;

                public final void apply(ReceiverTrackingInfo receiverTrackingInfo) {
                    Enumeration.Value value = receiverTrackingInfo.state();
                    Enumeration.Value value2 = ReceiverState$.MODULE$.ACTIVE();
                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish$1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receiver ", " exited but didn't deregister"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.receiverId$2)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.receiverId$2 = receiverId$2;
                }
            });
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$stopReceivers() {
            ((IterableLike)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().values().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<RpcEndpointRef> apply(ReceiverTrackingInfo x$10) {
                    return Option$.MODULE$.option2Iterable(x$10.endpoint());
                }
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(RpcEndpointRef x$11) {
                    x$11.send((Object)StopReceiver$.MODULE$);
                }
            });
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Sent stop signal to all ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().size())).append((Object)" receivers").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ ReceiverTracker org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer() {
            return this.$outer;
        }

        public final boolean org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$shouldStartReceiver$1() {
            return !this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() && !this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped();
        }

        public ReceiverTrackerEndpoint(ReceiverTracker $outer, RpcEnv rpcEnv) {
            this.rpcEnv = rpcEnv;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            RpcEndpoint.class.$init$((RpcEndpoint)this);
            this.submitJobThreadPool = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("submit-job-thead-pool"));
        }
    }
}

