/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t%e!B\u0001\u0003\u0005\tQ!\u0001\u0004#TiJ,\u0017-\\$sCBD'BA\u0002\u0005\u0003%\u0019HO]3b[&twM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\u0011\u00011\"\u0005\u000b\u0011\u00051yQ\"A\u0007\u000b\u00039\tQa]2bY\u0006L!\u0001E\u0007\u0003\r\u0005s\u0017PU3g!\ta!#\u0003\u0002\u0014\u001b\ta1+\u001a:jC2L'0\u00192mKB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\tS:$XM\u001d8bY&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011\u0015Y\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0010\u0011\u0005}\u0001Q\"\u0001\u0002\t\u000f\u0005\u0002!\u0019!C\u0005E\u0005a\u0011N\u001c9viN#(/Z1ngV\t1\u0005E\u0002%S-j\u0011!\n\u0006\u0003M\u001d\nq!\\;uC\ndWM\u0003\u0002)\u001b\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005)*#aC!se\u0006L()\u001e4gKJ\u0004$\u0001\f\u001b\u0011\u00075\u0002$'D\u0001/\u0015\ty#!A\u0004egR\u0014X-Y7\n\u0005Er#\u0001D%oaV$Hi\u0015;sK\u0006l\u0007CA\u001a5\u0019\u0001!\u0011\"\u000e\u001c\u0002\u0002\u0003\u0005)\u0011\u0001\u001d\u0003\u0007}#\u0013\u0007\u0003\u00048\u0001\u0001\u0006IaI\u0001\u000eS:\u0004X\u000f^*ue\u0016\fWn\u001d\u0011\u0012\u0005eb\u0004C\u0001\u0007;\u0013\tYTBA\u0004O_RD\u0017N\\4\u0011\u00051i\u0014B\u0001 \u000e\u0005\r\te.\u001f\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u00035yW\u000f\u001e9viN#(/Z1ngV\t!\tE\u0002%S\r\u0003$\u0001\u0012%\u0011\u00075*u)\u0003\u0002G]\t9Ai\u0015;sK\u0006l\u0007CA\u001aI\t%I%*!A\u0001\u0002\u000b\u0005\u0001HA\u0002`IIBaa\u0013\u0001!\u0002\u0013\u0011\u0015AD8viB,Ho\u0015;sK\u0006l7\u000f\t\u0005\b\u001b\u0002\u0001\r\u0011\"\u0003O\u0003QIg\u000e];u'R\u0014X-Y7OC6,\u0017I\u001c3J\tV\tq\nE\u0002Q1ns!!\u0015,\u000f\u0005I+V\"A*\u000b\u0005Qc\u0012A\u0002\u001fs_>$h(C\u0001\u000f\u0013\t9V\"A\u0004qC\u000e\\\u0017mZ3\n\u0005eS&aA*fc*\u0011q+\u0004\t\u0005\u0019qsV-\u0003\u0002^\u001b\t1A+\u001e9mKJ\u0002\"a\u00182\u000f\u00051\u0001\u0017BA1\u000e\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005l\u0001C\u0001\u0007g\u0013\t9WBA\u0002J]RDq!\u001b\u0001A\u0002\u0013%!.\u0001\rj]B,Ho\u0015;sK\u0006lg*Y7f\u0003:$\u0017\nR0%KF$\"a\u001b8\u0011\u00051a\u0017BA7\u000e\u0005\u0011)f.\u001b;\t\u000f=D\u0017\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010J\u0019\t\rE\u0004\u0001\u0015)\u0003P\u0003UIg\u000e];u'R\u0014X-Y7OC6,\u0017I\u001c3J\t\u0002B#\u0001]:\u0011\u00051!\u0018BA;\u000e\u0005!1x\u000e\\1uS2,\u0007bB<\u0001\u0001\u0004%\t\u0001_\u0001\u0011e\u0016lW-\u001c2fe\u0012+(/\u0019;j_:,\u0012!\u001f\t\u0003?iL!a\u001f\u0002\u0003\u0011\u0011+(/\u0019;j_:Dq! \u0001A\u0002\u0013\u0005a0\u0001\u000bsK6,WNY3s\tV\u0014\u0018\r^5p]~#S-\u001d\u000b\u0003W~Dqa\u001c?\u0002\u0002\u0003\u0007\u0011\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0015B=\u0002#I,W.Z7cKJ$UO]1uS>t\u0007\u0005C\u0005\u0002\b\u0001\u0001\r\u0011\"\u0001\u0002\n\u0005!2\r[3dWB|\u0017N\u001c;J]B\u0013xn\u001a:fgN,\"!a\u0003\u0011\u00071\ti!C\u0002\u0002\u00105\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0014\u0001\u0001\r\u0011\"\u0001\u0002\u0016\u0005A2\r[3dWB|\u0017N\u001c;J]B\u0013xn\u001a:fgN|F%Z9\u0015\u0007-\f9\u0002C\u0005p\u0003#\t\t\u00111\u0001\u0002\f!A\u00111\u0004\u0001!B\u0013\tY!A\u000bdQ\u0016\u001c7\u000e]8j]RLe\u000e\u0015:pOJ,7o\u001d\u0011\t\u0013\u0005}\u0001\u00011A\u0005\u0002\u0005\u0005\u0012\u0001\u0003>fe>$\u0016.\\3\u0016\u0005\u0005\r\u0002cA\u0010\u0002&%\u0019\u0011q\u0005\u0002\u0003\tQKW.\u001a\u0005\n\u0003W\u0001\u0001\u0019!C\u0001\u0003[\tAB_3s_RKW.Z0%KF$2a[A\u0018\u0011%y\u0017\u0011FA\u0001\u0002\u0004\t\u0019\u0003\u0003\u0005\u00024\u0001\u0001\u000b\u0015BA\u0012\u0003%QXM]8US6,\u0007\u0005C\u0005\u00028\u0001\u0001\r\u0011\"\u0001\u0002\"\u0005I1\u000f^1siRKW.\u001a\u0005\n\u0003w\u0001\u0001\u0019!C\u0001\u0003{\tQb\u001d;beR$\u0016.\\3`I\u0015\fHcA6\u0002@!Iq.!\u000f\u0002\u0002\u0003\u0007\u00111\u0005\u0005\t\u0003\u0007\u0002\u0001\u0015)\u0003\u0002$\u0005Q1\u000f^1siRKW.\u001a\u0011\t\u0011\u0005\u001d\u0003\u00011A\u0005\u0002a\fQBY1uG\"$UO]1uS>t\u0007\"CA&\u0001\u0001\u0007I\u0011AA'\u0003E\u0011\u0017\r^2i\tV\u0014\u0018\r^5p]~#S-\u001d\u000b\u0004W\u0006=\u0003\u0002C8\u0002J\u0005\u0005\t\u0019A=\t\u000f\u0005M\u0003\u0001)Q\u0005s\u0006q!-\u0019;dQ\u0012+(/\u0019;j_:\u0004\u0003\"CA,\u0001\u0001\u0007I\u0011BA-\u00031qW/\u001c*fG\u0016Lg/\u001a:t+\u0005)\u0007\"CA/\u0001\u0001\u0007I\u0011BA0\u0003AqW/\u001c*fG\u0016Lg/\u001a:t?\u0012*\u0017\u000fF\u0002l\u0003CB\u0001b\\A.\u0003\u0003\u0005\r!\u001a\u0005\b\u0003K\u0002\u0001\u0015)\u0003f\u00035qW/\u001c*fG\u0016Lg/\u001a:tA!\u001a\u00111M:\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n\u0005)1\u000f^1siR\u00191.a\u001c\t\u0011\u0005E\u0014\u0011\u000ea\u0001\u0003G\tA\u0001^5nK\"9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0014a\u0002:fgR\f'\u000f\u001e\u000b\u0004W\u0006e\u0004\u0002CA9\u0003g\u0002\r!a\t\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000\u0005!1\u000f^8q)\u0005Y\u0007bBAB\u0001\u0011\u0005\u0011QQ\u0001\u000bg\u0016$8i\u001c8uKb$HcA6\u0002\b\"A\u0011\u0011RAA\u0001\u0004\tY)A\u0002tg\u000e\u00042aHAG\u0013\r\tyI\u0001\u0002\u0011'R\u0014X-Y7j]\u001e\u001cuN\u001c;fqRDq!a%\u0001\t\u0003\t)*\u0001\ttKR\u0014\u0015\r^2i\tV\u0014\u0018\r^5p]R\u00191.a&\t\u000f\u0005e\u0015\u0011\u0013a\u0001s\u0006AA-\u001e:bi&|g\u000eC\u0004\u0002\u001e\u0002!\t!a(\u0002\u0011I,W.Z7cKJ$2a[AQ\u0011\u001d\tI*a'A\u0002eDq!!*\u0001\t\u0003\t9+\u0001\bbI\u0012Le\u000e];u'R\u0014X-Y7\u0015\u0007-\fI\u000b\u0003\u0005\u0002,\u0006\r\u0006\u0019AAW\u0003-Ig\u000e];u'R\u0014X-Y71\t\u0005=\u00161\u0017\t\u0005[A\n\t\fE\u00024\u0003g#1\"!.\u0002*\u0006\u0005\t\u0011!B\u0001q\t\u0019q\f\n\u001b\t\u000f\u0005e\u0006\u0001\"\u0001\u0002<\u0006y\u0011\r\u001a3PkR\u0004X\u000f^*ue\u0016\fW\u000eF\u0002l\u0003{C\u0001\"a0\u00028\u0002\u0007\u0011\u0011Y\u0001\r_V$\b/\u001e;TiJ,\u0017-\u001c\u0019\u0005\u0003\u0007\f9\r\u0005\u0003.\u000b\u0006\u0015\u0007cA\u001a\u0002H\u0012Y\u0011\u0011ZA_\u0003\u0003\u0005\tQ!\u00019\u0005\ryF%\u000e\u0005\b\u0003\u001b\u0004A\u0011AAh\u0003=9W\r^%oaV$8\u000b\u001e:fC6\u001cHCAAi!\u0015a\u00111[Al\u0013\r\t).\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0019\u0005\u00033\fi\u000e\u0005\u0003.a\u0005m\u0007cA\u001a\u0002^\u0012Y\u0011q\\Af\u0003\u0003\u0005\tQ!\u00019\u0005\ryFE\u000e\u0005\b\u0003G\u0004A\u0011AAs\u0003A9W\r^(viB,Ho\u0015;sK\u0006l7\u000f\u0006\u0002\u0002hB)A\"a5\u0002jB\"\u00111^Ax!\u0011iS)!<\u0011\u0007M\ny\u000fB\u0006\u0002r\u0006\u0005\u0018\u0011!A\u0001\u0006\u0003A$aA0%o!9\u0011Q\u001f\u0001\u0005\u0002\u0005]\u0018aF4fiJ+7-Z5wKJLe\u000e];u'R\u0014X-Y7t)\t\tI\u0010E\u0003\r\u0003'\fY\u0010\r\u0003\u0002~\n\u0015\u0001#B\u0017\u0002\u0000\n\r\u0011b\u0001B\u0001]\t!\"+Z2fSZ,'/\u00138qkR$5\u000b\u001e:fC6\u00042a\rB\u0003\t-\u00119!a=\u0002\u0002\u0003\u0005)\u0011\u0001\u001d\u0003\u0007}#\u0003\bC\u0004\u0003\f\u0001!\t!!\u0017\u0002\u001f\u001d,GOT;n%\u0016\u001cW-\u001b<feNDaAa\u0004\u0001\t\u0003q\u0015aF4fi&s\u0007/\u001e;TiJ,\u0017-\u001c(b[\u0016\fe\u000eZ%E\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0005+\tAbZ3oKJ\fG/\u001a&pEN$BAa\u0006\u0003&A!\u0001\u000b\u0017B\r!\u0011\u0011YB!\t\u000e\u0005\tu!b\u0001B\u0010\u0005\u0005I1o\u00195fIVdWM]\u0005\u0005\u0005G\u0011iBA\u0002K_\nD\u0001\"!\u001d\u0003\u0012\u0001\u0007\u00111\u0005\u0005\b\u0005S\u0001A\u0011\u0001B\u0016\u00035\u0019G.Z1s\u001b\u0016$\u0018\rZ1uCR\u00191N!\f\t\u0011\u0005E$q\u0005a\u0001\u0003GAqA!\r\u0001\t\u0003\u0011\u0019$\u0001\u000bva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u000b\u0004W\nU\u0002\u0002CA9\u0005_\u0001\r!a\t\t\u000f\te\u0002\u0001\"\u0001\u0003<\u0005\u00192\r\\3be\u000eCWmY6q_&tG\u000fR1uCR\u00191N!\u0010\t\u0011\u0005E$q\u0007a\u0001\u0003GAqA!\u0011\u0001\t\u0003\ty(A\u000bsKN$xN]3DQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\t\u000f\t\u0015\u0003\u0001\"\u0001\u0002\u0000\u0005Aa/\u00197jI\u0006$X\rC\u0004\u0003J\u0001!\tAa\u0013\u0002C\u001d,G/T1y\u0013:\u0004X\u000f^*ue\u0016\fWNU3nK6\u0014WM\u001d#ve\u0006$\u0018n\u001c8\u0015\u0003eDqAa\u0014\u0001\t\u0013\u0011\t&A\u0006xe&$Xm\u00142kK\u000e$HcA6\u0003T!A!Q\u000bB'\u0001\u0004\u00119&A\u0002p_N\u0004BA!\u0017\u0003d5\u0011!1\f\u0006\u0005\u0005;\u0012y&\u0001\u0002j_*\u0011!\u0011M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003f\tm#AE(cU\u0016\u001cGoT;uaV$8\u000b\u001e:fC6DcA!\u0014\u0003j\tU\u0004#\u0002\u0007\u0003l\t=\u0014b\u0001B7\u001b\t1A\u000f\u001b:poN\u0004BA!\u0017\u0003r%!!1\u000fB.\u0005-Iu*\u0012=dKB$\u0018n\u001c8$\u0005\t=\u0004b\u0002B=\u0001\u0011%!1P\u0001\u000be\u0016\fGm\u00142kK\u000e$HcA6\u0003~!A!q\u0010B<\u0001\u0004\u0011\t)A\u0002pSN\u0004BA!\u0017\u0003\u0004&!!Q\u0011B.\u0005Ey%M[3di&s\u0007/\u001e;TiJ,\u0017-\u001c\u0015\u0007\u0005o\u0012IG!\u001e")
public final class DStreamGraph
implements Serializable,
Logging {
    private final ArrayBuffer<InputDStream<?>> inputStreams;
    private final ArrayBuffer<DStream<?>> outputStreams;
    private volatile Seq<Tuple2<String, Object>> inputStreamNameAndID;
    private Duration rememberDuration;
    private boolean checkpointInProgress;
    private Time zeroTime;
    private Time startTime;
    private Duration batchDuration;
    private volatile int numReceivers;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private ArrayBuffer<InputDStream<?>> inputStreams() {
        return this.inputStreams;
    }

    private ArrayBuffer<DStream<?>> outputStreams() {
        return this.outputStreams;
    }

    private Seq<Tuple2<String, Object>> inputStreamNameAndID() {
        return this.inputStreamNameAndID;
    }

    private void inputStreamNameAndID_$eq(Seq<Tuple2<String, Object>> x$1) {
        this.inputStreamNameAndID = x$1;
    }

    public Duration rememberDuration() {
        return this.rememberDuration;
    }

    public void rememberDuration_$eq(Duration x$1) {
        this.rememberDuration = x$1;
    }

    public boolean checkpointInProgress() {
        return this.checkpointInProgress;
    }

    public void checkpointInProgress_$eq(boolean x$1) {
        this.checkpointInProgress = x$1;
    }

    public Time zeroTime() {
        return this.zeroTime;
    }

    public void zeroTime_$eq(Time x$1) {
        this.zeroTime = x$1;
    }

    public Time startTime() {
        return this.startTime;
    }

    public void startTime_$eq(Time x$1) {
        this.startTime = x$1;
    }

    public Duration batchDuration() {
        return this.batchDuration;
    }

    public void batchDuration_$eq(Duration x$1) {
        this.batchDuration = x$1;
    }

    private int numReceivers() {
        return this.numReceivers;
    }

    private void numReceivers_$eq(int x$1) {
        this.numReceivers = x$1;
    }

    public synchronized void start(Time time) {
        Predef$.MODULE$.require(this.zeroTime() == null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "DStream graph computation already started";
            }
        });
        this.zeroTime_$eq(time);
        this.startTime_$eq(time);
        this.outputStreams().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;

            public final void apply(DStream<?> x$1) {
                x$1.initialize(this.$outer.zeroTime());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.outputStreams().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;

            public final void apply(DStream<?> x$2) {
                x$2.remember(this.$outer.rememberDuration());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.outputStreams().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DStream<?> x$3) {
                x$3.validateAtStart();
            }
        });
        this.numReceivers_$eq(this.inputStreams().count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(InputDStream<?> x$4) {
                return x$4 instanceof ReceiverInputDStream;
            }
        }));
        this.inputStreamNameAndID_$eq((Seq<Tuple2<String, Object>>)((Seq)this.inputStreams().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(InputDStream<?> is) {
                return new Tuple2((Object)is.name(), (Object)BoxesRunTime.boxToInteger((int)is.id()));
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())));
        this.inputStreams().par().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(InputDStream<?> x$5) {
                x$5.start();
            }
        });
    }

    public synchronized void restart(Time time) {
        this.startTime_$eq(time);
    }

    public synchronized void stop() {
        this.inputStreams().par().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(InputDStream<?> x$6) {
                x$6.stop();
            }
        });
    }

    public synchronized void setContext(StreamingContext ssc) {
        this.outputStreams().foreach((Function1)new Serializable(this, ssc){
            public static final long serialVersionUID = 0L;
            private final StreamingContext ssc$1;

            public final void apply(DStream<?> x$7) {
                x$7.setContext(this.ssc$1);
            }
            {
                this.ssc$1 = ssc$1;
            }
        });
    }

    public synchronized void setBatchDuration(Duration duration2) {
        Predef$.MODULE$.require(this.batchDuration() == null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Batch duration already set as ", ". Cannot set it again."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.batchDuration()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.batchDuration_$eq(duration2);
    }

    public synchronized void remember(Duration duration2) {
        Predef$.MODULE$.require(this.rememberDuration() == null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Remember duration already set as ", ". Cannot set it again."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.rememberDuration()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.rememberDuration_$eq(duration2);
    }

    public void addInputStream(InputDStream<?> inputStream) {
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            inputStream.setGraph(this);
            this.inputStreams().$plus$eq(inputStream);
            return;
        }
    }

    public void addOutputStream(DStream<?> outputStream) {
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            outputStream.setGraph(this);
            this.outputStreams().$plus$eq(outputStream);
            return;
        }
    }

    public synchronized InputDStream<?>[] getInputStreams() {
        return (InputDStream[])this.inputStreams().toArray(ClassTag$.MODULE$.apply(InputDStream.class));
    }

    public synchronized DStream<?>[] getOutputStreams() {
        return (DStream[])this.outputStreams().toArray(ClassTag$.MODULE$.apply(DStream.class));
    }

    public synchronized ReceiverInputDStream<?>[] getReceiverInputStreams() {
        return (ReceiverInputDStream[])((TraversableOnce)((TraversableLike)this.inputStreams().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(InputDStream<?> x$8) {
                return x$8 instanceof ReceiverInputDStream;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReceiverInputDStream<?> apply(InputDStream<?> x$9) {
                return (ReceiverInputDStream)x$9;
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ReceiverInputDStream.class));
    }

    public int getNumReceivers() {
        return this.numReceivers();
    }

    public Seq<Tuple2<String, Object>> getInputStreamNameAndID() {
        return this.inputStreamNameAndID();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Seq<Job> generateJobs(Time time) {
        Object object;
        this.logDebug((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Generating jobs for time ").append((Object)this.time$1).toString();
            }
            {
                this.time$1 = time$1;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            object = this.outputStreams().flatMap((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$1;

                public final Iterable<Job> apply(DStream<?> outputStream) {
                    Option<Job> jobOption = outputStream.generateJob(this.time$1);
                    jobOption.foreach((Function1)new Serializable(this, outputStream){
                        public static final long serialVersionUID = 0L;
                        private final DStream outputStream$1;

                        public final void apply(Job x$10) {
                            x$10.setCallSite(this.outputStream$1.creationSite());
                        }
                        {
                            this.outputStream$1 = outputStream$1;
                        }
                    });
                    return Option$.MODULE$.option2Iterable(jobOption);
                }
                {
                    this.time$1 = time$1;
                }
            }, ArrayBuffer$.MODULE$.canBuildFrom());
        }
        ArrayBuffer jobs = (ArrayBuffer)object;
        this.logDebug((Function0<String>)new Serializable(this, time, jobs){
            public static final long serialVersionUID = 0L;
            private final Time time$1;
            private final ArrayBuffer jobs$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Generated ").append((Object)BoxesRunTime.boxToInteger((int)this.jobs$1.length())).append((Object)" jobs for time ").append((Object)this.time$1).toString();
            }
            {
                this.time$1 = time$1;
                this.jobs$1 = jobs$1;
            }
        });
        return jobs;
    }

    public void clearMetadata(Time time) {
        this.logDebug((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Clearing metadata for time ").append((Object)this.time$2).toString();
            }
            {
                this.time$2 = time$2;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$2;

                public final void apply(DStream<?> x$11) {
                    x$11.clearMetadata(this.time$2);
                }
                {
                    this.time$2 = time$2;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            this.logDebug((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$2;

                public final String apply() {
                    return new StringBuilder().append((Object)"Cleared old metadata for time ").append((Object)this.time$2).toString();
                }
                {
                    this.time$2 = time$2;
                }
            });
            return;
        }
    }

    public void updateCheckpointData(Time time) {
        this.logInfo((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$3;

            public final String apply() {
                return new StringBuilder().append((Object)"Updating checkpoint data for time ").append((Object)this.time$3).toString();
            }
            {
                this.time$3 = time$3;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$3;

                public final void apply(DStream<?> x$12) {
                    x$12.updateCheckpointData(this.time$3);
                }
                {
                    this.time$3 = time$3;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            this.logInfo((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$3;

                public final String apply() {
                    return new StringBuilder().append((Object)"Updated checkpoint data for time ").append((Object)this.time$3).toString();
                }
                {
                    this.time$3 = time$3;
                }
            });
            return;
        }
    }

    public void clearCheckpointData(Time time) {
        this.logInfo((Function0<String>)new Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final Time time$4;

            public final String apply() {
                return new StringBuilder().append((Object)"Clearing checkpoint data for time ").append((Object)this.time$4).toString();
            }
            {
                this.time$4 = time$4;
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$4;

                public final void apply(DStream<?> x$13) {
                    x$13.clearCheckpointData(this.time$4);
                }
                {
                    this.time$4 = time$4;
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            this.logInfo((Function0<String>)new Serializable(this, time){
                public static final long serialVersionUID = 0L;
                private final Time time$4;

                public final String apply() {
                    return new StringBuilder().append((Object)"Cleared checkpoint data for time ").append((Object)this.time$4).toString();
                }
                {
                    this.time$4 = time$4;
                }
            });
            return;
        }
    }

    public void restoreCheckpointData() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Restoring checkpoint data";
            }
        });
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(DStream<?> x$14) {
                    x$14.restoreCheckpointData();
                }
            });
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Restored checkpoint data";
                }
            });
            return;
        }
    }

    public synchronized void validate() {
        Predef$.MODULE$.require(this.batchDuration() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Batch duration has not been set";
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])this.getOutputStreams()).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "No output operations registered, so nothing to execute";
            }
        });
    }

    public Duration getMaxInputStreamRememberDuration() {
        return (Duration)((TraversableOnce)((TraversableLike)this.inputStreams().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Duration apply(InputDStream<?> x$15) {
                return x$15.rememberDuration();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Duration x$16) {
                return x$16 != null;
            }
        })).maxBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Duration x$17) {
                return x$17.milliseconds();
            }
        }, (Ordering)Ordering.Long$.MODULE$);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)new Serializable(this, oos){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;
            private final ObjectOutputStream oos$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "DStreamGraph.writeObject used";
                    }
                });
                DStreamGraph dStreamGraph = this.$outer;
                synchronized (dStreamGraph) {
                    this.$outer.checkpointInProgress_$eq(true);
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Enabled checkpoint mode";
                        }
                    });
                    this.oos$1.defaultWriteObject();
                    this.$outer.checkpointInProgress_$eq(false);
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Disabled checkpoint mode";
                        }
                    });
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.oos$1 = oos$1;
            }
        });
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)new Serializable(this, ois){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DStreamGraph $outer;
            private final ObjectInputStream ois$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "DStreamGraph.readObject used";
                    }
                });
                DStreamGraph dStreamGraph = this.$outer;
                synchronized (dStreamGraph) {
                    this.$outer.checkpointInProgress_$eq(true);
                    this.ois$1.defaultReadObject();
                    this.$outer.checkpointInProgress_$eq(false);
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ois$1 = ois$1;
            }
        });
    }

    public DStreamGraph() {
        Logging.class.$init$((Logging)this);
        this.inputStreams = new ArrayBuffer();
        this.outputStreams = new ArrayBuffer();
        this.inputStreamNameAndID = Nil$.MODULE$;
        this.rememberDuration = null;
        this.checkpointInProgress = false;
        this.zeroTime = null;
        this.startTime = null;
        this.batchDuration = null;
        this.numReceivers = 0;
    }
}

