/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.scheduler.ExecutorAllocationManager$;
import org.apache.spark.streaming.scheduler.OutputOperationInfo;
import org.apache.spark.streaming.scheduler.ReceiverTracker;
import org.apache.spark.streaming.scheduler.StreamingListener;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerBatchSubmitted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationCompleted;
import org.apache.spark.streaming.scheduler.StreamingListenerOutputOperationStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.streaming.scheduler.StreamingListenerStreamingStarted;
import org.apache.spark.streaming.util.RecurringTimer;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005=g!\u0002\u001d:\u0001m\u001a\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011i\u0003!\u0011!Q\u0001\nmC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005G\"Aa\r\u0001B\u0001B\u0003%q\rC\u0003n\u0001\u0011\u0005a\u000eC\u0004v\u0001\t\u0007I\u0011\u0002<\t\r]\u0004\u0001\u0015!\u0003d\u0011\u001dA\bA1A\u0005\neDa! \u0001!\u0002\u0013Q\bb\u0002@\u0001\u0005\u0004%I!\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0011\u0002>\t\u0013\u0005\u0005\u0001A1A\u0005\n\u0005\r\u0001\u0002CA\u0006\u0001\u0001\u0006I!!\u0002\t\u0013\u00055\u0001A1A\u0005\n\u0005\r\u0001\u0002CA\b\u0001\u0001\u0006I!!\u0002\t\u0013\u0005E\u0001A1A\u0005\n\u0005M\u0001\u0002CA\u0010\u0001\u0001\u0006I!!\u0006\t\u0011\u0005\u0005\u0002\u00011A\u0005\nYD\u0011\"a\t\u0001\u0001\u0004%I!!\n\t\u000f\u0005E\u0002\u0001)Q\u0005G\"I\u00111\b\u0001A\u0002\u0013%\u00111\u0001\u0005\n\u0003{\u0001\u0001\u0019!C\u0005\u0003\u007fA\u0001\"a\u0011\u0001A\u0003&\u0011Q\u0001\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u0013Bq!!\u0014\u0001\t\u0013\tI\u0005C\u0004\u0002P\u0001!I!!\u0015\t\u000f\u0005]\u0003\u0001\"\u0003\u0002J!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBA1\u0001\u0011%\u0011\u0011\n\u0005\b\u0003G\u0002A\u0011IA3\u000f!\t\t(\u000fE\u0001w\u0005Mda\u0002\u001d:\u0011\u0003Y\u0014Q\u000f\u0005\u0007[\n\"\t!a\u001e\t\u0013\u0005e$E1A\u0005\u0002\u0005m\u0004\u0002CAGE\u0001\u0006I!! \t\u0013\u0005=%E1A\u0005\u0002\u0005m\u0004\u0002CAIE\u0001\u0006I!! \t\u0013\u0005M%E1A\u0005\u0002\u0005\r\u0001\u0002CAKE\u0001\u0006I!!\u0002\t\u0013\u0005]%E1A\u0005\u0002\u0005m\u0004\u0002CAME\u0001\u0006I!! \t\u0011\u0005m%E1A\u0005\u0002eDq!!(#A\u0003%!\u0010C\u0005\u0002 \n\u0012\r\u0011\"\u0001\u0002|!A\u0011\u0011\u0015\u0012!\u0002\u0013\ti\b\u0003\u0005\u0002$\n\u0012\r\u0011\"\u0001z\u0011\u001d\t)K\tQ\u0001\niD\u0011\"a*#\u0005\u0004%\t!a\u001f\t\u0011\u0005%&\u0005)A\u0005\u0003{B\u0011\"a+#\u0005\u0004%\t!a\u001f\t\u0011\u00055&\u0005)A\u0005\u0003{Bq!a,#\t\u0003\t\t\fC\u0004\u0002<\n\"\t!!0\u00033\u0015CXmY;u_J\fE\u000e\\8dCRLwN\\'b]\u0006<WM\u001d\u0006\u0003um\n\u0011b]2iK\u0012,H.\u001a:\u000b\u0005qj\u0014!C:ue\u0016\fW.\u001b8h\u0015\tqt(A\u0003ta\u0006\u00148N\u0003\u0002A\u0003\u00061\u0011\r]1dQ\u0016T\u0011AQ\u0001\u0004_J<7\u0003\u0002\u0001E\u0015:\u0003\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u0013a!\u00118z%\u00164\u0007CA&M\u001b\u0005I\u0014BA':\u0005E\u0019FO]3b[&tw\rT5ti\u0016tWM\u001d\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#v\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003'B\u0013q\u0001T8hO&tw-\u0001\u0004dY&,g\u000e^\u0002\u0001!\t9\u0006,D\u0001>\u0013\tIVH\u0001\rFq\u0016\u001cW\u000f^8s\u00032dwnY1uS>t7\t\\5f]R\fqB]3dK&4XM\u001d+sC\u000e\\WM\u001d\t\u0003\u0017rK!!X\u001d\u0003\u001fI+7-Z5wKJ$&/Y2lKJ\fAaY8oMB\u0011q\u000bY\u0005\u0003Cv\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u001f\t\fGo\u00195EkJ\fG/[8o\u001bN\u0004\"!\u00123\n\u0005\u00154%\u0001\u0002'p]\u001e\fQa\u00197pG.\u0004\"\u0001[6\u000e\u0003%T!A[\u001f\u0002\tU$\u0018\u000e\\\u0005\u0003Y&\u0014Qa\u00117pG.\fa\u0001P5oSRtDCB8qcJ\u001cH\u000f\u0005\u0002L\u0001!)AK\u0002a\u0001-\")!L\u0002a\u00017\")aL\u0002a\u0001?\")!M\u0002a\u0001G\")aM\u0002a\u0001O\u0006\u00192oY1mS:<\u0017J\u001c;feZ\fGnU3dgV\t1-\u0001\u000btG\u0006d\u0017N\\4J]R,'O^1m'\u0016\u001c7\u000fI\u0001\u000fg\u000e\fG.\u001b8h+B\u0014\u0016\r^5p+\u0005Q\bCA#|\u0013\tahI\u0001\u0004E_V\u0014G.Z\u0001\u0010g\u000e\fG.\u001b8h+B\u0014\u0016\r^5pA\u0005\u00012oY1mS:<Gi\\<o%\u0006$\u0018n\\\u0001\u0012g\u000e\fG.\u001b8h\t><hNU1uS>\u0004\u0013aD7j]:+X.\u0012=fGV$xN]:\u0016\u0005\u0005\u0015\u0001cA#\u0002\b%\u0019\u0011\u0011\u0002$\u0003\u0007%sG/\u0001\tnS:tU/\\#yK\u000e,Ho\u001c:tA\u0005yQ.\u0019=Ok6,\u00050Z2vi>\u00148/\u0001\tnCbtU/\\#yK\u000e,Ho\u001c:tA\u0005)A/[7feV\u0011\u0011Q\u0003\t\u0005\u0003/\tY\"\u0004\u0002\u0002\u001a)\u0011!nO\u0005\u0005\u0003;\tIB\u0001\bSK\u000e,(O]5oORKW.\u001a:\u0002\rQLW.\u001a:!\u0003A\u0011\u0017\r^2i!J|7\rV5nKN+X.\u0001\u000bcCR\u001c\u0007\u000e\u0015:pGRKW.Z*v[~#S-\u001d\u000b\u0005\u0003O\ti\u0003E\u0002F\u0003SI1!a\u000bG\u0005\u0011)f.\u001b;\t\u0011\u0005=B#!AA\u0002\r\f1\u0001\u001f\u00132\u0003E\u0011\u0017\r^2i!J|7\rV5nKN+X\u000e\t\u0015\u0004+\u0005U\u0002cA#\u00028%\u0019\u0011\u0011\b$\u0003\u0011Y|G.\u0019;jY\u0016\f!CY1uG\"\u0004&o\\2US6,7i\\;oi\u00061\"-\u0019;dQB\u0013xn\u0019+j[\u0016\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002(\u0005\u0005\u0003\"CA\u0018/\u0005\u0005\t\u0019AA\u0003\u0003M\u0011\u0017\r^2i!J|7\rV5nK\u000e{WO\u001c;!Q\rA\u0012QG\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003O\tAa\u001d;pa\u0006\u0001R.\u00198bO\u0016\fE\u000e\\8dCRLwN\\\u0001\u0011e\u0016\fX/Z:u\u000bb,7-\u001e;peN$B!a\n\u0002T!9\u0011Q\u000b\u000fA\u0002\u0005\u0015\u0011a\u00048v[:+w/\u0012=fGV$xN]:\u0002\u0019-LG\u000e\\#yK\u000e,Ho\u001c:\u0002!\u0005$GMQ1uG\"\u0004&o\\2US6,G\u0003BA\u0014\u0003;Ba!a\u0018\u001f\u0001\u0004\u0019\u0017A\u0002;j[\u0016l5/\u0001\twC2LG-\u0019;f'\u0016$H/\u001b8hg\u0006\u0001rN\u001c\"bi\u000eD7i\\7qY\u0016$X\r\u001a\u000b\u0005\u0003O\t9\u0007C\u0004\u0002j\u0001\u0002\r!a\u001b\u0002\u001d\t\fGo\u00195D_6\u0004H.\u001a;fIB\u00191*!\u001c\n\u0007\u0005=\u0014HA\u0010TiJ,\u0017-\\5oO2K7\u000f^3oKJ\u0014\u0015\r^2i\u0007>l\u0007\u000f\\3uK\u0012\f\u0011$\u0012=fGV$xN]!mY>\u001c\u0017\r^5p]6\u000bg.Y4feB\u00111JI\n\u0004E\u0011sECAA:\u0003-)e*\u0011\"M\u000b\u0012{6*R-\u0016\u0005\u0005u\u0004\u0003BA@\u0003\u0013k!!!!\u000b\t\u0005\r\u0015QQ\u0001\u0005Y\u0006twM\u0003\u0002\u0002\b\u0006!!.\u0019<b\u0013\u0011\tY)!!\u0003\rM#(/\u001b8h\u00031)e*\u0011\"M\u000b\u0012{6*R-!\u0003Q\u00196)\u0011'J\u001d\u001e{\u0016J\u0014+F%Z\u000bEjX&F3\u0006)2kQ!M\u0013:;u,\u0013(U\u000bJ3\u0016\tT0L\u000bf\u0003\u0013!H*D\u00032KejR0J\u001dR+%KV!M?\u0012+e)Q+M)~\u001bViQ*\u0002=M\u001b\u0015\tT%O\u000f~Ke\nV#S-\u0006cu\fR#G\u0003VcEkX*F\u0007N\u0003\u0013\u0001F*D\u00032KejR0V!~\u0013\u0016\tV%P?.+\u0015,A\u000bT\u0007\u0006c\u0015JT$`+B{&+\u0011+J\u001f~[U)\u0017\u0011\u00021M\u001b\u0015\tT%O\u000f~+\u0006k\u0018*B)&{u\fR#G\u0003VcE+A\rT\u0007\u0006c\u0015JT$`+B{&+\u0011+J\u001f~#UIR!V\u0019R\u0003\u0013AF*D\u00032KejR0E\u001f^suLU!U\u0013>{6*R-\u0002/M\u001b\u0015\tT%O\u000f~#uj\u0016(`%\u0006#\u0016jT0L\u000bf\u0003\u0013AG*D\u00032KejR0E\u001f^suLU!U\u0013>{F)\u0012$B+2#\u0016aG*D\u00032KejR0E\u001f^suLU!U\u0013>{F)\u0012$B+2#\u0006%A\tN\u0013:{V\tW#D+R{%kU0L\u000bf\u000b!#T%O?\u0016CViQ+U\u001fJ\u001bvlS#ZA\u0005\tR*\u0011-`\u000bb+5)\u0016+P%N{6*R-\u0002%5\u000b\u0005lX#Y\u000b\u000e+Fk\u0014*T?.+\u0015\fI\u0001\u001bSN$\u0015P\\1nS\u000e\fE\u000e\\8dCRLwN\\#oC\ndW\r\u001a\u000b\u0005\u0003g\u000bI\fE\u0002F\u0003kK1!a.G\u0005\u001d\u0011un\u001c7fC:DQA\u0018\u001cA\u0002}\u000bqb\u0019:fCR,\u0017JZ#oC\ndW\r\u001a\u000b\r\u0003\u007f\u000b)-a2\u0002J\u0006-\u0017Q\u001a\t\u0005\u000b\u0006\u0005w.C\u0002\u0002D\u001a\u0013aa\u00149uS>t\u0007\"\u0002+8\u0001\u00041\u0006\"\u0002.8\u0001\u0004Y\u0006\"\u000208\u0001\u0004y\u0006\"\u000228\u0001\u0004\u0019\u0007\"\u000248\u0001\u00049\u0007")
public class ExecutorAllocationManager
implements StreamingListener,
Logging {
    private final ExecutorAllocationClient client;
    private final ReceiverTracker receiverTracker;
    private final SparkConf conf;
    private final long batchDurationMs;
    private final long scalingIntervalSecs;
    private final double scalingUpRatio;
    private final double scalingDownRatio;
    private final int minNumExecutors;
    private final int maxNumExecutors;
    private final RecurringTimer timer;
    private volatile long batchProcTimeSum;
    private volatile int batchProcTimeCount;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<ExecutorAllocationManager> createIfEnabled(ExecutorAllocationClient executorAllocationClient, ReceiverTracker receiverTracker, SparkConf sparkConf, long l, Clock clock) {
        return ExecutorAllocationManager$.MODULE$.createIfEnabled(executorAllocationClient, receiverTracker, sparkConf, l, clock);
    }

    public static boolean isDynamicAllocationEnabled(SparkConf sparkConf) {
        return ExecutorAllocationManager$.MODULE$.isDynamicAllocationEnabled(sparkConf);
    }

    public static String MAX_EXECUTORS_KEY() {
        return ExecutorAllocationManager$.MODULE$.MAX_EXECUTORS_KEY();
    }

    public static String MIN_EXECUTORS_KEY() {
        return ExecutorAllocationManager$.MODULE$.MIN_EXECUTORS_KEY();
    }

    public static double SCALING_DOWN_RATIO_DEFAULT() {
        return ExecutorAllocationManager$.MODULE$.SCALING_DOWN_RATIO_DEFAULT();
    }

    public static String SCALING_DOWN_RATIO_KEY() {
        return ExecutorAllocationManager$.MODULE$.SCALING_DOWN_RATIO_KEY();
    }

    public static double SCALING_UP_RATIO_DEFAULT() {
        return ExecutorAllocationManager$.MODULE$.SCALING_UP_RATIO_DEFAULT();
    }

    public static String SCALING_UP_RATIO_KEY() {
        return ExecutorAllocationManager$.MODULE$.SCALING_UP_RATIO_KEY();
    }

    public static int SCALING_INTERVAL_DEFAULT_SECS() {
        return ExecutorAllocationManager$.MODULE$.SCALING_INTERVAL_DEFAULT_SECS();
    }

    public static String SCALING_INTERVAL_KEY() {
        return ExecutorAllocationManager$.MODULE$.SCALING_INTERVAL_KEY();
    }

    public static String ENABLED_KEY() {
        return ExecutorAllocationManager$.MODULE$.ENABLED_KEY();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    @Override
    public void onStreamingStarted(StreamingListenerStreamingStarted streamingStarted) {
        StreamingListener.onStreamingStarted$(this, streamingStarted);
    }

    @Override
    public void onReceiverStarted(StreamingListenerReceiverStarted receiverStarted) {
        StreamingListener.onReceiverStarted$(this, receiverStarted);
    }

    @Override
    public void onReceiverError(StreamingListenerReceiverError receiverError) {
        StreamingListener.onReceiverError$(this, receiverError);
    }

    @Override
    public void onReceiverStopped(StreamingListenerReceiverStopped receiverStopped) {
        StreamingListener.onReceiverStopped$(this, receiverStopped);
    }

    @Override
    public void onBatchSubmitted(StreamingListenerBatchSubmitted batchSubmitted) {
        StreamingListener.onBatchSubmitted$(this, batchSubmitted);
    }

    @Override
    public void onBatchStarted(StreamingListenerBatchStarted batchStarted) {
        StreamingListener.onBatchStarted$(this, batchStarted);
    }

    @Override
    public void onOutputOperationStarted(StreamingListenerOutputOperationStarted outputOperationStarted) {
        StreamingListener.onOutputOperationStarted$(this, outputOperationStarted);
    }

    @Override
    public void onOutputOperationCompleted(StreamingListenerOutputOperationCompleted outputOperationCompleted) {
        StreamingListener.onOutputOperationCompleted$(this, outputOperationCompleted);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long scalingIntervalSecs() {
        return this.scalingIntervalSecs;
    }

    private double scalingUpRatio() {
        return this.scalingUpRatio;
    }

    private double scalingDownRatio() {
        return this.scalingDownRatio;
    }

    private int minNumExecutors() {
        return this.minNumExecutors;
    }

    private int maxNumExecutors() {
        return this.maxNumExecutors;
    }

    private RecurringTimer timer() {
        return this.timer;
    }

    private long batchProcTimeSum() {
        return this.batchProcTimeSum;
    }

    private void batchProcTimeSum_$eq(long x$1) {
        this.batchProcTimeSum = x$1;
    }

    private int batchProcTimeCount() {
        return this.batchProcTimeCount;
    }

    private void batchProcTimeCount_$eq(int x$1) {
        this.batchProcTimeCount = x$1;
    }

    public void start() {
        this.timer().start();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("ExecutorAllocationManager started with ").append(new StringBuilder(33).append("ratios = [").append(this.scalingUpRatio()).append(", ").append(this.scalingDownRatio()).append("] and interval = ").append(this.scalingIntervalSecs()).append(" sec").toString()).toString());
    }

    public void stop() {
        this.timer().stop(true);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "ExecutorAllocationManager stopped");
    }

    private synchronized void manageAllocation() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Managing executor allocation with ratios = [").append(this.scalingUpRatio()).append(", ").append(this.scalingDownRatio()).append("]").toString());
        if (this.batchProcTimeCount() > 0) {
            long averageBatchProcTime = this.batchProcTimeSum() / (long)this.batchProcTimeCount();
            double ratio = (double)averageBatchProcTime / (double)this.batchDurationMs;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Average: ").append(averageBatchProcTime).append(", ratio = ").append(ratio).toString());
            if (ratio >= this.scalingUpRatio()) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Requesting executors");
                int numNewExecutors = package$.MODULE$.max((int)package$.MODULE$.round(ratio), 1);
                this.requestExecutors(numNewExecutors);
            } else if (ratio <= this.scalingDownRatio()) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Killing executors");
                this.killExecutor();
            }
        }
        this.batchProcTimeSum_$eq(0L);
        this.batchProcTimeCount_$eq(0);
    }

    private void requestExecutors(int numNewExecutors) {
        Predef$.MODULE$.require(numNewExecutors >= 1);
        Seq allExecIds = this.client.getExecutorIds();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Executors (").append(allExecIds.size()).append(") = ").append(allExecIds).toString());
        int targetTotalExecutors = package$.MODULE$.max(package$.MODULE$.min(this.maxNumExecutors(), allExecIds.size() + numNewExecutors), this.minNumExecutors());
        this.client.requestTotalExecutors(targetTotalExecutors, 0, Predef$.MODULE$.Map().empty());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Requested total ").append(targetTotalExecutors).append(" executors").toString());
    }

    private void killExecutor() {
        Seq allExecIds = this.client.getExecutorIds();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Executors (").append(allExecIds.size()).append(") = ").append(allExecIds).toString());
        if (allExecIds.nonEmpty() && allExecIds.size() > this.minNumExecutors()) {
            Seq execIdsWithReceivers = ((TraversableOnce)this.receiverTracker.allocatedExecutors().values().flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toSeq();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Executors with receivers (").append(execIdsWithReceivers.size()).append("): ").append(execIdsWithReceivers).toString());
            Seq removableExecIds = (Seq)allExecIds.diff((GenSeq)execIdsWithReceivers);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Removable executors (").append(removableExecIds.size()).append("): ").append(removableExecIds).toString());
            if (removableExecIds.nonEmpty()) {
                String execIdToRemove = (String)removableExecIds.apply(Random$.MODULE$.nextInt(removableExecIds.size()));
                this.client.killExecutor(execIdToRemove);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Requested to kill executor ").append(execIdToRemove).toString());
            } else {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No non-receiver executors to kill");
            }
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No available executor to kill");
        }
    }

    private synchronized void addBatchProcTime(long timeMs) {
        this.batchProcTimeSum_$eq(this.batchProcTimeSum() + timeMs);
        this.batchProcTimeCount_$eq(this.batchProcTimeCount() + 1);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Added batch processing time ").append(timeMs).append(", sum = ").append(this.batchProcTimeSum()).append(", count = ").append(this.batchProcTimeCount()).toString());
    }

    private void validateSettings() {
        block0: {
            Predef$.MODULE$.require(this.scalingIntervalSecs() > 0L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Config ").append(ExecutorAllocationManager$.MODULE$.SCALING_INTERVAL_KEY()).append(" must be more than 0").toString());
            Predef$.MODULE$.require(this.scalingUpRatio() > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Config ").append(ExecutorAllocationManager$.MODULE$.SCALING_UP_RATIO_KEY()).append(" must be more than 0").toString());
            Predef$.MODULE$.require(this.scalingDownRatio() > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Config ").append(ExecutorAllocationManager$.MODULE$.SCALING_DOWN_RATIO_KEY()).append(" must be more than 0").toString());
            Predef$.MODULE$.require(this.minNumExecutors() > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Config ").append(ExecutorAllocationManager$.MODULE$.MIN_EXECUTORS_KEY()).append(" must be more than 0").toString());
            Predef$.MODULE$.require(this.maxNumExecutors() > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append(ExecutorAllocationManager$.MODULE$.MAX_EXECUTORS_KEY()).append(" must be more than 0").toString());
            Predef$.MODULE$.require(this.scalingUpRatio() > this.scalingDownRatio(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Config ").append(ExecutorAllocationManager$.MODULE$.SCALING_UP_RATIO_KEY()).append(" must be more than config ").append(ExecutorAllocationManager$.MODULE$.SCALING_DOWN_RATIO_KEY()).toString());
            if (!this.conf.contains(ExecutorAllocationManager$.MODULE$.MIN_EXECUTORS_KEY()) || !this.conf.contains(ExecutorAllocationManager$.MODULE$.MAX_EXECUTORS_KEY())) break block0;
            Predef$.MODULE$.require(this.maxNumExecutors() >= this.minNumExecutors(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Config ").append(ExecutorAllocationManager$.MODULE$.MAX_EXECUTORS_KEY()).append(" must be more than config ").append(ExecutorAllocationManager$.MODULE$.MIN_EXECUTORS_KEY()).toString());
        }
    }

    @Override
    public void onBatchCompleted(StreamingListenerBatchCompleted batchCompleted) {
        block0: {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("onBatchCompleted called: ").append(batchCompleted).toString());
            if (batchCompleted.batchInfo().outputOperationInfos().values().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExecutorAllocationManager.$anonfun$onBatchCompleted$2(x$2)))) break block0;
            batchCompleted.batchInfo().processingDelay().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeMs -> this.addBatchProcTime(timeMs));
        }
    }

    public static final /* synthetic */ boolean $anonfun$onBatchCompleted$2(OutputOperationInfo x$2) {
        return x$2.failureReason().nonEmpty();
    }

    public ExecutorAllocationManager(ExecutorAllocationClient client, ReceiverTracker receiverTracker, SparkConf conf, long batchDurationMs, Clock clock) {
        this.client = client;
        this.receiverTracker = receiverTracker;
        this.conf = conf;
        this.batchDurationMs = batchDurationMs;
        StreamingListener.$init$(this);
        Logging.$init$((Logging)this);
        this.scalingIntervalSecs = conf.getTimeAsSeconds(ExecutorAllocationManager$.MODULE$.SCALING_INTERVAL_KEY(), new StringBuilder(1).append(ExecutorAllocationManager$.MODULE$.SCALING_INTERVAL_DEFAULT_SECS()).append("s").toString());
        this.scalingUpRatio = conf.getDouble(ExecutorAllocationManager$.MODULE$.SCALING_UP_RATIO_KEY(), ExecutorAllocationManager$.MODULE$.SCALING_UP_RATIO_DEFAULT());
        this.scalingDownRatio = conf.getDouble(ExecutorAllocationManager$.MODULE$.SCALING_DOWN_RATIO_KEY(), ExecutorAllocationManager$.MODULE$.SCALING_DOWN_RATIO_DEFAULT());
        this.minNumExecutors = conf.getInt(ExecutorAllocationManager$.MODULE$.MIN_EXECUTORS_KEY(), package$.MODULE$.max(1, receiverTracker.numReceivers()));
        this.maxNumExecutors = conf.getInt(ExecutorAllocationManager$.MODULE$.MAX_EXECUTORS_KEY(), Integer.MAX_VALUE);
        this.timer = new RecurringTimer(clock, this.scalingIntervalSecs() * 1000L, (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$1 -> this.manageAllocation(), "streaming-executor-allocation-manager");
        this.batchProcTimeSum = 0L;
        this.batchProcTimeCount = 0;
        this.validateSettings();
    }
}

