/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.avro;

import com.esotericsoftware.kryo.Kryo;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.storm.hdfs.avro.AbstractAvroSerializer;

public class ConfluentAvroSerializer
extends AbstractAvroSerializer {
    private SchemaRegistryClient theClient;
    private final String url;

    ConfluentAvroSerializer(String url) {
        this.url = url;
        this.theClient = new CachedSchemaRegistryClient(this.url, 10000);
    }

    public ConfluentAvroSerializer(Kryo k, Map stormConf) {
        this.url = (String)stormConf.get("avro.schemaregistry.confluent");
        this.theClient = new CachedSchemaRegistryClient(this.url, 10000);
    }

    @Override
    public String getFingerprint(Schema schema) {
        int guid;
        String subject = schema.getName();
        try {
            guid = this.theClient.register(subject, schema);
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(e);
        }
        return Integer.toString(guid);
    }

    @Override
    public Schema getSchema(String fingerPrint) {
        Schema theSchema;
        try {
            theSchema = this.theClient.getByID(Integer.parseInt(fingerPrint));
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(e);
        }
        return theSchema;
    }
}

